/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.accessor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.Accessor;
import kd.isc.iscb.util.script.core.PropertyAccessor;
import kd.isc.iscb.util.script.core.Repository;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.Storer;
import kd.isc.iscb.util.script.core.ToolKit;

public final class NameAccessorImpl
implements Accessor {
    private Object stub;
    private String name;
    private Statement smt;

    public String toString() {
        return this.stub + "." + this.name;
    }

    public NameAccessorImpl(Object stub, String name, Statement smt) {
        this.stub = stub;
        this.name = name;
        this.smt = smt;
    }

    public Object getStub() {
        return this.stub;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object eval(ScriptContext ctx) {
        return NameAccessorImpl.getValue(this.stub, this.name, Util.eval(ctx, this.stub), false, this.smt.line());
    }

    public static Object getValue(Object stub, String name, Object ctx, boolean nullable, int line) {
        PropertyAccessor accessor;
        if (ctx == null) {
            return NameAccessorImpl.returnNull(stub, name, ctx, nullable);
        }
        if (ctx instanceof Context) {
            return ((Context)ctx).get(name);
        }
        if (ctx instanceof Map) {
            return ((Map)ctx).get(name);
        }
        if (ctx instanceof ScriptContext) {
            return Util.get((ScriptContext)ctx, name);
        }
        if (ctx instanceof Repository) {
            return ((Repository)ctx).getProperty(name);
        }
        if (ctx instanceof ToolKit) {
            return ((ToolKit)ctx).get(name);
        }
        if ("length".equals(name)) {
            if (ctx instanceof Collection) {
                return ((Collection)ctx).size();
            }
            if (ctx instanceof CharSequence) {
                return ((CharSequence)ctx).length();
            }
            if (ctx instanceof Object[]) {
                return ((Object[])ctx).length;
            }
            if (ctx.getClass().isArray()) {
                return Array.getLength(ctx);
            }
        } else if (ctx instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)ctx;
            if ("key".equalsIgnoreCase(name)) {
                return entry.getKey();
            }
            if ("value".equalsIgnoreCase(name)) {
                return entry.getValue();
            }
        } else if (ctx instanceof Date) {
            Date date = (Date)ctx;
            if ("year".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(1);
            }
            if ("month".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(2) + 1;
            }
            if ("day".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(5);
            }
            if ("hour".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(11);
            }
            if ("minute".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(12);
            }
            if ("second".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(13);
            }
            if ("week".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(3);
            }
            if ("day_of_week".equals(name)) {
                return NameAccessorImpl.getCalendar(date).get(7);
            }
        } else if (ctx instanceof Throwable) {
            if ("message".equals(name)) {
                return ((Throwable)ctx).getMessage();
            }
            if ("cause".equals(name)) {
                return ((Throwable)ctx).getCause();
            }
            if ("type".equals(name)) {
                return ctx.getClass().getName();
            }
            if ("code".equals(name)) {
                if (ctx instanceof IscBizException) {
                    return ((IscBizException)((Object)ctx)).getCode();
                }
                return null;
            }
        } else if (ctx instanceof Collection) {
            if ("#FIRST".equals(name)) {
                return NameAccessorImpl.getFirst((Collection)ctx);
            }
            if ("#LAST".equals(name)) {
                return NameAccessorImpl.getLast((Collection)ctx);
            }
            return NameAccessorImpl.getColumnFromList(stub, name, (Collection)ctx, nullable, line);
        }
        if ((accessor = LifeScriptEngine.getPropertyAccessor(ctx.getClass())) != null) {
            return accessor.get(ctx, name);
        }
        String msg = "Script \"" + stub + "." + name + "\" can't get property \"" + name + "\" from  \"" + ctx.getClass().getName() + "\". line : " + line;
        throw new UnsupportedOperationException(msg);
    }

    private static Object returnNull(Object stub, String name, Object value, boolean nullable) {
        if (nullable) {
            return null;
        }
        String msg = "'" + stub + "." + name + "' can't get property '" + name + "' from NULL.";
        throw new UnsupportedOperationException(msg);
    }

    private static Object getFirst(Collection<?> c) {
        if (c.size() == 0) {
            return null;
        }
        if (c instanceof LinkedList) {
            return ((LinkedList)c).getFirst();
        }
        if (c instanceof List) {
            return ((List)c).get(0);
        }
        Iterator<?> iterator = c.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private static Object getLast(Collection<?> c) {
        if (c.size() == 0) {
            return null;
        }
        if (c instanceof LinkedList) {
            return ((LinkedList)c).getLast();
        }
        if (c instanceof List) {
            return ((List)c).get(c.size() - 1);
        }
        Object el = null;
        for (Object e : c) {
            el = e;
        }
        return el;
    }

    static Object getColumnFromList(Object stub, String name, Collection<?> c, boolean nullable, int line) {
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(NameAccessorImpl.getValue(stub, name, o, nullable, line));
        }
        return list;
    }

    private static Calendar getCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    @Override
    public Object set(ScriptContext ctx, Object value) {
        Object target = Util.eval(ctx, this.stub);
        return NameAccessorImpl.set(target, this.name, value, ctx, this.stub, false);
    }

    public static Object set(Object target, String name, Object value, ScriptContext ctx, Object stub, boolean nullable) {
        if (target == null) {
            return NameAccessorImpl.handleNullTarget(name, value, ctx, stub, nullable);
        }
        if (target instanceof Context) {
            return ((Context)target).set(name, value);
        }
        if (target instanceof Map) {
            return ((Map)target).put(name, value);
        }
        if (target instanceof ScriptContext) {
            Util.set((ScriptContext)target, name, value);
            return value;
        }
        if (target instanceof Collection) {
            if (value instanceof List) {
                return NameAccessorImpl.setList((Collection<Object>)((Collection)target), name, (List)value, ctx, stub, nullable);
            }
            return NameAccessorImpl.setList((Collection<Object>)((Collection)target), name, value, ctx, stub, nullable);
        }
        PropertyAccessor accessor = LifeScriptEngine.getPropertyAccessor(target.getClass());
        if (accessor != null) {
            return accessor.set(target, name, value);
        }
        String text = target.getClass().getName() + "'s property '" + name + "' can't be set!";
        throw new UnsupportedOperationException(text);
    }

    private static Object handleNullTarget(String name, Object value, ScriptContext ctx, Object stub, boolean nullable) {
        if (nullable) {
            if (value == null) {
                return null;
            }
            Object e = NameAccessorImpl.newElement(name, value);
            ((Storer)stub).set(ctx, e);
            return null;
        }
        String msg = "'" + stub + "." + name + "' can't set property '" + name + "' to NULL.";
        throw new UnsupportedOperationException(msg);
    }

    private static Object setList(Collection<Object> target, String name, Object value, ScriptContext ctx, Object stub, boolean nullable) {
        for (Object o : target) {
            if (o == null) continue;
            NameAccessorImpl.set(o, name, value, ctx, stub, nullable);
        }
        return target;
    }

    private static Object setList(Collection<Object> target, String name, List<?> list, ScriptContext ctx, Object stub, boolean nullable) {
        if (target.size() == list.size()) {
            Iterator<Object> is = target.iterator();
            Iterator<?> iv = list.iterator();
            while (is.hasNext()) {
                NameAccessorImpl.set(is.next(), name, iv.next(), ctx, stub, nullable);
            }
            return target;
        }
        if (target.size() == 0) {
            for (Object o : list) {
                HashMap item = new HashMap();
                item.put(name, o);
                target.add(item);
            }
            return target;
        }
        String message = "Collection's size not matched. stub: " + target + ", value: " + list;
        throw new UnsupportedOperationException(message);
    }

    private static Object newElement(String name, Object value) {
        if (value instanceof List) {
            return NameAccessorImpl.newList(name, (List)value);
        }
        return NameAccessorImpl.newMap(name, value);
    }

    private static Object newList(String name, List<?> c) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object e : c) {
            if (e instanceof List) {
                list.add(NameAccessorImpl.newList(name, (List)e));
                continue;
            }
            list.add(NameAccessorImpl.newMap(name, e));
        }
        return list;
    }

    private static Object newMap(String name, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(name, value);
        return map;
    }
}

