/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.analyzer.expr.Util;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.feature.control.decision.If;
import kd.isc.iscb.util.script.feature.op.store.Assign;

public class DecisionOperator {
    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len) throws ScriptException {
        if (len < 5) {
            return len;
        }
        int newLen;
        while ((newLen = DecisionOperator.processOnePass(engine, context, elements, len)) != len && newLen >= 5) {
            len = newLen;
        }
        return newLen;
    }

    private static int processOnePass(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len) throws ScriptException {
        Object s;
        int question = DecisionOperator.findQuestion(elements, len);
        if (question < 0) {
            return len;
        }
        int alter = DecisionOperator.findAlternatives(elements, question, len);
        if (alter < 0) {
            return len;
        }
        DecisionOperator.checkDistance(elements, question, alter);
        elements[question - 1] = s = DecisionOperator.createInvocation(engine, context, elements, len, question, alter);
        len = DecisionOperator.packArray(elements, len, question);
        return len;
    }

    private static void checkDistance(Object[] elements, int question, int alter) throws ScriptException {
        if (alter - question != 2) {
            throw new ScriptException("There are some invalid operators between '" + elements[question] + "' and '" + elements[alter] + "'");
        }
    }

    private static int packArray(Object[] elements, int len, int question) {
        len -= 4;
        for (int i = question; i < len; ++i) {
            elements[i] = elements[i + 4];
        }
        return len;
    }

    private static Object createInvocation(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int question, int alter) throws ScriptException {
        Object condition = Util.getPriorElement(elements, question - 1);
        Util.checkOperand(condition);
        Object truePart = elements[question + 1];
        Util.checkOperand(truePart);
        Object falsePart = Util.getNextElement(elements, alter + 1, len);
        Util.checkOperand(falsePart);
        return If.create(engine, context, -1, -1, condition, truePart, falsePart);
    }

    private static int findQuestion(Object[] elements, int len) {
        for (int i = len - 1; i >= 0; --i) {
            if (elements[i] != Operator.QUESTION) continue;
            return i;
        }
        return -1;
    }

    private static int findAlternatives(Object[] elements, int question, int len) {
        for (int i = question + 1; i < len; ++i) {
            if (elements[i] != Operator.COLON) continue;
            return i;
        }
        return -1;
    }

    static void precheck(Statement smt) {
        boolean hasAssign = false;
        boolean hasQuestion = false;
        int j = smt.length();
        for (int i = 0; i < j; ++i) {
            Object e = smt.get(i);
            if (e == Operator.QUESTION) {
                hasQuestion = true;
                continue;
            }
            if (!(e instanceof Assign)) continue;
            hasAssign = true;
        }
        if (hasQuestion && hasAssign) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"'?:'\u8868\u8fbe\u5f0f\u90e8\u5206\u5fc5\u987b\u7f6e\u4e8e\u62ec\u53f7\u4e2d\uff0c\u884c\u53f7\uff1a'%s'\u3002", (String)"DecisionOperator_1", (String)"isc-iscb-util", (Object[])new Object[0]), smt.line()));
        }
    }
}

