/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.feature.control.advanced.DebugTrap;
import kd.isc.iscb.util.script.feature.control.advanced.Debuggable;

public final class MapConstructor
implements Debuggable,
Evaluator {
    private Object[][] entries;
    private DebugTrap trap;

    public MapConstructor(Object[][] entries, int line) {
        this.entries = entries;
        this.trap = new DebugTrap("{}", line);
    }

    @Override
    public Map<Object, Object> eval(ScriptContext ctx) {
        this.trap.get(ctx);
        int initCapacity = this.entries.length == 0 ? 16 : this.entries.length;
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(initCapacity);
        for (Object[] entry : this.entries) {
            Object key = this.getKey(ctx, entry);
            Object value = Util.eval(ctx, entry[1]);
            map.put(key, value);
        }
        return map;
    }

    public Object getKey(ScriptContext ctx, Object[] entry) {
        Object key = entry[0];
        if (key instanceof Identifier) {
            return ((Identifier)key).name();
        }
        return Util.eval(ctx, entry[0]);
    }

    public int size() {
        return this.entries.length;
    }

    public Object getKey(int index) {
        return this.entries[index][0];
    }

    public Object getValue(int index) {
        return this.entries[index][1];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (Object[] entry : this.entries) {
            Object key = entry[0];
            Object value = entry[1];
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(key).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean attachBreakpoint(int line) {
        if (this.trap.attachBreakpoint(line)) {
            return true;
        }
        for (Object[] entry : this.entries) {
            Object value = entry[1];
            if (!(value instanceof Debuggable) || !((Debuggable)value).attachBreakpoint(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void detachBreakpoint(int line) {
        this.trap.detachBreakpoint(line);
        for (Object[] entry : this.entries) {
            Object value = entry[1];
            if (!(value instanceof Debuggable)) continue;
            ((Debuggable)value).detachBreakpoint(line);
        }
    }

    @Override
    public void collectBreakpoints(Set<Integer> breakpoints) {
        this.trap.collectBreakpoints(breakpoints);
        for (Object[] entry : this.entries) {
            Object value = entry[1];
            if (!(value instanceof Debuggable)) continue;
            ((Debuggable)value).collectBreakpoints(breakpoints);
        }
    }

    @Override
    public int line() {
        return this.trap.line();
    }
}

