/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.context;

import java.util.HashMap;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.encoding.Hex;
import kd.isc.iscb.util.script.misc.Consts;

public final class ArrayContext
implements Context {
    private Object[] args;
    private static final HashMap<String, Integer> map = new HashMap(3000);

    public ArrayContext(Object ... args) {
        this.args = args == null ? Consts.EMPTY_OBJ_ARRAY : args;
        if (this.args.length > 1000) {
            throw new IscBizException("argument's count is greater than 1000.");
        }
    }

    @Override
    public Object get(String property) {
        int i = ArrayContext.parse(this.args, property);
        return i < 0 ? null : this.args[i];
    }

    @Override
    public boolean contains(String property) {
        int i = ArrayContext.parse(this.args, property);
        return i >= 0;
    }

    @Override
    public boolean set(String property, Object value) {
        int i = ArrayContext.parse(this.args, property);
        if (i >= 0 && i < this.args.length) {
            this.args[i] = value;
            return true;
        }
        return false;
    }

    private static int parse(Object[] args, String property) {
        int index;
        if (args.length == 0) {
            return -1;
        }
        Integer i = map.get(property);
        if (i == null) {
            if (!Hex.isNumber(property)) {
                return -1;
            }
            i = Integer.valueOf(property);
        }
        return args.length >= (index = i.intValue()) ? index : -1;
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            map.put(String.valueOf(i), i);
            map.put("v" + i, i);
            map.put("V" + i, i);
        }
    }
}

