/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.data;

import java.util.Arrays;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.data.Schema;
import kd.isc.iscb.util.script.feature.op.compare.Equals;

public final class Tuple
implements Comparable<Tuple>,
Context {
    private Schema schema;
    private Object[] args;
    private int hash = 0;

    public Tuple(Schema schema, Object[] args) {
        this.schema = schema;
        this.args = (Object[])args.clone();
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash == 0) {
            this.hash = hash = Arrays.hashCode(this.args);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Equals.equals(this.args, other.args);
    }

    public Object get(int index) {
        return index < 0 ? null : this.args[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.schema.size(); ++i) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(this.args[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int compareTo(Tuple o) {
        Object[] a = this.args;
        Object[] b = o.args;
        for (int i = 0; i < a.length; ++i) {
            Comparable ca = (Comparable)a[i];
            Comparable cb = (Comparable)b[i];
            if (ca == null) {
                if (cb == null) continue;
                return -1;
            }
            if (cb == null) {
                return 1;
            }
            int c = ca.compareTo(cb);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public Object get(String property) {
        int index = this.schema.getIndex(property);
        if (index < 0 && Hex.isNumber(property)) {
            index = Integer.parseInt(property);
        }
        return this.get(index);
    }

    @Override
    public boolean set(String property, Object value) {
        return false;
    }

    @Override
    public boolean contains(String property) {
        return this.schema.contains(property);
    }

    public int size() {
        return this.schema.size();
    }
}

