/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.advanced;

import java.util.ArrayList;
import javax.script.ScriptException;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.LiteralBuilder;
import kd.isc.iscb.util.script.core.NotExpression;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.QName;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.StatementBuilder;
import kd.isc.iscb.util.script.core.StatementEnd;
import kd.isc.iscb.util.script.core.StatementStart;
import kd.isc.iscb.util.script.core.StopAnalyzeElements;
import kd.isc.iscb.util.script.core.VarDeclare;
import kd.isc.iscb.util.script.feature.control.advanced.FunctionImpl;
import kd.isc.iscb.util.script.feature.control.advanced.FunctionProxy;
import kd.isc.iscb.util.script.statement.Arguments;

public final class FunctionBuilder
implements Constructor,
StatementStart,
StatementEnd,
NotExpression,
StopAnalyzeElements,
VarDeclare {
    @Override
    public String name() {
        return "function";
    }

    public String toString() {
        return this.name();
    }

    @Override
    public StatementBuilder getStatementBuilder() {
        return null;
    }

    @Override
    public LiteralBuilder getLiteralBuilder() {
        return null;
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        int len = statement.length();
        if (len < 3) {
            throw new ScriptException("Function definition is invalid!", null, statement.line(), statement.column());
        }
        int i = 1;
        String name = null;
        if (statement.get(i) instanceof QName) {
            name = ((QName)statement.get(i++)).name();
        }
        String[] args = FunctionBuilder.generateArgs(statement.get(i++));
        Object body = ((Statement)statement.get(i++)).analyze();
        FunctionImpl impl = new FunctionImpl(statement.getEngine(), name, args, body, statement.line());
        FunctionProxy.postHandle(statement.getContext(), impl);
        if (i < len) {
            throw new ScriptException("Function definition is incomplete!", null, statement.line(), statement.column());
        }
        return impl;
    }

    static String[] generateArgs(Object params) throws ScriptException {
        if (params instanceof Arguments) {
            Arguments s = (Arguments)params;
            ArrayList<String> args = new ArrayList<String>(s.length());
            for (int i = 0; i < s.length(); ++i) {
                Object o = s.get(i);
                if (o == Operator.COMMA) continue;
                args.add(((Identifier)o).name());
            }
            return args.toArray(new String[args.size()]);
        }
        throw new ScriptException(params + " is an invalid parameters declaration!");
    }
}

