/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.decision;

import java.util.Set;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.feature.control.advanced.DebugTrap;
import kd.isc.iscb.util.script.feature.control.advanced.Debuggable;

final class Decision
implements Evaluator,
Debuggable {
    private DebugTrap _condition;
    private DebugTrap _trueBody;
    private DebugTrap _falseBody;

    Decision(Object condition, Object trueBody, int line) {
        this._condition = new DebugTrap(condition, line);
        this._trueBody = new DebugTrap(trueBody, -1);
        this._falseBody = new DebugTrap(null, -1);
    }

    Decision set(Object falseBody) {
        this._falseBody = new DebugTrap(falseBody, -1);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("if(").append(this._condition).append("){\r\n\t").append(this._trueBody).append("\r\n}");
        if (this._falseBody.directGetElement() != null) {
            sb.append("else{\r\n\t").append(this._falseBody).append("\r\n}");
        }
        return sb.toString();
    }

    @Override
    public Object eval(ScriptContext ctx) {
        boolean pass = Util.test(this._condition.get(ctx), ctx);
        if (pass) {
            return Util.eval(ctx, this._trueBody.get(ctx));
        }
        return Util.eval(ctx, this._falseBody.get(ctx));
    }

    @Override
    public boolean attachBreakpoint(int line) {
        return this._condition.attachBreakpoint(line) || this._trueBody.attachBreakpoint(line) || this._falseBody.attachBreakpoint(line);
    }

    @Override
    public void detachBreakpoint(int line) {
        this._condition.detachBreakpoint(line);
        this._trueBody.detachBreakpoint(line);
        this._falseBody.detachBreakpoint(line);
    }

    @Override
    public void collectBreakpoints(Set<Integer> breakpoints) {
        this._condition.collectBreakpoints(breakpoints);
        this._trueBody.collectBreakpoints(breakpoints);
        this._falseBody.collectBreakpoints(breakpoints);
    }

    @Override
    public int line() {
        return this._condition.line();
    }
}

