/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.loop;

import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.NotExpression;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.StopAnalyzeElements;
import kd.isc.iscb.util.script.feature.control.advanced.DebugTrap;
import kd.isc.iscb.util.script.feature.control.advanced.Debuggable;
import kd.isc.iscb.util.script.misc.Const;

public class Throw
implements Constructor,
Identifier,
NotExpression,
StopAnalyzeElements {
    public static final Const<Boolean> DISABLE_CODED_MESSAGE = new Const<Boolean>(Boolean.FALSE);

    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "throw";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object result = Util.getTail(statement, pos, 0);
        return this.createEvaluator(result, statement.line());
    }

    private Object createEvaluator(Object result, int line) {
        return new ThrowEvaluator(result, line);
    }

    public static String toMessage(Object value) {
        String message = value instanceof CharSequence ? value.toString() : Json2.toString(value);
        return message;
    }

    private static final class ThrowEvaluator
    implements Evaluator,
    Debuggable {
        private final DebugTrap trap;

        private ThrowEvaluator(Object result, int line) {
            this.trap = new DebugTrap(result, line);
        }

        @Override
        public Object eval(ScriptContext ctx) {
            Object result = this.trap.get(ctx);
            Object value = Util.eval(ctx, result);
            if (value instanceof Exception) {
                throw CommonError.SCRIPT_RUNTIME_ERROR.wrap((Throwable)value);
            }
            if (value == null || value instanceof CharSequence) {
                String message = D.s(value);
                if (message == null) {
                    throw new NullPointerException("{Message is empty.}");
                }
                throw new IscBizException(message);
            }
            throw new IscBizException(Throw.toMessage(value));
        }

        public String toString() {
            return "throw " + this.trap;
        }

        @Override
        public boolean attachBreakpoint(int line) {
            return this.trap.attachBreakpoint(line);
        }

        @Override
        public void detachBreakpoint(int line) {
            this.trap.detachBreakpoint(line);
        }

        @Override
        public void collectBreakpoints(Set<Integer> breakpoints) {
            this.trap.collectBreakpoints(breakpoints);
        }

        @Override
        public int line() {
            return this.trap.line();
        }
    }
}

