/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.op.arith;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.Storer;
import kd.isc.iscb.util.script.util.Numeric;

public class Increment
implements Constructor,
Operator {
    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "++";
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public int type() {
        return 3;
    }

    @Override
    public Object analyze(Statement statement, final Constructor.Position pos) throws ScriptException {
        final Storer ref = (Storer)pos.getOperand(statement, 0);
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Object value = Util.eval(ctx, ref);
                Object result = this.addOne(value);
                ref.set(ctx, result);
                return pos == Constructor.Position.HEADER ? result : value;
            }

            private Object addOne(Object value) {
                Number result;
                if (value == null) {
                    return 1;
                }
                switch (Numeric.getType(value)) {
                    case 6: 
                    case 7: 
                    case 8: {
                        result = ((Number)value).intValue() + 1;
                        break;
                    }
                    case 5: {
                        result = ((Number)value).longValue() + 1L;
                        break;
                    }
                    case 4: {
                        result = ((BigInteger)value).add(BigInteger.ONE);
                        break;
                    }
                    case 1: {
                        result = ((BigDecimal)value).add(BigDecimal.ONE);
                        break;
                    }
                    case 2: 
                    case 3: {
                        result = ((Number)value).doubleValue() + 1.0;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301++%1$s\uff0c\u53d8\u91cf\u662f\uff1a%2$s", (String)"Increment_2", (String)"isc-iscb-util", (Object[])new Object[0]), value, ref));
                    }
                }
                return result;
            }

            public String toString() {
                return pos == Constructor.Position.HEADER ? Increment.this.name() + ref : ref + Increment.this.name();
            }
        };
    }
}

