/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.script.core.Storer;

public class ValueReader {
    private Storer assign;
    private List<Integer> columns;
    private volatile List<String> labels;
    private boolean is_array;

    public ValueReader(Storer assign, List<Integer> columns, boolean is_array) {
        this.assign = assign;
        this.columns = columns;
        this.is_array = is_array;
    }

    public boolean isArray() {
        return this.is_array;
    }

    public Storer getAssign() {
        return this.assign;
    }

    public Object read(ResultSet rs) throws SQLException {
        if (this.columns.size() == 1) {
            return DbUtil.read(rs, this.columns.get(0));
        }
        return this.readRow(rs);
    }

    private Object readRow(ResultSet rs) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>(this.columns.size());
        List<String> labels = this.getLabels(rs);
        for (int i = 0; i < this.columns.size(); ++i) {
            int column = this.columns.get(i);
            Object value = DbUtil.read(rs, column);
            String key = labels.get(i);
            row.put(key, value);
        }
        return row;
    }

    private List<String> getLabels(ResultSet rs) throws SQLException {
        List<String> labels = this.labels;
        if (labels == null) {
            return this.constructLabels(rs);
        }
        return labels;
    }

    private List<String> constructLabels(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        ArrayList<String> labels = new ArrayList<String>(this.columns.size());
        for (int column : this.columns) {
            String label = meta.getColumnLabel(column).toLowerCase();
            labels.add(label);
        }
        this.labels = labels;
        return labels;
    }
}

