/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;

abstract class Base
implements NativeFunction {
    Base() {
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object[] values = this.getValues(args);
        this.prepare(ctx, args, values);
        return this.calc(ctx, values);
    }

    private void prepare(ScriptContext ctx, Object[] args, Object[] values) {
        int index = args.length - 1;
        if (values.length > 0 && args[index] instanceof NativeFunction) {
            NativeFunction fn = (NativeFunction)args[index];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value instanceof NativeFunction) continue;
                values[i] = fn.call(ctx, new Object[]{value});
            }
        }
    }

    private Object[] getValues(Object[] args) {
        int len = args.length;
        if (len == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        if (len > 1 && !(args[len - 1] instanceof NativeFunction)) {
            return args;
        }
        if (len > 2 && args[len - 1] instanceof NativeFunction) {
            Object[] values = new Object[len - 1];
            System.arraycopy(args, 0, values, 0, len - 1);
            return values;
        }
        Object first = args[0];
        if (first == null) {
            return new Object[0];
        }
        if (first instanceof Collection) {
            return ((Collection)first).toArray();
        }
        if (first instanceof Map) {
            return ((Map)first).entrySet().toArray();
        }
        if (first.getClass().isArray()) {
            Object[] values = new Object[Array.getLength(first)];
            System.arraycopy(first, 0, values, 0, values.length);
            return values;
        }
        throw new UnsupportedOperationException();
    }

    abstract Object calc(ScriptContext var1, Object[] var2);
}

