/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.data.sls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.core.Style;
import kd.isc.iscb.util.script.feature.tool.data.sls.Diff;
import kd.isc.iscb.util.script.feature.tool.data.sls.Element;
import kd.isc.iscb.util.script.feature.tool.data.sls.Feature;
import kd.isc.iscb.util.script.feature.tool.data.sls.ShortListSelector;

public class ChooseShortList
implements NativeFunction {
    @Override
    public String name() {
        return "choose_short_list";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        ShortListSelector selector = this.generateSelector(args);
        int total = ((Number)args[1]).intValue();
        int maxTries = this.getMaxTries(args);
        Set<Element> fixed = this.getFixed(args, selector);
        Element[] selected = selector.choose(total, maxTries, fixed);
        this.outputLog(selector);
        return this.assembeResult(selected);
    }

    private void outputLog(ShortListSelector selector) {
        if (selector.isDebug()) {
            selector.outputDifferences();
        }
    }

    private Object assembeResult(Element[] selected) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Element e : selected) {
            list.add(e.getId());
        }
        return list;
    }

    private Set<Element> getFixed(Object[] args, ShortListSelector selector) {
        Set<Element> required;
        Object a2 = args.length < 3 ? null : args[2];
        Object a3 = args.length < 4 ? null : args[3];
        Collection fixed = null;
        if (a2 instanceof Collection) {
            fixed = (Collection)a2;
        } else if (a3 instanceof Collection) {
            fixed = (Collection)a3;
        }
        if (fixed != null) {
            required = new HashSet<Element>(fixed.size());
            HashMap<Object, Element> mapping = new HashMap<Object, Element>(64);
            int j = selector.getCandidateCount();
            for (int i = 0; i < j; ++i) {
                Element e = selector.getCandidate(i);
                mapping.put(e.getId(), e);
            }
            for (Object id : fixed) {
                required.add((Element)mapping.get(id));
                if (id != Style.DEBUG) continue;
                selector.setDebug(true);
            }
        } else {
            required = Collections.emptySet();
        }
        return required;
    }

    private int getMaxTries(Object[] args) {
        Object a3;
        Object a2 = args.length < 3 ? null : args[2];
        Object object = a3 = args.length < 4 ? null : args[3];
        int maxTries = a2 instanceof Number ? ((Number)a2).intValue() : (a3 instanceof Number ? ((Number)a3).intValue() : 64);
        return maxTries;
    }

    private ShortListSelector generateSelector(Object[] args) {
        Map groups = (Map)args[0];
        HashMap<Object, List<Feature>> candidates = new HashMap<Object, List<Feature>>();
        ArrayList<Feature> all_features = new ArrayList<Feature>(groups.size() * 4);
        this.preHandle(groups, candidates, all_features);
        Element[] elements = this.prepareCandidates(candidates);
        Feature[] features = all_features.toArray(new Feature[all_features.size()]);
        ShortListSelector selector = new ShortListSelector(features);
        selector.prepare(elements);
        return selector;
    }

    private Element[] prepareCandidates(Map<Object, List<Feature>> candidates) {
        Element[] elements = new Element[candidates.size()];
        int i = 0;
        for (Map.Entry<Object, List<Feature>> e : candidates.entrySet()) {
            List<Feature> list = e.getValue();
            Feature[] features = list.toArray(new Feature[list.size()]);
            elements[i] = new Element(e.getKey(), features);
            ++i;
        }
        return elements;
    }

    private void preHandle(Map<?, ?> groups, Map<Object, List<Feature>> candidates, List<Feature> all_features) {
        for (Map.Entry<?, ?> g : groups.entrySet()) {
            Object group = g.getKey();
            Map features = (Map)g.getValue();
            for (Map.Entry f : features.entrySet()) {
                Map param = (Map)f.getValue();
                double ratio = ((Number)param.get("ratio")).doubleValue();
                Number n = (Number)param.get("weight");
                double weight = n == null ? 1.0 : n.doubleValue();
                String s = (String)param.get("diff");
                Diff diff = s == null ? Diff.DUAL : Diff.valueOf(s);
                Feature feature = new Feature(f.getKey(), group, weight, ratio, diff);
                all_features.add(feature);
                for (Object c : (Collection)param.get("candidates")) {
                    List<Feature> list = candidates.get(c);
                    if (list == null) {
                        list = new ArrayList<Feature>(groups.size());
                        candidates.put(c, list);
                    }
                    list.add(feature);
                }
            }
        }
    }
}

