/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.data.sls;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.feature.tool.data.sls.Element;
import kd.isc.iscb.util.script.feature.tool.data.sls.Feature;
import kd.isc.iscb.util.script.feature.tool.data.sls.Util;

public final class ShortListSelector {
    private Map<Object, Map<Feature, Integer>> features;
    private Map<Feature, Integer> allFeatures;
    private Element[] candidates;
    private double weightSpace;
    private boolean debug = false;
    private transient boolean[] best = null;
    private transient int[] best_counter = null;
    private transient double min_diff;
    private transient double[] expected;
    private SecureRandom rand = new SecureRandom();

    public ShortListSelector(Feature ... features) {
        this.features = new LinkedHashMap<Object, Map<Feature, Integer>>(features.length);
        this.allFeatures = new LinkedHashMap<Feature, Integer>(features.length);
        for (Feature f : features) {
            Object group = f.getGroup();
            Map<Feature, Integer> map = this.features.get(group);
            if (map == null) {
                map = new HashMap<Feature, Integer>();
                this.features.put(group, map);
            }
            this.allFeatures.put(f, this.allFeatures.size());
            map.put(f, map.size());
        }
    }

    public void prepare(Element ... candidates) {
        double weight;
        int j;
        for (Element e : candidates) {
            e.setWeight(1.0);
        }
        for (Map.Entry entry : this.features.entrySet()) {
            Object group = entry.getKey();
            Map features = (Map)entry.getValue();
            Util.CalcWeights(group, features, candidates);
        }
        double min = Double.MAX_VALUE;
        int n = candidates.length;
        for (j = 0; j < n; ++j) {
            weight = candidates[j].getWeight();
            if (!(weight < min)) continue;
            min = weight;
        }
        this.weightSpace = 0.0;
        for (j = 0; j < n; ++j) {
            weight = candidates[j].getWeight() / min;
            candidates[j].setWeight(weight);
            this.weightSpace += weight;
        }
        this.candidates = candidates;
    }

    public int getCandidateCount() {
        return this.candidates.length;
    }

    public Element getCandidate(int i) {
        return this.candidates[i];
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Element[] choose(int count, int maxRetries, Element fixed) {
        Set<Element> set = Collections.singleton(fixed);
        return this.choose(count, maxRetries, set);
    }

    public Element[] choose(int count, int maxRetries) {
        Set<Element> fixed = Collections.emptySet();
        return this.choose(count, maxRetries, fixed);
    }

    public Element[] choose(int count, int maxRetries, Set<Element> fixed) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        if (count >= this.candidates.length) {
            return (Element[])this.candidates.clone();
        }
        this.expected = new double[this.allFeatures.size()];
        for (Map.Entry<Feature, Integer> item : this.allFeatures.entrySet()) {
            this.expected[item.getValue().intValue()] = (double)count * item.getKey().getProportion();
        }
        this.min_diff = Double.MAX_VALUE;
        while (maxRetries >= 0) {
            int i;
            --maxRetries;
            double space = this.weightSpace;
            int[] counter = new int[this.allFeatures.size()];
            boolean[] selected = new boolean[this.candidates.length];
            int remains = count;
            for (i = 0; i < selected.length; ++i) {
                Element e = this.candidates[i];
                if (!fixed.contains(e)) continue;
                --remains;
                space = this.setSelected(counter, selected, e, i, space);
            }
            block3: for (i = 0; i < remains; ++i) {
                double hitted = this.rand.nextDouble() * space;
                double total = 0.0;
                for (int j = 0; j < this.candidates.length; ++j) {
                    Element e;
                    if (selected[j] || !((total += (e = this.candidates[j]).getWeight()) >= hitted)) continue;
                    space = this.setSelected(counter, selected, e, j, space);
                    continue block3;
                }
            }
            double diff = 0.0;
            for (Map.Entry<Feature, Integer> item : this.allFeatures.entrySet()) {
                Feature f = item.getKey();
                Integer index = item.getValue();
                diff += f.getDiff().calc(counter[index], this.expected[index]) * f.getWeight();
            }
            if (!(diff < this.min_diff)) continue;
            this.min_diff = diff;
            this.best = selected;
            this.best_counter = counter;
            if (diff != 0.0) continue;
            break;
        }
        ArrayList<Element> result = new ArrayList<Element>(count);
        for (int i = 0; i < this.best.length; ++i) {
            if (!this.best[i]) continue;
            result.add(this.candidates[i]);
        }
        return result.toArray(new Element[result.size()]);
    }

    private double setSelected(int[] counter, boolean[] selected, Element e, int i, double space) {
        selected[i] = true;
        space -= e.getWeight();
        for (Feature f : e.getFeatures()) {
            int n = this.allFeatures.get(f);
            counter[n] = counter[n] + 1;
        }
        return space;
    }

    public String outputDifferences() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<Feature, Integer> item : this.allFeatures.entrySet()) {
            Feature feature = item.getKey();
            Integer count = item.getValue();
            s.append(feature.getGroup()).append('.').append(feature.getId()).append('\t').append(feature.getProportion()).append(ResManager.loadKDString((String)"\uff1b\t\u8981\u6c42\uff1a", (String)"ShortListSelector_0", (String)"isc-iscb-util", (Object[])new Object[0])).append((double)Math.round(this.expected[count] * 10.0) / 10.0).append(ResManager.loadKDString((String)"\uff1b\u3000\u3000\u5b9e\u9645\uff1a", (String)"ShortListSelector_1", (String)"isc-iscb-util", (Object[])new Object[0])).append(this.best_counter[count]);
        }
        return s.toString();
    }
}

