/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.misc;

import java.util.UUID;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.script.data.BinaryString;

public final class UuidUtil {
    public static byte[] toBytes(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        byte[] bytes = new byte[16];
        long mst = uuid.getMostSignificantBits();
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(0xFFL & mst);
            mst >>>= 8;
        }
        long lst = uuid.getLeastSignificantBits();
        for (int i = 15; i >= 8; --i) {
            bytes[i] = (byte)(0xFFL & lst);
            lst >>>= 8;
        }
        return bytes;
    }

    public static UUID toUUID(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof UUID) {
            return (UUID)v;
        }
        if (v instanceof byte[]) {
            byte[] data = (byte[])v;
            if (data.length == 0) {
                return null;
            }
            return UuidUtil.restoreFromBytes(data);
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 36) {
                return UUID.fromString(s);
            }
            if (s.length() == 32) {
                byte[] bytes = Hex.decode(s);
                return UuidUtil.restoreFromBytes(bytes);
            }
        }
        if (v instanceof BinaryString) {
            BinaryString b = (BinaryString)v;
            if (((BinaryString)v).getLength() == 16) {
                byte[] bytes = b.getBytes();
                return UuidUtil.restoreFromBytes(bytes);
            }
        }
        throw new IllegalArgumentException("{" + v + "} is invalid UUID.");
    }

    public static boolean isUuid(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() != 36) {
            return false;
        }
        int p = -1;
        for (int span : new int[]{8, 4, 4, 4, 12}) {
            for (int j = 0; j < span; ++j) {
                char c;
                if (UuidUtil.isHexDigital(c = s.charAt(++p))) continue;
                return false;
            }
            if (span == 12 || s.charAt(++p) == '-') continue;
            return false;
        }
        return true;
    }

    private static boolean isHexDigital(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static UUID restoreFromBytes(byte[] data) {
        int i;
        if (data.length != 16) {
            throw new IllegalArgumentException("The length of byte array is not 16.");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

