/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.parser;

import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.accessor.PathAccessor;
import kd.isc.iscb.util.script.core.BlockEnd;
import kd.isc.iscb.util.script.core.BlockStart;
import kd.isc.iscb.util.script.core.Comment;
import kd.isc.iscb.util.script.core.LiteralBuilder;
import kd.isc.iscb.util.script.core.LiteralQuotation;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.StatementBuilder;
import kd.isc.iscb.util.script.core.StatementDepressor;
import kd.isc.iscb.util.script.core.StatementEnd;
import kd.isc.iscb.util.script.core.StatementStart;
import kd.isc.iscb.util.script.core.ToolKit;
import kd.isc.iscb.util.script.core.VarDeclare;
import kd.isc.iscb.util.script.data.BinaryString;
import kd.isc.iscb.util.script.encoding.Encoding;
import kd.isc.iscb.util.script.feature.control.advanced.Debug;
import kd.isc.iscb.util.script.feature.control.advanced.FunctionProxy;
import kd.isc.iscb.util.script.feature.control.advanced.Use;
import kd.isc.iscb.util.script.feature.control.decision.Else;
import kd.isc.iscb.util.script.feature.control.decision.If;
import kd.isc.iscb.util.script.parser.JsonParser;
import kd.isc.iscb.util.script.parser.Null;
import kd.isc.iscb.util.script.parser.Program;
import kd.isc.iscb.util.script.parser.ScriptReader;
import kd.isc.iscb.util.script.statement.Block;
import kd.isc.iscb.util.script.util.Numeric;
import kd.isc.iscb.util.script.util.Symbol;

public final class ScriptParser {
    public static final String FIELD_ELEMENTS = UUID.randomUUID().toString();
    private LifeScriptEngine engine;
    private ScriptReader reader;
    private Map<String, Object> context;
    private Object prior;
    private char[] buffer = new char[128];
    private LiteralBuilder literalBuilder = null;

    public ScriptParser(LifeScriptEngine engine, Reader input, Map<String, Object> context) {
        this(engine, input, null, context);
    }

    public ScriptParser(LifeScriptEngine engine, Reader input, String res, Map<String, Object> context) {
        this.engine = engine;
        this.reader = new ScriptReader(input, res);
        this.context = context;
    }

    public Program parse() throws ScriptException {
        Object impl = this.readElement();
        if (impl instanceof Statement) {
            impl = ((Statement)impl).analyze();
        }
        return new Program(this.engine, this.reader, impl, this.context);
    }

    public Object parseJson() throws ScriptException {
        Object impl = this.readElement();
        return JsonParser.eval(impl);
    }

    public Object parseOnly() throws ScriptException {
        Object impl = this.readElement();
        return impl;
    }

    private Object readStatement(BlockEnd terminator) throws ScriptException {
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<Object> buffer = new ArrayList<Object>();
        int smtLine = this.reader.getLine();
        int smtColumn = this.reader.getColumn();
        this.reader.skipWhiteSpace();
        int line = this.reader.getLine();
        int column = this.reader.getColumn();
        boolean isBlock = false;
        Object prior = Operator.COMMA;
        while (true) {
            Object el = this.readElement();
            if (prior == Operator.COMMA && el == Operator.COMMA) {
                buffer.add(Null.KEYWORD);
            }
            prior = el;
            if (el instanceof Comment) {
                if (!buffer.isEmpty()) continue;
                this.reader.skipWhiteSpace();
                line = this.reader.getLine();
                column = this.reader.getColumn();
                continue;
            }
            if (this.isEnd(terminator, el, this.reader.getLine(), this.reader.getColumn())) break;
            if (el instanceof Block && buffer.size() > 0 && buffer.get(0) instanceof StatementStart && ((Block)el).terminator() == BlockEnd.BLOCK) {
                buffer.add(el);
                el = this.engine.getStyle().defaultTerminator();
            }
            if (!(el instanceof StatementEnd)) {
                el = FunctionProxy.preHandle(this.context, buffer, el);
                buffer.add(el);
                continue;
            }
            isBlock = true;
            this.processStatementTerminator(elements, buffer, line, column, el);
            this.reader.skipWhiteSpace();
            line = this.reader.getLine();
            column = this.reader.getColumn();
            this.prepareForNextStatement(buffer);
        }
        if (elements.size() == 0) {
            return this.createStatement(smtLine, smtColumn, buffer, terminator, false);
        }
        if (buffer.size() > 0) {
            Object s = this.createStatement(line, column, buffer, this.engine.getStyle().defaultTerminator(), false);
            elements.add(s);
        }
        return this.createStatement(smtLine, smtColumn, elements, terminator, isBlock);
    }

    private void prepareForNextStatement(List<Object> buffer) {
        this.reader.skipWhiteSpace();
    }

    private void processStatementTerminator(List<Object> elements, List<Object> buffer, int line, int column, Object el) throws ScriptException {
        if (el instanceof StatementStart) {
            if (buffer.size() > 0 && !(buffer.get(buffer.size() - 1) instanceof StatementDepressor)) {
                Object s = this.createStatement(line, column, buffer, this.engine.getStyle().defaultTerminator(), false);
                elements.add(s);
                buffer.clear();
            }
            buffer.add(el);
        } else {
            Object s = this.createStatement(line, column, buffer, (StatementEnd)el, false);
            elements.add(s);
            buffer.clear();
        }
    }

    private Object createStatement(int line, int column, List<Object> elements, StatementEnd terminator, boolean isBlock) throws ScriptException {
        Object first;
        StatementBuilder sb = null;
        if (elements.size() > 0 && (first = elements.get(0)) instanceof StatementStart) {
            sb = ((StatementStart)first).getStatementBuilder();
        }
        if (sb == null) {
            sb = (StatementBuilder)this.engine.getBuilder(terminator);
        } else {
            this.literalBuilder = null;
        }
        return sb.build(this.engine, this.context, line, column, terminator, elements, isBlock);
    }

    private boolean isEnd(BlockEnd terminator, Object el, int line, int column) throws ScriptException {
        if (!(el instanceof BlockEnd)) {
            return false;
        }
        if (el == terminator) {
            return true;
        }
        throw new ScriptException("Brackets dismatched, requires '" + terminator.name() + "', but meets '" + el + "'. line : " + line + ", column : " + column);
    }

    private Object readElement() throws ScriptException {
        Object el = this.checkPrior(this.readWord());
        if (el instanceof BlockStart) {
            return this.readStatement(((BlockStart)el).end());
        }
        return el;
    }

    private Object checkPrior(Object el) {
        Object prior = this.prior;
        if (prior instanceof Use) {
            if (el instanceof ToolKit) {
                Use.registerTools(this.context, (ToolKit)el);
            }
        } else if (el instanceof If && prior instanceof Else) {
            throw new IscBizException(ResManager.loadKDString((String)"\u7981\u6b62\u4f7f\u7528 'else if' \u8bed\u6cd5\u7ed3\u6784\u3002", (String)"ScriptParser_0", (String)"isc-iscb-util", (Object[])new Object[0]));
        }
        this.prior = el;
        return el;
    }

    private Object readWord() throws ScriptException {
        Object el;
        int c = Symbol.skipWhiteSpace(this.reader);
        LiteralQuotation quot = LiteralQuotation.get(c);
        if (quot != null) {
            el = this.readLiteral(quot);
        } else if (Symbol.isNumber(c)) {
            this.reader.backspace();
            el = this.readNumber();
        } else if (c == -2) {
            el = BlockStart.PROGRAM;
        } else if (c == -1) {
            el = BlockEnd.PROGRAM;
        } else if (Symbol.isSeperator(c)) {
            this.reader.backspace();
            el = this.readOperater();
        } else {
            el = Symbol.isAt(c) ? this.readIdentifier() : this.readIdentifier(c);
        }
        if (el instanceof Debug) {
            el = ((Debug)el).build(this.reader);
        }
        this.registerElement(el);
        return el;
    }

    private void registerElement(Object el) {
        HashSet<Object> elements;
        if (el instanceof StatementStart) {
            this.literalBuilder = ((StatementStart)el).getLiteralBuilder();
        }
        if ((elements = (HashSet<Object>)this.context.get(FIELD_ELEMENTS)) == null) {
            elements = new HashSet<Object>();
            this.context.put(FIELD_ELEMENTS, elements);
        }
        elements.add(el);
    }

    private Object readLiteral(LiteralQuotation quot) throws ScriptException {
        int sp = 0;
        int c = this.reader.read();
        while (c >= 0) {
            if (c == quot.getEscape()) {
                sp = this.pushChar(sp, this.readEscape());
            } else {
                if (c == quot.getChar()) break;
                sp = this.pushChar(sp, (char)c);
            }
            c = this.reader.read();
        }
        String text = new String(this.buffer, 0, sp);
        LiteralBuilder builder = this.getLiteralBuilder(quot);
        return builder.build(this.context, text, quot);
    }

    private LiteralBuilder getLiteralBuilder(LiteralQuotation quot) {
        LiteralBuilder builder = this.literalBuilder;
        if (builder == null) {
            builder = (LiteralBuilder)this.engine.getBuilder(quot);
        }
        return builder;
    }

    private int pushChar(int sp, char c) {
        if (sp == this.buffer.length) {
            char[] a = new char[sp + sp];
            System.arraycopy(this.buffer, 0, a, 0, sp);
            this.buffer = a;
        }
        this.buffer[sp++] = c;
        return sp;
    }

    private Object readOperater() {
        String s;
        int sp = 0;
        int c = this.reader.read();
        while (c > 0) {
            if (sp == 0 || Symbol.isOperater(c)) {
                sp = this.pushChar(sp, (char)c);
                if (this.engine.getStyle().isTerminater(c)) {
                    break;
                }
            } else {
                this.reader.backspace();
                break;
            }
            c = this.reader.read();
        }
        if (!(s = new String(this.buffer, 0, sp)).startsWith("//")) {
            return Util.get(s, this.context, this.engine);
        }
        Symbol.readToLineEnd(this.reader);
        return Comment.EMPTY;
    }

    private Object readIdentifier() throws ScriptException {
        int sp = 0;
        int bracket_count = 0;
        int prior = 0;
        int c = this.reader.read();
        while (c > 0) {
            if (prior != 92) {
                if (Symbol.isWhiteSpace(c) || Symbol.isPathEnd(c) || Symbol.isTerminater(c) && sp == 0) {
                    this.reader.backspace();
                    break;
                }
                if (Symbol.isBlockEnd(c) && --bracket_count < 0) {
                    this.reader.backspace();
                    break;
                }
                if (Symbol.isBlockStart(c)) {
                    ++bracket_count;
                }
            }
            sp = this.pushChar(sp, (char)c);
            prior = c;
            c = this.reader.read();
        }
        if (sp == 0) {
            return Util.get("@", this.context, this.engine);
        }
        String path = new String(this.buffer, 0, sp);
        return PathAccessor.parse(path, this.context, this.engine, this.reader.getLine());
    }

    private Object readIdentifier(int c) {
        int sp = this.pushChar(0, (char)c);
        c = this.reader.read();
        while (c > 0) {
            if (Symbol.isSeperator(c)) {
                this.reader.backspace();
                break;
            }
            sp = this.pushChar(sp, (char)c);
            c = this.reader.read();
        }
        String name = new String(this.buffer, 0, sp);
        if (this.prior instanceof VarDeclare) {
            return Util.createReference(name, this.context);
        }
        return Util.get(name, this.context, this.engine);
    }

    private Object readNumber() {
        String s = this.readNumberString();
        if (".".equals(s) || "..".equals(s)) {
            return Util.get(s, this.context, this.engine);
        }
        if (s.startsWith("0x")) {
            byte[] bytes = Encoding.HEX.decode(s.substring(2).getBytes(Charset.forName("UTF-8")));
            return new BinaryString(bytes);
        }
        return Numeric.parse(s);
    }

    private String readNumberString() {
        boolean hasDigital = false;
        int prior = -1;
        boolean isHex = false;
        int sp = 0;
        int c = this.reader.read();
        while (c > 0) {
            if (!(Symbol.isNumber(c) || hasDigital && Numeric.isNumberFlag(c) || (prior == 101 || prior == 69) && (c == 45 || c == 43) || isHex && (c >= 97 && c <= 102 || c >= 65 && c <= 70))) {
                this.reader.backspace();
                break;
            }
            sp = this.pushChar(sp, (char)c);
            hasDigital = hasDigital || Symbol.isDigital(c);
            isHex = isHex || c == 120;
            prior = c;
            c = this.reader.read();
        }
        return new String(this.buffer, 0, sp);
    }

    private char readEscape() {
        int c = this.reader.read();
        switch (c) {
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 117: {
                return this.readUnicodeChar();
            }
        }
        return (char)c;
    }

    private char readUnicodeChar() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int c = this.reader.read();
            int d = c - 48;
            if (d >= 49) {
                d -= 39;
            } else if (d >= 17) {
                d -= 7;
            }
            if (d >= 16 || d < 0) {
                throw new IscBizException((char)c + " can't be used in \\uXXXX.");
            }
            n = (n << 4) + d;
        }
        return (char)n;
    }
}

