/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.util;

import kd.isc.iscb.util.script.parser.ScriptReader;

public final class Symbol {
    public static final char AT = '@';

    public static int skipWhiteSpace(ScriptReader reader) {
        int c = reader.read();
        while (Symbol.isWhiteSpace(c)) {
            c = reader.read();
        }
        return c;
    }

    public static boolean isWhiteSpace(int c) {
        return c >= 0 && c <= 32 || c == 65279;
    }

    public static boolean isOperater(int c) {
        switch (c) {
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 92: 
            case 94: 
            case 124: 
            case 126: 
            case 65306: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSeperator(int c) {
        if (Symbol.isWhiteSpace(c)) {
            return true;
        }
        if (Symbol.isOperater(c)) {
            return true;
        }
        return Symbol.isTerminater(c);
    }

    public static boolean isAlphabet(int c) {
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 97 && c <= 122) {
            return true;
        }
        return c == 95;
    }

    public static boolean isDigital(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isStatementStart(int c) {
        switch (c) {
            case -2: 
            case 40: 
            case 91: 
            case 123: 
            case 65288: 
            case 65371: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockStart(int c) {
        switch (c) {
            case -2: 
            case 40: 
            case 91: 
            case 123: 
            case 65288: 
            case 65371: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockEnd(int c) {
        switch (c) {
            case -1: 
            case 41: 
            case 93: 
            case 125: 
            case 65289: 
            case 65373: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatementEnd(int c) {
        switch (c) {
            case -1: 
            case 41: 
            case 44: 
            case 58: 
            case 59: 
            case 93: 
            case 125: 
            case 65289: 
            case 65292: 
            case 65306: 
            case 65307: 
            case 65373: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPathEnd(int c) {
        switch (c) {
            case -1: 
            case 44: 
            case 59: 
            case 65292: 
            case 65307: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTerminater(int c) {
        switch (c) {
            case -2: 
            case -1: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 58: 
            case 59: 
            case 91: 
            case 93: 
            case 96: 
            case 123: 
            case 125: 
            case 65288: 
            case 65289: 
            case 65292: 
            case 65306: 
            case 65307: 
            case 65371: 
            case 65373: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEOF(int c) {
        return c < 0;
    }

    public static String toString(int c) {
        if (c >= 0) {
            return String.valueOf((char)c);
        }
        return "{eof}";
    }

    public static boolean isNumber(int c) {
        return Symbol.isDigital(c) || c == 46;
    }

    public static void readToLineEnd(ScriptReader reader) {
        while (!reader.isEOF()) {
            int c = reader.read();
            if (c != 13 && c != 10) continue;
            return;
        }
    }

    public static boolean isAt(int c) {
        return c == 64;
    }

    public static boolean isWhitespaceOrTerminator(int c) {
        if (Symbol.isTerminater(c)) {
            return true;
        }
        return Symbol.isWhiteSpace(c);
    }
}

