/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.trace;

import java.sql.Timestamp;
import kd.isc.iscb.util.trace.TraceOutput;
import kd.isc.iscb.util.trace.TraceState;

public final class TraceItem {
    private long id;
    private String type;
    private String number;
    private long defId;
    private String tag;
    private long traceId;
    private boolean disableInnerTrace = false;
    private TraceState state;
    private Timestamp startTime;
    private int elapsedTime;
    private long priorId = 0L;
    private String priorTag = " ";

    TraceItem(long traceId, String type, String number, long defId, TraceItem prior) {
        this.traceId = traceId;
        this.type = type;
        this.number = this.ensure(number);
        this.id = TraceOutput.INSTANCE.get().newId();
        this.defId = defId != 0L ? defId : -this.id;
        this.startTime = new Timestamp(System.currentTimeMillis());
        if (prior != null) {
            this.priorId = prior.id;
            this.priorTag = prior.tag == null ? " " : prior.tag;
            this.disableInnerTrace = prior.disableInnerTrace;
        }
    }

    private String ensure(String number) {
        if (number == null || number.length() == 0) {
            return "{none}";
        }
        return number;
    }

    public boolean isDisableTrace() {
        return this.disableInnerTrace;
    }

    public long getId() {
        return this.id;
    }

    public long getDefId() {
        return this.defId;
    }

    public String getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public long getPriorId() {
        return this.priorId;
    }

    public String getPriorTag() {
        return this.priorTag;
    }

    public TraceState getState() {
        return this.state;
    }

    public String toString() {
        return this.number + "@" + this.type + "/" + this.defId;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void disableTrace() {
        this.disableInnerTrace = true;
    }

    public void enableTrace() {
        this.disableInnerTrace = false;
    }

    void submit(TraceState state) {
        assert (state != null);
        this.state = state;
        this.elapsedTime = (int)Math.max(1L, System.currentTimeMillis() - this.startTime.getTime());
        if (!this.disableInnerTrace) {
            TraceOutput.INSTANCE.get().save(this);
        }
    }
}

