/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.trace;

import java.util.LinkedList;
import kd.isc.iscb.util.trace.TraceItem;
import kd.isc.iscb.util.trace.TraceOutput;
import kd.isc.iscb.util.trace.TraceState;
import kd.isc.iscb.util.trace.TraceTask;

public class TraceManager {
    public static final String UNDEFINED = "UNDEFINED";
    private static ThreadLocal<TraceInfo> ctx = new ThreadLocal();

    public static Object trace(long traceId, String type, String number, long defId, TraceTask task) {
        if (TraceOutput.INSTANCE.get().isTraceEnabled()) {
            return TraceManager.withTrace(traceId, type, number, defId, task);
        }
        return task.invoke();
    }

    public static Object trace(TraceItem current, TraceTask task) {
        if (current != null) {
            return TraceManager.traceWithTrace(current, task);
        }
        return task.invoke();
    }

    public static TraceItem current() {
        TraceInfo info = ctx.get();
        if (info == null) {
            return null;
        }
        if (info.stack.isEmpty()) {
            return null;
        }
        return (TraceItem)info.stack.getLast();
    }

    public static boolean contains(String type) {
        TraceInfo info = ctx.get();
        if (info == null) {
            return false;
        }
        for (TraceItem item : info.stack) {
            if (!type.equals(item.getType())) continue;
            return true;
        }
        return false;
    }

    public static void disableTrace() {
        TraceItem item = TraceManager.current();
        if (item != null) {
            item.disableTrace();
        }
    }

    public static void enableTrace() {
        TraceItem item = TraceManager.current();
        if (item != null) {
            item.enableTrace();
        }
    }

    public static Object run(String type, String number, long defId, TraceTask task) {
        if (TraceOutput.INSTANCE.get().isTraceEnabled()) {
            return TraceManager.runWithTrace(type, number, defId, task);
        }
        return task.invoke();
    }

    private static Object withTrace(long traceId, String type, String number, long defId, TraceTask task) {
        TraceInfo info = ctx.get();
        if (info != null) {
            return TraceManager.runWithTrace(info, type, number, defId, task);
        }
        return TraceManager.runWithNewTrace(traceId, type, number, defId, task);
    }

    private static Object traceWithTrace(TraceItem current, TraceTask task) {
        TraceInfo info = ctx.get();
        if (info != null) {
            return TraceManager.runWithCurrentTrace(info, current, task);
        }
        return TraceManager.runWithNewTrace(current, task);
    }

    private static Object runWithCurrentTrace(TraceInfo info, TraceItem current, final TraceTask task) {
        return TraceManager.runWithTrace(info, current.getType(), current.getNumber(), current.getDefId(), new TraceTask(){

            @Override
            public Object invoke() {
                return task.invoke();
            }
        });
    }

    private static Object runWithNewTrace(TraceItem current, TraceTask task) {
        TraceManager.newTrace(current.getTraceId()).stack.add(current);
        try {
            Object object = task.invoke();
            return object;
        }
        finally {
            TraceManager.endTrace();
        }
    }

    private static long newTraceId() {
        return TraceOutput.INSTANCE.get().newId();
    }

    private static TraceInfo newTrace(long traceId) {
        TraceInfo info = new TraceInfo(traceId);
        ctx.set(info);
        return info;
    }

    private static void endTrace() {
        ctx.remove();
    }

    private static Object runWithTrace(String type, String number, long defId, TraceTask task) {
        TraceInfo info = ctx.get();
        if (info != null) {
            return TraceManager.runWithTrace(info, type, number, defId, task);
        }
        return TraceManager.runWithUndefinedTrace(type, number, defId, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object runWithNewTrace(long traceId, String type, String number, long defId, TraceTask task) {
        TraceInfo info = TraceManager.newTrace(traceId);
        try {
            Object object = TraceManager.runWithTrace(info, type, number, defId, task);
            return object;
        }
        finally {
            TraceManager.endTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object runWithUndefinedTrace(final String type, final String number, final long defId, final TraceTask task) {
        final TraceInfo info = TraceManager.newTrace(TraceManager.newTraceId());
        try {
            Object object = TraceManager.runWithTrace(info, UNDEFINED, TraceManager.getUndefinedTraceNumber(), 0L, new TraceTask(){

                @Override
                public Object invoke() {
                    return TraceManager.runWithTrace(info, type, number, defId, task);
                }
            });
            return object;
        }
        finally {
            TraceManager.endTrace();
        }
    }

    private static String getUndefinedTraceNumber() {
        String entry = TraceManager.findBestEntryOfUnknownTrace();
        String user = TraceOutput.INSTANCE.get().getUserName();
        String traceNumber = entry + (user == null ? "" : " - " + user);
        return traceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object runWithTrace(TraceInfo info, String type, String number, long defId, TraceTask task) {
        TraceState state = TraceState.F;
        TraceManager.innerBeginTask(info, type, number, defId);
        try {
            Object result = task.invoke();
            state = TraceState.S;
            Object object = result;
            return object;
        }
        finally {
            TraceManager.innerEndTask(info, state);
        }
    }

    private static void innerBeginTask(TraceInfo info, String type, String number, long defId) {
        TraceItem prior = info.stack.isEmpty() ? null : (TraceItem)info.stack.getLast();
        TraceItem current = new TraceItem(info.traceId, type, number, defId, prior);
        info.stack.addLast(current);
    }

    private static void innerEndTask(TraceInfo info, TraceState state) {
        ((TraceItem)info.stack.removeLast()).submit(state);
    }

    public static String findBestEntryOfUnknownTrace() {
        StackTraceElement e;
        String className;
        String entry = UNDEFINED;
        StackTraceElement[] list = Thread.currentThread().getStackTrace();
        for (int i = 4; i < list.length && (className = (e = list[i]).getClassName()).startsWith("kd.isc.") && !className.contains(".TaskQueue") && !className.contains(".JobRunner"); ++i) {
            String simpleName = TraceManager.getSimpleClassName(e);
            if (entry.startsWith(simpleName)) continue;
            entry = simpleName + "." + e.getMethodName() + "(" + e.getFileName() + ":" + e.getLineNumber() + ")";
        }
        return entry;
    }

    private static String getSimpleClassName(StackTraceElement e) {
        String name = e.getClassName();
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1);
    }

    private static class TraceInfo {
        private long traceId;
        private LinkedList<TraceItem> stack = new LinkedList();

        TraceInfo(long traceId) {
            this.traceId = traceId != 0L ? traceId : TraceOutput.INSTANCE.get().newId();
        }
    }
}

