/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.tenant.TenantInfo;
import kd.isc.iscb.platform.core.task.DataPushHandler;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public abstract class AbstractDataPush
implements DataPushHandler {
    protected static final String ENV_TYPE = System.getProperty("env.type");

    public static void setHeadInfo(Map<String, Object> info) {
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantInfo().getId();
        TenantInfo tenantInfo = AccountUtils.getTenantByid((String)tenantId);
        String tenantName = tenantInfo.getName();
        String accountId = ctx.getAccountId();
        String accountName = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId).getAccountName();
        info.put("tenant_id", tenantId);
        info.put("tenant_name", tenantName);
        info.put("account_id", accountId);
        info.put("account_name", accountName);
        info.put("envtype", ENV_TYPE);
        try {
            List list = (List)Json.toObject((String)System.getProperty("mc.tenant.ids"));
            String instance_number = null;
            if (!list.isEmpty()) {
                instance_number = D.s(((Map)list.get(0)).get("instancenumber"));
            }
            info.put("instance_number", instance_number);
        }
        catch (Exception e) {
            info.put("instance_number", "null");
        }
        info.put("push_time", new Timestamp(System.currentTimeMillis()));
        String dayStr = D.s((Object)DataPushUtil.getMidNightTime(1)).replace("-", "").substring(0, 8);
        info.put("period_day", dayStr);
    }

    public Connection getConnection() {
        return TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
    }
}

