/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushInfo;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class DataPushTimerTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DataPushTimerTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) {
        if (DataPushUtil.disablePush()) {
            return;
        }
        DataPushInfo monthStartAndEndTime = this.getMonthStartAndEndTime();
        if (monthStartAndEndTime == null) {
            return;
        }
        int totalCount = this.getTotalCount(monthStartAndEndTime);
        ObjectReader<DataRow> dataPushReader = null;
        Connection cn = this.getConnection();
        try {
            dataPushReader = this.getDataPushReader(cn, monthStartAndEndTime);
            this.pushData(dataPushReader, totalCount);
        }
        catch (Exception e) {
            logger.warn("\u63a8\u9001\u96c6\u6210\u4e91\u8fd0\u884c\u65f6\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
        }
        finally {
            DbUtil.close(dataPushReader);
            DbUtil.close((Connection)cn);
        }
    }

    private Connection getConnection() {
        return TX.__getConnection((String)"ISCB", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalCount(DataPushInfo monthStartAndEndTime) {
        int count;
        String sql = "SELECT count(1) FROM t_iscb_runtime_stat WHERE fcreated_time > ? AND fcreated_time < ?";
        List<Object> values = Arrays.asList(monthStartAndEndTime.getMonthStartTime(), monthStartAndEndTime.getMonthEndTime());
        List<Integer> types = Arrays.asList(93, 93);
        Connection cn = this.getConnection();
        try {
            count = D.i((Object)DbUtil.executeCount((Connection)cn, (String)sql, values, types));
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return count;
    }

    private ObjectReader<DataRow> getDataPushReader(Connection cn, DataPushInfo monthStartAndEndTime) {
        String sql = "SELECT fdcr_total_count,fdcr_failed_count,fdct_total_count,fdct_failed_count,fdcw_total_count,fdcw_failed_count,fapi_total_count,fapi_failed_count,fsf_total_count,fsf_failed_count,fmq_pubished_count,fmq_consumed_count,fmq_published_bytes,fmq_consumed_bytes,fperiod_hour,fperiod_day,fperiod_week,fperiod_month,fperiod_quarter,fperiod_year,fserver,fcreated_time ,fdf_stream_count,fdf_execute_count,fdf_execute_failed,fdf_fiber_count,fdf_fiber_complete FROM t_iscb_runtime_stat WHERE fcreated_time > ? AND fcreated_time < ? ORDER BY fcreated_time ASC";
        List<Object> values = Arrays.asList(monthStartAndEndTime.getMonthStartTime(), monthStartAndEndTime.getMonthEndTime());
        List<Integer> types = Arrays.asList(93, 93);
        return DbUtil.executeQuery((Connection)cn, (String)sql, values, types);
    }

    private void pushData(ObjectReader<DataRow> dataPushReader, int totalCount) {
        int i = 0;
        int count = 0;
        Timestamp logStartTime = null;
        Timestamp logEndTime = null;
        ArrayList<Object> dataInfo = new ArrayList<Object>(4000);
        DataRow item = (DataRow)dataPushReader.read();
        while (item != null) {
            if (count == 0) {
                logStartTime = this.getCreatedTime(item);
            }
            ++count;
            dataInfo.add(this.getPushValue(item));
            if (++i % 4000 == 0 || i == totalCount) {
                logEndTime = this.getCreatedTime(item);
                DataPushUtil.pushData(dataInfo);
                this.savePushLog(count, logStartTime, logEndTime);
                dataInfo.clear();
                count = 0;
            }
            item = (DataRow)dataPushReader.read();
        }
    }

    private Timestamp getCreatedTime(DataRow item) {
        return D.t((Object)item.getValue("fcreated_time"));
    }

    private DataPushInfo getMonthStartAndEndTime() {
        Timestamp endTime;
        Timestamp startTime;
        DataRow startTimeFromLog = this.getStartTimeFromLog();
        if (startTimeFromLog != null) {
            startTime = D.t((Object)startTimeFromLog.getValue("fend_time"));
            endTime = this.getEndTime(startTime);
        } else {
            Timestamp startTimeFromRunTimeState = this.getStartTimeFromRunTimeState();
            if (startTimeFromRunTimeState == null) {
                return null;
            }
            startTime = new Timestamp(startTimeFromRunTimeState.getTime() - 86400000L);
            endTime = this.getEndTime(startTime);
        }
        DataPushInfo dataPushInfo = new DataPushInfo();
        dataPushInfo.setMonthStartTime(startTime);
        dataPushInfo.setMonthEndTime(endTime);
        return dataPushInfo;
    }

    private Timestamp getEndTime(Timestamp startTimeFromRunTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTimeFromRunTime);
        cal.add(2, 1);
        return new Timestamp(cal.getTime().getTime());
    }

    private void savePushLog(int count, Timestamp logStartTime, Timestamp logEndTime) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_runtime_push_log");
        obj.set("create_time", (Object)this.getLogCreateTime());
        obj.set("end", (Object)0);
        obj.set("count", (Object)count);
        obj.set("start_time", (Object)logStartTime);
        obj.set("end_time", (Object)logEndTime);
        obj.set("state", (Object)"1");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"isc_runtime_push_log", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
        CommonUtil.check((OperationResult)result);
    }

    private Timestamp getLogCreateTime() {
        Calendar date = Calendar.getInstance();
        return new Timestamp(date.getTimeInMillis());
    }

    private Map<String, Object> getPushValue(DataRow info) {
        HashMap<String, Object> map = new HashMap<String, Object>(24);
        AbstractDataPush.setHeadInfo(map);
        map.put("event_name", "t_isc_runtime");
        HashMap<String, Object> data = new HashMap<String, Object>(24);
        data.put("api_failed_count", info.get((Object)"fapi_failed_count"));
        data.put("api_total_count", info.getValue("fapi_total_count"));
        data.put("dcr_failed_count", info.getValue("fdcr_failed_count"));
        data.put("dcr_total_count", info.getValue("fdcr_total_count"));
        data.put("dct_failed_count", info.getValue("fdct_failed_count"));
        data.put("dct_total_count", info.getValue("fdct_total_count"));
        data.put("dcw_failed_count", info.getValue("fdcw_failed_count"));
        data.put("dcw_total_count", info.getValue("fdcw_total_count"));
        data.put("mq_consumed_bytes", info.getValue("fmq_consumed_bytes"));
        data.put("mq_consumed_count", info.getValue("fmq_consumed_count"));
        data.put("mq_published_bytes", info.getValue("fmq_published_bytes"));
        data.put("mq_pubished_count", info.getValue("fmq_pubished_count"));
        data.put("sf_failed_count", info.getValue("fsf_failed_count"));
        data.put("sf_total_count", info.getValue("fsf_total_count"));
        data.put("created_time", info.getValue("fcreated_time"));
        data.put("period_hour", info.getValue("fperiod_hour"));
        data.put("period_day", info.getValue("fperiod_day"));
        data.put("period_week", info.getValue("fperiod_week"));
        data.put("period_month", info.getValue("fperiod_month"));
        data.put("period_quarter", info.getValue("fperiod_quarter"));
        data.put("period_year", info.getValue("fperiod_year"));
        data.put("server", info.getValue("fserver"));
        data.put("fdf_stream_count", D.l((Object)info.getValue("fdf_stream_count")));
        data.put("fdf_execute_count", D.l((Object)info.getValue("fdf_execute_count")));
        data.put("fdf_execute_failed", D.l((Object)info.getValue("fdf_execute_failed")));
        data.put("fdf_fiber_count", D.l((Object)info.getValue("fdf_fiber_count")));
        data.put("fdf_fiber_complete", D.l((Object)info.getValue("fdf_fiber_complete")));
        map.put("var", data);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRow getStartTimeFromLog() {
        Connection cn = this.getConnection();
        DataRow read = null;
        try {
            String sql = "SELECT TOP 1 fstart_time,fend_time FROM t_isc_runtime_push_log ORDER BY fcreate_time DESC;";
            read = DbUtil.executeRow((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u5386\u53f2\u6570\u636e\u63a8\u9001\u65e5\u5fd7\u8bb0\u5f55\u8868\u4e2d\u7684\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getStartTimeFromRunTimeState() {
        Connection cn = this.getConnection();
        Timestamp created_time = null;
        try {
            String sql = "SELECT TOP 1 fcreated_time FROM t_iscb_runtime_stat ORDER BY fcreated_time ASC;";
            DataRow reader = DbUtil.executeRow((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            if (reader != null) {
                created_time = D.t((Object)reader.getValue("fcreated_time"));
            }
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u5f53\u524d\u8d26\u5957\u8fd0\u884c\u65f6\u6570\u636e\u8bb0\u5f55\u8868\u4e2d\u6700\u5c0f\u65f6\u95f4\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        return created_time;
    }
}

