/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.DataPushHandler;
import kd.isc.iscb.platform.core.task.PushDataCompParametersOfDay;
import kd.isc.iscb.platform.core.task.PushFlowParametersOfDay;
import kd.isc.iscb.platform.core.task.PushGlobalParametersOfDay;
import kd.isc.iscb.platform.core.task.PushIntegratedResourcesStatOfDay;
import kd.isc.iscb.platform.core.task.PushSchemaParametersOfDay;
import kd.isc.iscb.platform.core.task.PushTriggerParametersOfDay;
import kd.isc.iscb.platform.core.task.dataone.PushApiInvokeOfDay;
import kd.isc.iscb.platform.core.task.dataone.PushDataLinkInfoOfDay;
import kd.isc.iscb.platform.core.task.dataone.PushLogNumOfDay;
import kd.isc.iscb.platform.core.task.week.PushDataStreamTriggerParams;
import kd.isc.iscb.platform.core.task.week.PushDbcInfoOfWeek;
import kd.isc.iscb.platform.core.task.week.PushScriptConsumeTime;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.NetUtil;

public class DataPushUtil {
    private static final Log logger = LogFactory.getLog(DataPushUtil.class);
    public static final String PUSH_URL;
    public static final int QUERY_MAX = 300;
    private static final Set<DataPushHandler> PUSH_DATA_DAY;
    private static final Set<DataPushHandler> PUSH_DATA_Week;

    public static Set<DataPushHandler> getHandlerOfDay() {
        return PUSH_DATA_DAY;
    }

    public static Set<DataPushHandler> getHandlerOfWeek() {
        return PUSH_DATA_Week;
    }

    protected void clean() {
        PUSH_DATA_DAY.clear();
    }

    public static boolean disablePush() {
        return "false".equalsIgnoreCase(D.s((Object)ContextUtil.getTenantProperty((String)"ISC_JOIN_DATA_IMPROVEMENT")));
    }

    public static void pushData(List<Object> body) {
        NetUtil.httpInvoke((String)PUSH_URL, body, (String)"UTF-8");
    }

    public static Timestamp getMidNightTime(int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, -num);
        return D.t((Object)calendar.getTime());
    }

    static {
        PUSH_DATA_DAY = new HashSet<DataPushHandler>(12);
        PUSH_DATA_Week = new HashSet<DataPushHandler>(12);
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = DataPushUtil.class.getResourceAsStream("/iscb/poa.properties");
            properties.load(in);
        }
        catch (IOException e) {
            logger.warn("\u4ece\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u63a5\u53e3\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            DbUtil.close((InputStream)in);
        }
        String url = Cipher.decrypt((String)properties.getProperty("url"));
        String client_secret = Cipher.decrypt((String)properties.getProperty("client_secret"));
        String client_id = Cipher.decrypt((String)properties.getProperty("client_id"));
        String project = Cipher.decrypt((String)properties.getProperty("project"));
        String store = Cipher.decrypt((String)properties.getProperty("store"));
        PUSH_URL = url + "?client_secret=" + client_secret + "&client_id=" + client_id + "&project=" + project + "&store=" + store;
        PUSH_DATA_DAY.add(new PushGlobalParametersOfDay());
        PUSH_DATA_DAY.add(new PushTriggerParametersOfDay());
        PUSH_DATA_DAY.add(new PushSchemaParametersOfDay());
        PUSH_DATA_DAY.add(new PushFlowParametersOfDay());
        PUSH_DATA_DAY.add(new PushDataCompParametersOfDay());
        PUSH_DATA_DAY.add(new PushIntegratedResourcesStatOfDay());
        PUSH_DATA_DAY.add(new PushApiInvokeOfDay());
        PUSH_DATA_DAY.add(new PushDataLinkInfoOfDay());
        PUSH_DATA_DAY.add(new PushLogNumOfDay());
        PUSH_DATA_Week.add(new PushDbcInfoOfWeek());
        PUSH_DATA_Week.add(new PushDataStreamTriggerParams());
        PUSH_DATA_Week.add(new PushScriptConsumeTime());
    }
}

