/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class PushFlowParametersOfDay
extends AbstractDataPush {
    private static final Log logger = LogFactory.getLog(PushFlowParametersOfDay.class);

    @Override
    public void pushData() {
        List flowIds = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", null, null, (int)-1);
        int max = 300;
        List flowIdLists = Lists.partition((List)flowIds, (int)max);
        for (List flowIdList : flowIdLists) {
            this.pushFlowInfo(flowIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFlowInfo(List<Object> flowIds) {
        int size = flowIds.size();
        ArrayList<Object> dataList = new ArrayList<Object>(size);
        Connection cn = this.getConnection();
        ObjectReader<DataRow> flowReader = null;
        try {
            flowReader = this.getFlowReader(cn, flowIds, size);
            DataRow flow = (DataRow)flowReader.read();
            while (flow != null) {
                Map<String, Object> flowInfo = this.getFlowInfo(flow);
                dataList.add(flowInfo);
                flow = (DataRow)flowReader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushFlowParametersOfDay:\u7ec4\u88c5\u670d\u52a1\u6d41\u7a0b\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(flowReader);
            DbUtil.close((Connection)cn);
        }
        if (dataList.size() > 0) {
            DataPushUtil.pushData(dataList);
        }
    }

    private ObjectReader<DataRow> getFlowReader(Connection cn, List<Object> flowIds, int size) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT A.fid,B.fname,A.fnumber,A.floglevel,A.finit_mode,A.fdisable_trace FROM t_isc_service_flow A LEFT JOIN t_isc_service_flow_l B ON A.fid = B.fid AND B.flocaleid = 'zh_CN' WHERE A.fid IN (");
        ArrayList<Object> values = new ArrayList<Object>(size);
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            querySql.append('?');
            if (i < size - 1) {
                querySql.append(',');
            }
            values.add(flowIds.get(i));
            types.add(-5);
        }
        querySql.append(')');
        return DbUtil.executeQuery((Connection)cn, (String)querySql.toString(), values, types);
    }

    private Map<String, Object> getFlowInfo(DataRow flow) {
        HashMap<String, Object> flowInfo = new HashMap<String, Object>(16);
        PushFlowParametersOfDay.setHeadInfo(flowInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        flowInfo.put("event_name", "t_isc_flow_parameters");
        map.put("flow_id", flow.get((Object)"fid"));
        map.put("flow_name", flow.get((Object)"fname"));
        map.put("flow_number", flow.get((Object)"fnumber"));
        map.put("loglevel", this.getLogLevelName(D.s((Object)flow.get((Object)"floglevel"))));
        map.put("init_mode", this.getFlowTypeName(D.s((Object)flow.get((Object)"finit_mode"))));
        map.put("disable_trace", flow.get((Object)"fdisable_trace").equals("1") ? "\u662f" : "\u5426");
        flowInfo.put("var", map);
        return flowInfo;
    }

    private String getLogLevelName(String str) {
        String name;
        if (null == str) {
            return "\u8b66\u544a";
        }
        switch (str) {
            case "info": {
                name = "\u4fe1\u606f";
                break;
            }
            case "warn": {
                name = "\u8b66\u544a";
                break;
            }
            case "error": {
                name = "\u9519\u8bef";
                break;
            }
            default: {
                name = str;
            }
        }
        return name;
    }

    private String getFlowTypeName(String str) {
        String name;
        if (null == str) {
            return "\u4eba\u5de5\u542f\u52a8";
        }
        switch (str) {
            case "TIMER": {
                name = "\u5b9a\u65f6\u542f\u52a8";
                break;
            }
            case "MANUAL": {
                name = "\u4eba\u5de5\u542f\u52a8";
                break;
            }
            case "EVENT": {
                name = "\u4e8b\u4ef6\u89e6\u53d1";
                break;
            }
            case "MESSAGE": {
                name = "\u6d88\u606f\u542f\u52a8";
                break;
            }
            default: {
                name = str;
            }
        }
        return name;
    }
}

