/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class PushTriggerParametersOfDay
extends AbstractDataPush {
    private static final Log logger = LogFactory.getLog(PushTriggerParametersOfDay.class);

    @Override
    public void pushData() {
        List triggerIds = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", null, null, (int)-1);
        logger.info("PushTriggerParametersOfDay:\u67e5\u8be2\u542f\u52a8\u65b9\u6848id\u603b\u4e2a\u6570\uff1a" + triggerIds.size());
        int max = 300;
        List triggerIdLists = Lists.partition((List)triggerIds, (int)max);
        for (List triggerIdList : triggerIdLists) {
            this.pushTriggerInfo(triggerIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushTriggerInfo(List<Object> triggerIds) {
        int size = triggerIds.size();
        ArrayList<Object> dataList = new ArrayList<Object>(size);
        Connection cn = this.getConnection();
        ObjectReader<DataRow> triggerReader = null;
        try {
            triggerReader = this.getTriggerReader(cn, triggerIds, size);
            DataRow trigger = (DataRow)triggerReader.read();
            while (trigger != null) {
                Map<String, Object> triggerInfo = this.getTriggerInfo(trigger);
                dataList.add(triggerInfo);
                trigger = (DataRow)triggerReader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushTriggerParametersOfDay:\u7ec4\u88c5\u542f\u52a8\u65b9\u6848\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(triggerReader);
            DbUtil.close((Connection)cn);
        }
        int dataSize = dataList.size();
        if (dataSize > 0) {
            DataPushUtil.pushData(dataList);
        }
        logger.info("PushTriggerParametersOfDay:\u672c\u6279\u6b21\u63a8\u9001\u542f\u52a8\u65b9\u6848\u4e2a\u6570\uff1a" + dataSize);
    }

    private ObjectReader<DataRow> getTriggerReader(Connection cn, List<Object> triggerIds, int size) {
        ArrayList<Object> values = new ArrayList<Object>(size);
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT A.fid,B.fname,A.fnumber,A.ftrigger_type,A.ftrace_all,A.ftrigged_time,A.ftotal_count,A.fthread_ubound,A.ftasksize,A.fbatch_size,A.fretry_count_str,A.fretry_interval,A.fdisable_trace,A.finterval,A.fschedule,A.fvalidated_time,A.fexpired_time,A.fevents,A.ftimestamp_field,A.fmutex_name FROM t_isc_data_copy_trigger A LEFT JOIN t_isc_data_copy_trigger_l B ON A.fid = B.fid AND B.flocaleid = 'zh_CN'WHERE A.fid IN (");
        for (int i = 0; i < size; ++i) {
            querySql.append('?');
            if (i < size - 1) {
                querySql.append(',');
            }
            values.add(triggerIds.get(i));
            types.add(-5);
        }
        querySql.append(')');
        return DbUtil.executeQuery((Connection)cn, (String)querySql.toString(), values, types);
    }

    private Map<String, Object> getTriggerInfo(DataRow trigger) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        PushTriggerParametersOfDay.setHeadInfo(map);
        map.put("event_name", "t_isc_trigger_parameters");
        HashMap<String, Object> triggerInfo = new HashMap<String, Object>(26);
        triggerInfo.put("trigger_id", trigger.get((Object)"fid"));
        triggerInfo.put("trigger_name", trigger.get((Object)"fname"));
        triggerInfo.put("trigger_number", trigger.get((Object)"fnumber"));
        String trigger_type = D.s((Object)trigger.get((Object)"ftrigger_type"));
        triggerInfo.put("trigger_type", this.getTriggerTypeName(trigger_type));
        triggerInfo.put("trace_all", this.cast2Str(trigger.get((Object)"ftrace_all")));
        triggerInfo.put("trigged_time", trigger.get((Object)"ftrigged_time"));
        triggerInfo.put("total_count", trigger.get((Object)"ftotal_count"));
        triggerInfo.put("thread_ubound", trigger.get((Object)"fthread_ubound"));
        triggerInfo.put("task_size", trigger.get((Object)"ftasksize"));
        triggerInfo.put("batch_size", trigger.get((Object)"fbatch_size"));
        triggerInfo.put("retry_count_str", trigger.get((Object)"fretry_count_str"));
        triggerInfo.put("retry_interval", trigger.get((Object)"fretry_interval"));
        triggerInfo.put("disable_trace", this.cast2Str(trigger.get((Object)"fdisable_trace")));
        String interval = D.s((Object)trigger.get((Object)"finterval"));
        triggerInfo.put("trigger_interval", "auto".equals(trigger_type) ? this.getIntervalName(interval) : " ");
        triggerInfo.put("validated_time", trigger.get((Object)"fvalidated_time"));
        triggerInfo.put("trigger_schedule", trigger.get((Object)"fschedule"));
        triggerInfo.put("expired_time", trigger.get((Object)"fexpired_time"));
        triggerInfo.put("trigger_events", trigger.get((Object)"fevents"));
        triggerInfo.put("timestamp_field", trigger.get((Object)"ftimestamp_field"));
        triggerInfo.put("mutex_name", trigger.get((Object)"fmutex_name"));
        map.put("var", triggerInfo);
        return map;
    }

    private String cast2Str(Object str) {
        if ("1".equals(str)) {
            return "\u662f";
        }
        return "\u5426";
    }

    private String getIntervalName(String str) {
        String name;
        if (null == str) {
            return "\u6267\u884c\u9891\u7387 - 1\u6b21/\u5c0f\u65f6";
        }
        switch (str) {
            case "1": {
                name = "\u6267\u884c\u9891\u7387 - 1\u6b21/\u5c0f\u65f6";
                break;
            }
            case "2": {
                name = "\u6267\u884c\u9891\u7387 - 2\u6b21/\u5c0f\u65f6";
                break;
            }
            case "3": {
                name = "\u6267\u884c\u9891\u7387 - 3\u6b21/\u5c0f\u65f6";
                break;
            }
            case "5": {
                name = "\u6267\u884c\u9891\u7387 - 5\u6b21/\u5c0f\u65f6";
                break;
            }
            case "10": {
                name = "\u6267\u884c\u9891\u7387 - 10\u6b21/\u5c0f\u65f6";
                break;
            }
            case "20": {
                name = "\u6267\u884c\u9891\u7387 - 20\u6b21/\u5c0f\u65f6";
                break;
            }
            case "30": {
                name = "\u6267\u884c\u9891\u7387 - 30\u6b21/\u5c0f\u65f6";
                break;
            }
            case "60": {
                name = "\u6267\u884c\u9891\u7387 - 60\u6b21/\u5c0f\u65f6";
                break;
            }
            case "d": {
                name = "\u6bcf\u5929";
                break;
            }
            case "w": {
                name = "\u6bcf\u5468";
                break;
            }
            case "m": {
                name = "\u6bcf\u6708";
                break;
            }
            case "0": {
                name = "\u81ea\u5b9a\u4e49";
                break;
            }
            default: {
                name = str;
            }
        }
        return name;
    }

    private String getTriggerTypeName(String type) {
        String name;
        if (null == type) {
            return "\u4eba\u5de5\u542f\u52a8";
        }
        switch (type) {
            case "auto": {
                name = "\u5b9a\u65f6\u542f\u52a8";
                break;
            }
            case "manual": {
                name = "\u4eba\u5de5\u542f\u52a8";
                break;
            }
            case "event": {
                name = "\u4e8b\u4ef6\u89e6\u53d1";
                break;
            }
            case "message": {
                name = "\u6d88\u606f\u542f\u52a8";
                break;
            }
            default: {
                name = type;
            }
        }
        return name;
    }
}

