/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public enum ResourcesClassify {
    DATABASE_LINK{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT fdatabase_type as category,count(fid) as count FROM t_isc_database_link GROUP BY fdatabase_type";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u8fde\u63a5\u914d\u7f6e", null);
        }
    }
    ,
    DATA_SOURCE{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_isc_datasource";
            return ResourcesClassify.getDataList(cn, sql, "\u6570\u636e\u6e90", "ds");
        }
    }
    ,
    META{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT ftype as category,count(fid) as count FROM t_isc_dataschema GROUP BY ftype";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u96c6\u6210\u5bf9\u8c61", null);
        }
    }
    ,
    DATA_COPY{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_data_copy";
            return ResourcesClassify.getDataList(cn, sql, "\u96c6\u6210\u65b9\u6848", "dc");
        }
    }
    ,
    TRIGGER{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT ftrigger_type as category,count(fid) as count FROM t_isc_data_copy_trigger GROUP BY ftrigger_type";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u542f\u52a8\u65b9\u6848", null);
        }
    }
    ,
    FLOW{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT finit_mode as category,count(fid) as count FROM t_isc_service_flow GROUP BY finit_mode";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u670d\u52a1\u6d41\u7a0b", "FLOW");
        }
    }
    ,
    VC{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT frule_type as category,count(fid) as count FROM t_isc_value_conver_rule GROUP BY frule_type";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u503c\u8f6c\u6362\u89c4\u5219", "vc");
        }
    }
    ,
    META_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_by_meta_data";
            return ResourcesClassify.getDataList(cn, sql, "API", "meta_api");
        }
    }
    ,
    DC_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_by_dc_schema";
            return ResourcesClassify.getDataList(cn, sql, "API", "dc_api");
        }
    }
    ,
    TRIGGER_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_by_dc_trigger";
            return ResourcesClassify.getDataList(cn, sql, "API", "trigger_api");
        }
    }
    ,
    VC_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_by_vc";
            return ResourcesClassify.getDataList(cn, sql, "API", "vc_api");
        }
    }
    ,
    FLOW_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_by_sf";
            return ResourcesClassify.getDataList(cn, sql, "API", "flow_api");
        }
    }
    ,
    EX_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_external_api";
            return ResourcesClassify.getDataList(cn, sql, "API", "ex_api");
        }
    }
    ,
    WEB_API{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_webapi";
            return ResourcesClassify.getDataList(cn, sql, "API", "web_api");
        }
    }
    ,
    SERVICE{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_mservice_api";
            return ResourcesClassify.getDataList(cn, sql, "API", "service_api");
        }
    }
    ,
    SCRIPT{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_apic_script";
            return ResourcesClassify.getDataList(cn, sql, "API", "script_api");
        }
    }
    ,
    MQ{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT ftype as category,count(fid) as count FROM t_iscb_mq_server GROUP BY ftype";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u961f\u5217\u670d\u52a1", null);
        }
    }
    ,
    MQ_SUB{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_mq_subscriber";
            return ResourcesClassify.getDataList(cn, sql, "\u6d88\u606f\u4e3b\u9898", "mq_sub");
        }
    }
    ,
    MQ_PUB{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_mq_publisher";
            return ResourcesClassify.getDataList(cn, sql, "\u6d88\u606f\u4e3b\u9898", "mq_pub");
        }
    }
    ,
    BILL_DATA_SUB{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_mq_bill_data_sub";
            return ResourcesClassify.getDataList(cn, sql, "\u5355\u636e\u6d88\u606f", "data_sub");
        }
    }
    ,
    BILL_DATA_PUB{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_mq_bill_data_pub";
            return ResourcesClassify.getDataList(cn, sql, "\u5355\u636e\u6d88\u606f", "data_pub");
        }
    }
    ,
    FILE_EXPORT{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_export_file";
            return ResourcesClassify.getDataList(cn, sql, "\u6570\u636e\u8fc1\u79fb", "file_export");
        }
    }
    ,
    FILE_IMPORT{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT count(fid) as count FROM t_iscb_import_file";
            return ResourcesClassify.getDataList(cn, sql, "\u6570\u636e\u8fc1\u79fb", "file_import");
        }
    }
    ,
    DATA_COMP{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT fstrategy as category,count(fid) as count FROM t_isc_data_comp GROUP BY fstrategy";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u6570\u636e\u5bf9\u6bd4", null);
        }
    }
    ,
    DATA_STREAM_RES{

        @Override
        public List<Map<String, Object>> statisticalInfo(Connection cn) {
            String sql = "SELECT ftype as category,count(fid) as count FROM t_iscx_res_main GROUP BY ftype";
            return ResourcesClassify.getDataListByCategory(cn, sql, "\u6570\u636e\u6d41\u8d44\u6e90", null);
        }
    };


    private static Map<String, Object> getInfo(String type, String category, int count) {
        HashMap<String, Object> info = new HashMap<String, Object>(12);
        AbstractDataPush.setHeadInfo(info);
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("resource_type", type);
        map.put("category", category);
        map.put("count", count);
        map.put("push_time", new Timestamp(System.currentTimeMillis()));
        info.put("var", map);
        info.put("event_name", "t_isc_resource_statistics");
        return info;
    }

    private static List<Map<String, Object>> getDataList(Connection cn, String sql, String type, String category) {
        int count = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql));
        ArrayList<Map<String, Object>> dates = new ArrayList<Map<String, Object>>(1);
        if (count != 0) {
            Map<String, Object> info = ResourcesClassify.getInfo(type, category, count);
            dates.add(info);
        }
        return dates;
    }

    private static List<Map<String, Object>> getDataListByCategory(Connection cn, String sql, String type, String suffix) {
        List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
        ArrayList<Map<String, Object>> dates = new ArrayList<Map<String, Object>>(dataRows.size());
        for (DataRow dr : dataRows) {
            String category = D.s((Object)dr.getValue("category"));
            category = suffix == null ? category : suffix + "_" + category;
            Map<String, Object> info = ResourcesClassify.getInfo(type, category, D.i((Object)dr.getValue("count")));
            dates.add(info);
        }
        return dates;
    }

    public abstract List<Map<String, Object>> statisticalInfo(Connection var1);
}

