/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task.dataone;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.platform.core.task.dataone.Const;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class PushDataLinkInfoOfDay
extends AbstractDataPush
implements Const {
    private static final String className = "PushDataLinkInfoOfDay";
    private static final Log logger = LogFactory.getLog(PushDataLinkInfoOfDay.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushData() {
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"isc_database_link", null, null, (int)-1);
        logger.info("PushDataLinkInfoOfDay :\u67e5\u8be2\u8fde\u63a5\u914d\u7f6e\u603b\u4e2a\u6570\uff1a" + objects.size());
        int max = 300;
        List lists = Lists.partition((List)objects, (int)max);
        Connection cn = this.getConnection();
        try {
            Map<String, Object> linkTypeMap = this.getLinkTypeInfo(cn);
            for (List list : lists) {
                this.pushInfo(list, cn, linkTypeMap);
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getLinkTypeInfo(Connection cn) {
        ObjectReader<DataRow> reader = null;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            reader = this.getLinkInfoMapReader(cn);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                map.put(D.s((Object)row.get((Object)"fnumber")), row.get((Object)"fname"));
                row = (DataRow)reader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushDataLinkInfoOfDay :\u67e5\u8be2\u8fde\u63a5\u7c7b\u578b \u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(reader);
        }
        return map;
    }

    private ObjectReader<DataRow> getLinkInfoMapReader(Connection cn) {
        String sql = "select  A.fnumber,B.fname from t_iscb_connection_type A left join          t_iscb_connection_type_l B on B.fid = A.fid AND B.flocaleid = 'zh_CN'";
        return DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushInfo(List<Object> list, Connection cn, Map<String, Object> linkTypeMap) {
        int size = list.size();
        ArrayList<Object> dataList = new ArrayList<Object>(size);
        ObjectReader<DataRow> reader = null;
        try {
            reader = this.getReader(cn, list, size);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                Map<String, Object> info = this.getInfo(row, linkTypeMap);
                dataList.add(info);
                row = (DataRow)reader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushDataLinkInfoOfDay :\u7ec4\u88c5\u8fde\u63a5\u914d\u7f6e\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(reader);
        }
        int dataSize = dataList.size();
        if (dataSize > 0) {
            DataPushUtil.pushData(dataList);
        }
        logger.info("PushDataLinkInfoOfDay :\u672c\u6279\u6b21\u63a8\u9001\u8fde\u63a5\u914d\u7f6e\u4e2a\u6570\uff1a" + dataSize);
    }

    private Map<String, Object> getInfo(DataRow row, Map<String, Object> linkTypeMap) {
        HashMap<String, Object> info = new HashMap<String, Object>(12);
        HashMap<String, Object> map = new HashMap<String, Object>();
        PushDataLinkInfoOfDay.setHeadInfo(map);
        map.put("event_name", "t_isc_datalink_info");
        info.put("link_id", row.get((Object)"fid"));
        info.put("number", row.get((Object)"fnumber"));
        info.put("name", row.get((Object)"fname"));
        info.put("database_type", linkTypeMap.get(D.s((Object)row.get((Object)"fdatabase_type"))));
        info.put("state", row.get((Object)"fstate"));
        map.put("var", info);
        return map;
    }

    private ObjectReader<DataRow> getReader(Connection cn, List<Object> idList, int size) {
        StringBuilder querySql = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>(size);
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        querySql.append("select A.fid,A.fnumber,B.fname,A.fdatabase_type,A.fstate  from t_isc_database_link A  left join t_isc_database_link_l B on B.fid=A.fid and B.flocaleid='zh_CN' where A.fid in(");
        for (int i = 0; i < size; ++i) {
            querySql.append('?');
            if (i < size - 1) {
                querySql.append(',');
            }
            values.add(idList.get(i));
            types.add(-5);
        }
        querySql.append(')');
        return DbUtil.executeQuery((Connection)cn, (String)querySql.toString(), values, types);
    }
}

