/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task.dataone;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.platform.core.task.dataone.Const;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.io.ObjectReader;

public class PushLogNumOfDay
extends AbstractDataPush
implements Const {
    private static final String className = "PushLogNumOfDay";
    private static final Log logger = LogFactory.getLog(PushLogNumOfDay.class);

    @Override
    public void pushData() {
        this.pushInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushInfo() {
        ArrayList<Object> dataList = new ArrayList<Object>(1);
        Connection cn = this.getConnection();
        ObjectReader<DataRow> reader = null;
        try {
            reader = this.getReader(cn);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                Map<String, Object> info = this.getInfo(row);
                dataList.add(info);
                row = (DataRow)reader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushLogNumOfDay :\u7ec4\u88c5\u65e5\u5fd7\u6570\u91cf\u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(reader);
            DbUtil.close((Connection)cn);
        }
        int dataSize = dataList.size();
        if (dataSize > 0) {
            DataPushUtil.pushData(dataList);
        }
        logger.info("PushLogNumOfDay :\u672c\u6279\u6b21\u63a8\u9001\u65e5\u5fd7\u6570\u91cf\u4e2a\u6570\uff1a" + dataSize);
    }

    private Map<String, Object> getInfo(DataRow row) {
        HashMap<String, Object> info = new HashMap<String, Object>(8);
        PushLogNumOfDay.setHeadInfo(info);
        info.put("event_name", "t_isc_lognum");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("log_num", row.get((Object)"num"));
        info.put("var", map);
        return info;
    }

    private ObjectReader<DataRow> getReader(Connection cn) {
        ArrayList<Timestamp> values = new ArrayList<Timestamp>(2);
        ArrayList<Integer> types = new ArrayList<Integer>(2);
        values.add(DataPushUtil.getMidNightTime(1));
        values.add(DataPushUtil.getMidNightTime(0));
        types.add(93);
        types.add(93);
        String querySql = "select count(*) as num from t_isc_data_copy_exec_log where fcreated_time>=? and fcreated_time<=?";
        return DbUtil.executeQuery((Connection)cn, (String)querySql, values, types);
    }
}

