/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.org.model.OrgParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.isc.iscb.connector.ierp.handler.demo.init.OrgUtil;
import kd.isc.iscb.platform.core.connector.self.DoBizAction;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.TargetDataHandler;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public abstract class AbstractOrgHandler
implements TargetDataHandler {
    private static final String ORGPATTERN_STR = "orgpattern";
    private static final String ENABLE_STR = "enable";
    private static final String FTAXREGNUM_STR = "ftaxregnum";

    public abstract Set<String> getDutySet(Map<String, Object> var1);

    public abstract void setOrgView(long var1, OrgParam var3, Set<String> var4, Map<String, Object> var5);

    public Response exec(ConnectorContext ctx, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        Set<String> dutySet = this.getDutySet(data);
        long parentId = D.l((Object)data.get("parent"));
        long id = D.l((Object)DoBizAction.queryPrimaryKey((String)"bos_org", data, judgeFields));
        OrgParam orgParam = this.initOrgParam(data, id);
        this.setPropertyMap(data, orgParam);
        this.setOrgView(parentId, orgParam, dutySet, data);
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>();
        orgParams.add(orgParam);
        OrgUnitServiceHelper.addOrUpdate(orgParams);
        if (!orgParam.isSuccess()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7ec4\u7ec7\u63a5\u53e3OrgUnitServiceHelper.addOrUpdate\u5931\u8d25\uff0c\u7ec4\u7ec7id\u4e3a%1$s,\u7ec4\u7ec7\u5355\u5143\u670d\u52a1\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f\uff1a%2$s", (String)"AbstractOrgHandler_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), orgParam.getId(), orgParam.getMsg()));
        }
        this.handleFreeze(data, orgParam);
        return this.handleResponse(id, orgParam);
    }

    protected void handleFreeze(Map<String, Object> data, OrgParam orgParam) {
    }

    private Response handleResponse(long id, OrgParam orgParam) {
        if (orgParam.isSuccess()) {
            if (id == 0L) {
                return new Response(D.s((Object)orgParam.getId()), SaveDataType.INSERT, null);
            }
            return new Response(D.s((Object)orgParam.getId()), SaveDataType.UPDATE, null);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7ec4\u7ec7\u63a5\u53e3\u5931\u8d25\uff0c\u7ec4\u7ec7id\u4e3a%1$s,\u7ec4\u7ec7\u5355\u5143\u670d\u52a1\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f\uff1a%2$s", (String)"AbstractOrgHandler_1", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), orgParam.getId(), orgParam.getMsg()));
    }

    private OrgParam initOrgParam(Map<String, Object> data, long id) {
        OrgParam orgParam = new OrgParam();
        if (id == 0L && D.l((Object)data.get("customOrgId")) > 0L) {
            orgParam.setCustomOrgId(D.l((Object)data.get("customOrgId")));
        } else {
            orgParam.setId(id);
        }
        Object name = data.get("name");
        if (name instanceof Map) {
            orgParam.setName(D.s(((Map)name).get("zh_CN")));
        } else {
            orgParam.setName(D.s((Object)name));
        }
        orgParam.setNumber(D.s((Object)data.get("number")));
        OrgUtil.setYzjSyncIfNeeded(data, orgParam);
        return orgParam;
    }

    private void setPropertyMap(Map<String, Object> data, OrgParam orgParam) {
        Object status;
        Object taxreg;
        Object enable;
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        Object orgpattern = data.get(ORGPATTERN_STR);
        if (orgpattern != null) {
            propertyMap.put(ORGPATTERN_STR, orgpattern);
        }
        if ((enable = data.get(ENABLE_STR)) != null) {
            propertyMap.put(ENABLE_STR, enable);
        }
        if ((taxreg = data.get(FTAXREGNUM_STR)) != null) {
            propertyMap.put(FTAXREGNUM_STR, taxreg);
        }
        if ((status = data.get("status")) != null) {
            propertyMap.put("status", status);
        }
        if (data.containsKey("fcomment")) {
            this.setMultiLangField(data, propertyMap, "fcomment");
        }
        if (data.containsKey("ffirmname")) {
            this.setMultiLangField(data, propertyMap, "ffirmname");
        }
        orgParam.setPropertyMap(propertyMap);
    }

    private void setMultiLangField(Map<String, Object> data, Map<String, Object> propertyMap, String fieldName) {
        Object field = data.get(fieldName);
        if (field instanceof Map) {
            propertyMap.put(fieldName, D.s(((Map)field).get("zh_CN")));
        } else {
            propertyMap.put(fieldName, D.s((Object)field));
        }
    }
}

