/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.connector.ierp.IerpConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.SelfConnectionFactory;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;

public class GetTableService
extends AbstractCommandExecutor {
    protected Map<String, Object> exec(ConnectorContext ctx, Map<String, Object> params) {
        String tableName = D.s((Object)params.get("table_name"));
        IerpConnectorUtil.checkReadOrWritePermission(ctx, tableName);
        Table table = SelfConnectionFactory.getTable((String)tableName);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("quot", " ");
        data.put("fields", GetTableService.parseFields(table.getFieldMap()));
        data.put("primary_keys", table.getPrimaryKeyName() == null ? Collections.emptyList() : Collections.singleton(table.getPrimaryKeyName()));
        data.put("name", tableName);
        return data;
    }

    private static List<Map<String, Object>> parseFields(Map<String, Column> fields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(fields.size());
        for (Column c : fields.values()) {
            Map<String, Object> item = GetTableService.castColumnToMap(c);
            list.add(item);
        }
        return list;
    }

    private static Map<String, Object> castColumnToMap(Column c) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("COLUMN_NAME", c.getBinding().toUpperCase());
        item.put("IS_NULLABLE", c.isNullable() ? "NO" : "YES");
        item.put("DATA_TYPE", c.getSqlType());
        item.put("COLUMN_SIZE", c.getPrecision());
        item.put("DECIMAL_DIGITS", c.getScale());
        item.put("TYPE_NAME", c.getDataType().toString().toUpperCase());
        return item;
    }

    public String getCommand() {
        return "get_table";
    }
}

