/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc;

import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.connector.ierp.IerpConnectorUtil;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.hub.ConnectorUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;

public class PushPermissionService
extends AbstractCommandExecutor {
    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        this.savePermission(params);
        return "ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePermission(Map<String, Object> params) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            boolean supportMultiHub = ConnectorUtil.supportMultiHub((String)IerpUtil.getAccountKey());
            String iscHub = D.s((Object)params.get("isc_hub"));
            String originData = D.s((Object)params.get("origin_data"));
            if (supportMultiHub) {
                ConnectorUtil.checkIscHubNotNull((String)iscHub);
                Map permission = (Map)Json.toObject((String)originData);
                this.savePermissionInNewWay(cn, iscHub, permission);
            } else {
                this.defaultHandle(params, cn, originData);
            }
            IerpConnectorUtil.broadcastPermission();
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void defaultHandle(Map<String, Object> params, Connection cn, String originData) {
        if (originData != null) {
            Map permission = (Map)Json.toObject((String)originData);
            this.savePermissionInOldWay(cn, permission);
        } else {
            String accessKey = this.getAccessKey(cn);
            String data = Cipher.decrypt((String)D.s((Object)params.get("data")), (String)accessKey);
            Map permission = (Map)Json.toObject((String)data);
            this.savePermissionInOldWay(cn, permission);
        }
    }

    private void savePermissionInOldWay(Connection cn, Map<String, String> permission) {
        IscHubConfigUtil.clearIscHubPermissions((Connection)cn);
        for (Map.Entry<String, String> e : permission.entrySet()) {
            IscHubConfigUtil.saveIscHubPermit((Connection)cn, (String)e.getKey(), (String)e.getValue());
        }
    }

    private void savePermissionInNewWay(Connection cn, String iscHub, Map<String, String> permission) {
        ConnectorUtil.clearIscHubPermissions((Connection)cn, (String)iscHub);
        for (Map.Entry<String, String> e : permission.entrySet()) {
            String meta = e.getKey();
            String permit = e.getValue();
            ConnectorUtil.saveIscHubPermit((Connection)cn, (String)meta, (String)permit, (String)iscHub);
        }
    }

    private String getAccessKey(Connection cn) {
        DataRow row = DbUtil.executeRow((Connection)cn, (String)"select fisc_access_key from T_ISC_HUB_SERVER");
        Assert.notNull((Object)row, (String)ResManager.loadKDString((String)"\u8be5\u82cd\u7a79\u8fde\u63a5\u5668\u6ca1\u6709\u90e8\u7f72\u4fe1\u606f\u3002", (String)"PushPermissionService_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        return D.s((Object)row.get((Object)"fisc_access_key"));
    }

    private String getAccessKeyByHub(Connection cn, String iscHub) {
        ConnectorUtil.checkIscHubNotNull((String)iscHub);
        DataRow row = DbUtil.executeRow((Connection)cn, (String)"select fisc_access_key from T_ISC_HUB_SERVER where fisc_hub = ?", Collections.singletonList(iscHub), Collections.singletonList(12));
        Assert.notNull((Object)row, (String)ResManager.loadKDString((String)"\u8be5\u82cd\u7a79\u8fde\u63a5\u5668\u6ca1\u6709\u90e8\u7f72\u4fe1\u606f\u3002", (String)"PushPermissionService_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        return D.s((Object)row.get((Object)"fisc_access_key"));
    }

    public String getCommand() {
        return "push_permission";
    }
}

