/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.connector.ierp.IerpConnectorUtil;
import kd.isc.iscb.connector.ierp.svc.RemoteDeployService;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.platform.core.connector.self.CacheManager;
import kd.isc.iscb.platform.core.connector.self.EventRegister;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.hub.ConnectorUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class RemoteUndeployService
extends AbstractCommandExecutor {
    private static Log logger = LogFactory.getLog(RemoteUndeployService.class);

    public String getCommand() {
        return "remote_undeploy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object exec(ConnectorContext ctx, Map<String, Object> map) {
        String iscHub = D.s((Object)map.get("isc_hub"));
        String encryptContent = D.s((Object)map.get("check_content"));
        String key = IerpConnectorUtil.getDeployKey(D.s((Object)map.get("appId")));
        String dataCenter = IerpUtil.getAccountKey();
        Json.toObject((String)Cipher.decrypt((String)encryptContent, (String)key));
        Connection cn = ctx.getConnection();
        List<String> entityList = this.getIscHubEntityList(iscHub);
        try {
            if (ConnectorUtil.supportMultiHub((String)IerpUtil.getAccountKey())) {
                ConnectorUtil.clearHubConfig((Connection)cn, (String)iscHub);
                IerpConnectorUtil.initAccount();
                Object[] p = new String[]{RequestContext.get().getAccountId(), RequestContext.get().getTenantId()};
                BroadcastService.broadcastMessageWithApp((String)"iscb", (String)RemoteDeployService.class.getName(), (String)"refreshCluster", (Object[])p);
            } else {
                this.clearTable(cn, iscHub);
                if (entityList.size() > 0) {
                    this.batchUnRegister(cn, entityList);
                }
                this.clearCache(cn, dataCenter);
            }
        }
        finally {
            ctx.dispose(cn);
        }
        return "ok";
    }

    private void clearTable(Connection cn, String iscHub) {
        EventBindingUtil.deleteIscHub((Connection)cn);
        IscHubConfigUtil.clearIscHubPermissions((Connection)cn);
        EventBindingUtil.batchDeleteEventBind((Connection)cn, (String)iscHub);
        EventBindingUtil.batchDeleteEventQue((Connection)cn, (String)iscHub);
    }

    private void clearCache(Connection cn, String dataCenter) {
        try {
            logger.info("\u53cd\u90e8\u7f72\u8fdc\u7aef\u7f13\u5b58\u6e05\u7406\u53ca\u5e7f\u64ad:" + dataCenter);
            RequestContext rc = RequestContext.get();
            EventBindingCache.init((String)rc.getAccountId(), (Connection)cn);
            CacheManager.removeEventCache((RequestContext)rc);
            RemoteUndeployService.clearIerpDeployCache(dataCenter);
        }
        catch (Throwable e) {
            logger.error("IERP\u53cd\u90e8\u7f72\u8fdc\u7aef\u7f13\u5b58\u6e05\u7406\u5f02\u5e38:" + StringUtil.getCascadeMessage((Throwable)e));
        }
    }

    public static void clearIerpDeployCache(String dataCenter) {
        ConnectorCallback.removeLoginInfo((String)dataCenter);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ConnectorCallback.class.getName(), (String)"removeLoginInfo", (Object[])new Object[]{dataCenter});
        IscHubConfigUtil.removePermissions((String)dataCenter);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)IscHubConfigUtil.class.getName(), (String)"removePermissions", (Object[])new Object[]{dataCenter});
    }

    private void batchUnRegister(Connection cn, List<String> entityList) {
        for (String entity : entityList) {
            EventRegister.unRegister((Connection)cn, (String)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getIscHubEntityList(String iscHub) {
        ArrayList<String> entityList = new ArrayList<String>();
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT fentity FROM T_ISCB_CON_EVT_BND WHERE fisc_hub = ?";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(iscHub), Collections.singletonList(12));
            for (DataRow dataRow : dataRows) {
                if (entityList.contains(D.s((Object)dataRow.get((Object)"fentity")))) continue;
                entityList.add(D.s((Object)dataRow.get((Object)"fentity")));
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return entityList;
    }
}

