/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc.attach;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.CommonError;

public class AttachmentReadService
implements CommandExecutor {
    private static final int BATCH_SIZE = 0x400000;

    public void exec(ConnectorContext ctx, Map<String, Object> params, Returns returns) {
        Map fileInfo = (Map)params.get("fileInfo");
        String url = D.s(fileInfo.get("srcUrl"));
        Assert.notNull((Object)url, (String)ResManager.loadKDString((String)"\u9644\u4ef6URL\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bfb\u53d6\u9644\u4ef6\u4fe1\u606f\u3002", (String)"AttachmentReadService_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        BufferedInputStream in = new BufferedInputStream(FileServiceFactory.getAttachmentFileService().getInputStream(url));
        try {
            int temp;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(0x400000);
            int length = 0;
            while ((temp = in.read()) > -1) {
                buffer.write(temp);
                if (++length != 0x400000) continue;
                this.output(returns, buffer.toByteArray(), 0x400000, true);
                length = 0;
                buffer = new ByteArrayOutputStream(0x400000);
            }
            this.output(returns, buffer.toByteArray(), length, false);
        }
        catch (IOException e) {
            throw CommonError.INPUT_READER_FAILURE.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private void output(Returns returns, byte[] bytes, int length, boolean hasMore) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("length", length);
        data.put("data", Hex.encode((byte[])bytes));
        returns.setResult(data, hasMore);
    }

    public String getCommand() {
        return "retrieve_attachment";
    }

    public boolean isSync() {
        return false;
    }
}

