/**
 * 内置对象-集合
 */
declare class Collection {
    /**
     * 将多个集合Collection或数组Object[]进行合并。
     *
     * @param {any} entriesA对象A
     * @param {any} entriesB对象B
     * @return Returns合并在一起的集合对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var entriesA = { "number":"zhangsan", "name":"张三" };
     * var entriesB = { "phone":18811112222, "email":"18811112222@kingdee.com" };
     * Collection.addAll(entriesA, entriesB);
     * // => {
            "number":"zhangsan",
            "name":"张三",
            "phone":"18811112222",
            "email":"18811112222@kingdee.com"
        }
     * ```
     */
    static addAll(entriesA: any, entriesB: any): any;
    /**
     * 对集合Collection或数组Object[]的数值求均值，忽略null值。
     *
     * @param {any} entries待求平均值的集合
     * @param {any} callback求值方式的回调
     * @return Returns平均值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var entries = { a:1, b:1.5, c:2.5f, d:null };
     * Collection.avg(entries, e->e.value);
     * // => 1.6666666....
     * ```
     */
    static avg(entries: any, callback?: Function): any;
    /**
     * 清除Collection或Map中的内容。
     *
     * @param {any} c需要清空的集合
     * @return Returns是否清空true/false
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var map = { id : 1, name : 'Hans' };
     * Collection.clear(map);	//执行后，map的内容被清空 var isEmpty = map is Empty;
     * ```
     */
    static clear(c: any): boolean;
     /**
     * 检查Collection或数组Object[]是否存在目标值；等价于 c contains target。
     *
     * @param {any} c集合
     * @param {any} c是否包含的目标
     * @param {any} callback包含逻辑的回调
     * @return Returns是否包含true/false
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = {a: 'A', b: 'B', c: 'C'};
     * Collection.contains(c, 'B', e -> e.value );
     * // => true
     * ```
     */
    static contains(c: any, target: any, callback?:Function): boolean;
    /**
     * 求target在集合Collection或数组Object[]中出现的次数.
     *
     * @param {any} c集合
     * @param {Function|any} c计数目标或者处理计数逻辑方式的回调
     * @return Returns计数结果
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = [1,3,8,9,8,1,10,8];
     * Collection.count(c,8);
     * // => 3
     * var c = {a:12, b:5, c:22.0, d:22};
     * Collection.count(c, e-> e.value == 22);
     * // => 2
     * ```
     */
    static  count(c: any, target: Function | any): number;
     /**
     * 对集合Collection或数组Object[]或Map的EntrySet中的每一个元素执行条件表达式， 返回不满足条件表达式=的元素构成的列表
     *
     * @param {any} c集合
     * @param {Function} callback1处理回调逻辑1
     * @param {Function} callback2可选处理回调逻辑2
     * @return Returns返回不满足逻辑结果的集合中可选项组成的集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = [
            {name:'John', hobby:'Baseball'} ,
            {name:'Tim', hobby:'Baseball'} ,
            {name:'Tom', hobby:'Baseball'} ,
            {name:'John', hobby:'Football'} ,
            {name:'Tom', hobby:'Football'}
        ];
     * Collection.exclude (c, e -> e.hobby=='Baseball', e -> e.name);
        // => ["John", "Tom"]
     * ```
     */
    static exclude(c: any, callback1: Function, callback2?: Function): any;
    /**
     * 获取集合或数组中的第一个元素
     *
     * @param {string} c集合
     * @return Returns集合中第一个子项
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = [15,29,2.3,3.6f];
     * Collection.first(c);
     * // => 15
     * ```
     */
    static first(c: any): any;
     /**
     * 对集合Collection或数组Object[]或Map的EntrySet中的每一个元素执行表达式，求分组名称， 并将相同分组的元素置于同一个列表中，得到由分组为Key，同组元素列表为Value的Map
     *
     * @param {any} c集合
     * @param {Function} callback1处理回调逻辑1
     * @param {Function} callback2可选处理回调逻辑2
     * @return Returns返回集合经过逻辑处理后的分组结果
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = [
            {name:'John', hobby:'Baseball'},
            {name:'Tim', hobby:'Baseball'},
            {name:'Tom', hobby:'Baseball'},
            {name:'John', hobby:'Football'},
            {name:'Tom', hobby:'Football'}
        ];
     * Collection.group(c, e->e.name, e->e.hobby);
        // => {
                "Tom":["Baseball","Football"],
                "John":["Baseball","Football"],
                "Tim":["Baseball"]
            }
     * ```
     */
    static group(c: any, callback1: Function, callback2?: Function): any;
    /**
     * 将第一个集合中与第二个集合中相同KEY的值构造一个新集合
     *
     * @param {any} c1集合
     * @param {any} c2集合
     * @return Returns两个集合中相交元素组成的集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c1 = ['Java','C','C++','Delphi','VB'];
     * var c2 = ['C','C++','C#','J#'];
     * Collection.intersect(c1, c2);
     * // => ["C","C++"]
     * ```
     */
    static intersect(c1: any, c2:any): any;
     /**
     * 获取集合或数组中的最后一个元素
     *
     * @param {any} c集合
     * @return Returns集合最后一个元素子项
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = [15,29,2.3,3.6f];
     * Collection.last(c);
     * // => 3.6
     * ```
     */
    static last(c: any): any;
    /**
     * 获取集合或数组中的最大值
     *
     * @param {any} c集合
     * @param {Function} callback处理最大值回调逻辑
     * @return Returns集合中的最大值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var score = { "Math":90.6, "English":86, "PE":null };
     * return Collection.max(score, e->e.value);
     * // => "90.6"
     * ```
     */
    static max(c: any, callback?: Function): any;
    /**
     * 获取集合或数组中的中值
     *
     * @param {any} c集合
     * @param {Function} comp处理排序回调逻辑
     * @param {Function} getter处理具体中值回调逻辑
     * @return Returns集合中的中值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var list=[
            {i:1,name:'C'},
            {i:3,name:'Z'},
            {i:9,name:'Y'},
            {i:6,name:'X'}
        ];
     * var comp = (a,b)->(a>b);	//comp：对getter的值进行排序，a>b：即最后顺序为9,6,3,1（降序）
     * var getter = a -> (a.i);	//getter：取"i"属性
     * Collection.mid(list,comp, getter);
     * // => 4.5
     * ```
     */
    static mid(c: any, comp?: Function, getter?: Function): any;
    /**
     * 获取集合或数组中的最小值
     *
     * @param {any} c集合
     * @param {Function} callback处理最小值回调逻辑
     * @return Returns集合中的最小值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var score = { "Math":90.6, "English":86, "PE":null };
     * return Collection.min(score, e->e.value);
     * // => "86"
     * ```
     */
    static min(c: any, callback?: Function): any;
    /**
     * 从第一个集合中排除与第二个集合中相同KEY的值，将剩余的值构造一个新集合
     *
     * @param {any} c1集合
     * @param {any} c1集合
     * @param {Function} callback处理去重回调逻辑
     * @return Returns去重结果集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c1 = {a:90.6, b:86, c:77};
     * var c2 = {a:90.6, d:96, e:77};
     * Collection.minus(c1, c2, e->e.key);
     * // => [
            {"key":"b","value":86 },
            {"key":"c","value":77 }
        ]
     * ```
     */
    static minus(c1: any, c2: any, callback?: Function): any;
    /**
     * 对集合Collection或数组Object[]或Map的EntrySet中的每一个元素执行条件表达式， 返回满足条件表达式的元素构成的列表
     *
     * @param {any} c集合
     * @param {Function} criteria处理前行是否添加到新集合
     * @param {Function} getter处理返回添加到新集合的值
     * @return Returns映射逻辑组成集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c=[
            {name:'John', hobby:'Baseball'},
            {name:'Tim', hobby:'Baseball'},
            {name:'Tom', hobby:'Baseball'},
            {name:'John', hobby:'Football'},
            {name:'Tom', hobby:'Football'}
        ];
     * Collection.project (c, e -> e.hobby=='Football', e -> e.name);
     * // => ["John","Tom"]
     * ```
     */
    static project(c: any, criteria: Function, getter?: Function): any;
    /**
     * 对集合Collection或数组Object[]或Map的EntrySet中的每一个元素执行条件表达式，如果满足条件表达式满足，则将此元素从原集合/数组/Map中删除,返回值为删除的元素个数；执行完成后， 原集合/数组/Map中的元素通常会发生变化，不会生成新的列表，这是与exclude的主要区别
     *
     * @param {any} c集合
     * @param {Function} callback处理删除的回调逻辑
     * @return Returns删除的个数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c = { "Java":90, "C":88, "C++":95, "VB":78 };
     * var affected = Collection.remove(c, e -> (e.value > 90));	//值为删除的个数：1
     * return c;
     * // => { "Java":90 , "C":88 , "VB":78 }
     * ```
     */
    static remove(c: any, callback?: Function): number;
     /**
     * 获取集合或数组的元素个数
     *
     * @param {any} c集合
     * @return Returns集合中元素个数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var a = [15, 25, 35, 45];
     * Collection.sizeOf(a);
     * // => 4
     * ```
     */
    static sizeOf(c: any): number;
    /**
     * 从start开始取len个元素构成新集合
     *
     * @param {any} c集合
     * @param {number} start开始抽取位置
     * @param {number} len抽取长度
     * @return Returns抽取子集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var a = [15, 25, 35, 45];
     * return Collection.slice(a, 1, 3);
     * // => [25 ,35 ,45]
     * ```
     */
    static slice(c: any, start, len): any;
    /**
     * 对集合Collection或数组Object[]的元素按自然顺序排序
     *
     * @param {any} c集合
     * @param {Function} callback处理排序的回调逻辑
     * @return Returns排序后结果
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * ["VB","Java","Delphi","C++","C",null]
     * Collection.sort(c);
     * // => ["VB","Java","Delphi","C++","C",null]
     * ```
     */
    static sort(c: any, callback?: Function): any;
    /**
     * 对集合Collection或数组Object[]的数值求和
     *
     * @param {any} c集合
     * @param {Function} callback处理排序的回调逻辑
     * @return Returns计算和
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c={a:1, b:1.5, c:2.5f, d:null};
     * Collection.sum(c, e->e.value);
     * // => "5.0"
     * ```
     */
    static sum(c: any, callback?: Function): any;
    /**
     * 对集合Collection或数组Object[]或Map的EntrySet中的每一个元素执行条件表达式，如果满足条件表达式满足，则对此元素执行 visit_script。如果省略条件表达式则对所有元素执行visit_script
     *
     * @param {any} c集合
     * @param {Function} callback1遍历回调
     * @param {Function} callback2处理满足条件回调
     * @return Returns如果存在满足条件形式，返回满足条件的项组成的集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var c1=['Java','C','C++','Delphi','VB'];
     * var s=[];
     * Collection.visit(c1, e -> (s += e), e -> (e > 'D'));
     * return s;
     * // => [25 ,35 ,45]
     * ```
     */
    static visit(c: any, callback1: Function, callback2?: Function): any;
}
/**
 * 内置对象-时间/日期
 */
declare class Date {
    /**
     * 将日期加上一个时间，或者时间的分量 例如：月份、天数、小时数；
     *
     * @param {Date} date日期
     * @param {Date} time时间的分量
     * @return Returns返回相加之后新的日期；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var now=Date.new();
     * var a = Date.add(now,(-10Months));  //月份分量减10
     * var a = Date.add(now, -3 Days);          //日期分量减3 注意-3和Days之前有一个空格
     * var a = Date.add(now, -400 Milliseconds);   //毫秒分量减400
     * ```
     */
    static  add(date: Date, time: any): any;
     /**
     * 根据分量单位返回两个日期的差，支持DAY，HOUR，MINUTE，SECOND，MONTH，YEAR， WEEK，QUARTER的分量单位；
     *
     * @param {Date} firstDate第一个日期
     * @param {Date} secondDate第二期日期
     * @param {any} timeUnit期待的两个日期在此单位上的差值
     * @return Returns根据分量单位返回相差的数量级；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var now=Date.new();
     * Date.diff(now, (now - 1Year), YEAR)               //结果为-1，相差一年
     * Date.diff(now, (now - 10Months), MONTH)  //结果为-10，相差十个月份
     * Date.diff(now, (now - 3 Days), DAY)              //结果为-3，相差三天
     * Date.diff(now, (now + 4 Seconds), SECOND)//结果为4，相差4秒
     * Date.diff(now, (now - 10Weeks), WEEK)         //结果为-10，相差十周
     * ```
     */
    static diff(firstDate, secondDate, timeUnit): any;
    /**
     * 获取时间指定区间上的第一天
     *
     * @param {Date} date日期对象
     * @param {any} 参数为日期分量，支持MONTH，WEEK，YEAR，QUARTER，HALFYEAR，DAY；
     * @return Returns返回一个日期对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.firstDay(Date('2019-10-10'),YEAR); //2019-01-01  2019的第一天
     * Date.firstDay(Date('2019-10-10'),MONTH); //2019-10-01  2019年10月份的第一天
     * Date.firstDay(Date('2019-10-10'),WEEK);     //2019-10-06  2019年10月10日这周的第一天
     * Date.firstDay(Date('2019-10-10'),QUARTER);  //2019-10-01  2019年10月10日这个季度的第一天
     * Date.firstDay(Date('2019-10-10'),HALFYEAR); //2019-07-01  2019年下半年的第一天
     * Date.firstDay(Date('2019-10-10'),DAY);         //2019-10-10
     * ```
     */
    static  firstDay(date: Date, type: any): Date;
     /**
     * 日期格式化函数，根据日期格式格式化传入的日期
     *
     * @param {Date} date日期对象
     * @param {string} format日期格式
     * @return Returns返回格式化之后的字符串
     * ______
     * __注意事项：__ 一般情况下使用yyyy dd；DD 是该年的第 n 天，dd 是该月的第 m 天；YYYY在特殊日期下会出现超预期的情况
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.format(NOW,'yyyy-MM-dd HH:mm:ss')  //结果示例：2021-01-27 10:30:07
     * Date.format(NOW,'yyyy-MM-dd HH:mm:ss.SSS') //结果示例：2021-01-27 10:30:07.909
     * Date.format(NOW,'yyyy@MM@dd')               //结果示例 : 2021@01@27
     * Date.format(Date.new('2021-01-27 10:30:07'),'yyyy-MM-dd')   // 2021-01-27
     * ```
     */
    static format(date: Date, format: string): string;
    /**
     * 获取时间的毫秒数表示
     *
     * @param {Date} date日期对象
     * @return Returns返回时间的毫秒数表示；该毫秒数是1970.01.01到目标时间的差值；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.getTime(NOW);   //结果示例 1611729807304
     * Date.getTime(Date('2019-10-10 08:00:00'));  //1570665600000
     * L(Date.getTime(NOW)/1000);    //结果示例 1611729807
     * ```
     */
    static  getTime(date: Date): number;
    /**
     * 指定区间的最后一天
     *
     * @param {Date} date日期对象
     * @param {any} 参数为日期分量，支持MONTH，WEEK，YEAR，QUARTER，HALFYEAR，DAY；
     * @return Returns返回一个日期对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.lastDay(Date('2019-10-10 09:00:40'),MONTH)      //2019-10-31 10月这个月的最后一天
     * Date.lastDay(Date('2019-10-10 09:00:40'),WEEK);         //2019-10-12 10月10号这周的最后一天
     * Date.lastDay(Date('2019-10-10 09:00:40'),YEAR);         //2019-12-31 19年的最后一天
     * Date.lastDay(Date('2019-10-10 09:00:40'),QUARTER);  //2019-12-31 第四季度的最后一天
     * ```
     */
    static lastDay(date: Date, type: any): number;
    /**
     * 创建一个时间/日期对象，有两个可选参数，不传参即以当前时间创建时间对象，
     *
     * @param {string} timeString时间/日期字符串
     * @param {string} format输出的时间格式
     * @return Returns返回格式化后的时间/日期对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.new()  //结果示例：2021-01-27 10:44:43.365
     * Date.new("2021-01-27 10:44:43.365",'yyyy-MM-dd') //输出为 2021-01-27 00:00:00.000
     * Date.new('2012-8-18')     // 2012-08-18
     * Date.new("10:44:43.365") // 10:44:43
     * ```
     */
    static new(timeString?: string, format?: string): Date;
    /**
     * 返回当前时间，此外它还可以用 ‘NOW’,‘现在’表示，效果等同；
     *
     * @return Returns返回当前时间
     * ______
     * __适用场景：__ 所有脚本场景
     */
    static now(): Date;
    /**
     * 获取日期/时间值的指定部分的值，例如：年中的第几天、第几月、小时数等，
     *
     * @param {Date} date日期对象
     * @param {any} type日期分量标识（编码：DateIdentifiers）
     * @return Returns返回日期/时间值的指定部分的值。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var date = NOW;
     * var num = Date.part(date, DAY); // 月中的第几天，1~31
     * var num = Date.part(date, HOUR); // 小时，0~23
     * var num = Date.part(date, MINUTE); // 分钟，0~59
     * var num = Date.part(date, SECOND); // 秒，0~59
     * var num = Date.part(date, MILLISECOND); // 毫秒，0~999
     * var num = Date.part(date, MONTH); // 月，1~12
     * var num = Date.part(date, DAY_OF_WEEK); // 该周的第几天，1~7
     * var num = Date.part(date, YEAR); // 年
     * var num = Date.part(date, WEEK_OF_YEAR); // 该年的第几周，1~53
     * var num = Date.part(date, WEEK_OF_MONTH); // 该月的第几周，1~5
     * var num = Date.part(date, DAY_OF_YEAR); // 该年的第几天，1~366
     * var num = Date.part(date, QUARTER); // 季度，1~4
     * ```
     */
    static part(date: Date, type: any): any;
    /**
     * 返回 time 所在时间段的区间 a <= time < b; 函数的内置缩写 是 $R(type, time)
     *
     * @param {Date} type区间类型，取值为 MONTH, DAY, WEEK, MONTH, QUARTER，YEAR；
     * @param {Date} time日期对象
     * @return Returns所在时间段的区间 a <= time < b
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.range(MONTH,NOW);       //结果示例   [2021-01-01 .. 2021-01-31 23:59:59.999]
     * Date.range(DAY,NOW);            //结果示例    [2021-01-27 .. 2021-01-27 23:59:59.999]
     * Date.range(WEEK,NOW);          //结果示例    [2021-01-24 .. 2021-01-30 23:59:59.999]
     * Date.range(MONTH,NOW);       //结果示例   [2021-01-01 .. 2021-01-31 23:59:59.999]
     * Date.range(QUARTER,NOW);   //结果示例   [2021-01-01 .. 2021-03-31 23:59:59.999]
     * Date.range(YEAR,NOW);      //结果示例   [2021-01-01 .. 2021-12-31 23:59:59.999]
     *
     * 脚本引擎内置了如下的快捷内置范围
     * $今天;   // 同DAY类型的还有 $TODAY；$昨天；$YESTERDAY；$明天；$TOMORROW
     * $本周;   //同WEEK类型的还有 $本週；$THIS_WEEK；$上周；$上週；$LAST_WEEK；$NEXT_WEEK；$下周；$下週
     * $本月;   //同MONTH类型的还有 $THIS_MONTH；$上月；$LAST_MONTH；$下月；$NEXT_MONTH
     * $今年;    //同YEAR类型的还有 $THIS_YEAR；$去年；$LAST_YEAR；$明年；$NEXT_YEAR
     * $$本季度;  //同QUARTER类型的还有 $THIS_QUARTER；$上季度；$LAST_QUARTER；$下季度；$NEXT_QUARTER
     * ```
     */
    static range(type: any, time: Date): any;
    /**
     * 返回当天的日期，效果等同于 ‘TODAY’，‘今天’
     *
     * @return Returns返回当天的日期；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Date.today()
     * ```
     */
    static today(): any;
}
/**
 * 内置对象-字符串
 */
declare class String {
    /**
     * 创建一个时间/日期对象，有两个可选参数，不传参即以当前时间创建时间对象，
     *
     * @param {string} s由非英文字母分隔的多个单词所组成的字符串 例如："hello@ good7dworld、yes"
     * @return Returns组合在一起的首字母大写的字符串 ，例如：HelloGoodDworldYes
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.capital("hello  world"); // "HelloWorld"
     * var result = String.capital("hello， world，i am kk");  // "HelloWorldIAmKk"
     * ```
     */
    static capital(s: string): string;
    /**
     * 根据输入的节点名称创建一个xml。
     *
     * @param {string} nodename输入参数为字符串，表示想要增加的节点名称，例如：root
     * @return Returns输出为xml对象，例如："<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><root/>"
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.createXml("root");
     * //添加属性名称为name，属性值为life的hello标签
     * result("hello").name = "life";
     * //添加属性名称为name，属性值为script的world标签
     * result("world").name = "script";
     * //给标签赋值
     * result.#children[0].#text = 1000;
     * result.#children[1].#text = 1111;
     * return result;
     * // => "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><root><hello name=\"life\">1000</hello><world name=\"script\">1111</world></root>"
     * ```
     */
    static createXml(nodename: string): any;
    /**
     * 将Map/List组成的对象格式化为JSON字符串。
     *
     * @param {object} Map/List组成的对象。例如：{id:1,name:'daivi',age:3};
     * @return Returns一个json字符串，例如 "{\"id\":1 ,\"name\":\"daivi\",\"age\":3 }"
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var map = {id:1,name:'daivi',age:3};
     * var result = String.FormatJson(map);
     * // => "{\"id\":1 ,\"name\":\"daivi\",\"age\":3 }"
     * ```
     */
    static FormatJson(obj: object): string;
    /**
     * 该方法是将16字节的二进制串转换为字符串。
     *
     * @param {string} v输入参数为16字节的二进制串
     * @return Returns二进制字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * //假设有一个16字节的二进制串
     * var b16 = 0x1234b67890abc456;
     * //转换
     * var result = String.fromBinary16(b16);
     * // => "1234b67890abc456"
     * ```
     */
    static fromBinary16(v: string): string;
    /**
     * 将字符串转换为字节数组
     *
     * @param {string} s输入为一个字符串
     * @return Returns字节数组,byte[]类型
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "你好啊，world!";
     * var result= String.getBytes(str);
     * var list = [];
     * for(v : result){
     *  list += v;
     * }
     * print(list);
     * // => "[-28, -67, -96, -27, -91, -67, -27, -107, -118, -17, -68, -116, 119, 111, 114, 108, 100, 33]"
     * ```
     */
    static getBytes(s: string): any;
    /**
     * 将字符串转换为字节数组
     *
     * @param {string} s字符串
     * @param {string} charset字符集，默认charset为"UTF-8"
     * @return Returns返回byte[]字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * String.getBytes2("ISCB-test")
     * // => "495343422d74657374"
     * ```
     */
    static getBytes2(s: string, charset?: string): any;
    /**
     * 取日期/时间格式化字符串的小时:分
     *
     * @param {any} Date输入参数
     * @return Returns返回格式化后小时：分字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var  str = "2021-02-20 12:23:00";
     * var date = Date(str);
     * String.HHMM(date);
     * => "12:23"
     * ```
     */
    static HHMM(date: any): string;
    /**
     * 取日期/时间格式化字符串的 小时:分钟。
     *
     * @param {any} Date输入参数
     * @return Returns返回格式化后小时：分字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var  str = "2021-02-20 02:23:00";
     * var date = Date(str);
     * String.HM(date);
     * // => "2:23"
     * ```
     */
    static  HM(date:any): string;
    /**
     * 对字符串进HTML编码，编码规则如下： '<' 编码为 "<"、'>' 编码为 ">"、'\'' 编码为 "'"、'&' 编码为 "&"、'\r' 编码为 "<br>"、'\n' ： 如果前置字符是 \r，则忽略；否则添加换行符"<br>"
     * ' ' 编码为 " "、'\t' 编码为 "    "
     *
     * @param {string} s字符串
     * @return Returns返回编码化后的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var s = "<>''\"\r\n  \t";
     * var res =  String.HTMLEncode(s);
     * // => "&lt;&gt;&apos;&apos;&quot;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
     * ```
     */
    static HTMLEncode(s: string): string;
    /**
     * 返回匹配到的子串的第一个字符所在的位置，如果匹配不到，返回-1
     *
     * @param {string} s主字符串
     * @param {string} s2子字符串
     * @return Returns返回子串所在主串中的位置
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abcdefgbcddss";
     * var result = String.indexOf(str,"bc");
     * // => 1
     * ```
     */
    static indexOf(s: string, s2: string): number;
    /**
     * 判断字符串中仅允许含有 字母, 数字, $、- 或 _
     *
     * @param {string} s字符串
     * @return Returns（true or false）
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var name = "test$";
     * var flag = String.isQname(name);
     * // => true
     * ```
     */
    static isQname(s:string): boolean;
    /**
     * 以给定的分隔符将 Collection 或 Object[] 中的值组成字符串。
     *
     * @param {any} collection集合或者数组
     * @param {string} seperator分隔符
     * @return Returns输出所组成的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var list = [1,2,3,4];
     * var result = String.join( list, ';');
     * // => “1;2;3;4”
     * var map = {a:1, b:2, c:3};
     * var retulst = String.join(map , '; ');
     * // => "a=1; b=2; c=3"
     * ```
     */
    static join(collection: any, seperator: string): string;
    /**
     * Json对象转换为XML对象
     *
     * @param {string} jsonString输入参数为json字符串
     * @return Returns输出结果为XML对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str =  {id:1 ,name:'daivi',age:3 };
     * var xml= String.json2Xml(str);
     * // => "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><data><id>1</id><name>daivi</name><age>3</age></data>"
     * ```
     */
    static  json2Xml(jsonString: string): any;
     /**
      * Json对象转换为XML对象，支持将“-”开头的key转换为XML中的属性项
      *
      * @param {string} jsonString输入参数为json字符串
      * @return Returns输出结果为XML对象
      * ______
      * __注意事项：__ 因生成的Xml必须有一个根节点，Json2XmlWithAttribute函数传入的Map格式参数必须有且仅有一个键值对
      * ______
      * __适用场景：__ 所有脚本场景
      * ______
      * @example w
      * ```js
      * var map = {"obj":{"-count":10 ,"id":1 ,"name":"tomcat","age":3 }};
      * var xml= String.Json2XmlWithAttribute(map);
      * // => "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><obj count=\"10\"><id>1</id><name>tomcat</name><age>3</age></obj>"
      * ```
      */
    static Json2XmlWithAttribute(timeString?: string, format?: string): any;
     /**
     * 返回字符串 t 在字符串 s 中出现的最后位置；如果不存在，则返回-1。
     *
     * @param {string} s字符串1
     * @param {string} t字符串2
     * @param {string} from为搜索开始的位置，如果省略，则从字符串末开始搜索。
     * @return Returns返回子串从后往前所在主串中的位置
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abcdefgghabcgfgffffdddabc";
     * var res = String.lastIndexOf(str,"abc"); //不指定参数from ,从字符串末开始搜索，
     * // => 22
     * ```
     */
    static lastIndexOf(s: string, t: string, from?: number): number;
    /**
     * 取字符串左侧指定长度的字串。
     *
     * @param {string} s字符串
     * @param {string} s代表位数
     * @return Returns字符串s左边的len位子串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abcdefgghabcgfgffffdddabc";
     * var result = String.left(str,3); //取字符串左侧3位
     * // => abc
     * ```
     */
    static left(s: string, len: number): string;
    /**
     * 将字符串转换小写形式。
     *
     * @param {string} s字符串
     * @return Returns小写字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.lower('ABC');
     * // => “abc”
     * ```
     */
    static lower(s: string): string;
    /**
     * 往指定字符串s左边填充特定字符c直到满足指定位数。
     *
     * @param {string} s代表需要填充的字符串
     * @param {string} s代表用来填充的字符
     * @param {string} 代表需要将s字符串填充到多少位
     * @return Returns经过填充的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abc";
     * var result = String.lpad(str, 'X', 10);
     * // => XXXXXXXabc
     * ```
     */
    static lpad(s: string, c: string, len: number): string;
    /**
     * 将JSON字符串解析为Map/List对象。
     *
     * @param {string} s输入为json字符串
     * @return Returns输出结果为Map/List对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var json = "{\"id\":1 ,\"name\":\"daivi\",\"age\":3 }";
     * var result2 = String.ParseJson(json);
     * // => {"id":1,"name":"daivi","age":3}
     * ```
     */
    static ParseJson(s: string): any;
    /**
     * 输入一个xml格式的字符串，返回一个xmlobject对象。用于转换成json串。
     *
     * @param {string} xmlstr字符串
     * @return Returns返回xmlobject对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str= '<?xml version="1.0" encoding="UTF-8" standalone="no"?><data><id>1</id><name>daivi</name><age>3</age></data>';
     * var result= String.parseXml(str);
     * // => "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><data><id>1</id><name>daivi</name><age>3</age></data>"
     * ```
     */
    static parseXml(xmlstr: string): any;
    /**
     * 对字符串进行伪Base64解码
     *
     * @param {string} s字符串
     * @return Returns返回解码后字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str="adeamGaZ";
     * var result = String.PseudoBase64Decode(str);
     * // => 123
     * ```
     */
    static PseudoBase64Decode(s: string): string;
    /**
     * 对字符串进行伪Base64编码
     *
     * @param {string} s字符串
     * @return Returns返回编码后字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var res = "123";
     * var result = String.PseudoBase64Encode(res);
     * // => adeamGaZ
     * ```
     */
    static PseudoBase64Encode(s: string): string;
    /**
     * 字符串替换
     *
     * @param {string} s代表当前字符串
     * @param {string} old代表被替换的字符串
     * @param {string} newStr代表将要替换的字符串
     * @return 替换后的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str= "hello,world!";
     * var result = String.replace(str,'o','MM');
     * // => "hellMM,wMMrld!"
     * ```
     */
    static replace(s: string, old: string, newStr: string): string;
    /**
     * 取字符串右侧指定长度的字串。
     *
     * @param {string} s代表原字符串
     * @param {string} s代表位数
     * @return Returns返回字符串s右边的len位子串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abcdefgghabcgfgffffdddgdf";
     * var result = String.right(str,3); //取字符串右边3位
     * // => "gdf"
     * ```
     */
    static right(s: string, len: number): string;
    /**
     * 往指定字符串s右边填充特定字符c直到满足指定位数
     *
     * @param {string} s代表需要填充的字符串
     * @param {string} s代表用来填充的字符
     * @param {string} 代表需要将s字符串填充到多少位
     * @return Returns经过填充的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abc";
     * var result = String.rpad(str, 'X', 10);
     * // => "abcXXXXXXX"
     * ```
     */
    static rpad(s: string, c: string, len: number): string;
    /**
     * 替换指定字段，包含多个相同字符时，仅替换最右一个
     *
     * @param {string} s代表当前字符串
     * @param {string} c代表需要被替换的字符串
     * @return Returns替换后字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.rtrim("深圳市", "市");
     * // => "深圳"
     * ```
     */
    static rtrim(s: string, c: string): string;
    /**
     * 生成指定长度字符串。
     *
     * @param {number} len代表生成字符串的长度
     * @param {string} s代表要生成的字符，不设置的话默认为一个空格" "
     * @return Returns输出结果为生成的字符串，例如" "
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.space(5);
     * // => "     "     //默认为五个空格组成的字符串
     * ```
     */
    static space(len: number, s?: string): string;
    /**
     * 以字符串regex表示的模式分割字符串s为子串数组
     *
     * @param {string} s字符串
     * @param {string} regex为分隔的字符
     * @param {number} limit为最大分割子串数，可以省略。
     * @return Returns小写字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "hello,world,i am kk";
     * var result = String.split(str,','); //以逗号 , 分隔
     * // => ["hello","world","i am kk"]
     * ```
     */
    static split(s: string, regex: string, limit?: number): any;
    /**
     * 返回字符串s中位置从 start 开始到 finish （不含位置为finish的字符）的字符组成的子串。
     *
     * @param {string} s代表需要填充的字符串
     * @param {number} start开始位置，需要小于字符串s的长度
     * @param {number} finish结束位置，需要小于字符串的位置且大于等于start，可以省略，表示直到字符串尾
     * @return Returns返回字符串s从start位置到finish位置的子串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "abcdefghijk";
     * var result = String.sub(str,1,5); //下标从0开始，取下标为1到下标为5(不包含5)之间的子串
     * // => "bcde"
     * ```
     */
    static sub(s: string, start: number, finish?: number): string;
    /**
     * 将UUID格式或十六进制编码的字符串转换为字节串。
     *
     * @param {string} s字符串
     * @return Returns输出为字节串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.toBinary("ABCD123");
     * // => "0abcd123"  //用0补齐偶数位，因为16进制中两位表示一个字节
     * ```
     */
    static toBinary(s: string): string;
    /**
     * 将字符串转换为16字节的二进制串,32位长度16进制字符串直接转换，36位长度UUID字符串直接转换； 其他则取UTF8编码字节串，如果长度小于16，则末尾以 长度值 补足剩余字节，否则报错。
     *
     * @param {string} s字符串
     * @return Returns16字节的二进制串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.toBinary16('64a61d0523c549d688faa4fd3e8a940b');
     * // => "64a61d0523c549d688faa4fd3e8a940b"
     * ```
     */
    static toBinary16(s: string): string;
    /**
     * 将输入值转换为字符串。
     *
     * @param {string} s如果v为null，返回值为空字符串，v为Context，如果其to_text属性值不为null，则返回to_text属性值，其他返回值为v.toString()。
     * @return Returns输出为字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var s = null ;
     * var result = String.toString( s )
     * // => ""
     * ```
     */
    static toString(v: any): string;
    /**
     * 去除字符串头尾的空格
     *
     * @param {string} s字符串
     * @return Returns去除字符串头尾空格后的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.trim("    abcd efg    ");
     * // => "abcd efg"
     * ```
     */
    static trim(s: string): string;
    /**
     * 将字符串转换成大写形式。
     *
     * @param {string} s字符串
     * @return Returns大写字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = String.upper ('abc');
     * // => “ABC”
     * ```
     */
    static upper(s: string): string;
    /**
     * 对URL格式字符串解码，使用java中的URLDecoder.decode(s, UTF_8) 来实现的
     *
     * @param {string} s输入参数s为经过url编码的字符串，例如 "id%3D12%26world%3D%E5%87%8F%E8%82%A5";
     * @return Returns解码后的字符串 ，例如 "id=12&world=减肥"
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "id%3D12%26world%3D%E5%87%8F%E8%82%A5";
     * var result = String. URLDecode (str) ;
     * // => "id=12&world=减肥"
     * ```
     */
    static URLDecode(s: string): string;
    /**
     * 对字符串进行URL格式编码，使用java中的 URLEncoder.encode(s, UTF_8) 来实现的。
     *
     * @param {string} s字符串
     * @return Returns编码后的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "id=12&world=减肥";
     * var result = String. URLEncode (str) ;
     * // => "id%3D12%26world%3D%E5%87%8F%E8%82%A5"
     * ```
     */
    static URLEncode(s: string): string;
    /**
     * 将输入参数转换为字符串。
     *
     * @param {string} v将v转换为字符串，v为null返回值为空字符串，其他返回值为v.toString()
     * @return Returns输出转换的字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = null;
     * var result = String.valueOf ( str)；
     * // => ""
     * ```
     */
    static valueOf(v: string): string;
    /**
     * 将XML对象转换为JSON，由于该方法需要的参数是xmlobject类型，因此需要使用 String.parseXml(xmlstr) 来 将一个xml字符串转换为xmlobject，之后再进行转换。
     *
     * @param {any}} xml输入参数为XML对象
     * @return Returns输出结果为JSON对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var xmlstr = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><data><id>1</id><name>daivi</name><age>3</age></data>';
     * var result = String.parseXml(xmlstr);
     * var res = String.xml2Json(result);
     * // => {"id":1,"name":"daivi","age":3}
     * ```
     */
    static xml2Json(xml: any): any;
    /**
     * 将XML对象转换为JSON，由于该方法需要的参数是xmlobject类型，因此需要使用 String.parseXml(xmlstr) 来 将一个xml字符串转换为xmlobject，之后再进行转换。该函数支持将xml的属性项转换为json中的键值对，其中键以“-”开头
     *
     * @param {string} 输入参数为XML对象
     * @return Returns输出结果为JSON对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
            <obj count="10">
            <id>1</id>
            <name>tomcat</name>
            <age>3</age>
            </obj>';
     * var result = String.parseXml(str);
     * var res = String.Xml2JsonWithAttribute(result);
     * // => {
                    "obj":
                        {
                            "-count":"10",
                            "id":"1",
                            "name":"tomcat",
                            "age":"3"
                        }
                }
     * ```
     */
    static  Xml2JsonWithAttribute(xml: any): any;
}
/**
 * 内置对象-Math
 */
declare class Math {
    /**
     * Math.abs获取绝对值
     *
     * @param {number} num入参为整型和浮点类型的有效数据。
     * @return Returns入参的绝对值；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var obj = -123;
     * var result = Math.abs(obj);
     * // => 123
     * ```
     */
    static abs(num: number): number;
    /**
     * Math.cos计算余弦。
     *
     * @param {number} num入参为整型和浮点数
     * @return Returns计算的余弦结果。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3.141592;
     * var result = Math.cos(number);
     * // => -0.9999999999997864
     * ```
     */
    static cos(num: number): number;
    /**
     * Math.max比较最大值。
     *
     * @param {number} num1类型为整型和浮点型有效参数。
     * @param {number} num2类型为整型和浮点型有效参数。
     * @return Returns返回比较结果最大值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Math.max(1,2);
     * // => 2
     * ```
     */
    static max(num1: number, num2: number): number;
    /**
     * Math.min比较最小值
     *
     * @param {number} num1类型为整型和浮点型有效参数。
     * @param {number} num2类型为整型和浮点型有效参数。
     * @return Returns返回比较结果最大值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Math.min(1,2);
     * // => 1
     * ```
     */
    static min(num1: number, num2: number): number;
    /**
     * Math.rnd计算随机数。
     *
     * @param {number} num入参为整型和浮点类型的参数。
     * @return Returns返回0到入参范围类的随机数，包括0，不包括入参。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3;
     * var result = Math.rnd(number);
     * // => 0或者1或者2
     * ```
     */
    static rnd(num: number): number;
    /**
     * Math.sin获取正弦值。
     *
     * @param {number} num整型和浮点型入参
     * @return Returns返回入参的正弦值；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3;
     * var result = Math.sin(number);
     * // => 0.1411200080598672
     * ```
     */
    static sin(num: number): number;
}
/**
 * 内置对象-Number
 */
declare class Number {
    /**
     * Number.$将入参转换为带逗号的形式。
     *
     * @param {number} num整型和浮点型入参
     * @return Returns返回带逗号的格式。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3;
     * var result = Number.$(number);
     * // => 3.00
     * ```
     */
    static $(num: number): any;
    /**
     * Number.abs计算绝对值。
     *
     * @param {number} num入参为整型和浮点类型的有效数据。
     * @return Returns入参的绝对值；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = -3.1;
     * var result = Number.abs(number);
     * // => "3.1"
     * ```
     */
    static abs(num: number): number;
    /**
     * Number.capital转换成人民币汉字表示。
     *
     * @param {number} num入参为整型和浮点类型的有效数据。
     * @return Returns汉字表示的人民币结果。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 5.6;
     * var result = Number.capital(number);
     * // => 伍元陆角零分
     * ```
     */
    static capital(num: number): number;
    /**
     * Number.ceil向上取整数。
     *
     * @param {number} num类型为整型和浮点型有效参数。
     * @return Returns取入参的向上整数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3.1;
     * var result = Number.ceil(number);
     * // => 4
     * ```
     */
    static ceil(num: number): number;
    /**
     * Number.floor取入参向下的整数。
     *
     * @param {number} num入参为整型和浮点类型的参数。
     * @return Returns去入参向下的整数。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3.1;
     * var result = Number.ceil(number);
     * // => 3
     * ```
     */
    static floor(num: number): number;
    /**
     * Number.format参数格式化。
     *
     * @param {number} num整型和浮点型入参
     * @param {number} 第二个参数为格式化字符（可选），小数点后保留位数与格式化字符的小数点后0相同，样例中为保留小数点后3位，四舍五入。
     * @return Returns整型返回原值，浮点型返回0.0000格式。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Number.format(0.3);
     * var result = Number.format(1.000510，"#,##0.000");
     * // => 0.3000  、  1.001
     * ```
     */
    static format(num: number, format?: string): number;
    /**
     * Number.parseDecimal转成精度数据。
     *
     * @param {number} num类型为整型和浮点型有效参数。
     * @return Returns将入参转换成decimal精度数据。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3.23;
     * var result = Number.parseDecimal(number);
     * // => 3.23
     * ```
     */
    static parseDecimal(num: number): number;
    /**
     * Number.parseDouble转成双精度浮点型
     *
     * @param {number} num入参为整型和浮点类型的参数。
     * @return Returns转换成双精度浮点型的数据。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3;
     * var result = Number.parseDouble(number);
     * // => 3.0
     * ```
     */
    static parseDouble(num: number): number;
    /**
     * Number.parseHex解析16进制字符串，生成长整数
     *
     * @param {string} numHex16进制字符串。
     * @return Returns长整数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 2AF5;
     * var result = Number.parseHex(number);
     * // => "10997"
     * ```
     */
    static parseHex(numHex: string): number;
    /**
     * Number.parseInt转换成int类型整数
     *
     * @param {number} num需要转成int类型的有效参数。
     * @return Returns整型结果。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = "123";
     * var result = Number.parseInt(number);
     * // => 123
     * ```
     */
    static parseInt(num: number): number;
    /**
     * Number.parseLong转换成long类型整数。
     *
     * @param {number} num需要转成long类型的有效参数。
     * @return Returnslong类型结果。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = "123";
     * var result = Number.parseLong(number);
     * // => 123
     * ```
     */
    static parseLong(num: number): number;
    /**
     * Number.rnd计算随机数。
     *
     * @param {number} num入参为整型和浮点类型的参数。
     * @return Returns返回0到入参范围类的随机数，包括0，不包括入参。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 3;
     * var result = Math.rnd(number);
     * // => 0或者1或者2
     * ```
     */
    static rnd(num: number): number;
    /**
     * Number.round四舍五入
     *
     * @param {number} num需要四舍五入的参数。
     * @param {number} scale保留的位数。
     * @return Returns四舍五入之后的结果。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var number = 5.48369;
     * var result = Number.round(number,4);
     * // => 5.4837
     * ```
     */
    static round(num: number, scale?:number): number;
    /**
     * Number.split数据拆分。
     *
     * @param {number} num整数、小数入参。
     * @param {number} count将入参拆分成count个参数
     * @return Returns数组，将入参拆分成count个参数。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Number.split(7, 2);
     * // => ["4","3"]
     * ```
     */
    static split(num: number, count: number): any;
    /**
     * Number.test判断是否是Number类型。
     *
     * @param {number} num需要判断的任意有效入参
     * @return Returns布尔值。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Number.test(3);
     * // => true
     * ```
     */
    static  test(num: any): boolean;
}
/**
 * 内置对象-AES
 */
declare class AES {
     /**
     * Number.$将入参转换为带逗号的形式。
     *
     * @param {string} mode: 加密模式 如：CBC、EBC等；字符串类型
     * @param {string} padding：填充方式 如：PKCS5Padding、NoPadding等；字符串类型
     * @param {any} key：解密key 字节数组类型
     * @param {any} data：待解密数据 字节数组类型
     * @param {any} v：初始化向量 字节数组类型
     * @return Returns解密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = String.getBytes("It will rain tomorrow", 'utf-8');// 待加密的内容，类型 byte[16]
     * var key = Base64Decode("5Lit5paH5a+G56CBQUJDRA==");// 加密KEY，类型 byte[16]
     * var iv = Base64Decode("5Yid5aeL5ZCR6YePR0hJSg=="); // 初始化向量，IV，类型 byte[16]
     * var secret = AES.encrypt("CBC","PKCS5Padding",key,data,iv); // 加密结果，类型 byte[]
     * var result = AES.decrypt("CBC","PKCS5Padding",key,secret,iv);// 解密结果，类型 byte[]
     * var orgin = String(result);//原始内容
     * // => "It will rain tomorrow"
     * ```
     */
    static decrypt(mode: string, padding: string, key: any, data: any, iv: any): any;
    /**
     * Number.abs计算绝对值。
     *
     * @param {string} mode: 加密模式 如：CBC、EBC等；字符串类型
     * @param {string} padding：填充方式 如：PKCS5Padding、NoPadding等；字符串类型
     * @param {any} key：解密key 字节数组类型
     * @param {any} data：待解密数据 字节数组类型
     * @param {any} v：初始化向量 字节数组类型
     * @return Returns加密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = String.getBytes("It will rain tomorrow", 'utf-8');// 待加密的内容，类型 byte[16]
     * var key = Base64Decode("5Lit5paH5a+G56CBQUJDRA==");// 加密KEY，类型 byte[16]
     * var iv = Base64Decode("5Yid5aeL5ZCR6YePR0hJSg=="); // 初始化向量，IV，类型 byte[16]
     * var secret = AES.encrypt("CBC","PKCS5Padding",key,data,iv); // 加密结果，类型 byte[]
     * var result = AES.decrypt("CBC","PKCS5Padding",key,secret,iv);// 解密结果，类型 byte[]
     * var base64 = Base64Encode(secret); // BASE64编码的密文，类型：字符串
     * // => "ABPRidEJgaT0eS9Aif2teQtCCPqiJyzyVjbkDzvSmFA="
     * ```
     */
    static encrypt(mode: string, padding: string, key: any, data: any, iv: any): any;
}
/**
 * 内置对象-Hash
 */
declare class Hash {
    /**
     * CRC32是将数据生成32位数校验码的一种散列函數。。
     *
     * @param {any} str需要计算的任意有效数据（如二进制，字节数组、字符串等）。
     * @return Returns输出32位校验码。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.CRC32("abc");
     * // => "352441c2"
     * ```
     */
    static CRC32(str: any): string;
    /**
     * 根据密钥对数据进行加密的MD5的哈希算法
     *
     * @param {any} msg_bytes待加密数据byte数组。
     * @param {any} key_bytes加密密钥byte数组
     * @return Returns加密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var msg = '1648019833725';
     * var signingKey = 'YCREWXJQZTERCGYNJTCY3L0QC39TAGQO';
     * var encrytByteArrayData = Hash.HmacMD5(String.getBytes2(msg),String.getBytes2(signingKey));
     * // => "406c75fe71ace6cb66491021a545f837"
     * ```
     */
    static HmacMD5(msg_bytes: any, key_bytes: any): any;
    /**
     * 根据密钥对数据进行加密的SHA1的哈希算法
     *
     * @param {any} msg_bytes待加密数据byte数组。
     * @param {any} key_bytes加密密钥byte数组
     * @return Returns加密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var msg = '1648019833725';
     * var signingKey = 'YCREWXJQZTERCGYNJTCY3L0QC39TAGQO';
     * var encrytByteArrayData = Hash.HmacSHA1(String.getBytes2(msg),String.getBytes2(signingKey));
     * // => "92359f47000faafdacfa160f32736079b616db67"
     * ```
     */
    static  HmacSHA1(msg_bytes: any, key_bytes: any): any;
    /**
     * 根据密钥对数据进行加密的SHA256的哈希算法
     *
     * @param {any} msg_bytes待加密数据byte数组。
     * @param {any} key_bytes加密密钥byte数组
     * @return Returns加密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var msg = '1648019833725';
     * var signingKey = 'YCREWXJQZTERCGYNJTCY3L0QC39TAGQO';
     * var encrytByteArrayData = Hash.HmacSHA256(String.getBytes2(msg),String.getBytes2(signingKey));
     * // => "910229de63d20f77858bfd838df47e7c7b77c926ce572347fcbff5094df214ad"
     * ```
     */
    static HmacSHA256(msg_bytes: any, key_bytes: any): any;
    /**
     * 根据密钥对数据进行加密的SHA384的哈希算法
     *
     * @param {any} msg_bytes待加密数据byte数组。
     * @param {any} key_bytes加密密钥byte数组
     * @return Returns加密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var msg = '1648019833725';
     * var signingKey = 'YCREWXJQZTERCGYNJTCY3L0QC39TAGQO';
     * var encrytByteArrayData = Hash.HmacSHA384(String.getBytes2(msg),String.getBytes2(signingKey));
     * // => "deaad115ce611ca8a12a64c7cb19f40a6ff332cbb9512cdd43ac268c5fddcc559a91db9206d37444bd7677bfb919fd30"
     * ```
     */
    static HmacSHA384(msg_bytes: any, key_bytes: any): any;
    /**
     * 根据密钥对数据进行加密的SHA512的哈希算法
     *
     * @param {any} msg_bytes待加密数据byte数组。
     * @param {any} key_bytes加密密钥byte数组
     * @return Returns加密后的字节数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var msg = '1648019833725';
     * var signingKey = 'YCREWXJQZTERCGYNJTCY3L0QC39TAGQO';
     * var encrytByteArrayData = Hash.HmacSHA512(String.getBytes2(msg),String.getBytes2(signingKey));
     * // => "5d402c8adb603617f91ab50d14d6b553c6d249dd5b420551ed0883554f2fff441e49fe27bac6403aa4417a8a48d398585c085c2a3af3fef0058f401b405e8f09"
     * ```
     */
    static HmacSHA512(msg_bytes: any, key_bytes: any): any;
    /**
     * 对数据进行MD5加密。
     *
     * @param {any} str需要计算的任意有效数据（如二进制，字节数组、字符串等）。
     * @return Returns返回128位散列值；
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.MD5("abc");
     * // => "900150983cd24fb0d6963f7d28e17f72"
     * ```
     */
    static MD5(str: any): string;
    /**
     * 非加密型哈希算法。
     *
     * @param {any} str需要加密的数据。
     * @return Returns哈希码
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.MUR("abc");
     * // => "945bc643ba2e9e51"
     * ```
     */
    static MUR(str: any): string;
    /**
     * 16位非加密哈希算法。
     *
     * @param {any} str需要加密的数据。
     * @return Returns返回16位哈希码
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.MUR16("abc");
     * // => 4174
     * ```
     */
    static MUR16(str: any): string;
    /**
     * 32位非加密哈希算法。
     *
     * @param {any} str需要加密的数据。
     * @return Returns返回32位哈希码
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.MUR32("abc");
     * // => b61e4174
     * ```
     */
    static MUR32(str: any): string;
    /**
     * RSA_SHA256签名加密算法。
     *
     * @param {string}} msg待签名数据
     * @param {string} key：RSA私钥(需要使用符合PKCS规范的密钥)
     * @return Returns签名结果
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var msg="abc";
        var key="-----BEGIN RSA PRIVATE KEY-----
        MIIEogIBAAKCAQEA33TqqLR3eeUmDtHS89qF3p4MP7Wfqt2Zjj3lZjLjjCGDvwr9
        cJNlNDiuKboODgUiT4ZdPWbOiMAfDcDzlOxA04DDnEFGAf+kDQiNSe2ZtqC7bnIc
        8+KSG/qOGQIVaay4Ucr6ovDkykO5Hxn7OU7sJp9TP9H0JH8zMQA6YzijYH9LsupT
        errY3U6zyihVEDXXOv08vBHk50BMFJbE9iwFwnxCsU5+UZUZYw87Uu0n4LPFS9BT
        8tUIvAfnRXIEWCha3KbFWmdZQZlyrFw0buUEf0YN3/Q0auBkdbDR/ES2PbgKTJdk
        jc/rEeM0TxvOUf7HuUNOhrtAVEN1D5uuxE1WSwIDAQABAoIBAA41OeJmLx6SAlx4
        3OfiYhaoh/DZFIDhvCy+JMLdw3gafWz9PuYUiR/L5s8CZHhhvS+/RFhuG/238YGH
        XjV+3BRWoJlj0Ra5cW3euFUWBWsGR0SbftnG8zFSOgy/BCuG7uVMeak4leOCcNfY
        aA/Zw8wk3z80k0hqyg94iz3Z0RGGiBg1cXIwb908eq6792dpYRxyoRB29EUYwE3I
        wFSlfTWYTGoyeJfaaidwOCEKwgZfebsel5taFz9Iumke/HI3IbAqXDF3T91jLLx4
        E5bGU9EWSxR675IjR5T4opeBtv3h5ML0//wq3GzukpiP8wrTJsqbhyanK/l2+xjy
        aGuuFqECgYEA8K33pX90XX6PZGiv26wZm7tfvqlqWFT03nUMvOAytqdxhO2HysiP
        n4W58OaJd1tY4372Qpiv6enmUeI4MidCie+s+d0/B6A0xfhU5EeeaDN0xDOOl8yN
        +kaaVj9b4HDR3c91OAwKpDJQIeJVZtxoijxl+SRx3u7Vs/7meeSpOfECgYEA7a5K
        nUs1pTo72A+JquJvIz4Eu794Yh3ftTk/Et+83aE/FVc6Nk+EhfnwYSNpVmM6UKdr
        Aoy5gsCvZPxrq+eR9pEwU8M5UOlki03vWY/nqDBpJSIqwPvGHUB16zvggsPQUyQB
        fnN3N8XlDi12n88ltvWwEhn1LQOwMUALEfka9/sCgYAMH2ca4emVj/te/lrlQKzl
        iDGRY+0kV9shnVmv5ccIJjT0khZF44ZAbbbo6GPCLEq04r86qYAq0woz06Yq+IlE
        c1sOFtPG6Y3e7twvx1+2NelKvKIRCU+ZbJb3gyd4jZY0iu+HjCu5C4O3wTO2A6IM
        XHBydSB7LyJ6d3taZmcTsQKBgDvm0k1EODf1LkHs4JBd0w65wa2juu5XgxsEW34h
        P1NIIUL6oeQwNEEj1c5Vg2XPSlIrb4/L8bEfaNT1vRktGp9exiRGLnrS55EoSitz
        VjoQQV+ndcj/a1XR+iYYCCRMv4NErs+0wBYhXPIuyRfLuECdOQvG2QDITi6Lan7U
        HlTjAoGAInfGmkb2jNkPGuNiZ+mU0+ZrOgLza/fLL9ErZ35jUPhGFzdGxJNobklv
        sNoTd+E2GAU41YkJh24bncMLvJVYxHHA5iF7FBWx1SvpEyKVhhnIcuXGD7N5PbNZ
        zEdmr9C6I7cPVkWO+sUV7zfFukexIcANmsd/oBBGKRoYzP5Tti4=
        -----END RSA PRIVATE KEY-----
        ";
        var result = Hash.RSA_SHA256(msg, key);
        // => odZy7C77pGbuaXEEwE6BMbvtrwtyhfgo8nhpZ5puIYEiwfooOiOVbZsPrYx9j2MVOq4cZo9pRpgSYnrEgHPMHGHvHYKEBxyiXWuIDHHmNQGoHZad5ZQzFsoTyApsnL0jJxOn7fQmcj2kyIJ
     * ```
     */
    static RSA_SHA256(msg: string, key: string): string;
    /**
     * SHA1加密算法。
     *
     * @param {any} str待加密数据。
     * @return Returns返回160位加密数据
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.SHA1("abc");
     * // => a9993e364706816aba3e25717850c26c9cd0d89d
     * ```
     */
    static SHA1(str: string): string;
    /**
     * Hash.SHA256加密算法。
     *
     * @param {any} str待加密数据
     * @return Returns返回256位加密数据
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.SHA256("abc");
     * // => "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad"
     * ```
     */
    static SHA256(str: string): string;
    /**
     * SHA384加密算法。
     *
     * @param {any} str需要加密的数据。
     * @return Returns返回384位加密数据
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Hash.SHA384("abc");
     * // => "cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7"
     * ```
     */
    static SHA384(str: any): string;
}
/**
 * 内置对象-数据结构Data
 */
declare class Data {
    /**
     * 深度克隆一个由简单值构成的Map或List，对其中的可变对象（Map/List）都复制一个新对象。即克隆后新对象或原对象若修改，彼此之间不会受到影响
     *
     * @param {any} v待克隆数据
     * @return Returns返回克隆数据
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var list = [{"a":1,"b":2},{"a":3,"b":4}];
     * var list2 = Data.deepClone(list);
     * return list2;
     * // => [{"a":1,"b":2},{"a":3,"b":4}]
     * ```
     */
    static deepClone(v: any): any;
    /**
     * 字符串模式匹配 ^ - 字符串开头；$ - 字符串结尾；* - 任意长度子串; ? - 任意字符
     *
     * @param {string} pattern1模式匹配字符串
     * @param {string} pattern2模式匹配字符串
     * @return Returns是否匹配true/false
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var fsm = Data.fsm('^ab$','a*a');
     * return fsm('baba')；
     * // => true
     * ```
     */
    static fsm(pattern1:string, pattern2: string): boolean;
    /**
     * 新建一个堆，并将集合中的元素加入堆中
     *
     * @param {any} v加入堆中的参数，可以是多个参数
     * @return Returns返回一个多个元素组成的集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var heap = Data.heap(1,3,2,5,6);
     * var list = [];
        for(a : heap){
            list+=a;
        };
        return list;
     * // => [1 ,2 ,3 ,5 ,6 ]
     * ```
     */
    static heap(v?: any): any;
    /**
     * 生成一个静态查找表，与Map不同的是，此查找表在编译期生成。可以用default指定查询key不匹配时使用的默认值。如果查询到值是函数，则执行此函数
     *
     * @param {object} obj转换成查找表mapping的对象
     * @return Returns静态查找表map
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var map = Data.mapping({a:1, b: 2, c: 3, default: -1});
     * return map('b');
     * // => 2
     * ```
     */
    static mapping(obj: object): any;
    /**
     * 构造二元组.
     *
     * @param {any} str待加密数据
     * @return Returns返回256位加密数据
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var p = Data.pair('key', 'value');
     * println(p.key + '=' + p.value);
     * // => "key=value"
     * ```
     */
    static pair(key: string, value: any): any;
    /**
     * 新建一个队列，并将集合中的元素加入队列
     *
     * @param {any} v加入堆中的参数，可以是多个参数
     * @return Returns返回元素组成的队列
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var queue = Data.queue(1,3,2,5,6);
     * queue <+ 15;	//入队
     * queue +> a; 	//出队
     * return a;
     * // => 1
     * ```
     */
    static queue(v?: any): string;
    /**
     * 生成一个动态查找表，其中key应该是变量, value可以是常量或变量
     *
     * @param {any} obj转换成查找表routing的对象
     * @return Returns动态查找表routing
     * ______
     * __注意事项：__  如果 key 值是常量, 则应该用静态查找表, 有助于提升性能。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var tlb = Data.routing({'a':1, 'b': 2, 'c': 3, default:99});
     * return tlb('b');
     * // => 2
     * ```
     */
    static routing(obj: any): any;
    /**
     * 构造无重复集合
     *
     * @param {any} v加入集合中的参数，可以是多个参数
     * @return Returns返回set集合
     * ______
     * __注意事项：__  当collection中元素类型各异时，可能发生类型转换，但转换前后的值是等价的；不要将double和其他类型的数值混用，以免在转换类型时丢失精度。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Data.set();	//输出结果：[]（默认初始容量的空集合）
     * Data.set(16);//输出结果：[]（此种方式建立的是初始容量为16的空集合）
     * Data.set(1, 2, 3, 2); //输出结果：[1, 2, 3]
     * var c=[1,2,3,2,null]; Data.set(c); //输出结果：[1, 2, 3]
     * ```
     */
    static set(v?: any): string;
    /**
     * 新建一个堆栈，并将集合中的元素加入堆栈中
     *
     * @param {any} v加入集合中的参数，可以是多个参数
     * @return Returns返回参数组成的堆栈
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var stack = Data.stack(1,3,2,5,6);
     * stack <+ 15;	//入栈
     * stack +> a; 	//出栈
     * return a;
     * // => 15
     * ```
     */
    static stack(v: any): any;
    /**
     * 定义一个多元组变量的结构声明，其实例可以作为Map的组合Key，且该实例的数据项可以使用 field名称或field下标访问
     *
     * @param {any} v加入集合中的参数，可以是多个参数
     * @return Returns返回set集合
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var s = Data.struct(a, b, c);
     * var item = s(3,5,7);
     * [item.b, item.c] = [item.c, item.b];	//将数据项b与c的值交换
     * return item;
     * // => { "a":3 , "b":7 , "c":5 }
     * ```
     */
    static struct(v: any): any;
    /**
     * 动态查找表 key -> value, 其中 key 应该是变量, value 可以是常量或变量; var call = Data.switch({c1 : v1, c2 : v2, ... , default : 默认值}); var result = call({p1:v1, p2:v2, ...}, args); 根据{p1:v1,p2:v2,...}提供的值计算条件(c1, c2, ...)值, 如果满足则得到对应的 (v1, v2,...)； 如果 v1, v2, ... 是函数，则用传入的参数执行，返回结果
     *
     * @param {any} obj转换成动态查找表的对象
     * @return Returns返回动态查找表
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var map=Data.switch(v==1 : 'A', v==2 :'B' , v==3 : 'C', default : 'D');
     * return map(v : 2);
     * // => B
     * ```
     */
    static switch(obj: any): any;
    /**
     * 定义一个多元组常量的结构声明，其实例可以作为Map的组合Key，且该实例的数据项可以使用 field名称或field下标访问
     *
     * @param {any} v加入多元组中的参数，可以是多个参数
     * @return Returns多元组tuple
     * ______
     * __注意事项：__  如果 key 值是常量, 则应该用静态查找表, 有助于提升性能。
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var t = Data.tuple(a,b,c);
     * println(t(1,2,3));		//输出结果："(1, 2, 3)"
     * println(t(2,3,5).b);	        //输出结果："3"
     * ```
     */
    static tuple(v: any): any;
}
/**
 * 内置对象-文件操作Ftp
 */
declare class Ftp {
    /**
     * 删除目录下的指定文件。
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @param {string} 文件名
     * @return Returns是否删除成功
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Ftp.delete(ftp, "/data", "demo.txt");
     * // => true
     * ```
     */
    static delete(ftpCn: string, dirPath:string, fileName: string): boolean;
    /**
     * 检查指定目录或目录下文件是否存在。
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @return Returns是否存在
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Ftp.exists(ftp, "/data/");  //目录"/data"是否存在
     * Ftp.exists(ftp, "/data/demo.txt");//文件"demo.txt"是否存在目录"/data“”中
     * // => true
     * ```
     */
    static exists(ftpCn: string, dirPath:string): boolean;
    /**
     * 获取FTP服务器上某路径下的某文件的内容
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @param {string} 文件名
     * @return Returns返回byte[]
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Ftp.getBytes(ftp, "/data", "1.txt");
     * // => "320d0a32320d0ab2e2cad4320d0a"
     * ```
     */
    static getBytes(ftpCn: string, dirPath:string, fileName: string): any;
    /**
     * 获取FTP服务器上某路径下的某文件的内容
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @param {string} 文件名
     * @return Returns字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var a = Ftp.getString(ftp, "/data", "1.txt", "utf8");
     * // => "\"heaaa\"\"23456\"\r\n67888899\r\n\"343354544\"\r\n343354544\r\n[1,2]\r\na\r\n中国"
     * ```
     */
    static getString(ftpCn: string, dirPath:string, fileName: string, charset: string): string;
    /**
     * 动态查找表 key -> value, 其中 key 应该是变量, value 可以是常量或变量; var call = Data.switch({c1 : v1, c2 : v2, ... , default : 默认值}); var result = call({p1:v1, p2:v2, ...}, args); 根据{p1:v1,p2:v2,...}提供的值计算条件(c1, c2, ...)值, 如果满足则得到对应的 (v1, v2,...)； 如果 v1, v2, ... 是函数，则用传入的参数执行，返回结果
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @param {any} 文件类型，可选值有：null-获取所有文件和目录、获取所有文件和目录-获取所有文件、DIR-获取所有目录
     * @return Returns包含文件或目录信息的数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * result =  Ftp.list(ftp, "/data", null);
     * // => [
            {
                "fileName":"d1",
                "modifyTime":"2021-04-22 11:29:00",
                "fileSize":"-1",
                "fileExt":"",
                "type":"DIR"
            },
            {
                "fileName":"lv1.json",
                "modifyTime":"2021-03-25 16:41:00",
                "fileSize":"903",
                "fileExt":"json",
                "type":"FILE"
            }
        ]
     * ```
     */
    static list(ftpCn: string, dirPath:string, type: any): any;
    /**
     * 创建目录。
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @return Returns创建成功true或失败false
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Ftp.mkdir(ftp, "/data");
     * // => true
     * ```
     */
    static list(ftpCn: string, dirPath:string): boolean;
    /**
     * 上传文件
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @param {string} fileName文件名
     * @param {string} fileContent文件内容（byte[]）
     * @param {string} sUpdate存在同名文件是否覆盖文件内容
     * @return Returns上传成功true或失败false
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var str = "1\r\na\r\n我";
     * var result= String.getBytes(str);
     * return Ftp.putBytes(ftp, "/data", "demo.txt", result, true);
     * // => true
     * ```
     */
    static putBytes(ftpCn: string, dirPath:string, fileName: string, fileContent: any, isUpdate: boolean): boolean;
    /**
     * 删除指定目录及目录下所有子文件和目录。
     *
     * @param {string} ftp系统连接别名
     * @param {string} ftp目录路径
     * @return Returns删除成功true或失败false
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * Ftp.rmdir(ftp, "/data");
     * // => true
     * ```
     */
    static rmdirs(ftpCn: string, dirPath:string): boolean;
}
/**
 * 内置对象-ClickHouse
 */
declare class ClickHouse {
    /**
     * ClickHouse删除函数。
     *
     * @param {any} cn系统连接
     * @param {string} table表名
     * @param {any} data数据
     * @param {any} judgeFields候选键
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = {"a":1};
     * judgeFields=['a'];
     * var result = ClickHouse.delete(cn,table,data,judgeFields);
     * // => 1
     * ```
     */
    static delete(cn:any, table:string, data:any, judgeFields:any): any;
    /**
     * ClickHouse插入函数
     *
     * @param {any} cn系统连接
     * @param {string} table表名
     * @param {any} data数据
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = [{"a":1,"b":"1"},{"a":2,"b":"2"}];
     * var result = ClickHouse.insert(cn,"test10",data);
     * // => 1
     * ```
     */
    static insert(cn:any, table:string, data:any): any;
    /**
     * 删除指定目录及目录下所有子文件和目录。
     *
     * @param {any} cn系统连接
     * @param {string} table表名
     * @param {any} data数据
     * @param {any} judgeFields候选键
     * @return Returns返回保存的数据条数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = {"a":1};
     * var judgeFields=['a'];
     * var result = ClickHouse.save(cn,table,data,judgeFields);
     * // => 1
     * ```
     */
    static save(cn:any, table:string, data:any, judgeFields:any): boolean;
    /**
     * ClickHouse更新函数
     *
     * @param {any} cn系统连接
     * @param {string} table表名
     * @param {any} data数据
     * @param {any} judgeFields候选键
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = {"a":1};
     * var judgeFields=['a'];
     * var result = ClickHouse.update(cn,table,data,judgeFields);
     * // => 1
     * ```
     */
    static update(cn:any, table:string, data:any, judgeFields:any): boolean;
}
/**
 * 内置对象-数组
 */
declare class Array {
    /**
     * 返回数组中位置从 start 开始到 end （不含位置为end的项）的项组成的数组。支持任意同一种类型项组成的数组，如字节数组的截取等
     *
     * @param {any} arr数组
     * @param {number} start开始位置，需要小于数组的长度
     * @param {any} end结束位置，需要小于数组长度的位置且大于等于start
     * @return Returns数组中位置从 start 开始到 end （不含位置为end的项）的项组成的数组
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var list = [1,2,3,4,5];
     * var arr = NewArray(list);//此处仅为举例，实际使用时数组变量应该已存在。如果是列表类型数据需要抽取子项，可直接使用Collection.slice函数。
     * var subArray = Array.sub(arr,0,2);//下标从0开始，取下标为1到下标为2(不包含2)之间的项
     * // => [1, 2]
     * ```
     */
    static sub(arr:any, start: number, end: number):any;
}
/**
 * Ldap函数-Ldap
 */
declare class Ldap {
    /**
     * Ldap list函数
     *
     * @param {any} cn系统连接
     * @param {string} 条目DN
     * @return Returns指定DN直接子项列表
     * ______
     *  __注意事项：__ dn不需要自己传入，会读取连接配置上基础DN
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Ldap.list(cn); //连接配置基础DN:dc=maxcrc,dc=com
     * // => [
            "ou=BeiJing",
            "ou=GuangDong",
            "ou=People",
            "ou=Sales"
        ]
     * ```
     */
    static list(cn:any, dn?:any):any;
    /**
     * Ldap lookup函数
     *
     * @param {any} cn系统连接
     * @param {string} 条目DN
     * @return Returns指定DN条目所有属性
     * ______
     *  __注意事项：__ dn不需要自己传入，会读取连接配置上基础DN
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Ldap.lookup(cn); //连接配置基础DN:uid=liuyang,ou=People,dc=maxcrc,dc=com
     * // => {
            "uid":"liuyang",
            "homeDirectory":"sss",
            "uidNumber":"64638",
            "displayName":"aaaa",
            "givenName":"刘",
            "sn":"洋",
            "gidNumber":"0",
            "cn":"aaaa"
        }
     * ```
     */
    static lookup(cn:any, dn?:any):any;
    /**
     * Ldap search函数
     *
     * @param {any} cn系统连接
     * @param {string} filter过滤条件
     * @param {string} searchScope搜索范围
     * @return 返回指定DN的对象或者列表的所有属性
     * ______
     *  __注意事项：__
     *  - dn不需要自己传入，会读取连接配置上基础DN
     *  - searchScope可以不传，默认值为2：0-搜索指定DN的对象本身，不搜索子对象、1-搜索指定DN下的一级子对象，不包括子对象的子对象、2-搜索指定DN下的所有子孙对象，包括子对象的子对象
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var result = Ldap.search(cn,"objectClass=Person");//基础DN：dc=maxcrc,dc=com
     * // => [ // 返回dc=maxcrc,dc=com这个域下所有的人员信息
            {
                "uid":"kevin",
                "homeDirectory":"a",
                "uidNumber":"53172",
                "givenName":"李",
                "name":"uid=kevin,ou=shenzhen,ou=GuangDong",
                "fullName":"uid=kevin,ou=shenzhen,ou=GuangDong,dc=maxcrc,dc=com",
                "gidNumber":"0",
                "sn":"红",
                "cn":"kevin"
            },
            {
                "uid":"liuyang",
                "homeDirectory":"sss",
                "uidNumber":"64638",
                "displayName":"aaaa",
                "givenName":"刘",
                "name":"uid=liuyang,ou=People",
                "fullName":"uid=liuyang,ou=People,dc=maxcrc,dc=com",
                "sn":"洋",
                "gidNumber":"0",
                "cn":"aaaa"
            },
            {
                "uid":"刘弘",
                "homeDirectory":"ad",
                "uidNumber":"54730",
                "givenName":"刘",
                "name":"uid=刘弘,ou=Sales",
                "fullName":"uid=刘弘,ou=Sales,dc=maxcrc,dc=com",
                "gidNumber":"0",
                "sn":"弘",
                "cn":"刘弘"
            }
        ]
     * ```
     */
    static search(cn:any, filter: string, searchScope?: number):any;
}
/**
 * 内置对象-Mongo
 */
declare class Mongo {
    /**
     * MongoDB批量更新函数
     *
     * @param {any} cn系统连接
     * @param {string} collectionName集合名
     * @param {any} docs待更新数据, 键$filter存放过滤条件map，键$set存放待更新数据
     * @param {boolean} 是否upsert（不存在新增，已存在更新）
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var filter = {"a":{"$eq":1}};//形如 {过滤字段:{"比较符",比较值}}，比较符为相等时也可以直接使用格式：{过滤字段:过滤值}
     * var data = {"a":1,"b":"1"};
     * var docs = [];
     * docs += {"$filter":filter,"$set":data};//待更新数据, 键$filter存放过滤条件map，键$set存放待更新数据
     * var result = Mongo.batchUpdate(cn,"test10",docs,true);
     * // => {
                "upsertedCount":0 , //upsertedCount upsert记录数
                "matchedCount":1 ,//matchedCount 找到的符合条件的记录条数
                "modifiedCount":0 //modifiedCount 更新的记录条数
        }
     * ```
     */
    static batchUpdate(cn:any, collectionName:string, docs:any, upsert: boolean): any;
    /**
     * MongoDB count函数
     *
     * @param {any} cn系统连接
     * @param {string} collectionName集合名
     * @param {any} filter过滤条件
     * @return Returns返回符合过滤条件的数据条数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var filter = {"a":{"$eq":1}};//形如 {过滤字段:{"比较符",比较值}}，比较符为相等时也可以直接使用格式：{过滤字段:过滤值}
     * var result = Mongo.count(cn,"test10",filter);
     * // => 1
     * ```
     */
    static count(cn:any, collectionName:string, filter:any): any;
    /**
     * MongoDB删除函数
     *
     * @param {any} cn系统连接
     * @param {string} collectionName集合名
     * @param {any} filter过滤条件
     * @return Returns返回删除数据条数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var filter = {"a":{"$eq":1}};//形如 {过滤字段:{"比较符",比较值}}，比较符为相等时也可以直接使用格式：{过滤字段:过滤值}
     * var result = Mongo.delete(cn,"test10",filter);
     * // => 1
     * ```
     */
    static delete(cn:any, collectionName:string, filter:any): any;
    /**
     * MongoDB插入函数
     *
     * @param {any} cn系统连接
     * @param {string} collectionName集合名
     * @param {any} data数据
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var data = [{"a":1,"b":"1"},{"a":2,"b":"2"}];
     * var result = Mongo.insert(cn,"test10",data);
     * // => [
            {
                "a":1 ,
                "b":"1",
                "_id":"63a15ceaf371ff7f9c1c93c6"
            },

            {
                "a":2 ,
                "b":"2",
                "_id":"63a15ceaf371ff7f9c1c93c7"
            }
        ]
     * ```
     */
    static insert(cn:any, collectionName:string, data:any): any;
    /**
     * MongoDB分页查询函数
     *
     * @param {any} cn系统连接
     * @param {string} collectionName集合名
     * @param {any} filter过滤条件
     * @param {any} required查询字段
     * @param {any} sort排序
     * @param {number} pageNo页号（应大于等于1）
     * @param {number} pageSize页大小
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var filter = {"id":{"$eq":"1571033834080748544"}};//形如 {过滤字段:{"比较符",比较值}}，比较符为相等时也可以直接使用格式：{过滤字段:过滤值}
     * var selector = {"number":1,"name":1};//查询字段； 空map时，返回所有字段
     * var sort = {"id":-1};//排序字段id， 1为升序，-1为降序
     * var result = Mongo.query(cn,"test10",filter,selector,sort,1,10);
     * // => [
            {
                "_id":"639187a3d5903eb38df7f2bb",
                "name":
                    {
                        "zh_CN":"yl111"
                    },
                "number":"1571033834080748544_4"
            }
        ]
     * ```
     */
    static query(cn:any, collectionName:string, filter:any, required:any, sort:any, pageNo:number, pageSize:number): any;
    /**
     * MongoDB更新函数
     *
     * @param {any} cn系统连接
     * @param {string} collectionName集合名
     * @param {any} filter过滤条件
     * @param {boolean} 是否upsert（不存在新增，已存在更新）
     * @param {any} data数据
     *
     * @return Returns不报错时返回1
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * var filter = {"a":{"$eq":1}};//形如 {过滤字段:{"比较符",比较值}}，比较符为相等时也可以直接使用格式：{过滤字段:过滤值}
     * var data = {"a":1,"b":"1"};
     * var result = Mongo.update(cn,"test10",filter,data,true);
     * // => {
                "upsertedId": null, //upsertedId 开启了upsert，如果更新的记录不存在，就会新建一条数据，返回的是新建数据的id
                "matchedCount":1 ,//matchedCount 找到的符合条件的记录条数
                "modifiedCount":0 //modifiedCount 更新的记录条数
        }
     * ```
     */
    static update(cn:any, collectionName:string, filter:any, data: any, upsert: boolean): any;
}
/**
 * 内置对象-苍穹ORM
 */
interface ORM {
    /**
     * 获取一个动态对象，返回值是：DynamicObject
     * @returns dynamicObject {Object}
     */
    static get(entity, id, selector): Object;
    /**
     * 执行动态对象操作，支持批量操作
     * @returns void
     */
    static execute(obj, operation): void;
    /**
     * 保存动态对象（不触发操作插件）
     * @returns void
     */
    static save(obj): void;
    /**
     * 读取动态对象的数据，返回值是：Map
     * @returns map {Map}
     */
    static read(entity, id, requires): Map;
}
/**
 * 内置对象-TimeUnit
 */
declare class TimeUnit {
    /**
     * 常量-年
     */
    static YEAR: string
     /**
     * 常量-半年
     */
    static HALFYEAR: string
     /**
     * 常量-季度
     */
    static QUARTER: string
     /**
     * 常量-月
     */
    static MONTH: string
     /**
     * 常量-周
     */
    static WEEK: string
     /**
     * 常量-天
     */
    static DAY: string
     /**
     * 常量-时
     */
    static HOUR: string
     /**
     * 常量-分
     */
    static MINUTE: string
     /**
     * 常量-秒
     */
    static SECOND: string
     /**
     * 常量-毫秒
     */
    static MILLISECOND: string
}
/**
 * 内置对象-TimePart
 */
declare class TimePart {
    /**
     * 常量-年
     */
    static YEAR: string
     /**
     * 常量-季度
     */
    static QUARTER: string
     /**
     * 常量-月
     */
    static MONTH: string
     /**
     * 常量月每周
     */
    static WEEK_OF_MONTH: string
     /**
     * 常量年每周
     */
    static WEEK_OF_YEAR: string
     /**
     * 常量天
     */
    static DAY: string
     /**
     * 常量周每天
     */
    static DAY_OF_WEEK: string
     /**
     * 常量年每天
     */
    static DAY_OF_YEAR: string
     /**
     * 常量-时
     */
    static HOUR: string
     /**
     * 常量-分
     */
    static MINUTE: string
     /**
     * 常量-秒
     */
    static SECOND: string
     /**
     * 常量-毫秒
     */
    static MILLISECOND: string
}

/**
 * 内置对象-聚合对象Aggregation
 */
declare class Aggregation {
    /**
     * 求得一个list内所有数值的平均值
     *
     * @param {Array} list数组
     * @return Returns 平均值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * AVG([1,2,3]) ; //2.0
     * AVG([3,5,6]) ; //4.666666666666667
     * var a = [7,9,9,7] ; AVG(a) ; //8.0
     * ```
     */
    static AVG(list): number;
    /**
     * 将list内元素转换为字符串连接，不去除重复字符串，第一个参数是需要转换的list，第二个参数是需要拼接的字符串。
     *
     * @param {Array} list数组
     * @param {string} char拼接字符
     * @return Returns 拼接字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * CONCAT([1,2,3],"-") ; //"1-2-3"
     * CONCAT([3,5,6],"i") ; //"3i5i6"
     * var a = [7,9,9,7] ; CONCAT(a,'') ; //"7997"
     * var a = [7,9,9,7] ; CONCAT(a,null) ;//"7, 9, 9, 7"
     * ```
     */
    static CONCAT(list, char: string): string;
    /**
     * 将list内元素转换为字符串连接，去除重复字符串，第一个参数是需要转换的list，第二个参数是需要拼接的字符串。
     *
     * @param {Array} list数组
     * @param {string} char拼接字符
     * @return Returns 拼接字符串
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * CONCAT2([3,5,6],"i") ; //"3i5i6"
     * var a = ["xy","yx","yy","xy","xx","yx"] ; CONCAT2(a,"-") ;//"xy-yx-yy-xx"
     * var a = [7,9,9,7] ; CONCAT2(a,'') ; //"79"
     * var a = [7,9,9,7] ; CONCAT2(a,null) ;//"7, 9"
     * ```
     */
    static CONCAT2(list, char: string): string;
    /**
     * 统计非NULL值个数。
     *
     * @param {Array} list数组
     * @return Returns 个数
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * COUNT([3,5,6]) ; // 3
     * var a = ["xy","yx","yy","xy","xx","yx"] ; COUNT(a) ;//6
     * var a = [7,9,9,7,null] ; COUNT(a) ; //4
     * var a = [7,9,9,7,""] ; COUNT(a) ;//5
     * ```
     */
    static COUNT(list): number;
    /**
     * 返回list中首个位置的值。
     *
     * @param {Array} list数组
     * @return Returns list首个值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * FIRST([3,5,6]) ; // 3
     * var a = ["xy","yx","yy","xy","xx","yx"] ; FIRST(a) ;//"xy"
     * var a = [7,9,9,7,null] ; FIRST(a) ; //7
     * var a = [null,7,9,9,7,""] ; FIRST(a) ;//null
     * var a = ["","x","y","y"] ; FIRST(a) ;//""
     * ```
     */
    static FIRST(list): any;
    /**
     * 返回list中最后位置的值。
     *
     * @param {Array} list数组
     * @return Returns list最后一个值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * LAST([3,5,6]) ; // 6
     * var a = ["xy","yx","yy","xy","xx","yx"] ; LAST(a) ;//"yx"
     * var a = [7,9,9,7,null] ; LAST(a) ; //null
     * var a = [null,7,9,9,7,""] ; LAST(a) ;//""
     * var a = ["","x","y","y"] ; LAST(a) ;//"y"
     * ```
     */
    static LAST(list): any;
    /**
     * 返回list中最大元素值。
     *
     * @param {Array} list数组
     * @return Returns 最大值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * MAX([3,5,6]) ; // 6
     * var a = ["xy","yx","yy","xy","xx","yx"] ; MAX(a) ;//"yy"
     * var a = [7,9,9,7,null] ; MAX(a) ; //9
     * var a = [null,7,9,9,7,""] ;MAX(a) ;//9
     * var a = ["","x","y","y"] ; MAX(a) ;//"y"
     * ```
     */
    static MAX(list): any;
    /**
     * 返回list中间值。
     *
     * @param {Array} list数组
     * @return Returns 中间值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * MID([3,5,6]) ; // 5
     * var a = ["xy","yx","yy","xy","xx","yx"] ; MID(a) ;//"xy"
     * var a = [7,9,9,7,null] ; MID(a) ; //8.0
     * var a = [null,7,9,9,7] ;MID(a) ;//8.0
     * var a = ["","x","y","y"] ; MID(a) ;//"x"
     * var a = [1,2,3,4,5,6,7] ; MID(a);//4
     * ```
     */
    static MID(list): any;
    /**
     * 返回list中最小元素值。
     *
     * @param {Array} list数组
     * @return Returns 最小值
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * MIN([3,5,6]) ; // 3
     * var a = ["xy","yx","yy","xy","xx","yx"] ; MIN(a) ;//"xx"
     * var a = [7,9,9,7,null] ; MIN(a) ; //7
     * var a = [null,7,9,9,7,""] ;MIN(a) ;//7
     * var a = ["","x","y","y"] ; MIN(a) ;//"x"
     * ```
     */
    static MIN(list): any;
    /**
     * 返回list中元素值得标准偏差。
     *
     * @param {Array} list数组
     * @return Returns 标准偏差
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * STDEV([3,3,3]) ; // 0.0
     * var a = [7,9,9,7,null] ; STDEV(a) ; //1.1547005383792515
     * var a = [1,2,3,4,5,6,7] ; STDEV(a) ; //2.160246899469287
     * ```
     */
    static STDEV(list): number;
    /**
     * 返回列表中所有元素的和。
     *
     * @param {Array} list数组
     * @return Returns 计算和SUM
     * ______
     * __适用场景：__ 所有脚本场景
     * ______
     * @example w
     * ```js
     * SUM([3,5,6]) ; // 14
     * var a = [7,9,9,7,null] ; SUM(a) ; //32
     * var a = [null,7,9,9,7] ;SUM(a) ;//32
     * var a = [1,2,3,4,5,6,7] ; SUM(a);//28
     * ```
     */
    static SUM(list): number;
}


/**
 * 内置对象-开发平台OpenAPI
 */
interface OpenAPI {
    /**
     * 调用开放平台查询OpenApi
     * @param {string} apiUrl开放平台API2.0服务URL
     * @param {object} data请求体
     * @param {number} pageSize当前页显示条数
     * @param {number} pageNo页码
     * @return Returns开放平台对应服务访问结果.
     * ______
     * __注意事项:__ 仅支持开放平台注册的2.0版本查询服务API，如apiUrl开头为：/v2/..
     * ______
     * __适用场景:__ 服务流程_脚本节点、自定义API、数据集成_目标数据处理脚本
     * ______
     * @example w
     * ```js
     * var apiUrl = "/v2/iscb/isc_data_source/get_data_source";
     * OpenAPI.queryData(apiUrl, {"number": "UNIT-TEST-THIS-SYSTEM-1"}, 10, 1);
     * // => { data: {...}, errorCode: 'OK', message: '', status, true }
     * ```
     */
    static queryData(apiUrl: string, data: object, pageSize: number, pageNo: number): any;
    /**
     * 调用开放平台OpenApi
     * @param {string} apiUrl开放平台API2.0服务URL
     * @param {object} data请求体
     * @param {object} header请求头
     * @return Returns开放平台对应服务访问结果.
     * ______
     * __注意事项:__ 仅支持开放平台注册的2.0版本API，如apiUrl开头为：/v2/...，如果url中需拼接相应参数，可在url后拼接?key=value，多参数用"&"分隔，如：/v2/iscb/route/xxx?caller=admin
     * ______
     * __适用场景:__ 服务流程_脚本节点、自定义API、数据集成_目标数据处理脚本
     * ______
     * @example w
     * ```js
     * var apiUrl = "/v2/iscb/route/script_test";
     * var params = { "A": 10, "B": 5 };
     * OpenAPI.invokeOperation(apiUrl, params);
     * // =>  { data: {...}, errorCode: 'OK', message: '', status, true }
     * ```
     */
    static invokeOperation(apiUrl: string, data: object, header?: object): any;
}

/**
 * 内置对象-数据迁移DataFile
 */
interface DataFile {
    /**
     * 将文件字节数组与数据导入执行结果绑定
     *
     * @param {string} jobId数据导入执行结果的ID
     * @param {any} bytes文件的字节数组
     * @param {string} fileName文件名，不包含文件扩展名，非必填
     * @return Returns文件大小size，单位：字节
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * var jobId = DataFile.createJob(IMPORT_SOURCE);
     * var bytes = Ftp.getBytes(cn,"/data","test.json");
     * DataFile.attach(jobId,bytes,"自定义文件名");
     * ```
     */
    static attach(jobId: string,bytes: any, fileName: string):any;
    /**
     * 创建数据导入结果
     *
     * @param {any} IMPORT_SOURCE数据导入任务资源
     * @param {string} jobName数据导入执行结果名称，非必填
     * @return Returns数据导入执行结果的ID,可以使用DataFile.getState(source,jobId)函数获取执行状态
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * var jobId = DataFile.createJob(IMPORT_SOURCE);
     * DataFile.attach(jobId,bytes);
     * DataFile.start(jobId，"自定义结果名称");
     * // => jobId 的内容为 1245626457154171904
     * ```
     */
    static createJob(IMPORT_SOURCE:any, jobName:string): string
    /**
     * 根据文件URL获取字节数组
     *
     * @param {any} fileUrl苍穹文件服务器上的文件URL，由ExportFileTriggerResource函数执行获取文件URL
     * @return Returns文件字节数组bytes
     * ______
     * __注意事项：__
     *  - 此方法默认最大只能获取5M的文件，在内存满足且不会出现OOM的情况下，用户可以联系系统管理员修改JVM系统参数ISC_MAX_FILE_SIZE的值（单位：字节），来调整最大限制
     *  - 用户在使用此函数获取字节数组时，建议在一个脚本节点或者一个循环内处理一个文件，请勿将字节数组赋值给流程变量。
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * var fileUrls = EXPORT_FN(params);//EXPORT_FN为数据导出任务资源的别名
     * for(var fileUrl : fileUrls){
     *  var bytes = DataFile.getBytes(fileUrl);
     *  //do others
     * }
     * ```
     */
    static getBytes(fileUrl:any):any;
     /**
     * 获取数据迁移执行结果的状态
     *
     * @param {any} resource数据导入任务或者数据导出任务的别名
     * @param {string}} jobId执行结果的ID
     * @return Returns执行结果的状态，有如下几种执行状态 C(创建)、R(执行中)、S(完成)、F(失败)、X(已撤销)、P(部分成功),其中 S,F,X,P 状态代表任务已经结束。
     * ______
     * __使用建议：__ DataFile.getState会进行查库操作，不建议直接在循环中不间断的调用，可以配合Sleep()函数或者时间等待节点隔段时间查询
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * var files = ["2021-09-13_0.xlsx"];
     * for(var file : files){
            //创建数据导入执行结果
            var jobId = DataFile.createJob(IMPORT_FN);
            //从FTP服务器获取文件的字节数组
            var bytes = Ftp.getBytes(cn,"/demo",file);
            //将字节数组上传到数据导入执行结果
            DataFile.attach(jobId,bytes);
            //执行数据导入结果
            DataFile.start(jobId);
            while("C" == DataFile.getState(IMPORT_FN,jobId) || "R" == DataFile.getState(IMPORT_FN,jobId)){
                Sleep(100);
                count++;
            }
        }
     * ```
     */
    static getState(resource: any, jobId: string):any;
    /**
     * 异步启动数据导入执行结果
     *
     * @param {string} jobId : 数据导入执行结果的ID,需要明确此结果已经上传可文件，即调用了DataFile.attach()
     * @return Returns此Id为后台任务的Id,与jobId不同。
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * //创建数据导入执行结果
     *  var jobId = DataFile.createJob(IMPORT_SOURCE);
     *  //从FTP服务器获取文件的字节数组
     *  var bytes = Ftp.getBytes(cn,"/data","test.json");
     *  //将字节数组上传到数据导入执行结果
     *  DataFile.attach(jobId,bytes);
     *  //执行数据导入结果
     *  DataFile.start(jobId);
     * ```
     */
    static start(jobId: string):any;
     /**
     * 上传字节数组到文件服务器并绑定到相关单据，重复上传相同内容不会覆盖原有文件
     *
     * @param {object} options控制单据的可选操作项
     * @return Returns绑定成功返回文件的url, 执行失败会抛出错误（比如单据不存在，文件内容为空等）
     * ______
     * __参数说明：__
     * 入参options内容如下：
     * - entityName：单据标识 不可为空
     * - entityPk：单据id 不可为空
     * - field：字段标识，指定上传的附件面板或者附件字段的标识 不可为空
     * - content：文件内容，byte数组，不可为空
     * - appId：应用id，不可为空
     * - formId：表单id,一般和entityName保持一致，不可为空
     * ______
     * __结果说明：__
     * - url：文件的url
     * - id：如果上传的是附件面板，id为附件面板实体bos_attachment的id。上传的是附件字段，则是附件字段实体bd_attachment的id
     * - uid：如果上传的是附件面板，uid为附件面板实体bos_attachment的编码number。上传的是附件字段，则是附件字段实体bd_attachment的附件uid
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * var content=  String.getBytes2("1234", 'utf-8');
        var fileName= "1.txt";
        var map={
        "entityName":"isc_demo_basedata_1",
        "entityPk":1817352476500716544,
        "field":"attachmentpanelap",
        "fileName":fileName,
        "content":content,
        "appId":"iscb",
        "formId":"isc_demo_basedata_1"
        };
        var res = DataFile.uploadAndBind(map);
     * // => {
            "uid":"rc-upload-1700042156490-48",
            "url":"/tenant_devother_dev/1150102438640877568/202311/iscb/isc_demo_basedata_1/1817352476500716544/attachments/1_1700042156455.txt",
            "id":"1819003848937754624"
        }
     * ```
     */
    static uploadAndBind(options: any):any;
    /**
     * 上传字节数组到文件服务器并绑定到相关单据，重复上传相同内容不会覆盖原有文件
     *
     * @param {object} options控制单据的可选操作项
     * @return Returns绑定成功返回文件的url, 执行失败会抛出错误（比如单据不存在，文件内容为空等）
     * ______
     * __参数说明：__
     * 入参options内容如下：
     * - entityName：单据标识 不可为空
     * - entityPk：单据id 不可为空
     * - entryName：单据分录的标识 必填
     * - entryPk：单据分录的主键 必填
     * - entryField：分录上附件字段标识 必填
     * - filename：文件名，需带后缀，不可为空 必填
     * - content：文件内容，byte数组，不可为空
     * - appId：应用id，不可为空
     * - formId：表单id,一般和entityName保持一致，不可为空
     * ______
     * __结果说明：__
     * - url：文件的url
     * - id：如果上传的是附件面板，id为附件面板实体bos_attachment的id。上传的是附件字段，则是附件字段实体bd_attachment的id
     * - uid：如果上传的是附件面板，uid为附件面板实体bos_attachment的编码number。上传的是附件字段，则是附件字段实体bd_attachment的附件uid
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     * var content=  String.getBytes2("1234", 'utf-8');
        var fileName= "1.txt";
        var map={
        "entityName":"isc_demo_basedata_1",
        "entityPk":1817352476500716544,
        "entryName":"entryentity",
        "entryPk":1817353015309396992,
        "entryField":"attachmentfield1",
        "fileName":fileName,
        "content":content,
        "appId":"iscb",
        "formId":"isc_demo_basedata_1"
        };
        var res = DataFile.uploadAndBindFile3(map);
     * // => {
           "uid":"rc-upload-1700040729078-38",
            "url":"/tenant_devother_dev/1150102438640877568/202311/iscb/isc_demo_basedata_1/1817352476500716544/attachments/1.txt",
            "id":"1818991875047085056"
        }
     * ```
     */
    static uploadAndBindFile3(options: any):any;
     /**
     * 上传文件到苍穹文件服务器，重复上传会返回新的url
     *
     * @param {object} options控制单据的可选操作项
     * @return Returns绑定成功返回文件的url, 执行失败会抛出错误（比如单据不存在，文件内容为空等）
     * ______
     * __参数说明：__
     * 入参options内容如下：
     * - fileName：文件名，需带后缀，不可为空
     * - content：文件内容，byte数组类型，不可为空
     * - appId：应用id，不可为空
     * - formId：表单id,一般和entityName保持一致，不可为空
     * - pkId：可为空，为空的情况随机生成
     * - __appid formid 会组成文件的路径，包含在url上__
     * ______
     * __结果说明：__ 执行成功，返回结果为url，失败会抛出错误
     * - url：文件的url
     * ______
     * __适用场景：__ 服务流程_脚本节点
     * ______
     * @example w
     * ```js
     *  var content=  String.getBytes2("1234", 'utf-8');
        var fileName= "1.txt";
        var map={
        "fileName":fileName,
        "content":content,
        "appId":"iscb",
        "formId":"isc_demo_basedata_1",

        };
        var map =DataFile.uploadFile2(map);
     * // => /tenant_devother_dev/1150102438640877568/202311/iscb/isc_demo_basedata_1/1819007023371571200/attachments/1.txt
     * ```
     */
    static uploadFile2(options):any;
}
/**
 * 文件操作函数对象-AttachFieldServiceToolkit
 */
declare class AttachFieldServiceToolkit {
    /**
     * 通过单据实体标识，单据的id删除某单据上所有附件面板的文件
     * @param {string} entityNumber单据的实体标识
     * @param {string} pkId单据的id
     * @return Returns返回值为null，异常时抛出异常信息
     * ______
     * __注意事项:__ 此脚本函数只对入参做了类型转换或检查，直接调用kd.bos.servicehelper.AttachmentServiceHelper的remove(String formId,Object pkId)
     * ______
     * __适用场景:__ 服务流程_脚本节点、数据集成_目标数据处理脚本、数据集成_来源数据处理脚本、数据集成_转换脚本、自定义API
     * ______
     * @example w
     * ```js
     *  AttachPanelServiceToolkit.removeAllByBillId("isc_demo_basedata_1", 1575213064674881536);
     * ```
     */
    static removeAllByBillId(entityNumber: string, pkId: string): any;
    /**
     * 通过单据实体标识，单据的id，附件面板实体的编码 删除附件面板的单个文件
     * @param {string} entityNumber单据的实体标识
     * @param {string} pkId单据的id
     * @param {string} fileUid:附件面板的编码
     * @return Returns返回值为null，异常时抛出异常信息
     * ______
     * __注意事项:__ 此脚本函数只对入参做了类型转换或检查，直接调用kd.bos.servicehelper.AttachmentServiceHelper的remove(String formId, Object pkId, Object fileUid)
     * ______
     * __适用场景:__ 服务流程_脚本节点、数据集成_目标数据处理脚本、数据集成_来源数据处理脚本、数据集成_转换脚本、自定义API
     * ______
     * @example w
     * ```js
     *  AttachPanelServiceToolkit.removeByAttachNumber("isc_demo_basedata_1", 1575213064674881536,"rc-upload-1670978268054-6" );
     * ```
     */
    static removeByAttachNumber(entityNumber: string, pkId: string, fileUid: string): any;
    /**
     * 通过单据实体标识，元数据上附件字段对应得表名，附件字段bd_attachment的fid批量删除附件字段的文件
     * @param {string} entityNumber单据的实体标识
     * @param {string} tableName附件字段对应得表名
     * @param {any} pks附件字段实体bd_attachment的fid集合
     * @return Returns返回值为null，异常时抛出异常信息
     * ______
     * __注意事项:__ 此脚本函数只对入参做了类型转换或检查，直接调用kd.bos.servicehelper.AttachmentServiceHelper的removeAttachmentsByAttPkIds(String entityNum, String tableName, Object[] attPkIds)
     * ______
     * __适用场景:__ 服务流程_脚本节点、数据集成_目标数据处理脚本、数据集成_来源数据处理脚本、数据集成_转换脚本、自定义API
     * ______
     * @example w
     * ```js
     * var ids=[1575213749571170306,1575213749571170305]
     * AttachFieldServiceToolkit.removeByAttachPkId("isc_demo_basedata_1", "t_isc_demo1_file",ids );
     * ```
     */
    static removeByAttachPkId(entityNumber: string, tableName: string, pks: any): any;
    /**
     * 调用开放平台OpenApi
     * @param {string} entityNumber单据的实体标识
     * @param {string} tableName附件字段对应得表名
     * @param {any} attachments：附件字段信息（目前接口是只依赖uid进行删除的，后续若有改动可以增加相应字段）
     * @return Returns返回值为null，异常时抛出异常信息
     * @see 详情查询 https://developer.kingdee.com/school/detail/3470?pathId=262271880000806144&topicId=262262914743115008&productLineId=29&isKnowledge=2&lang=zh-CN
     * ______
     * __注意事项:__ 此脚本函数只对入参做了类型转换或检查，直接调用kd.bos.servicehelper.AttachmentServiceHelper的removeAttachments(String formId, String tableName, Map<String, Object> attachments)
     * ______
     * __适用场景:__ 服务流程_脚本节点、数据集成_目标数据处理脚本、数据集成_来源数据处理脚本、数据集成_转换脚本、自定义API
     * ______
     * @example w
     * ```js
     * var attachments={ "uid":"rc-upload-1670978268054-9" };//若removeAttachments方法attachments需要更多参数，可以增加相应字段
     * AttachFieldServiceToolkit.removeByAttachUid("isc_demo_basedata_1", "t_isc_demo1_file",attachments );
     * ```
     */
    static removeByAttachUid(entityNumber: string, tableName: string, attachments: any): any;
}

// 场景API库
// declare var OpenAPI: OpenAPI;
// declare var DataFile: DataFile;
// declare var ORM: ORM;
