/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProExtraPriceImportOpPlugin
extends BatchImportPlugin {
    private static final String NUMBER = "number";
    private Log logger = LogFactory.getLog(ProExtraPriceImportOpPlugin.class);
    private DynamicObject org;
    private DynamicObject material;

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger impLogger) {
        Throwable throwable = null;
        try {
            this.cacheBaseData();
        }
        catch (Throwable e) {
            throwable = e;
            throw e;
        }
        throwable = null;
        try {
            this.beforeImportBill(rowdatas, impLogger);
        }
        catch (Throwable var27) {
            throwable = var27;
            throw var27;
        }
        return rowdatas != null && !rowdatas.isEmpty() ? super.save(rowdatas, impLogger) : null;
    }

    private void cacheBaseData() {
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger impLogger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRowData(impLogger, iterator);
        }
    }

    protected void handleRowData(ImportLogger impLogger, Iterator<ImportBillData> iterator) {
        ImportBillData rowdata = iterator.next();
        int index = rowdata.getStartIndex();
        JSONObject data = rowdata.getData();
        try {
            Object matObj;
            Map orgMap = (Map)data.get((Object)"org");
            String orgNumber = orgMap.get(NUMBER).toString();
            if (!this.checkOrg(index, orgNumber, impLogger)) {
                return;
            }
            Map costAccountMap = (Map)data.get((Object)"costaccount");
            String costAccountNum = costAccountMap.get(NUMBER).toString();
            if (!this.checkCostAccount(index, costAccountNum, impLogger, data)) {
                return;
            }
            Map materialMap = (Map)data.get((Object)"material");
            String materialNum = materialMap.get(NUMBER).toString();
            if (!this.checkMaterial(index, materialNum, impLogger)) {
                return;
            }
            Boolean enableVersion = this.material.getBoolean("isenablematerialversion");
            if (enableVersion != null && enableVersion.booleanValue() && (matObj = data.get((Object)"matversion")) == null) {
                impLogger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5f00\u542f\u4e86\u7269\u6599\u7248\u672c\uff0c\u8bf7\u5f55\u5165\u7269\u6599\u7248\u672c\u3002", (String)"ProExtraPriceImportOpPlugin_18", (String)"macc-aca-opplugin", (Object[])new Object[0]), materialNum));
                return;
            }
            Boolean isUseAuxpty = this.material.getBoolean("isuseauxpty");
            if (isUseAuxpty != null && isUseAuxpty.booleanValue()) {
                Object auxpty;
                Boolean isaffectprice = false;
                DynamicObjectCollection auxptyentry = this.material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject aux : auxptyentry) {
                    if (!aux.getBoolean("isaffectprice")) continue;
                    isaffectprice = true;
                    break;
                }
                if (isaffectprice.booleanValue() && (auxpty = data.get((Object)"auxpty")) == null) {
                    impLogger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5f00\u542f\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u5f55\u5165\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ProExtraPriceImportOpPlugin_19", (String)"macc-aca-opplugin", (Object[])new Object[0]), materialNum));
                }
            }
            List parseArray = JSON.parseArray((String)data.get((Object)"entryentity").toString(), HashMap.class);
            ArrayList<String> subElementNums = new ArrayList<String>(parseArray.size());
            int pricePrecision = (Integer)data.get((Object)"priceprecision");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (Map row : parseArray) {
                JSONObject subElement = (JSONObject)row.get("subelement");
                String subElementNum = subElement.get((Object)NUMBER).toString();
                if (subElementNums.contains(subElementNum)) {
                    impLogger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u540c\u4e00\u7269\u6599\u4e0d\u5141\u8bb8\u5f55\u5165\u591a\u4e2a\u76f8\u540c\u5b50\u8981\u7d20\u3002", (String)"ProExtraPriceImportOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    return;
                }
                subElementNums.add(subElementNum);
                this.setElement(subElementNum, row);
                BigDecimal price = new BigDecimal(row.get("price").toString()).setScale(pricePrecision, RoundingMode.DOWN);
                row.put("price", price);
                totalPrice = totalPrice.add(price).setScale(pricePrecision, RoundingMode.DOWN);
            }
            data.put("entryentity", (Object)parseArray);
            amount = totalPrice.setScale(pricePrecision, RoundingMode.DOWN);
            data.put("amount", (Object)amount);
            data.put("datasrc", (Object)"import");
        }
        catch (Exception e) {
            impLogger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"ProExtraPriceImportOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            this.logger.error(e.getMessage());
            return;
        }
    }

    public void setElement(String subElementNum, Map<String, Object> row) {
        DynamicObject subElementObj = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_subelement", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)subElementNum)});
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementObj.getLong("id"));
        DynamicObject dySubElement = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            JSONObject element = new JSONObject();
            element.put("id", dySubElement.getDynamicObject("element").getPkValue());
            row.put("element", element);
        }
    }

    private boolean checkMaterial(int index, String materialNum, ImportLogger logger) {
        DynamicObject material;
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)materialNum);
        String selectedFields = "isenablematerialversion,isuseauxpty,auxptyentry.isaffectprice";
        this.material = material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
        if (material == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7269\u6599\u201c%s\u201d\u5bf9\u5e94\u7684\u7269\u6599\u3002", (String)"ProExtraPriceImportOpPlugin_20", (String)"macc-aca-opplugin", (Object[])new Object[0]), materialNum));
            return false;
        }
        return true;
    }

    private boolean checkCostAccount(int index, String costAccountNum, ImportLogger logger, JSONObject data) {
        Long count;
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy.currency", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)costAccountNum)});
        Long costAccountId = costAccount.getLong("id");
        DynamicObjectCollection costAccountCollection = AcaCostAccountHelper.getCostAccountCollection((String)String.valueOf(this.org.getLong("id")));
        if (costAccountCollection == null || costAccountCollection.size() == 0) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ProExtraPriceImportOpPlugin_21", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0]), this.org.getString(NUMBER));
        }
        if (costAccountCollection != null && !(count = Long.valueOf(costAccountCollection.stream().filter(dynamicObject -> costAccountId.equals(dynamicObject.getLong("id"))).count())).equals(1L)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"ProExtraPriceImportOpPlugin_22", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER), costAccountNum));
            return false;
        }
        JSONObject currencyJson = new JSONObject();
        currencyJson.put("id", (Object)costAccount.getLong("calpolicy.currency.id"));
        data.put("currency", (Object)currencyJson);
        DynamicObject currency = this.getCurrency(costAccountId);
        if (currency != null) {
            int amtprecision = currency.getInt("amtprecision");
            int priceprecision = currency.getInt("priceprecision");
            data.put("amtprecision", (Object)amtprecision);
            data.put("priceprecision", (Object)priceprecision);
        }
        return true;
    }

    private DynamicObject getCurrency(Long costAccountId) {
        if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
            return null;
        }
        String selectedFields = "calpolicy.currency";
        QFilter costAccountNumberFilter = new QFilter("id", "=", (Object)costAccountId);
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)selectedFields, (QFilter[])new QFilter[]{costAccountNumberFilter});
        return costAccount.getDynamicObject("calpolicy.currency");
    }

    private boolean checkOrg(int index, String orgNumber, ImportLogger logger) {
        DynamicObject org;
        this.org = org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,fisaccounting", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)orgNumber)});
        Long orgId = org.getLong("id");
        List acctOrgs = OrgHelper.getHasPermAccountOrgIds((String)"aca_proextraprice", (String)"aca");
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"ProExtraPriceImportOpPlugin_5", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!acctOrgs.contains(orgId)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"ProExtraPriceImportOpPlugin_23", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        return true;
    }
}

