/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.opplugin.basedata.ProductExtraPriceDelValidator;
import kd.macc.cad.common.utils.DateUtils;

public class ProductExtraPriceDelPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProductExtraPriceDelValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List pks = Arrays.stream(dataEntities).map(entity -> entity.getLong("id")).collect(Collectors.toList());
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"aca_proextraprice", (String)"org,costaccount,material,startperiod,endperiod,enddate,matversion,auxpty", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        for (int i = 0; i < collection.length; ++i) {
            boolean isUseAuxpty;
            DynamicObject matVersion;
            DynamicObject dynamicObject = collection[i];
            Long startPeriodId = dynamicObject.getDynamicObject("startperiod").getLong("id");
            Long endPeriodId = null;
            if (dynamicObject.getDynamicObject("endperiod") != null) {
                endPeriodId = dynamicObject.getDynamicObject("endperiod").getLong("id");
            }
            DynamicObject material = dynamicObject.getDynamicObject("material");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            Long orgId = dynamicObject.getDynamicObject("org").getLong("id");
            qFilters.add(new QFilter("org.id", "=", (Object)orgId));
            Long costAccountId = dynamicObject.getDynamicObject("costaccount").getLong("id");
            qFilters.add(new QFilter("costaccount.id", "=", (Object)costAccountId));
            Long materialId = material.getLong("id");
            qFilters.add(new QFilter("material.id", "=", (Object)materialId));
            boolean enableVersion = material.getBoolean("isenablematerialversion");
            if (enableVersion && (matVersion = dynamicObject.getDynamicObject("matversion")) != null) {
                Long matVersionId = matVersion.getLong("id");
                qFilters.add(new QFilter("matversion.id", "=", (Object)matVersionId));
            }
            if (isUseAuxpty = material.getBoolean("isuseauxpty")) {
                Boolean isaffectprice = false;
                DynamicObjectCollection auxptyentry = material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject aux : auxptyentry) {
                    if (!aux.getBoolean("isaffectprice")) continue;
                    isaffectprice = true;
                    break;
                }
                if (isaffectprice.booleanValue()) {
                    DynamicObject auxpty = dynamicObject.getDynamicObject("auxpty");
                    Long auxptyId = auxpty.getLong("id");
                    qFilters.add(new QFilter("auxpty.id", "=", (Object)auxptyId));
                }
            }
            QFilter qfStartPeriod = new QFilter("endperiod".concat(".id"), "=", (Object)startPeriodId);
            qFilters.add(qfStartPeriod);
            DynamicObject previous = BusinessDataServiceHelper.loadSingle((String)"aca_proextraprice", (String)"id,endperiod,enddate,modifytime,modifier", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty((Long)endPeriodId)) {
                qFilters.remove(qfStartPeriod);
                QFilter qfEndPeriod = new QFilter("startperiod".concat(".id"), "=", (Object)endPeriodId);
                qFilters.add(qfEndPeriod);
                DynamicObject next = BusinessDataServiceHelper.loadSingle((String)"aca_proextraprice", (String)"id,endperiod,enddate,modifytime,modifier", (QFilter[])qFilters.toArray(new QFilter[0]));
                if (next == null || previous == null) continue;
                Date endDate = dynamicObject.getDate("enddate");
                this.updatePrevious(previous, endPeriodId, endDate);
                continue;
            }
            if (previous == null) continue;
            this.updatePrevious(previous);
        }
    }

    private void updatePrevious(DynamicObject previous, Long endPeriodId, Date endDate) {
        previous.set("endperiod", (Object)endPeriodId);
        previous.set("enddate", (Object)endDate);
        previous.set("modifytime", (Object)new Date());
        previous.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        SaveServiceHelper.update((DynamicObject)previous);
    }

    private void updatePrevious(DynamicObject previous) {
        previous.set("endperiod", null);
        previous.set("enddate", (Object)DateUtils.getMaxDate());
        previous.set("modifytime", (Object)new Date());
        previous.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        SaveServiceHelper.update((DynamicObject)previous);
    }
}

