/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.basedata;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ProductExtraPriceOpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            this.validateSave(dataEntity);
        }
    }

    private void validateSave(ExtendedDataEntity dataEntity) {
        DynamicObject material;
        DynamicObject costAccount;
        DynamicObject item = dataEntity.getDataEntity();
        DynamicObject org = item.getDynamicObject("org");
        if (org == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProductExtraPriceOpValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
        if ((costAccount = item.getDynamicObject("costaccount")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProductExtraPriceOpValidator_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
        if ((material = item.getDynamicObject("material")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801", (String)"ProductExtraPriceOpValidator_14", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject auxptyObj;
            boolean isUseAuxpty = material.getBoolean("isuseauxpty");
            boolean isaffectprice = false;
            if (isUseAuxpty) {
                DynamicObjectCollection auxptyentry = material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject aux : auxptyentry) {
                    if (!aux.getBoolean("isaffectprice")) continue;
                    isaffectprice = true;
                    break;
                }
            }
            if (isaffectprice && (auxptyObj = item.getDynamicObject("auxpty")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ProductExtraPriceOpValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection entryTable = item.getDynamicObjectCollection("entryentity");
        if (entryTable == null || entryTable.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6700\u5c11\u5f55\u5165\u4e00\u6761\u5206\u5f55\u4fe1\u606f\u3002", (String)"ProductExtraPriceOpValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            String amountStr;
            String[] amountInfos;
            BigDecimal total = BigDecimal.ZERO;
            for (int i = 0; i < entryTable.size(); ++i) {
                BigDecimal price;
                DynamicObject row = (DynamicObject)entryTable.get(i);
                DynamicObject subElement = row.getDynamicObject("subelement");
                if (subElement == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5206\u5f55\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"ProductExtraPriceOpValidator_12", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                }
                if ((price = row.getBigDecimal("price")).compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u5b9a\u989d\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ProductExtraPriceOpValidator_13", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                    continue;
                }
                total = total.add(price);
            }
            BigDecimal amount = item.getBigDecimal("amount");
            if (total.compareTo(amount) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9a\u989d\u6210\u672c\u8ba1\u7b97\u9519\u8bef\u3002", (String)"ProductExtraPriceOpValidator_8", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
            if ((amountInfos = (amountStr = amount.toString()).split("\\.")).length > 0 && amountInfos[0].length() > 13) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5b9a\u989d\u6210\u672c\u201d\u5df2\u8d85\u8fc7\u53ef\u5b58\u50a8\u7684\u6570\u636e\u8303\u56f4\uff0c\u8bf7\u8c03\u6574\u5b50\u8981\u7d20\u5355\u4ef7\u4fe1\u606f\u3002", (String)"ProductExtraPriceOpValidator_9", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

