/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.cal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;

public class FinishCostTranFerDeleteVoucherValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap sourceIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap<Long, Long> costaccountPeriodMap = new HashMap<Long, Long>(10);
        long orgId = 0L;
        long costaccountId = 0L;
        long periodId = 0L;
        for (ExtendedDataEntity data : datas) {
            DynamicObject dyn;
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            String billno = dataEntity.getString("billno");
            DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
            DynamicObject period = dataEntity.getDynamicObject("period");
            if (period == null || costaccount == null || org == null) continue;
            costaccountId = costaccount.getLong("id");
            orgId = org.getLong("id");
            Long curPeriodId = (Long)costaccountPeriodMap.get(costaccount.getLong("id"));
            if (curPeriodId == null && (dyn = PeriodHelper.getCurrentPeriod((Long)costaccountId)) != null) {
                curPeriodId = dyn.getLong("id");
                costaccountPeriodMap.put(costaccountId, curPeriodId);
            }
            if (curPeriodId != null && curPeriodId.compareTo((Long)period.getPkValue()) != 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u975e\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u5220\u9664\u51ed\u8bc1\u3002", (String)"FinishCostTranFerDeleteVoucherValidator_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            periodId = period.getLong("id");
            String sourcevoucher = dataEntity.getString("sourcevoucher");
            if (sourcevoucher != null && ("true".equals(sourcevoucher) || "1".equals(sourcevoucher))) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u5220\u9664\u5931\u8d25\uff0c\u5355\u636e%s\u5df2\u5728\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinishCostTranFerDeleteVoucherValidator_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            if (!dataEntity.getBoolean("creatvoucher")) continue;
            sourceIdMap.computeIfAbsent(dataEntity.getLong("sourcebill"), t -> new ArrayList()).add(dataEntity.getLong("id"));
        }
        if (!sourceIdMap.isEmpty()) {
            HashSet errorIds = Sets.newHashSetWithExpectedSize((int)10);
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("costaccount", "=", (Object)costaccountId);
            filter.and("period", "=", (Object)periodId);
            filter.and("creatvoucher", "=", (Object)Boolean.TRUE);
            filter.and("sourcebill", "in", sourceIdMap.keySet());
            DataSet resultDs = QueryServiceHelper.queryDataSet((String)"FINISHCOSTTRANFER", (String)"aca_finishcosttranfer", (String)"id,sourcebill", (QFilter[])filter.toArray(), null);
            resultDs = resultDs.groupBy(new String[]{"sourcebill"}).count().finish();
            for (Row row : resultDs) {
                Long sourceBillid = row.getLong("sourcebill");
                int count = row.getInteger("count");
                List ids = (List)sourceIdMap.get(sourceBillid);
                if (ids == null || ids.size() >= count) continue;
                errorIds.addAll(ids);
            }
            datas = this.dataEntities;
            if (!errorIds.isEmpty()) {
                for (ExtendedDataEntity data : datas) {
                    DynamicObject dataEntity = data.getDataEntity();
                    Long id = dataEntity.getLong("id");
                    if (!errorIds.contains(id)) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u5b8c\u5de5\u5165\u5e93\u5355\u5bf9\u5e94\u591a\u4e2a\u5b8c\u5de5\u7ed3\u8f6c\u5355\u751f\u6210\u4e86\u51ed\u8bc1\uff0c\u9700\u8981\u540c\u65f6\u9009\u4e2d\u8fdb\u884c\u5220\u9664\u3002", (String)"FinishCostTranFerDeleteVoucherValidator_3", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

