/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.feealloc;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.aca.opplugin.feealloc.MatAllocateOpValidator;

public class MatAllocateOpPlugin
extends AbstractOperationServicePlugIn {
    private Log logger = LogFactory.getLog(MatAllocateOpPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MatAllocateOpValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("costcenter");
        fieldKeys.add("costaccount");
        fieldKeys.add("manuorg");
        fieldKeys.add("period");
        fieldKeys.add("alloctype");
        fieldKeys.add("costobject");
        fieldKeys.add("usetype");
        fieldKeys.add("allocstatus");
        fieldKeys.add("useamount");
        fieldKeys.add("useqty");
        fieldKeys.add("entryentity");
        fieldKeys.add("amount");
        fieldKeys.add("qty");
        fieldKeys.add("price");
        fieldKeys.add("costdriver");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditdate");
        fieldKeys.add("appnum");
        fieldKeys.add("material");
        fieldKeys.add("vouchernum");
        fieldKeys.add("srcbilltype");
        fieldKeys.add("entryentity.costobejctentry");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("entryentity.elemententry");
        fieldKeys.add("entryentity.subelemententry");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("isreturnitem");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(16);
        for (DynamicObject dyn : e.getDataEntities()) {
            if (!"eca".equals(dyn.getString("appnum"))) continue;
            selectedRows.add(new ListSelectedRow(dyn.getPkValue()));
        }
        this.logger.info("\u670d\u52a1\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355\uff1a{}", (Object)selectedRows.size());
        if (selectedRows.isEmpty()) {
            return;
        }
        switch (e.getOperationKey()) {
            case "op_confirm": {
                this.pushCarryBill(selectedRows);
                break;
            }
            case "op_unconfirm": {
                this.delCarryBill(selectedRows);
                break;
            }
        }
    }

    private void delCarryBill(List<ListSelectedRow> selectedRows) {
        ArrayList ids = new ArrayList(16);
        selectedRows.forEach(p -> ids.add(p.getPrimaryKeyValue()));
        QFilter[] filters = new QFilter[]{new QFilter("srcbillid", "in", ids), new QFilter("billtype", "=", (Object)"aca_matalloc"), new QFilter("vouchernum", "=", (Object)" ")};
        DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])filters);
    }

    private void pushCarryBill(List<ListSelectedRow> selectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("aca_matalloc");
        pushArgs.setTargetEntityNumber("eca_costcarrybill");
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        try (TXHandle h = TX.required();){
            try {
                ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                if (!pushResult.isSuccess()) {
                    StringBuilder errMessage = this.pushErrorMsgHandle(pushResult);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"MatAllocateOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), errMessage.toString()));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private StringBuilder pushErrorMsgHandle(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            this.logger.error("\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355\u5931\u8d25\uff1a{}", (Object)billMessage);
            errMessage.append(billMessage);
        }
        return errMessage;
    }
}

