/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.feealloc;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.alloc.output.AllocResult;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.aca.common.helper.AcaCloseAccountHelper;
import kd.macc.cad.common.enums.BillBaseEnum;
import kd.macc.cad.common.helper.MultiPartCcHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MatAllocateOpValidator
extends AbstractValidator {
    public void validate() {
        List<DynamicObject> notSaveItems;
        ExtendedDataEntity[] datas = this.dataEntities;
        HashSet costObjCcSet = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList<ExtendedDataEntity> delBills = new ArrayList<ExtendedDataEntity>(16);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        HashMap<String, Boolean> closeAccountMap = new HashMap<String, Boolean>(10);
        HashMap<Long, Long> costaccountPeriodMap = new HashMap<Long, Long>(10);
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            DynamicObject saveItem = null;
            if (!this.isCurPeriod(dataEntity, this.getOperateKey(), costaccountPeriodMap)) continue;
            switch (this.getOperateKey()) {
                case "op_confirm": {
                    if (this.checkCloseAccount(dataEntity, closeAccountMap)) {
                        if (!this.validateAll(dataEntity)) break;
                        saveItem = this.confirm(dataEntity);
                        this.checkIfMultiPartCc(dataEntity, costObjCcSet);
                        break;
                    }
                    this.addErrorMessage(dataEntity, ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\uff0c\u6210\u672c\u8d26\u7c3f\u3001\u751f\u4ea7\u7ec4\u7ec7\u5df2\u5173\u8d26\u3002", (String)"MatAllocateOpValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), (String)"MatAllocateOpValidator_0"));
                    break;
                }
                case "op_unconfirm": {
                    if (this.checkCloseAccount(dataEntity, closeAccountMap)) {
                        saveItem = this.unconfirm(dataEntity);
                    } else {
                        this.addErrorMessage(dataEntity, ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u4e0d\u80fd\u53cd\u786e\u8ba4\uff0c\u6210\u672c\u8d26\u7c3f\u3001\u751f\u4ea7\u7ec4\u7ec7\u5df2\u5173\u8d26\u3002", (String)"MatAllocateOpValidator_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), (String)"MatAllocateOpValidator_1"));
                    }
                    if (!"eca".equals(dataEntity.getDataEntity().getString("appnum"))) break;
                    delBills.add(dataEntity);
                }
            }
            if (saveItem == null) continue;
            list.add(saveItem);
        }
        if (!delBills.isEmpty() && !CadEmptyUtils.isEmpty(notSaveItems = this.checkCarryBillVourcher(delBills))) {
            list.removeAll(notSaveItems);
        }
        MultiPartCcHelper.resolveMultipartCc((Set)costObjCcSet);
        switch (this.getOperateKey()) {
            case "op_allocate": {
                this.allocate(datas);
                break;
            }
            case "op_confirm": 
            case "op_unconfirm": {
                this.save(list);
                break;
            }
        }
    }

    private List<DynamicObject> checkCarryBillVourcher(List<ExtendedDataEntity> delBills) {
        ArrayList ids = new ArrayList(delBills.size());
        delBills.forEach(p -> ids.add(p.getDataEntity().getPkValue()));
        QFilter[] filters = new QFilter[]{new QFilter("srcbillid", "in", ids), new QFilter("billtype", "=", (Object)"aca_matalloc"), new QFilter("vouchernum", "!=", (Object)" ")};
        DynamicObjectCollection matAllocs = QueryServiceHelper.query((String)"eca_costcarrybill", (String)"srcbillid,srcbillno", (QFilter[])filters);
        if (matAllocs.isEmpty()) {
            return null;
        }
        HashMap<Long, String> allocIds = new HashMap<Long, String>(matAllocs.size());
        for (DynamicObject matAlloc : matAllocs) {
            allocIds.put(matAlloc.getLong("srcbillid"), matAlloc.getString("srcbillno"));
        }
        ArrayList<DynamicObject> notSaveBills = new ArrayList<DynamicObject>(10);
        for (ExtendedDataEntity delBill : delBills) {
            String srcBillNo = (String)allocIds.get(delBill.getBillPkId());
            if (StringUtils.isEmpty((CharSequence)srcBillNo)) continue;
            notSaveBills.add(delBill.getDataEntity());
            this.addErrorMessage(delBill, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0b\u6e38\u6210\u672c\u7ed3\u8f6c\u5355\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53cd\u786e\u8ba4\u3002", (String)"MatAllocateOpValidator_25", (String)"macc-aca-opplugin", (Object[])new Object[0]), srcBillNo));
        }
        return notSaveBills;
    }

    private void checkIfMultiPartCc(ExtendedDataEntity dataEntity, Set<String> costObjCcSet) {
        DynamicObject item = dataEntity.getDataEntity();
        long costCenterId = item.getLong("costcenter.id");
        DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
        if (entryentity != null) {
            for (DynamicObject dynamicObject : entryentity) {
                long ccId;
                DynamicObject costObject = dynamicObject.getDynamicObject("costobejctentry");
                if (CadEmptyUtils.isEmpty((DynamicObject)costObject) || costCenterId == (ccId = costObject.getLong("costcenter.id"))) continue;
                costObjCcSet.add(String.valueOf(costObject.getLong("id")).concat("@").concat(String.valueOf(costCenterId)));
            }
        }
    }

    private boolean checkCloseAccount(ExtendedDataEntity dataEntity, Map<String, Boolean> closeAccountMap) {
        DynamicObject matAlloc = dataEntity.getDataEntity();
        DynamicObject org = matAlloc.getDynamicObject("org");
        DynamicObject costAccount = matAlloc.getDynamicObject("costaccount");
        DynamicObject manuOrg = matAlloc.getDynamicObject("manuorg");
        DynamicObject period = matAlloc.getDynamicObject("period");
        if (manuOrg == null) {
            return true;
        }
        String key = String.format("%s@%s@%s@%s", org.getLong("id"), costAccount.getLong("id"), manuOrg.getLong("id"), period.getLong("id"));
        if (closeAccountMap.containsKey(key)) {
            return closeAccountMap.get(key);
        }
        List closeAccountList = AcaCloseAccountHelper.isCloseAccount((Long)org.getLong("id"), (Long)costAccount.getLong("id"), (Long)manuOrg.getLong("id"), (Long)period.getLong("id"), (String)"aca_matalloc");
        closeAccountMap.put(key, closeAccountList == null || closeAccountList.size() == 0);
        return closeAccountMap.get(key);
    }

    private boolean validateAll(ExtendedDataEntity dataEntity) {
        Boolean isrework;
        DynamicObject mainData = dataEntity.getDataEntity();
        String tips = null;
        boolean isPass = true;
        if (!this.validateQty(mainData)) {
            tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u6570\u91cf\u5408\u8ba1\u2260\u9886\u7528\u6570\u91cf\u3002", (String)"MatAllocateOpValidator_2", (String)"macc-aca-opplugin", (Object[])new Object[0]);
        }
        if (!(isrework = Boolean.valueOf(mainData.getBoolean("isreturnitem"))).booleanValue()) {
            Integer sameRow = this.validateIsSameMaterial(mainData);
            if (sameRow != null) {
                tips = String.format(ResManager.loadKDString((String)"\u5206\u914d\u786e\u8ba4\u5931\u8d25\u3002\u5206\u914d\u660e\u7ec6\u7684\u7b2c%s\u884c\u6240\u5c5e\u4ea7\u54c1\u4e0e\u7269\u6599\u4fe1\u606f.\u7269\u6599\u540d\u79f0\u76f8\u540c\u3002", (String)"MatAllocateOpValidator_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), sameRow);
            }
            if (StringUtils.isNotEmpty((CharSequence)tips)) {
                this.addErrorMessage(dataEntity, String.format(tips, new Object[0]));
                isPass = false;
            }
        }
        boolean notExistEntryQtyIsZero = this.validateEntryQty(dataEntity);
        boolean notSubelementIsNull = this.validateEntrySubElement(dataEntity);
        return isPass && notExistEntryQtyIsZero && notSubelementIsNull;
    }

    private boolean validateEntryQty(ExtendedDataEntity dataEntity) {
        DynamicObject mainData = dataEntity.getDataEntity();
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        boolean notExistEntryQtyIsZero = true;
        String srcbilltype = mainData.getString("srcbilltype.number");
        for (DynamicObject row : rows) {
            BigDecimal entryQty = row.getBigDecimal("qty");
            if (BigDecimal.ZERO.compareTo(entryQty) != 0 || "cal_costadjust_subentity".equals(srcbilltype)) continue;
            String tips = String.format(ResManager.loadKDString((String)"\u5206\u914d\u786e\u8ba4\u5931\u8d25\u3002\u5206\u914d\u660e\u7ec6\u7684\u7b2c%s\u884c\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatAllocateOpValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), row.getInt("seq"));
            this.addErrorMessage(dataEntity, tips);
            notExistEntryQtyIsZero = false;
        }
        return notExistEntryQtyIsZero;
    }

    private boolean validateEntrySubElement(ExtendedDataEntity dataEntity) {
        DynamicObject mainData = dataEntity.getDataEntity();
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        boolean flag = true;
        for (DynamicObject row : rows) {
            String tips;
            if (row.getDynamicObject("elemententry") == null) {
                tips = String.format(ResManager.loadKDString((String)"\u5206\u914d\u786e\u8ba4\u5931\u8d25\u3002\u5206\u914d\u660e\u7ec6\u7684\u7b2c%s\u884c\u8981\u7d20\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatAllocateOpValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), row.getInt("seq"));
                this.addErrorMessage(dataEntity, tips);
                flag = false;
            }
            if (row.getDynamicObject("subelemententry") != null) continue;
            tips = String.format(ResManager.loadKDString((String)"\u5206\u914d\u786e\u8ba4\u5931\u8d25\u3002\u5206\u914d\u660e\u7ec6\u7684\u7b2c%s\u884c\u5b50\u8981\u7d20\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatAllocateOpValidator_6", (String)"macc-aca-opplugin", (Object[])new Object[0]), row.getInt("seq"));
            this.addErrorMessage(dataEntity, tips);
            flag = false;
        }
        return flag;
    }

    private boolean validateQty(DynamicObject mainData) {
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        BigDecimal useQty = mainData.getBigDecimal("useqty");
        BigDecimal entryQtyTotal = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return useQty.compareTo(entryQtyTotal) == 0;
        }
        for (DynamicObject row : rows) {
            BigDecimal entryQty = row.getBigDecimal("qty");
            entryQtyTotal = entryQtyTotal.add(entryQty);
        }
        return useQty.compareTo(entryQtyTotal) == 0;
    }

    private void save(List<DynamicObject> list) {
        if (CadEmptyUtils.isEmpty(list)) {
            return;
        }
        DynamicObject item = list.get(0);
        Long id = item.getLong("id");
        if (CadEmptyUtils.isEmpty((Long)id)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aca_matalloc");
            SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
        } else {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocate(ExtendedDataEntity[] datas) {
        String lockErrStr;
        HashMap<Long, String> commonMap = new HashMap<Long, String>();
        DynamicObject org = datas[0].getDataEntity().getDynamicObject("org");
        Long calOrgId = org.getLong("id");
        DynamicObject costAccount = datas[0].getDataEntity().getDynamicObject("costaccount");
        Long costAccountId = costAccount.getLong("id");
        String costAccountName = costAccount.getString("name");
        DynamicObject period = datas[0].getDataEntity().getDynamicObject("period");
        Long periodId = period.getLong("id");
        String appNum = datas[0].getDataEntity().getString("appnum");
        boolean returnFlag = false;
        HashSet<Long> manuOrgIdSet = new HashSet<Long>();
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)calOrgId);
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject item = dataEntity.getDataEntity();
            if (!this.checkAlloc(dataEntity) || item.get("costobject") != null || ScaAllocEnum.USETYPE_DRIECT.getValue().equals(item.getString("usetype"))) continue;
            commonMap.put(item.getLong("id"), item.getString("billno"));
            if ("eca".equals(appNum) || !orgEnableMultiFactory) continue;
            DynamicObject manuorg = item.getDynamicObject("manuorg");
            if (manuorg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a", (String)"MatAllocateOpValidator_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                returnFlag = true;
                break;
            }
            manuOrgIdSet.add(manuorg.getLong("id"));
        }
        if (returnFlag) {
            return;
        }
        if (!"eca".equals(appNum)) {
            QFilter qfId;
            DynamicObjectCollection manuOrgNames;
            String manuOrgNameTip = null;
            List manuOrgIds = AcaCloseAccountHelper.isCloseAccount((Long)calOrgId, (Long)costAccountId, manuOrgIdSet, (Long)periodId);
            if (CollectionUtils.isNotEmpty((Collection)manuOrgIds) && CollectionUtils.isNotEmpty((Collection)(manuOrgNames = QueryServiceHelper.query((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{qfId = new QFilter("id", "in", (Object)manuOrgIds)})))) {
                List names = manuOrgNames.stream().map(manuOrgName -> manuOrgName.getString("name")).collect(Collectors.toList());
                manuOrgNameTip = StringUtils.join(names, (String)";");
                this.addErrorMessage(datas[0], ResManager.LoadKDString((String)String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u548c\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u7ec4\u5408\u4e0b\u201c\u5f53\u524d\u671f\u95f4\u201d\u5df2\u5173\u8d26\u3002", (String)"MatAllocateOpValidator_24", (String)"macc-aca-opplugin", (Object[])new Object[0]), costAccountName, manuOrgNameTip), (String)"MatAllocateOpValidator_0"));
                return;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)costAccountId)))) {
            this.addErrorMessage(datas[0], String.format(lockErrStr, costAccountName));
            return;
        }
        try {
            AllocResult allocResult = AcaMatAllocHelper.doAlloc(commonMap.keySet());
            this.showAfterAlgoxTips4Alloc(datas, allocResult);
        }
        finally {
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)costAccountId);
        }
    }

    private DynamicObject confirm(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        DynamicObjectCollection entrys = item.getDynamicObjectCollection("entryentity");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys) && ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            item.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
            item.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
            item.set("auditdate", (Object)TimeServiceHelper.now());
            return item;
        }
        String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u975e\u5206\u914d\u72b6\u6001\u3002", (String)"MatAllocateOpValidator_9", (String)"macc-aca-opplugin", (Object[])new Object[0]);
        this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
        return null;
    }

    private DynamicObject unconfirm(ExtendedDataEntity dataEntity) {
        boolean hasVourcher;
        DynamicObject item = dataEntity.getDataEntity();
        boolean bl = hasVourcher = !this.checkVourcher(dataEntity);
        if (hasVourcher) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u53cd\u786e\u8ba4\u3002\u5df2\u7ecf\u751f\u6210\u4e86\u51ed\u8bc1\u3002", (String)"MatAllocateOpValidator_10", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        if (!ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u53cd\u786e\u8ba4\u3002\u975e\u5df2\u786e\u8ba4\u72b6\u6001\u3002", (String)"MatAllocateOpValidator_11", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        item.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        item.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_STAGED.getValue());
        return item;
    }

    private boolean checkVourcher(ExtendedDataEntity dataEntity) {
        DynamicObject matAlloc = dataEntity.getDataEntity();
        String voucherNum = matAlloc.getString("vouchernum");
        return StringUtils.isEmpty((CharSequence)voucherNum);
    }

    private boolean isCurPeriod(ExtendedDataEntity dataEntity, String opreateKey, Map<Long, Long> costaccountPeriodMap) {
        DynamicObject dyn;
        String opreateKeyStr = "";
        boolean flag = true;
        switch (opreateKey) {
            case "op_allocate": {
                opreateKeyStr = ResManager.loadKDString((String)"\u5206\u914d", (String)"MatAllocateOpValidator_13", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case "op_confirm": {
                opreateKeyStr = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MatAllocateOpValidator_14", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case "op_unconfirm": {
                opreateKeyStr = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"MatAllocateOpValidator_15", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                return false;
            }
        }
        DynamicObject item = dataEntity.getDataEntity();
        DynamicObject costaccount = item.getDynamicObject("costaccount");
        DynamicObject period = item.getDynamicObject("period");
        Long curPeriodId = costaccountPeriodMap.get(costaccount.getLong("id"));
        if (curPeriodId == null && (dyn = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"))) != null) {
            curPeriodId = dyn.getLong("id");
            costaccountPeriodMap.put(costaccount.getLong("id"), curPeriodId);
        }
        if (curPeriodId == null || period.getLong("id") != curPeriodId.longValue()) {
            flag = false;
            String atips = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5931\u8d25\uff1a\u4e0d\u5141\u8bb8\u5bf9\u4ee5\u524d\u671f\u95f4\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MatAllocateOpValidator_23", (String)"macc-aca-opplugin", (Object[])new Object[0]), opreateKeyStr);
            this.addErrorMessage(dataEntity, atips);
        }
        return flag;
    }

    private boolean checkAlloc(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        if (item.getDynamicObject("costobject") != null || ScaAllocEnum.USETYPE_DRIECT.getValue().equals(item.getString("usetype"))) {
            String aTips = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002%s\u5355\u636e\u5df2\u5b8c\u6210\u5206\u914d\u3002", (String)"MatAllocateOpValidator_18", (String)"macc-aca-opplugin", (Object[])new Object[0]), item.getString("billno"));
            this.addErrorMessage(dataEntity, aTips);
            return false;
        }
        if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u786e\u8ba4\u5206\u914d\u7ed3\u679c\u3002", (String)"MatAllocateOpValidator_19", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, aTips);
            return false;
        }
        if (item.getString("costdriver") == null) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u201c\u5206\u914d\u6807\u51c6\u201d\u4e3a\u7a7a\u3002", (String)"MatAllocateOpValidator_20", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, aTips);
            return false;
        }
        if (ScaAllocEnum.ALLOCTYPE_MANUAL.getValue().equalsIgnoreCase(item.getString("alloctype"))) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u8fdb\u884c\u8fc7\u624b\u52a8\u5206\u914d\u3002", (String)"MatAllocateOpValidator_21", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, aTips);
            return false;
        }
        return true;
    }

    private void showAfterAlgoxTips4Alloc(ExtendedDataEntity[] datas, AllocResult result) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject item = dataEntity.getDataEntity();
            if (result.isReportContainError()) {
                String aTips = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5206\u914d\u62a5\u544a\u3002", (String)"MatAllocateOpValidator_26", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, aTips);
                continue;
            }
            for (String number : result.getReasonMap().keySet()) {
                if (!StringUtils.equals((CharSequence)number, (CharSequence)item.getString("id")) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)result.getReasonMap().get(number)))) continue;
                String aTips = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"MatAllocateOpValidator_22", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, aTips);
            }
        }
    }

    private Integer validateIsSameMaterial(DynamicObject mainData) {
        if (ScaAllocEnum.USETYPE_PUBLIC.getValue().equals(mainData.getString("usetype"))) {
            Long materialId = mainData.getLong("material.id");
            DynamicObjectCollection allocDetails = mainData.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < allocDetails.size(); ++i) {
                DynamicObject allocDetail = (DynamicObject)allocDetails.get(i);
                Long subMaterial = allocDetail.getLong("costobejctentry.material.id");
                if (materialId.longValue() != subMaterial.longValue()) continue;
                return i + 1;
            }
        }
        return null;
    }
}

