/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WipCostInitImportSubEntryOp
extends BatchImportPlugin {
    private Log log = LogFactory.getLog(WipCostInitImportSubEntryOp.class);
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";
    private static final String NUMBER = "number";

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("keyfields");
        lockKeys.add("flexpanelap6");
        return lockKeys;
    }

    public String getDefaultImportType() {
        return "override";
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"WipCostInitImportSubEntryOp_53", (String)"macc-aca-opplugin", (Object[])new Object[0])), "id"));
        return items;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        if (result.getSuccess()) {
            List dataList = (List)result.getData();
            List idList = dataList.stream().map(hashMap -> hashMap.get("id")).collect(Collectors.toList());
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"aca_wipcostinit", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
            if (submitResult.isSuccess()) {
                OperationServiceHelper.executeOperate((String)"audit", (String)"aca_wipcostinit", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
            }
        } else {
            this.log.error(result.getMessage());
        }
        return result;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        this.validateSubEntry(billDatas, logger);
    }

    private void validateSubEntry(List<ImportBillData> billDatas, ImportLogger logger) {
        Iterator<ImportBillData> billIterator = billDatas.iterator();
        while (billIterator.hasNext()) {
            ImportBillData billData = billIterator.next();
            JSONObject data = billData.getData();
            int index = billData.getStartIndex();
            if (!this.subCheckHeadBody(index, data, logger)) {
                billIterator.remove();
                logger.setFailed(logger.getFailed() + 1);
                continue;
            }
            if (this.subCheckSubEntry(index, data, logger)) continue;
            billIterator.remove();
            logger.setFailed(logger.getFailed() + 1);
        }
        this.validateSubData(billDatas, logger);
    }

    private void validateSubData(List<ImportBillData> billDatas, ImportLogger logger) {
        ArrayList idAndsubEleNum = Lists.newArrayList();
        Map<Long, List<ImportBillData>> billNoSubEntryMap = billDatas.stream().collect(Collectors.groupingBy(importBillData -> Long.valueOf(importBillData.getData().get("id").toString())));
        if (billNoSubEntryMap != null && billNoSubEntryMap.size() > 0) {
            Set<Long> ids = billNoSubEntryMap.keySet();
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and("billstatus", "=", (Object)"A");
            DynamicObject[] wipCostInitArray = BusinessDataServiceHelper.load((String)"aca_wipcostinit", (String)"id,org,costobject,costaccount,entryentity.subelement,entryentity.amount,entryentity.yearinputamt,entryentity.yearfinishamt", (QFilter[])new QFilter[]{qFilter});
            HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
            if (wipCostInitArray != null && wipCostInitArray.length > 0) {
                Map<Long, DynamicObject> storedNoSubMap = Arrays.stream(wipCostInitArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
                for (Map.Entry<Long, List<ImportBillData>> billNoSubEntry : billNoSubEntryMap.entrySet()) {
                    Long id = billNoSubEntry.getKey();
                    String idStr = id.toString();
                    List<ImportBillData> subEntryDatas = billNoSubEntry.getValue();
                    Iterator<ImportBillData> iterator = subEntryDatas.iterator();
                    while (iterator.hasNext()) {
                        Long costaccountId;
                        ImportBillData subEntryData = iterator.next();
                        int index = subEntryData.getStartIndex();
                        JSONObject data = subEntryData.getData();
                        if (!storedNoSubMap.containsKey(id)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5185\u7801\u201c%s\u201d\u672a\u627e\u5230\u5339\u914d\u6570\u636e\u3002", (String)"WipCostInitImportSubEntryOp_54", (String)"macc-aca-opplugin", (Object[])new Object[0]), idStr));
                            iterator.remove();
                            logger.setFailed(logger.getFailed() + 1);
                            continue;
                        }
                        DynamicObject wipAdjust = storedNoSubMap.get(id);
                        JSONArray jsonArray = data.getJSONArray("entryentity");
                        for (Object o : jsonArray) {
                            JSONObject entryObj = (JSONObject)o;
                            Map subElementMap = (Map)entryObj.get((Object)"subelement");
                            if (subElementMap == null || subElementMap.size() <= 0) continue;
                            String subEleNum = subElementMap.get(NUMBER).toString();
                            if (idAndsubEleNum.contains(idStr.concat("@").concat(subEleNum))) {
                                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5185\u7801\u3010%1$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%2$s\u3011\u5df2\u91cd\u590d", (String)"WipCostInitImportSubEntryOp_55", (String)"macc-aca-opplugin", (Object[])new Object[0]), idStr, subEleNum));
                                iterator.remove();
                                logger.setFailed(logger.getFailed() + 1);
                                continue;
                            }
                            idAndsubEleNum.add(idStr.concat("@").concat(subEleNum));
                        }
                        if (wipAdjust == null) continue;
                        Long orgId = wipAdjust.getLong("org.id");
                        String key = String.format("%s@%s", orgId, costaccountId = Long.valueOf(wipAdjust.getLong("costaccount.id")));
                        Set calcKeys = (Set)costaccountKeyColMap.get(key);
                        if (calcKeys == null) {
                            calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costaccountId, (String)"aca");
                            costaccountKeyColMap.put(key, calcKeys);
                        }
                        if (this.checkEntryEntity(index, wipAdjust, data, logger, CadEmptyUtils.isEmpty((Set)calcKeys))) continue;
                        billDatas.remove(subEntryData);
                        logger.setFailed(logger.getFailed() + 1);
                    }
                }
            } else {
                logger.log(Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5185\u7801\u201c%s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u5355\u636e\u3002", (String)"WipCostInitImportSubEntryOp_56", (String)"macc-aca-opplugin", (Object[])new Object[0]), StringUtils.join(ids, (String)",")));
                logger.setFailed(logger.getFailed() + billDatas.size());
                billDatas.clear();
            }
        }
    }

    private boolean subCheckSubEntry(int index, JSONObject data, ImportLogger logger) {
        boolean checkFlag = true;
        JSONArray entryData = data.getJSONArray("entryentity");
        boolean subEntryFlag = false;
        for (Object entryObj : entryData) {
            if (entryObj == null) continue;
            JSONObject entryObject = (JSONObject)entryObj;
            entryObject.put("importtype", (Object)"subentry");
            JSONArray subEntry = entryObject.getJSONArray("subentryentity");
            if (subEntry == null || subEntry.size() <= 0) continue;
            subEntryFlag = true;
            Iterator iterator = subEntry.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object != null) {
                    JSONObject subEntryRow = (JSONObject)object;
                    if (subEntryRow.get((Object)"submateriel") == null) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5b50\u9879\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"WipCostInitImportSubEntryOp_3", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                        checkFlag = false;
                    } else {
                        Map subMaterialMap = (Map)subEntryRow.get((Object)"submateriel");
                        String matNum = subMaterialMap.get(NUMBER).toString();
                        QFilter qFilter = new QFilter(NUMBER, "=", (Object)matNum);
                        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter});
                        if (material == null) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b50\u9879\u7269\u6599\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipCostInitImportSubEntryOp_40", (String)"macc-aca-opplugin", (Object[])new Object[0]), matNum));
                            checkFlag = false;
                            return checkFlag;
                        }
                        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material) && subEntryRow.get((Object)"subauxpty") == null) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b50\u9879\u7269\u6599\u201c%s\u201d\u5f00\u542f\u4e86\u8f85\u52a9\u5c5e\u6027\u4e14\u8f85\u52a9\u5c5e\u6027\u5f71\u54cd\u6210\u672c\uff0c\u8bf7\u5f55\u5165\u5b50\u9879\u7269\u6599\u8f85\u52a9\u5c5e\u6027\u3002", (String)"WipCostInitImportSubEntryOp_42", (String)"macc-aca-opplugin", (Object[])new Object[0]), matNum));
                            checkFlag = false;
                        }
                        subEntryRow.put("subbaseunit".concat("_id"), material.get("baseunit.id"));
                    }
                    if (subEntryRow.get((Object)"subqty") == null) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u201d\u7684\u57fa\u672c\u6570\u91cf\u3002", (String)"WipCostInitImportSubEntryOp_5", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    }
                    if (subEntryRow.get((Object)"subamount") != null) continue;
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u201d\u7684\u91d1\u989d\u3002", (String)"WipCostInitImportSubEntryOp_6", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    continue;
                }
                iterator.remove();
            }
        }
        if (!subEntryFlag) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u201d\u3002", (String)"WipCostInitImportSubEntryOp_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        return checkFlag;
    }

    private boolean subCheckHeadBody(int index, JSONObject data, ImportLogger logger) {
        JSONArray entryEntity;
        boolean checkFlag = true;
        if (data.get((Object)"costobject") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u201d\u3002", (String)"WipCostInitImportSubEntryOp_8", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        if ((entryEntity = data.getJSONArray("entryentity")) == null || entryEntity.size() == 0) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4fe1\u606f\u201d\u3002", (String)"WipCostInitImportSubEntryOp_9", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        if (entryEntity != null && entryEntity.size() != 0) {
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o != null) {
                    JSONObject entryRow = (JSONObject)o;
                    if (entryRow.get((Object)"subelement") != null) continue;
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u672a\u586b\u5165", (String)"WipCostInitImportSubEntryOp_47", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    checkFlag = false;
                    continue;
                }
                iterator.remove();
            }
        }
        return checkFlag;
    }

    private boolean checkEntryEntity(int index, DynamicObject wipCostInit, JSONObject data, ImportLogger logger, boolean checkRepeat) {
        boolean checkFlag = true;
        DynamicObjectCollection entryEntity = wipCostInit.getDynamicObjectCollection("entryentity");
        ArrayList subEleMats = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            JSONArray jsonArray = data.getJSONArray("entryentity");
            Map<String, JSONObject> subEleJsonObjMap = jsonArray.stream().collect(Collectors.toMap(o -> {
                JSONObject entryObject = (JSONObject)o;
                Map subElementMap = (Map)entryObject.get((Object)"subelement");
                return subElementMap.get(NUMBER).toString();
            }, o -> (JSONObject)o));
            for (DynamicObject costInfo : entryEntity) {
                String subEleType;
                DynamicObject subElement = costInfo.getDynamicObject("subelement");
                if (subElement == null || !(subEleType = subElement.getString("type")).equals(MATTYPE) && !subEleType.equals(MATCOST)) continue;
                String subElementNum = subElement.getString(NUMBER);
                if (subEleJsonObjMap.containsKey(subElementNum)) {
                    BigDecimal yearFinishAmt;
                    BigDecimal yearInputAmt;
                    JSONObject entryObject = subEleJsonObjMap.get(subElementNum);
                    entryObject.put("importtype", (Object)"subentry");
                    JSONArray subEntryArray = entryObject.getJSONArray("subentryentity");
                    BigDecimal amtTotal = BigDecimal.ZERO;
                    BigDecimal matInputAmtTotal = BigDecimal.ZERO;
                    BigDecimal matFinishAmtTotal = BigDecimal.ZERO;
                    boolean amtCheckFlag = true;
                    for (Object matInfoObj : subEntryArray) {
                        if (matInfoObj == null) continue;
                        JSONObject matInfo = (JSONObject)matInfoObj;
                        Map matMap = (Map)matInfo.get((Object)"submateriel");
                        String matNum = matMap.get(NUMBER).toString();
                        if (subEleMats.contains(subElementNum.concat("@").concat(matNum)) && checkRepeat) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%1$s\u3011\u5b58\u5728\u76f8\u540c\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%2$s\u3011", (String)"WipCostInitImportSubEntryOp_48", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum, matNum));
                            checkFlag = false;
                        }
                        subEleMats.add(subElementNum.concat("@").concat(matNum));
                        BigDecimal subAmount = matInfo.getBigDecimal("subamount");
                        if (amtTotal != null && subAmount != null) {
                            amtTotal = amtTotal.add(subAmount);
                        }
                        BigDecimal matYearInputQty = matInfo.getBigDecimal("matyearinputqty");
                        BigDecimal matYearInputAmt = matInfo.getBigDecimal("matyearinputamt");
                        if (!(matYearInputQty == null && matYearInputAmt == null || matYearInputQty != null && matYearInputAmt != null)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%1$s\u3011\u5b50\u7269\u6599\u7269\u6599\u7f16\u7801\u3010%2$s\u3011\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u6570\u91cf\u3001\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55", (String)"WipCostInitImportSubEntryOp_49", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum, matNum));
                            checkFlag = false;
                        }
                        matInputAmtTotal = matInputAmtTotal.add(matYearInputAmt == null ? BigDecimal.ZERO : matYearInputAmt);
                        BigDecimal matYearFinishQty = matInfo.getBigDecimal("matyearfinishqty");
                        BigDecimal matYearFinishAmt = matInfo.getBigDecimal("matyearfinishamt");
                        if (!(matYearFinishQty == null && matYearFinishAmt == null || matYearFinishQty != null && matYearFinishAmt != null)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%1$s\u3011\u5b50\u7269\u6599\u7269\u6599\u7f16\u7801\u3010%2$s\u3011\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6570\u91cf\u3001\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55", (String)"WipCostInitImportSubEntryOp_50", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum, matNum));
                            checkFlag = false;
                        }
                        matFinishAmtTotal = matFinishAmtTotal.add(matYearFinishAmt == null ? BigDecimal.ZERO : matYearFinishAmt);
                    }
                    BigDecimal amount = costInfo.getBigDecimal("amount");
                    if (amount != null && amount.compareTo(amtTotal) != 0) {
                        amtCheckFlag = false;
                        this.log.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5bfc\u5165\uff1aamount\uff1a{}\uff0camtTotal\uff1a{}", (Object)amount, (Object)amtTotal);
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u91d1\u989d\u4e0d\u7b49\u4e8e\u201c\u5b50\u9879\u7269\u6599\u201d\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitImportSubEntryOp_12", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    }
                    if ((yearInputAmt = costInfo.getBigDecimal("yearinputamt")).compareTo(matInputAmtTotal) != 0) {
                        amtCheckFlag = false;
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u4e0d\u7b49\u4e8e\u201c\u5b50\u9879\u7269\u6599\u201d\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitImportSubEntryOp_13", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    }
                    if ((yearFinishAmt = costInfo.getBigDecimal("yearfinishamt")).compareTo(matFinishAmtTotal) != 0) {
                        amtCheckFlag = false;
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u4e0d\u7b49\u4e8e\u201c\u5b50\u9879\u7269\u6599\u201d\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitImportSubEntryOp_14", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    }
                    if (amtCheckFlag) continue;
                    logger.setFailed(logger.getFailed() + 1);
                    checkFlag = false;
                    continue;
                }
                String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%1$s\u201d\u5bf9\u5e94\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u9700\u5f55\u5165\u5b50\u7269\u6599\u660e\u7ec6\u3002", (String)"WipCostInitImportSubEntryOp_39", (String)"macc-aca-opplugin", (Object[])new Object[0]), wipCostInit.getString("costobject".concat(".billno")), subElementNum);
                logger.log(Integer.valueOf(index), msg);
                checkFlag = false;
            }
        }
        return checkFlag;
    }
}

