/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.init;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.common.constants.WipInitSubItem;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class WipCostInitOpValidator
extends AbstractValidator {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";

    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap costaccountSubItem = Maps.newHashMapWithExpectedSize((int)10);
        HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            DynamicObject item = dataEntity.getDataEntity();
            DynamicObject costAccount = item.getDynamicObject("costaccount");
            boolean isCostElement = false;
            if (costAccount != null) {
                Long costaccountId = costAccount.getLong("id");
                if (!costaccountSubItem.containsKey(costaccountId)) {
                    costaccountSubItem.put(costaccountId, CostaccountHelper.getCostElementByCostAccount((long)costaccountId));
                }
                isCostElement = (Boolean)costaccountSubItem.get(costaccountId);
            }
            Long orgId = item.getLong("org.id");
            Long costaccountId = item.getLong("costaccount.id");
            String key = String.format("%s@%s", orgId, costaccountId);
            Set calcKeys = (Set)costaccountKeyColMap.get(key);
            if (calcKeys == null) {
                calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costaccountId, (String)"aca");
                costaccountKeyColMap.put(key, calcKeys);
            }
            this.relateData(dataEntity);
            this.validateSave(dataEntity, isCostElement, CadEmptyUtils.isEmpty((Set)calcKeys));
        }
    }

    private void relateData(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryEntity;
        DynamicObject item = dataEntity.getDataEntity();
        String source = item.getString("source");
        String billStatus = item.getString("billstatus");
        if ("import".equals(source) && !"C".equals(billStatus) && CollectionUtils.isNotEmpty((Collection)(entryEntity = item.getDynamicObjectCollection("entryentity")))) {
            Map<Long, DynamicObject> subElementSubEntryMap = entryEntity.stream().filter(dynamicObject -> "subentry".equals(dynamicObject.getString("importtype"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("subelement".concat(".id")), dynamicObject -> dynamicObject));
            if (!subElementSubEntryMap.isEmpty()) {
                for (DynamicObject entry : entryEntity) {
                    if (entry == null) continue;
                    long subElementId = entry.getLong("subelement".concat(".id"));
                    entry.set("element".concat("_id"), (Object)ElementRelationHelper.getElement((long)subElementId));
                    if (!subElementSubEntryMap.containsKey(subElementId) || "subentry".equals(entry.getString("importtype"))) continue;
                    DynamicObject entryEntityVal = subElementSubEntryMap.get(subElementId);
                    entry.set("subentryentity", entryEntityVal.get("subentryentity"));
                }
            }
            if (!subElementSubEntryMap.isEmpty()) {
                Iterator iterator = entryEntity.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry;
                    entry = (DynamicObject)iterator.next();
                    if (entry != null) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void validateSave(ExtendedDataEntity dataEntity, boolean isCostElement, boolean checkRepeat) {
        DynamicObject item = dataEntity.getDataEntity();
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.checkBillHead(dataEntity, item);
            this.checkBillBody(dataEntity, item);
            DynamicObjectCollection costInfoList = item.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < costInfoList.size(); ++i) {
                DynamicObjectCollection matInfoList;
                DynamicObject costInfo = (DynamicObject)costInfoList.get(i);
                String subElementType = costInfo.getString("subelement".concat(".type"));
                String subElementName = costInfo.getString("subelement".concat(".name"));
                if (costInfo.getDynamicObject("element") == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c\u3010%1$s\u3011\u884c\u3010%2$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u5bf9\u5e94\u7684\u6210\u672c\u8981\u7d20\u9700\u5f55\u5165", (String)"WipCostInitOpValidator_49", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                }
                if (MATTYPE.equals(subElementType) || MATCOST.equals(subElementType)) {
                    matInfoList = costInfo.getDynamicObjectCollection("subentryentity");
                    if (CollectionUtils.isEmpty((Collection)matInfoList)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u9700\u5f55\u5165\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u3002", (String)"WipCostInitOpValidator_29", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                    }
                    BigDecimal amountTotal = BigDecimal.ZERO;
                    BigDecimal matYearInputAmtTotal = BigDecimal.ZERO;
                    BigDecimal matYearFinishAmtTotal = BigDecimal.ZERO;
                    HashMap matRepeatMap = Maps.newHashMapWithExpectedSize((int)16);
                    for (int j = 0; j < matInfoList.size(); ++j) {
                        DynamicObject matInfo = (DynamicObject)matInfoList.get(j);
                        this.validateMat(dataEntity, matInfo, i, j, subElementName, matRepeatMap, checkRepeat);
                        BigDecimal subQty = matInfo.getBigDecimal("subqty");
                        BigDecimal matYearInputQty = matInfo.getBigDecimal("matyearinputqty");
                        BigDecimal matYearInputAmt = matInfo.getBigDecimal("matyearinputamt");
                        BigDecimal matYearFinishQty = matInfo.getBigDecimal("matyearfinishqty");
                        BigDecimal matYearFinishAmt = matInfo.getBigDecimal("matyearfinishamt");
                        BigDecimal matAmount = matInfo.getBigDecimal("subamount");
                        if (CadEmptyUtils.isEmpty((BigDecimal)subQty) && CadEmptyUtils.isEmpty((BigDecimal)matAmount) && CadEmptyUtils.isEmpty((BigDecimal)matYearInputQty) && CadEmptyUtils.isEmpty((BigDecimal)matYearFinishQty)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u57fa\u672c\u6570\u91cf\u9700\u5f55\u5165\u3002", (String)"WipCostInitOpValidator_30", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                        }
                        if (this.checkQtyAmt(matYearInputQty, matYearInputAmt)) {
                            matYearInputAmtTotal = matYearInputAmtTotal.add(matYearInputAmt);
                        } else {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u7b2c%3$s\u884c\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u6570\u91cf\u3001\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55\u3002", (String)"WipCostInitOpValidator_31", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                        }
                        if (this.checkQtyAmt(matYearFinishQty, matYearFinishAmt)) {
                            matYearFinishAmtTotal = matYearFinishAmtTotal.add(matYearFinishAmt);
                        } else {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u7b2c%3$s\u884c\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6570\u91cf\u3001\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55\u3002", (String)"WipCostInitOpValidator_32", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                        }
                        amountTotal = amountTotal.add(matAmount);
                        if (!isCostElement) continue;
                        String subitemjson = matInfo.getString("subitemjson_tag");
                        List subitems = null;
                        if (StringUtils.isEmpty((String)subitemjson) || (subitems = JSON.parseArray((String)subitemjson, WipInitSubItem.class)).isEmpty()) continue;
                        BigDecimal subamt = BigDecimal.ZERO;
                        BigDecimal subinamt = BigDecimal.ZERO;
                        BigDecimal suboutamt = BigDecimal.ZERO;
                        for (WipInitSubItem subitem : subitems) {
                            if (CadEmptyUtils.isEmpty((Long)subitem.getSsubelement()) || CadEmptyUtils.isEmpty((Long)subitem.getSelement())) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u5206\u9879\u8981\u7d20\u6216\u5b50\u8981\u7d20\u4e3a\u7a7a\u3002", (String)"WipCostInitOpValidator_40", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                            }
                            subamt = subamt.add(subitem.getSamount());
                            subinamt = subinamt.add(subitem.getSyearinamt());
                            suboutamt = suboutamt.add(subitem.getSyearcomamt());
                        }
                        if (subamt.compareTo(matAmount) != 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u5b50\u8981\u7d20\u5206\u9879\u4fe1\u606f\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5b50\u7269\u6599\u91d1\u989d\u3002", (String)"WipCostInitOpValidator_41", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                        }
                        if (subinamt.compareTo(matYearInputAmt) != 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u5b50\u8981\u7d20\u5206\u9879\u4fe1\u606f\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5b50\u7269\u6599\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u3002", (String)"WipCostInitOpValidator_42", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                        }
                        if (suboutamt.compareTo(matYearFinishAmt) == 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u5b50\u8981\u7d20\u5206\u9879\u4fe1\u606f\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5b50\u7269\u6599\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u3002", (String)"WipCostInitOpValidator_43", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                    }
                    BigDecimal yearInputAmt = costInfo.getBigDecimal("yearinputamt");
                    BigDecimal yearFinishAmt = costInfo.getBigDecimal("yearfinishamt");
                    BigDecimal amount = costInfo.getBigDecimal("amount");
                    if (yearInputAmt.compareTo(matYearInputAmtTotal) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u201c\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u4e0d\u7b49\u4e8e\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitOpValidator_33", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                    }
                    if (yearFinishAmt.compareTo(matYearFinishAmtTotal) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u4e0d\u7b49\u4e8e\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitOpValidator_34", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                    }
                    if (amountTotal.compareTo(amount) == 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u91d1\u989d\u4e0d\u7b49\u4e8e\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitOpValidator_35", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                    continue;
                }
                matInfoList = costInfo.getDynamicObjectCollection("subentryentity");
                if (CollectionUtils.isEmpty((Collection)matInfoList)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u201c%2$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u975e\u7269\u6599\u548c\u7269\u6599\u8d39\u7528\u7c7b\u578b\uff0c\u4e0d\u9700\u5f55\u5165\u5b50\u7269\u6599\u4fe1\u606f\u4fe1\u606f\u3002", (String)"WipCostInitOpValidator_44", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
            }
        }
    }

    private void checkBillBody(ExtendedDataEntity dataEntity, DynamicObject item) {
        this.validateQtyAmt(dataEntity, item);
        this.validateOutsourceType(dataEntity, item);
    }

    private void validateOutsourceType(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costobjectDyn = item.getDynamicObject("costobject");
        if (costobjectDyn == null) {
            return;
        }
        boolean isOutsource = costobjectDyn.getBoolean("isoutsource");
        DynamicObjectCollection dynCols = item.getDynamicObjectCollection("entryentity");
        if (!dynCols.isEmpty()) {
            int i = 1;
            HashSet subelementKeys = Sets.newHashSetWithExpectedSize((int)10);
            for (DynamicObject dyn : dynCols) {
                String outsourcetype = dyn.getString("outsourcetype");
                Long subElementId = dyn.getLong("subelement.id");
                if (!isOutsource && !StringUtils.isBlank((String)outsourcetype)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u975e\u59d4\u5916\u65f6\uff0c\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\uff0c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u4e0d\u9700\u8981\u586b\u503c\u3002", (String)"WipCostInitOpValidator_45", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                } else if (isOutsource && StringUtils.isBlank((String)outsourcetype)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u662f\u59d4\u5916\u5de5\u5355\u65f6\uff0c\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\uff0c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u5fc5\u5f55\u3002", (String)"WipCostInitOpValidator_46", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                }
                if (!subelementKeys.add(String.format("%s@%s", subElementId, outsourcetype))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\uff0c\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u59d4\u5916\u6210\u672c\u7c7b\u578b\u7ec4\u5408\u4e0d\u662f\u552f\u4e00\u3002", (String)"WipCostInitOpValidator_47", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                }
                ++i;
            }
        }
    }

    private void validateQtyAmt(ExtendedDataEntity dataEntity, DynamicObject item) {
        boolean inputQty = !CadEmptyUtils.isEmpty((BigDecimal)item.getBigDecimal("yearinputqty"));
        boolean finishQty = !CadEmptyUtils.isEmpty((BigDecimal)item.getBigDecimal("yearfinishqty"));
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
        boolean entryInputAmt = false;
        boolean entryFinishAmt = false;
        BigDecimal initAmt = BigDecimal.ZERO;
        for (DynamicObject entryRow : entryEntity) {
            if (!CadEmptyUtils.isEmpty((BigDecimal)entryRow.getBigDecimal("yearinputamt"))) {
                entryInputAmt = true;
            }
            if (!CadEmptyUtils.isEmpty((BigDecimal)entryRow.getBigDecimal("yearfinishamt"))) {
                entryFinishAmt = true;
            }
            if (CadEmptyUtils.isEmpty((BigDecimal)entryRow.getBigDecimal("amount"))) continue;
            initAmt = initAmt.add(entryRow.getBigDecimal("amount"));
        }
        if (inputQty != entryInputAmt) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55\u3002", (String)"WipCostInitOpValidator_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
        if (finishQty != entryFinishAmt) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55\u3002", (String)"WipCostInitOpValidator_2", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
        if (CadEmptyUtils.isEmpty((BigDecimal)item.getBigDecimal("initamt"))) {
            item.set("initamt", (Object)initAmt);
        }
    }

    private void validateMatTypeElementAmount(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
        ArrayList<Integer> invalidateRowSeqList = new ArrayList<Integer>(10);
        for (DynamicObject row : entryEntity) {
            String elementType = row.getString("element.type");
            BigDecimal amount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("amount"));
            BigDecimal yearInputAmount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("yearinputamt"));
            BigDecimal yearFinishAmount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("yearfinishamt"));
            if (!MATTYPE.equals(elementType) || amount.compareTo(BigDecimal.ZERO) != 0 || yearInputAmount.compareTo(BigDecimal.ZERO) != 0 || yearFinishAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            invalidateRowSeqList.add(row.getInt("seq"));
        }
        if (!CadEmptyUtils.isEmpty(invalidateRowSeqList)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u8bf7\u586b\u5199\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\u91d1\u989d\u4fe1\u606f\u6216\u7d2f\u8ba1\u91d1\u989d\u4fe1\u606f\u3002", (String)"WipCostInitOpValidator_48", (String)"macc-aca-opplugin", (Object[])new Object[0]), StringUtils.join(invalidateRowSeqList, (String)","));
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void validateExistMatTypeElement(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
        boolean hasMatTypeElement = false;
        for (DynamicObject row : entryEntity) {
            String type;
            DynamicObject subElement;
            DynamicObject element;
            if (MATTYPE.equals(row.getString("element.type"))) {
                hasMatTypeElement = true;
                break;
            }
            if (row.get("element") != null || (element = ElementRelationHelper.getElement((DynamicObject)(subElement = row.getDynamicObject("subelement")))) == null || !MATTYPE.equals(type = element.getString("type"))) continue;
            hasMatTypeElement = true;
            break;
        }
        if (!hasMatTypeElement) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u6210\u672c\u4fe1\u606f\u5fc5\u987b\u7ef4\u62a4\u7269\u6599\u8981\u7d20\u76f8\u5173\u4fe1\u606f\u3002", (String)"WipCostInitOpValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkBillHead(ExtendedDataEntity dataEntity, DynamicObject item) {
        this.checkOrgManuOrg(dataEntity, item);
        this.checkOrgCostAccount(dataEntity, item);
        this.checkOrgCostCenter(dataEntity, item);
        this.checkOrgCostObject(dataEntity, item);
    }

    private void checkOrgManuOrg(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject org = item.getDynamicObject("org");
        if (org == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"WipCostInitOpValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else if (OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
            DynamicObject manuOrg = item.getDynamicObject("manuorg");
            if (manuOrg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipCostInitOpValidator_6", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            } else {
                Long manuOrgId = manuOrg.getLong("id");
                List manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)"aca_wipcostinit", (String)"aca");
                if (!manuOrgIds.contains(manuOrgId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkOrgCostObject(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costObject = item.getDynamicObject("costobject");
        if (costObject == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201d\u3002", (String)"WipCostInitOpValidator_8", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject costCenter;
            DynamicObject org = item.getDynamicObject("org");
            if (org != null && costObject.getDynamicObject("org").getLong("id") != org.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_9", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
            if ((costCenter = item.getDynamicObject("costcenter")) != null && costObject.getDynamicObject("costcenter").getLong("id") != costCenter.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_10", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkOrgCostCenter(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costCenter = item.getDynamicObject("costcenter");
        if (costCenter == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"WipCostInitOpValidator_11", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject accountOrg;
            long orgDuty = costCenter.getLong("orgduty.id");
            if (orgDuty != DutyIdConstants.BASIC_PRODUCT_ID) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7c7b\u578b\u4e0d\u4e3a\u201c\u7b80\u5355\u751f\u4ea7\u201d\u3002", (String)"WipCostInitOpValidator_12", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
            if ((accountOrg = costCenter.getDynamicObject("accountorg")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_13", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            } else {
                DynamicObject org = item.getDynamicObject("org");
                if (org != null && accountOrg.getLong("id") != org.getLong("id")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_13", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkOrgCostAccount(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costAccount = item.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"WipCostInitOpValidator_14", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject calOrg = costAccount.getDynamicObject("calorg");
            if (calOrg != null) {
                DynamicObject org = item.getDynamicObject("org");
                if (org != null && calOrg.getLong("id") != org.getLong("id")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_15", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitOpValidator_15", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateMat(ExtendedDataEntity dataEntity, DynamicObject matInfo, int i, int j, String subElementName, Map<String, Integer> matRepeatMap, boolean checkRepeat) {
        DynamicObject material = matInfo.getDynamicObject("submateriel");
        StringBuilder stringBuilder = new StringBuilder();
        if (material == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u7b2c%3$s\u884c\u5b50\u9879\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipCostInitOpValidator_36", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
        } else {
            DynamicObject matVersion;
            stringBuilder.append(material.getLong("id"));
            if (BomRouterHelper.isEnableMatversion((DynamicObject)material) && (matVersion = matInfo.getDynamicObject("submatversion")) != null) {
                stringBuilder.append(matVersion.getLong("id"));
            }
            if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
                DynamicObject auxpty = matInfo.getDynamicObject("subauxpty");
                if (auxpty == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u7b2c%3$s\u884c\u5b50\u9879\u7269\u6599\u5f00\u542f\u4e86\u8f85\u52a9\u5c5e\u6027\u4e14\u8f85\u52a9\u5c5e\u6027\u5f71\u54cd\u6210\u672c\uff0c\u5b50\u9879\u7269\u6599\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipCostInitOpValidator_38", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                } else {
                    stringBuilder.append(auxpty.getLong("id"));
                }
            }
        }
        if (stringBuilder.length() > 0) {
            String matKey = stringBuilder.toString();
            if (matRepeatMap.containsKey(matKey) && checkRepeat) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c%2$s\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u5bf9\u5e94\u7684\u201c\u5b50\u7269\u6599\u4fe1\u606f\u201d\u7b2c%3$s\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"WipCostInitOpValidator_39", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
            } else {
                matRepeatMap.put(matKey, j + 1);
            }
        }
    }

    private boolean checkQtyAmt(BigDecimal qty, BigDecimal amt) {
        return qty.compareTo(BigDecimal.ZERO) == 0 && amt.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) != 0 && amt.compareTo(BigDecimal.ZERO) != 0;
    }
}

