/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.realtime;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class MfgFeeRateSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("costcenter");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("effectstatus");
        fieldKeys.add("calctype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    QFilter[] qFilter;
                    boolean exists;
                    DynamicObject mfgRateBill = dataEntity.getDataEntity();
                    String calcType = mfgRateBill.getString("calctype");
                    DynamicObjectCollection entryEntity = mfgRateBill.getDynamicObjectCollection("entryentity");
                    boolean isResource = "R".equals(calcType);
                    if (CadEmptyUtils.isEmpty((List)entryEntity)) {
                        if (isResource) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u6309\u8d44\u6e90\u5de5\u65f6\u8ba1\u7b97\uff0c\u8d44\u6e90\u4e3a\u5fc5\u5f55\u3002", (String)"MfgFeeRateSaveOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u6309\u4ea7\u91cf\u8ba1\u7b97\uff0c\u4ea7\u54c1\u4e3a\u5fc5\u5f55\u3002", (String)"MfgFeeRateSaveOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        DynamicObject entity = (DynamicObject)entryEntity.get(i);
                        if (entity == null) continue;
                        if (isResource) {
                            if (entity.get("resource") != null) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c%s\u884c\uff1a\u201c\u8d44\u6e90\u201d\u3002", (String)"MfgFeeRateSaveOpPlugin_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        if (entity.get("material") != null) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c%s\u884c\uff1a\u201c\u4ea7\u54c1\u201d\u3002", (String)"MfgFeeRateSaveOpPlugin_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), i + 1));
                    }
                    this.checkRepeatData(dataEntity, isResource);
                    Date effectDate = mfgRateBill.getDate("effectdate");
                    if (effectDate == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"MfgFeeRateSaveOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0]));
                        return;
                    }
                    DynamicObject accountOrg = (DynamicObject)mfgRateBill.get("org");
                    if (accountOrg == null) {
                        return;
                    }
                    if (!MfgFeeRateSaveOpPlugin.this.isEnableEffectByOrg(accountOrg.getLong("id")) || !(exists = QueryServiceHelper.exists((String)"aca_mfgplanfeerate", (QFilter[])(qFilter = MfgFeeRateSaveOpPlugin.this.getQFilter(mfgRateBill)))) || effectDate.getTime() >= DateUtils.getDayStartTime((Date)new Date()).getTime()) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53d8\u66f4\u5355\u636e\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u5929\u65e5\u671f\u3002", (String)"MfgFeeRateSaveOpPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }

            private void checkRepeatData(ExtendedDataEntity data, boolean isResource) {
                DynamicObject dataEntity = data.getDataEntity();
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
                if (entryEntity == null) {
                    return;
                }
                HashMap<String, List> entryMapIndex = new HashMap<String, List>(16);
                int indexRow = 1;
                for (DynamicObject entry : entryEntity) {
                    String entryKey = isResource ? entry.getString("resource.id") + "@" + entry.getLong("subelement.id") : entry.getString("material.id") + "@" + entry.getLong("subelement.id");
                    entryMapIndex.computeIfAbsent(entryKey, s -> new ArrayList()).add(String.valueOf(indexRow));
                    ++indexRow;
                }
                StringBuffer sb = new StringBuffer();
                if (entryMapIndex.size() > 0) {
                    for (List indexList : entryMapIndex.values()) {
                        if (indexList.size() <= 1) continue;
                        indexList.forEach(s -> sb.append((String)s).append("\uff0c"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    if (isResource) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c %s \u884c\u8d44\u6e90+\u6210\u672c\u5b50\u8981\u7d20\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MfgFeeRateSaveOpPlugin_6", (String)"macc-aca-opplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
                    } else {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c %s \u884c\u4ea7\u54c1+\u6210\u672c\u5b50\u8981\u7d20\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MfgFeeRateSaveOpPlugin_7", (String)"macc-aca-opplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("attentryentity");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                if (entry.get("attelement") != null && entry.get("attsubelement") != null && !CadEmptyUtils.isEmpty((BigDecimal)entry.getBigDecimal("attrate"))) continue;
                iterator.remove();
            }
        }
    }

    private boolean isEnableEffectByOrg(Long orgId) {
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)"aca", (String)"aca_mfgplanfeerate");
    }

    private QFilter[] getQFilter(DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        if (org == null || costAccount == null) {
            return null;
        }
        String calcType = dataEntity.getString("calctype");
        QFilter[] filters = new QFilter[]{new QFilter("id", "!=", dataEntity.getPkValue()), new QFilter("org", "=", org.getPkValue()), new QFilter("costaccount", "=", costAccount.getPkValue()), new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()), new QFilter("calctype", "=", (Object)calcType), new QFilter("effectstatus", "=", (Object)"E")};
        return filters;
    }
}

