/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.subeleandmat;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.utils.TimeUtils;
import kd.macc.cad.common.helper.SysParamHelper;

public class SubElementAndMatUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SubElementAndMatUnAuditOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.getPropertys("aca_subelementandmat"));
        fieldKeys.addAll(this.getEntryPropertys("aca_subelementandmat", "entryentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Date date;
                    DynamicObject checkData = dataEntity.getDataEntity();
                    if (!SysParamHelper.getEnableEffectByOrg((Long)checkData.getLong("org.id"), (String)"aca", (String)"aca_subelementandmat").booleanValue() || (date = checkData.getDate("expdate")) == null || date.compareTo(new Date()) >= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7 %s \u7684\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\uff0c\u5982\u9700\u53cd\u5ba1\u6838\u8bf7\u5148\u5173\u95ed\u671f\u95f4\u5f00\u5173\u3002", (String)"SubElementAndMatUnAuditOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), checkData.getString("number")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Date opDate = new Date();
        ArrayList<DynamicObject> saveDataLIst = new ArrayList<DynamicObject>(dataEntities.length);
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)4);
        for (DynamicObject dataEntity : dataEntities) {
            Long orgId = dataEntity.getLong("org.id");
            orgIds.add(orgId);
            if (SysParamHelper.getEnableEffectByOrg((Long)dataEntity.getLong("org.id"), (String)"aca", (String)"aca_subelementandmat").booleanValue()) {
                DynamicObject newProductData = (DynamicObject)OrmUtils.clone((Object)dataEntity, (IDataEntityType)dataEntity.getDataEntityType(), (boolean)true, (boolean)true);
                String newNumber = newProductData.getString("number");
                newProductData.set("number", (Object)(newNumber + DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"ddHHmmss"})));
                newProductData.set("expdate", (Object)opDate);
                newProductData.set("status", (Object)"C");
                newProductData.set("sourceid", (Object)dataEntity.getLong("id"));
                saveDataLIst.add(newProductData);
                dataEntity.set("effectdate", (Object)opDate);
                Date invalidDate = dataEntity.getDate("expdate");
                if (invalidDate == null) {
                    dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
                }
            }
            dataEntity.set("audittime", null);
            dataEntity.set("auditor", null);
        }
        if (saveDataLIst.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveDataLIst.toArray(new DynamicObject[0]));
        }
        try {
            for (Long orgId : orgIds) {
                this.doInvokeBizService(orgId);
            }
        }
        catch (Exception ex) {
            logger.info("\u5237\u65b0\u7f13\u5b58\u62a5\u9519:{}", (Object)ex.getMessage());
        }
    }

    private void doInvokeBizService(Long orgId) {
        DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"clearSubElementConfigCache", (Object[])new Object[]{orgId});
    }

    private Set<String> getPropertys(String entryName) {
        return EntityMetadataCache.getDataEntityType((String)entryName).getFields().keySet();
    }

    private Set<String> getEntryPropertys(String entryName, String entry) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            if (!transField.getFullFieldName().startsWith(entry)) continue;
            String fieldName = transField.getFieldName();
            dateFields.add(fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName);
        }
        return dateFields;
    }
}

