/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.aca.business.wipadjust.WipAdjustBillService;
import kd.macc.cad.common.helper.PeriodHelper;

public class WipAdjustBillAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("period");
        fieldKeys.add("costaccount");
        fieldKeys.add("billno");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject bill : dataEntities) {
            Long billId = bill.getLong("id");
            idList.add(billId);
        }
        WipAdjustBillService service = new WipAdjustBillService();
        service.toCalcResult(idList);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                this.checkWipAdjustBill(dataEntities);
            }

            private void checkWipAdjustBill(ExtendedDataEntity[] dataEntities) {
                HashMap<Long, Long> costaccountMap = new HashMap<Long, Long>();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject wipAjustBill = dataEntity.getDataEntity();
                    String billno = wipAjustBill.getString("billno");
                    Long costAccountId = wipAjustBill.getLong("costaccount.id");
                    Long periodId = wipAjustBill.getLong("period.id");
                    if (0L == costAccountId) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"WipAdjustBillAuditOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (0L == periodId) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"WipAdjustBillAuditOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long currPeriod = (Long)costaccountMap.get(costAccountId);
                    if (currPeriod == null) {
                        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                        if (curPeriod != null) {
                            currPeriod = curPeriod.getLong("id");
                        }
                        costaccountMap.put(costAccountId, currPeriod);
                    }
                    if (periodId != null && currPeriod != null && Long.compare(periodId, currPeriod) == 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u6838\u7b97\u671f\u95f4 \u2260 \u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"WipAdjustBillAuditOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                }
            }
        });
    }
}

