/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.business.wipadjust.WipAdjustBillService;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class WipAdjustBillPushOpPlugin
extends AbstractOperationServicePlugIn {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("org");
        fields.add("billno");
        fields.add("billstatus");
        fields.add("costaccount");
        fields.add("period");
        fields.add("entryentity");
        fields.add("entryentity.adjustamt");
        fields.add("entryentity.subadjustid");
        fields.add("entryentity.subadjustbillno");
        fields.add("subitementry");
        fields.add("subitementry.sitemadjamt");
        fields.add("subitementry.sitemadjustid");
        fields.add("subitementry.sitemadjustbillno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                dataEntities = this.checkPush(dataEntities);
            }

            private ExtendedDataEntity[] checkPush(ExtendedDataEntity[] dataEntities) {
                ArrayList<ExtendedDataEntity> passList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
                HashMap costaccountMap = new HashMap(16);
                HashSet<Long> costAccountIds = new HashSet<Long>(16);
                HashSet<Long> adjustIds = new HashSet<Long>(16);
                HashMap costaccountItemMap = Maps.newHashMapWithExpectedSize((int)10);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Object entry2;
                    DynamicObject wipAjustBill = dataEntity.getDataEntity();
                    Long costAccountId = wipAjustBill.getLong("costaccount.id");
                    costAccountIds.add(costAccountId);
                    if (!costaccountItemMap.containsKey(costAccountId)) {
                        Boolean isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costAccountId);
                        costaccountItemMap.put(costAccountId, isViewSubItem);
                    }
                    DynamicObjectCollection entries = wipAjustBill.getDynamicObjectCollection("entryentity");
                    for (Object entry2 : entries) {
                        Long adjustbill = entry2.getLong("subadjustid");
                        if (adjustbill == 0L) continue;
                        adjustIds.add(adjustbill);
                    }
                    DynamicObjectCollection subitementry = wipAjustBill.getDynamicObjectCollection("subitementry");
                    entry2 = subitementry.iterator();
                    while (entry2.hasNext()) {
                        DynamicObject entry3 = (DynamicObject)entry2.next();
                        Long adjustbill = entry3.getLong("sitemadjustid");
                        if (adjustbill == 0L) continue;
                        adjustIds.add(adjustbill);
                    }
                }
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{new QFilter("id", "in", adjustIds)}, (String)"", (int)adjustIds.size());
                Map curPeriodMap = PeriodHelper.getAccountCurrentPeriod(costAccountIds);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long adjustbill;
                    BigDecimal adjustAmt;
                    DynamicObject wipAjustBill = dataEntity.getDataEntity();
                    String billstatus = wipAjustBill.getString("billstatus");
                    String billno = wipAjustBill.getString("billno");
                    if (!"C".equalsIgnoreCase(billstatus)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"WipAdjustBillPushOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long costAccountId = wipAjustBill.getLong("costaccount.id");
                    Long periodId = wipAjustBill.getLong("period.id");
                    if (costAccountId == null || Long.compare(0L, costAccountId) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"WipAdjustBillPushOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (periodId == null || Long.compare(0L, periodId) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"WipAdjustBillPushOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long currPeriod = (Long)costaccountMap.get(costAccountId);
                    if (currPeriod == null && curPeriodMap.get(costAccountId) != null) {
                        costaccountMap.put(costAccountId, curPeriodMap.get(costAccountId));
                        currPeriod = (Long)curPeriodMap.get(costAccountId);
                    }
                    if (periodId == null || currPeriod == null || Long.compare(periodId, currPeriod) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u6838\u7b97\u671f\u95f4 \u2260 \u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"WipAdjustBillPushOpPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    BigDecimal countAdjustAmt = BigDecimal.ZERO;
                    boolean isHasPushed = Boolean.FALSE;
                    if (!((Boolean)costaccountItemMap.get(costAccountId)).booleanValue()) {
                        DynamicObjectCollection entries = wipAjustBill.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entries) {
                            adjustAmt = entry.getBigDecimal("adjustamt");
                            countAdjustAmt = countAdjustAmt.add(adjustAmt);
                            adjustbill = entry.getLong("subadjustid");
                            if (!ids.contains(adjustbill)) continue;
                            isHasPushed = true;
                        }
                    } else {
                        DynamicObjectCollection subitementry = wipAjustBill.getDynamicObjectCollection("subitementry");
                        for (DynamicObject entry : subitementry) {
                            adjustAmt = entry.getBigDecimal("sitemadjamt");
                            if (adjustAmt != null && adjustAmt.compareTo(BigDecimal.ZERO) != 0) {
                                countAdjustAmt = adjustAmt;
                            }
                            if (!ids.contains(adjustbill = Long.valueOf(entry.getLong("sitemadjustid")))) continue;
                            isHasPushed = true;
                        }
                    }
                    if (isHasPushed) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u5355\u636e\u5df2\u4e0b\u63a8\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4e0b\u63a8\u3002", (String)"WipAdjustBillPushOpPlugin_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (countAdjustAmt.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u5355\u636e\u8c03\u6574\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"WipAdjustBillPushOpPlugin_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    passList.add(dataEntity);
                }
                return passList.toArray(new ExtendedDataEntity[0]);
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            String msg;
            HashSet<Long> orgIds = new HashSet<Long>(16);
            ArrayList<Long> ids = new ArrayList<Long>(10);
            ArrayList<Long> subItemIds = new ArrayList<Long>(10);
            HashMap costaccountItemMap = Maps.newHashMapWithExpectedSize((int)10);
            for (DynamicObject bill : dataEntities) {
                Long costAccountId = bill.getLong("costaccount.id");
                if (!costaccountItemMap.containsKey(costAccountId)) {
                    Boolean isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costAccountId);
                    costaccountItemMap.put(costAccountId, isViewSubItem);
                }
                orgIds.add(bill.getLong("org.id"));
                if (!((Boolean)costaccountItemMap.get(costAccountId)).booleanValue()) {
                    ids.add(bill.getLong("id"));
                    continue;
                }
                subItemIds.add(bill.getLong("id"));
            }
            WipAdjustBillService wipService = new WipAdjustBillService();
            Map result = null;
            if (!ids.isEmpty()) {
                result = wipService.pushWipAdjustBill(orgIds, ids);
            }
            Map itemResult = null;
            if (!subItemIds.isEmpty()) {
                itemResult = wipService.pushWipSubItemAdjustBill(orgIds, subItemIds);
            }
            String string = msg = result == null ? null : (String)result.get("fail");
            if (CadEmptyUtils.isEmpty((String)msg) && itemResult != null) {
                msg = (String)itemResult.get("fail");
            }
            if (CadEmptyUtils.isEmpty((String)msg) && result != null) {
                msg = (String)result.get("success");
            }
            if (CadEmptyUtils.isEmpty((String)msg) && itemResult != null) {
                msg = (String)itemResult.get("success");
            }
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = "success";
            }
            String opName = ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u5355 \u4e0b\u63a8", (String)"WipAdjustBillPushOpPlugin_8", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            WriteLogUtils.addLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)msg, (String)"aca_wipadjustbill");
        }
    }
}

