/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.aca.business.wipadjust.WipAdjustBillService;
import kd.macc.aca.common.helper.WipAdjustHelper;
import kd.macc.cad.common.helper.PeriodHelper;

public class WipAdjustBillUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(WipAdjustBillUnAuditOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("costobject");
        fieldKeys.add("period");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("costcenter");
        fieldKeys.add("billno");
        fieldKeys.add("adjusttype");
        fieldKeys.add("entryentity.subadjustid");
        fieldKeys.add("entryentity.subadjustbillno");
        fieldKeys.add("source");
        fieldKeys.add("vouchernum");
        fieldKeys.add("subitementry.sitemadjustid");
        fieldKeys.add("subitementry.sitemadjustbillno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if ((dataEntities = this.checkWipAdjustBill(dataEntities)).length > 0) {
                    ExtendedDataEntity data = dataEntities[0];
                    this.checkFinishDiff(dataEntities);
                }
            }

            private ExtendedDataEntity[] checkFinishDiff(ExtendedDataEntity[] dataEntities) {
                Long costAdjustId;
                DynamicObjectCollection entryEntity;
                HashSet<Long> costAdjustIds = new HashSet<Long>(16);
                ArrayList<ExtendedDataEntity> list = new ArrayList<ExtendedDataEntity>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Object entry2;
                    entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
                    for (Object entry2 : entryEntity) {
                        Long costAdjustId2 = entry2.getLong("subadjustid");
                        if (costAdjustId2 == null || Long.compare(0L, costAdjustId2) == 0) continue;
                        costAdjustIds.add(costAdjustId2);
                    }
                    DynamicObjectCollection subitementry = dataEntity.getDataEntity().getDynamicObjectCollection("subitementry");
                    entry2 = subitementry.iterator();
                    while (entry2.hasNext()) {
                        DynamicObject entry3 = (DynamicObject)entry2.next();
                        costAdjustId = entry3.getLong("sitemadjustid");
                        if (costAdjustId == null || Long.compare(0L, costAdjustId) == 0) continue;
                        costAdjustIds.add(costAdjustId);
                    }
                    list.add(dataEntity);
                }
                Map idAndAjustMap = WipAdjustHelper.getIdAndAjustMap(costAdjustIds);
                ArrayList<ExtendedDataEntity> passList = new ArrayList<ExtendedDataEntity>(list.size());
                for (ExtendedDataEntity dataEntity : list) {
                    entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
                    boolean isSuccess = true;
                    for (DynamicObject entry3 : entryEntity) {
                        DynamicObject obj;
                        costAdjustId = entry3.getLong("subadjustid");
                        if (costAdjustId == null || Long.compare(0L, costAdjustId) == 0 || this.checkAdjustBill(obj = (DynamicObject)idAndAjustMap.get(costAdjustId), dataEntity)) continue;
                        isSuccess = false;
                    }
                    DynamicObjectCollection subitementry = dataEntity.getDataEntity().getDynamicObjectCollection("subitementry");
                    for (DynamicObject entry : subitementry) {
                        DynamicObject obj;
                        Long costAdjustId3 = entry.getLong("sitemadjustid");
                        if (costAdjustId3 == null || Long.compare(0L, costAdjustId3) == 0 || this.checkAdjustBill(obj = (DynamicObject)idAndAjustMap.get(costAdjustId3), dataEntity)) continue;
                        isSuccess = false;
                    }
                    if (!isSuccess) continue;
                    passList.add(dataEntity);
                }
                return passList.toArray(new ExtendedDataEntity[0]);
            }

            private boolean checkAdjustBill(DynamicObject adustBill, ExtendedDataEntity dataEntity) {
                if (adustBill != null) {
                    boolean isvoucher = adustBill.getBoolean("isvoucher");
                    String wipBillno = adustBill.getString("billno");
                    if (isvoucher) {
                        String voucher = adustBill.getString("vouchernum");
                        String adjustBillNo = adustBill.getString("billno");
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c%1$s\uff1a\u5173\u8054\u7684\u6210\u672c\u8c03\u8282\u5355%2$s\uff0c\u5df2\u751f\u6210\u51ed\u8bc1%3$s\u3002", (String)"WipAdjustBillUnAuditOpPlugin_9", (String)"macc-aca-opplugin", (Object[])new Object[0]), wipBillno, adjustBillNo, voucher));
                        return false;
                    }
                }
                return true;
            }

            private ExtendedDataEntity[] checkWipAdjustBill(ExtendedDataEntity[] dataEntities) {
                ArrayList<ExtendedDataEntity> passList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
                HashMap<Long, Long> costaccountMap = new HashMap<Long, Long>();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject wipAjustBill = dataEntity.getDataEntity();
                    String billstatus = wipAjustBill.getString("billstatus");
                    String billno = wipAjustBill.getString("billno");
                    String voucherNum = wipAjustBill.getString("vouchernum");
                    if (!StringUtils.isBlank((String)voucherNum)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"WipAdjustBillUnAuditOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (!"C".equalsIgnoreCase(billstatus)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"WipAdjustBillUnAuditOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long costAccountId = wipAjustBill.getLong("costaccount.id");
                    Long periodId = wipAjustBill.getLong("period.id");
                    if (costAccountId == null || Long.compare(0L, costAccountId) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"WipAdjustBillUnAuditOpPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (periodId == null || Long.compare(0L, periodId) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"WipAdjustBillUnAuditOpPlugin_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long currPeriod = (Long)costaccountMap.get(costAccountId);
                    if (currPeriod == null) {
                        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                        if (curPeriod != null) {
                            currPeriod = curPeriod.getLong("id");
                        }
                        costaccountMap.put(costAccountId, currPeriod);
                    }
                    if (periodId == null || currPeriod == null || Long.compare(periodId, currPeriod) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u6838\u7b97\u671f\u95f4 \u2260 \u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"WipAdjustBillUnAuditOpPlugin_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    passList.add(dataEntity);
                }
                return passList.toArray(new ExtendedDataEntity[0]);
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            DynamicObject dy = dataEntities[0];
            String adjustType = dy.getString("adjusttype");
            Set failWipIds = this.getService().deleteCostAudit(dataEntities);
            dataEntities = this.getSuccessList(failWipIds, dataEntities);
            this.getService().updateCalcResultBill(dataEntities, adjustType);
            this.getService().updateWipAdjustInfo(dataEntities);
            logger.info("\u53cd\u5ba1\u6838\u6210\u529f {} \u5f20", (Object)dataEntities.length);
        }
    }

    private DynamicObject[] getSuccessList(Set<Long> failWipIds, DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            Long wipId = (Long)bill.getPkValue();
            if (failWipIds.contains(wipId)) {
                String wipBillno = bill.getString("billno");
                OperateErrorInfo errInfo = new OperateErrorInfo();
                errInfo.setPkValue((Object)wipId);
                errInfo.setLevel(ErrorLevel.Error);
                errInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\uff1a\u5173\u8054\u7684\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u3002", (String)"WipAdjustBillUnAuditOpPlugin_7", (String)"macc-aca-opplugin", (Object[])new Object[0]), wipBillno));
                this.getOperationResult().addErrorInfo(errInfo);
                continue;
            }
            successList.add(bill);
        }
        return successList.toArray(new DynamicObject[0]);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ExtendedDataEntity dataone;
        String adjustType;
        super.beforeExecuteOperationTransaction(e);
        List dataEntities = e.getValidExtDataEntities();
        if (dataEntities.size() > 0 && "END".equalsIgnoreCase(adjustType = (dataone = (ExtendedDataEntity)dataEntities.get(0)).getDataEntity().getString("adjusttype"))) {
            List<ExtendedDataEntity> successDataEntities = this.unAuditCostAdjustBill(dataEntities);
            e.getValidExtDataEntities().clear();
            e.getValidExtDataEntities().addAll(successDataEntities);
        }
    }

    private List<ExtendedDataEntity> unAuditCostAdjustBill(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> successList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Set srcFailWipIds = this.getService().unauditCostAdjustBill(dataEntities);
        if (srcFailWipIds.isEmpty()) {
            return new ArrayList<ExtendedDataEntity>(dataEntities);
        }
        HashMap<Long, DynamicObject> wipAdjustIdAndBillMap = new HashMap<Long, DynamicObject>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            Long dataId = (Long)dataEntity.getDataEntity().getPkValue();
            wipAdjustIdAndBillMap.put(bill.getLong("id"), bill);
            if (srcFailWipIds.contains(dataId)) continue;
            successList.add(dataEntity);
        }
        for (Long wipId : srcFailWipIds) {
            DynamicObject dy = (DynamicObject)wipAdjustIdAndBillMap.get(wipId);
            String wipBillno = "";
            if (dy != null) {
                wipBillno = dy.getString("billno");
            }
            OperateErrorInfo errInfo = new OperateErrorInfo();
            errInfo.setPkValue((Object)wipId);
            errInfo.setLevel(ErrorLevel.Error);
            errInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\uff1a\u5173\u8054\u7684\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"WipAdjustBillUnAuditOpPlugin_8", (String)"macc-aca-opplugin", (Object[])new Object[0]), wipBillno));
            this.getOperationResult().addErrorInfo(errInfo);
        }
        return successList;
    }

    private WipAdjustBillService getService() {
        return new WipAdjustBillService();
    }
}

