/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.common.constants.WipAdjustSubItem;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class WipAdjustBillZeroOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costaccount");
        fieldKeys.add("wipqty");
        fieldKeys.add("adjustqty");
        fieldKeys.add("afteradjustqty");
        fieldKeys.add("billstatus");
        fieldKeys.add("entryentity");
        fieldKeys.add("period");
        fieldKeys.add("entryentity.element");
        fieldKeys.add("entryentity.subelement");
        fieldKeys.add("entryentity.outsourcetype");
        fieldKeys.add("entryentity.wipamt");
        fieldKeys.add("entryentity.adjustamt");
        fieldKeys.add("entryentity.afteradjustamt");
        fieldKeys.add("entryentity.importtype");
        fieldKeys.add("subentryentity");
        fieldKeys.add("subentryentity.submatamt");
        fieldKeys.add("subentryentity.submatadjamt");
        fieldKeys.add("subentryentity.aftersubmatadjamt");
        fieldKeys.add("subentryentity.sadjustamt");
        fieldKeys.add("subentryentity.safteradjustamt");
        fieldKeys.add("subentryentity.subitemjson_tag");
        fieldKeys.add("subentryentity.submatqty");
        fieldKeys.add("subentryentity.submatadjqty");
        fieldKeys.add("subentryentity.aftersubmatadjqty");
        fieldKeys.add("subitementry");
        fieldKeys.add("subitementry.sitemelement");
        fieldKeys.add("subitementry.sitemsubelement");
        fieldKeys.add("subitementry.sitemoutsourcetype");
        fieldKeys.add("subitementry.sitemwipamt");
        fieldKeys.add("subitementry.sitemadjamt");
        fieldKeys.add("subitementry.sitemafteradjamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<Long, Long> costaccountMap = new HashMap<Long, Long>();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject wipAjustZeroBill = dataEntity.getDataEntity();
                    String billstatus = wipAjustZeroBill.getString("billstatus");
                    String billno = wipAjustZeroBill.getString("billno");
                    if ("B".equals(billstatus) || "C".equals(billstatus)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u8c03\u96f6\u3002", (String)"WipAdjustBillZeroOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long costAccountId = wipAjustZeroBill.getLong("costaccount.id");
                    Long periodId = wipAjustZeroBill.getLong("period.id");
                    if (costAccountId == null || Long.compare(0L, costAccountId) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"WipAdjustBillZeroOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (periodId == null || Long.compare(0L, periodId) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"WipAdjustBillZeroOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                        continue;
                    }
                    Long currPeriod = (Long)costaccountMap.get(costAccountId);
                    if (currPeriod == null) {
                        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                        if (curPeriod != null) {
                            currPeriod = curPeriod.getLong("id");
                        }
                        costaccountMap.put(costAccountId, currPeriod);
                    }
                    if (periodId != null && currPeriod != null && Long.compare(periodId, currPeriod) == 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u6838\u7b97\u671f\u95f4\u4e0d\u7b49\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u8c03\u96f6\u3002", (String)"WipAdjustBillZeroOpPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> wipqtyList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> dataEntitieList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> dataSubEntitieList = new ArrayList<DynamicObject>(10);
        if (e.getOperationKey().equalsIgnoreCase("adjust_zero")) {
            for (DynamicObject dyn : dataEntities) {
                dyn.set("adjustqty", (Object)dyn.getBigDecimal("wipqty").negate());
                dyn.set("afteradjustqty", (Object)BigDecimal.ZERO);
                wipqtyList.add(dyn);
                DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                    if (subentryentity != null && !subentryentity.isEmpty()) {
                        for (DynamicObject subentry : subentryentity) {
                            String json = subentry.getString("subitemjson_tag");
                            List subItems = new ArrayList(10);
                            if (!StringUtils.isEmpty((String)json)) {
                                subItems = JSON.parseArray((String)json, WipAdjustSubItem.class);
                            }
                            BigDecimal submatamt = BigDecimalUtil.getOrZero((Object)subentry.getBigDecimal("submatamt"));
                            BigDecimal submatqty = BigDecimalUtil.getOrZero((Object)subentry.getBigDecimal("submatqty"));
                            subentry.set("submatadjamt", (Object)submatamt.negate());
                            subentry.set("aftersubmatadjamt", (Object)submatamt.add(submatamt.negate()));
                            subentry.set("submatadjqty", (Object)submatqty.negate());
                            subentry.set("aftersubmatadjqty", (Object)BigDecimal.ZERO);
                            if (!CadEmptyUtils.isEmpty(subItems)) {
                                subItems.forEach(subitem -> {
                                    BigDecimal swipamt = subitem.getSwipamt();
                                    subitem.setSadjustamt(swipamt.negate());
                                    subitem.setSafteradjustamt(swipamt.add(swipamt.negate()));
                                });
                            }
                            subentry.set("subitemjson_tag", (Object)JSONObject.toJSONString(subItems));
                            dataSubEntitieList.add(subentry);
                        }
                    }
                    BigDecimal wipAmt = BigDecimalUtil.getOrZero((Object)entry.getBigDecimal("wipamt"));
                    entry.set("adjustamt", (Object)wipAmt.negate());
                    entry.set("afteradjustamt", (Object)wipAmt.add(wipAmt.negate()));
                    dataEntitieList.add(entry);
                }
            }
            SaveServiceHelper.update((DynamicObject[])wipqtyList.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])dataEntitieList.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])dataSubEntitieList.toArray(new DynamicObject[0]));
        }
    }
}

