/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipcostcheck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckUnAuditPluginValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashSet<Long> accountIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            Long orgId = data.getLong("org.id");
            Long costaccountId = data.getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)orgId) || costaccountId == null) continue;
            orgIdSet.add(orgId);
            accountIdSet.add(costaccountId);
        }
        Map<String, Long> currPeriodMap = this.getCurrPeriodAndDate(orgIdSet, accountIdSet);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long currPeriod;
            DynamicObject data = dataEntity.getDataEntity();
            Long orgId = data.getLong("org.id");
            Long periodId = data.getLong("period.id");
            Long costaccountId = data.getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)orgId) || costaccountId == null || periodId == null || !CadEmptyUtils.isEmpty((Long)(currPeriod = currPeriodMap.get(orgId + "@" + costaccountId))) && Long.compare(currPeriod, periodId) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u53cd\u5ba1\u6838\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u4ee5\u524d\u671f\u95f4\u7684\u5355\u636e\u3002", (String)"TerminalWipMatCheckUnAuditPluginValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Long> getCurrPeriodAndDate(Set<Long> orgId, Set<Long> costAccountId) {
        HashMap<String, Long> currPeriodMap = new HashMap<String, Long>(16);
        QFilter qfOrg = new QFilter("org", "in", orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "in", costAccountId);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DataSet res = QueryServiceHelper.queryDataSet((String)"TerminalWipMat", (String)"cal_sysctrlentity", (String)"org,entry.costaccount as costaccount,entry.currentperiod as currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter}, null);
        while (res.hasNext()) {
            Row next = res.next();
            Long org = next.getLong("org");
            Long costaccount = next.getLong("costaccount");
            Long currentperiod = next.getLong("currentperiod");
            currPeriodMap.put(org + "@" + costaccount, currentperiod);
        }
        return currPeriodMap;
    }
}

