/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipcostcheck;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.business.wipcostcheck.WipCostCheckService;

public class WipCostCheckImportPlugin
extends BatchImportPlugin {
    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("keyfields");
        lockKeys.add("flexpanelap6");
        return lockKeys;
    }

    public String getDefaultImportType() {
        return "overridenew";
    }

    public String getDefaultKeyFields() {
        return "org".concat(",").concat("manuorg").concat(",").concat("costcenter").concat(",").concat("costaccount").concat(",").concat("period").concat(",").concat("costobject");
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"WipCostCheckImportPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0])), "org"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"WipCostCheckImportPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0])), "manuorg"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"WipCostCheckImportPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0])), "costcenter"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"WipCostCheckImportPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0])), "costaccount"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4", (String)"WipCostCheckImportPlugin_4", (String)"macc-aca-opplugin", (Object[])new Object[0])), "period"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"WipCostCheckImportPlugin_5", (String)"macc-aca-opplugin", (Object[])new Object[0])), "costobject"));
        return items;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Map option = this.ctx.getOption();
        if (option != null) {
            Object importtype = option.get("importtype");
            String orgNumber = null;
            String costaccountNumber = null;
            HashSet<String> manuorgNumSet = new HashSet<String>(billdatas.size());
            HashSet<String> costcenterNumSet = new HashSet<String>(billdatas.size());
            HashSet<String> costobjectNumSet = new HashSet<String>(billdatas.size());
            for (ImportBillData billdata : billdatas) {
                JSONObject costobject;
                JSONObject costcenter;
                JSONObject costaccount;
                JSONObject data = billdata.getData();
                JSONObject org = data.getJSONObject("org");
                if (org == null || (costaccount = data.getJSONObject("costaccount")) == null) continue;
                String excelOrgNum = org.getString("number");
                if (orgNumber == null) {
                    orgNumber = excelOrgNum;
                } else if (!orgNumber.equals(excelOrgNum)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u662f\u540c\u4e00\u4e2a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f15\u5165\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_6", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
                excelOrgNum = costaccount.getString("number");
                if (costaccountNumber == null) {
                    costaccountNumber = excelOrgNum;
                } else if (!costaccountNumber.equals(excelOrgNum)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7684\u6210\u672c\u8d26\u7c3f\u4e0d\u662f\u540c\u4e00\u4e2a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f15\u5165\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
                JSONObject manuorg = data.getJSONObject("manuorg");
                if (manuorg != null) {
                    manuorgNumSet.add(manuorg.getString("number"));
                }
                if ((costcenter = data.getJSONObject("costcenter")) != null) {
                    costcenterNumSet.add(costcenter.getString("number"));
                }
                if ((costobject = data.getJSONObject("costobject")) == null) continue;
                costobjectNumSet.add(costobject.getString("billno"));
            }
            HashMap numToIds = new HashMap(billdatas.size() * 2);
            DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"WipCostCheckImportPlugin", (String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", manuorgNumSet)}, null);
            orgDataSet.forEach(o -> {
                String number = o.getString("number");
                number = StringUtils.isEmpty((Object)number) ? "manuorg" : number + "manuorg";
                numToIds.put(number, o.getLong("id"));
            });
            DataSet costcenterDataSet = QueryServiceHelper.queryDataSet((String)"WipCostCheckImportPlugin", (String)"bos_costcenter", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", costcenterNumSet)}, null);
            costcenterDataSet.forEach(o -> {
                String number = o.getString("number");
                number = StringUtils.isEmpty((Object)number) ? "center" : number + "center";
                numToIds.put(number, o.getLong("id"));
            });
            DataSet costobjectDataSet = QueryServiceHelper.queryDataSet((String)"WipCostCheckImportPlugin", (String)"cad_costobjectf7", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", costobjectNumSet)}, null);
            costobjectDataSet.forEach(o -> {
                String number = o.getString("billno");
                number = StringUtils.isEmpty((Object)number) ? "cost" : number + "cost";
                numToIds.put(number, o.getLong("id"));
            });
            List orgList = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)}, null, (int)2);
            if (orgList.size() != 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7\u4e3a %s \u7684\u7f16\u53f7\u4e0d\u552f\u4e00,\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_8", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber));
            }
            Long orgId = (Long)orgList.get(0);
            List costaccountList = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costaccountNumber)}, null, (int)2);
            if (costaccountList.size() != 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u4e3a %s \u7684\u7f16\u53f7\u4e0d\u552f\u4e00,\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_22", (String)"macc-aca-opplugin", (Object[])new Object[0]), costaccountNumber));
            }
            Long costAccountId = (Long)costaccountList.get(0);
            DynamicObject period = this.getPeriod(orgId, costAccountId);
            if (period == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u548c\u201c\u6210\u672c\u8d26\u7c3f\u201d\u672a\u7ef4\u62a4\u6838\u7b97\u671f\u95f4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_10", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
            WipCostCheckService wipCostCheckService = new WipCostCheckService();
            DataSet fullDataSet = wipCostCheckService.loadDataByCondition(orgId, Long.valueOf(0L), costAccountId, new HashSet(), period);
            Map checkNumMap = wipCostCheckService.loadDataDataSetConvertMap(fullDataSet);
            Iterator<ImportBillData> iterator = billdatas.iterator();
            StringBuilder keyBuilder = new StringBuilder();
            HashSet<String> sameData = new HashSet<String>();
            while (iterator.hasNext()) {
                keyBuilder.setLength(0);
                ImportBillData billdata = iterator.next();
                JSONObject data = billdata.getData();
                JSONObject org = data.getJSONObject("org");
                if (org == null) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"WipCostCheckImportPlugin_11", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                String orgnum = org.getString("number");
                if (StringUtils.isEmpty((Object)orgnum)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7\u3002", (String)"WipCostCheckImportPlugin_12", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                JSONObject manuorg = data.getJSONObject("manuorg");
                if (manuorg == null) {
                    keyBuilder.append(0L).append("@");
                } else {
                    String number = manuorg.getString("number");
                    number = StringUtils.isEmpty((Object)number) ? "manuorg" : number + "manuorg";
                    keyBuilder.append(numToIds.get(number)).append("@");
                }
                JSONObject costaccount = data.getJSONObject("costaccount");
                if (costaccount == null) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"WipCostCheckImportPlugin_13", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                String costaccountnum = costaccount.getString("number");
                if (StringUtils.isEmpty((Object)costaccountnum)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u3002", (String)"WipCostCheckImportPlugin_23", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                if (period == null) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u548c\u201c\u6210\u672c\u8d26\u7c3f\u201d\u672a\u7ef4\u62a4\u6838\u7b97\u671f\u95f4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_10", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("importprop", (Object)"id");
                jsonObject.put("id", (Object)period.getLong("currentperiod"));
                data.put("period", (Object)jsonObject);
                JSONObject costcenter = data.getJSONObject("costcenter");
                if (costcenter == null) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u4e2d\u5fc3\u4fe1\u606f\u3002", (String)"WipCostCheckImportPlugin_15", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                String orgnum2 = costcenter.getString("number");
                if (StringUtils.isEmpty((Object)orgnum2)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u4e2d\u5fc3\u7f16\u53f7\u3002", (String)"WipCostCheckImportPlugin_16", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                keyBuilder.append(numToIds.get(orgnum2 + "center")).append("@");
                JSONObject costobject = data.getJSONObject("costobject");
                if (costobject == null) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f\u3002", (String)"WipCostCheckImportPlugin_17", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                String orgnum3 = costobject.getString("billno");
                if (StringUtils.isEmpty((Object)orgnum3)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u3002", (String)"WipCostCheckImportPlugin_24", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                keyBuilder.append(numToIds.get(orgnum3 + "cost"));
                String key = keyBuilder.toString();
                if (sameData.contains(key)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u5728\u672c\u6b21\u4fdd\u5b58\u4e2d,\u5b58\u5728\u4e0e\u672c\u6761\u6570\u636e\u76f8\u540c\u7684,\u6838\u7b97\u7ec4\u7ec7,\u751f\u4ea7\u7ec4\u7ec7,\u6210\u672c\u4e2d\u5fc3,\u8d26\u7c3f,\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u6570\u636e\u3002", (String)"WipCostCheckImportPlugin_19", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                sameData.add(key);
                BigDecimal checkNum = (BigDecimal)checkNumMap.get(key);
                if (checkNum == null) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u6838\u7b97\u7ec4\u7ec7,\u6210\u672c\u4e2d\u5fc3,\u6210\u672c\u8d26\u7c3f\u672c\u671f\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u6570\u636e,\u65e0\u6cd5\u5f15\u5165\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckImportPlugin_20", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                BigDecimal importCheckNum = data.getBigDecimal("checknum");
                if (importCheckNum != null && checkNum.compareTo(importCheckNum) == 0) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u5b9e\u76d8\u6570\u91cf\u548c\u8ba1\u7b97\u7ed3\u679c\u4e00\u81f4,\u65e0\u9700\u5f15\u5165\u3002", (String)"WipCostCheckImportPlugin_21", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("importprop", (Object)"id");
                jsonObject2.put("id", (Object)Long.valueOf(RequestContext.get().getUserId()));
                data.put("modifier", (Object)jsonObject2);
                data.put("modifytime", (Object)new Date());
            }
        }
    }

    private DynamicObject getPeriod(Long orgId, Long costaccountId) {
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costaccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,entry.currentperiod.id currentperiod,entry.currentperiod.begindate as begindate,entry.currentperiod.enddate as enddate", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            return (DynamicObject)cal_sysctrlentity.get(0);
        }
        return null;
    }
}

