/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.olap.util.Pair;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.alloc.MatAllocProcessor;
import kd.macc.aca.algox.alloc.WipCostCheckService;
import kd.macc.aca.algox.alloc.function.MatAllocFunction;
import kd.macc.aca.algox.alloc.input.AllocDataParameter;
import kd.macc.aca.algox.alloc.output.AllocResult;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.algox.utils.AcaAlgoxElementHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.AcaCalcRangeHelper;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.aca.algox.utils.FormulaUtil;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.algox.utils.ProgressHelper;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.dto.AllocReport;
import kd.macc.cad.common.helper.AllocReportHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.MultiPartCcHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class AcaMatAllocHelper {
    private static final Log logger = LogFactory.getLog(AcaMatAllocHelper.class);
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String OPERATOR = "+-*/()";
    private static final Long ACA_COST_TYPE_ID = 957770985921275904L;
    private static final Long MAT_QUOTA_Id = 1554353182669544448L;
    public static final String fields = "id, billno,bookdate as bizdate, org, manuorg, costcenter, biztype,srcbiztype,appnum,sourcebillid,srcbilltype,entryentity.id As entryid, entryentity.seq As seq, entryentity.material As material, entryentity.material.baseunit As baseunit, entryentity.material.isenablematerialversion AS isusematver, entryentity.material.isuseauxpty AS isuseauxpty, entryentity.material.group As materialgroup, entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.productnum AS productnum,entryentity.subproductnum AS subproductnum,entryentity.lotcoderule AS lotcoderule,entryentity.configuredcode AS configuredcode,entryentity.tracknumber AS tracknumber,entryentity.project AS project,entryentity.qty AS qty, entryentity.warehouse AS warehouse, entryentity.location AS location,entryentity.costobject AS costobject, entryentity.costobject.material.id AS promaterial,entryentity.unit AS unit,entryentity.productgroup AS productgroup,entryentity.sourcebillentryid AS sourcebillentryid,entryentity.isrework AS isrework,entryentity.product AS product";

    private static void validateAllocResultStatus(Set<Long> allocIds, AllocResult allocResult) {
        QFilter filter = new QFilter("id", "in", allocIds);
        filter.and(new QFilter("entryentity.id", ">", (Object)1L));
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"aca_matalloc", (String)"id", (QFilter[])new QFilter[]{filter});
        Map<String, String> map = allocResult.getReasonMap();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (Long id : allocIds) {
            boolean result = false;
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(entrys)) {
                for (DynamicObject entry : entrys) {
                    if (!id.equals(entry.getLong("id"))) continue;
                    result = true;
                    break;
                }
            }
            if (result) continue;
            map.computeIfAbsent(id.toString(), s -> "error");
        }
        allocResult.setReasonMap(map);
    }

    public static AllocResult doAlloc(Set<Long> allocIds, String allocStatus, AllocReport report) {
        AllocResult allocResult;
        block11: {
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u6279\u91cf\u5206\u914d\uff0c\u53ef\u81ea\u5b9a\u4e49\u5206\u914d\u72b6\u6001\uff1a{}", (Object)allocIds.toString());
            boolean needSave = false;
            if (report == null) {
                needSave = true;
                report = AllocReportHelper.initReport((long)0L, (long)0L, (long)0L, (long)0L, (String)"8", (String)"aca");
            }
            AllocDataParameter param = AcaMatAllocHelper.wrapParam(allocIds, report);
            if (!StringUtils.isEmpty((CharSequence)allocStatus)) {
                param.setAllocStatus(allocStatus);
            }
            AllocResult allocResult2 = null;
            String errorMsg = null;
            try {
                MatAllocProcessor allocProcessor = new MatAllocProcessor();
                allocProcessor.setAllocFunction(new MatAllocFunction());
                allocResult2 = allocProcessor.allocate(param, report);
                AcaMatAllocHelper.validateAllocResultStatus(allocIds, allocResult2);
                allocResult = allocResult2;
                if (report == null) break block11;
            }
            catch (Exception ex) {
                try {
                    errorMsg = ex.getMessage();
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (report != null) {
                        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                            AllocReportHelper.addCheckDatail((AllocReport)report, null, (long)0L, (String)errorMsg);
                        }
                        if (needSave && allocResult2 != null) {
                            AllocReportHelper.saveReport((AllocReport)report);
                            allocResult2.getReportIds().add(report.getReportId());
                            allocResult2.setReportContainError(!"1".equals(report.getStatus()));
                        }
                    }
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                AllocReportHelper.addCheckDatail((AllocReport)report, null, (long)0L, (String)errorMsg);
            }
            if (needSave && allocResult2 != null) {
                AllocReportHelper.saveReport((AllocReport)report);
                allocResult2.getReportIds().add(report.getReportId());
                allocResult2.setReportContainError(!"1".equals(report.getStatus()));
            }
        }
        return allocResult;
    }

    public static AllocResult doAlloc(Set<Long> allocIds, String allocStatus) {
        return AcaMatAllocHelper.doAlloc(allocIds, allocStatus, null);
    }

    public static AllocResult doAlloc(Set<Long> allocIds) {
        return AcaMatAllocHelper.doAlloc(allocIds, null);
    }

    public static AllocResult doAlloc(DynamicObject alloc) {
        return AcaMatAllocHelper.doAlloc(alloc, null);
    }

    public static AllocResult doAlloc(DynamicObject alloc, AllocReport report) {
        AllocResult allocResult;
        block10: {
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u5355\u4e2a\u5b9e\u65f6\u5206\u914d\uff1a{}", (Object)alloc.getString("id"));
            boolean needSave = false;
            if (report == null) {
                needSave = true;
                report = AllocReportHelper.initReport((long)0L, (long)0L, (long)0L, (long)0L, (String)"8", (String)"aca");
            }
            AllocResult allocResult2 = null;
            String errorMsg = null;
            try {
                AllocDataParameter param = AcaMatAllocHelper.wrapParam(alloc, report);
                MatAllocProcessor allocProcessor = new MatAllocProcessor();
                allocProcessor.setAllocFunction(new MatAllocFunction());
                allocResult = allocProcessor.allocate(param, report);
                if (report == null) break block10;
            }
            catch (Exception ex) {
                try {
                    errorMsg = ex.getMessage();
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (report != null) {
                        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                            AllocReportHelper.addCheckDatail((AllocReport)report, null, (long)0L, (String)errorMsg);
                        }
                        if (needSave && allocResult2 != null) {
                            AllocReportHelper.saveReport((AllocReport)report);
                            allocResult2.getReportIds().add(report.getReportId());
                            allocResult2.setReportContainError(!"1".equals(report.getStatus()));
                        }
                    }
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                AllocReportHelper.addCheckDatail((AllocReport)report, null, (long)0L, (String)errorMsg);
            }
            if (needSave && allocResult2 != null) {
                AllocReportHelper.saveReport((AllocReport)report);
                allocResult2.getReportIds().add(report.getReportId());
                allocResult2.setReportContainError(!"1".equals(report.getStatus()));
            }
        }
        return allocResult;
    }

    private static AllocDataParameter wrapParam(Set<Long> allocIds, AllocReport report) {
        HashMap<Long, Map<String, Object>> allocMap = new HashMap<Long, Map<String, Object>>();
        Map collDataMap = null;
        Map matIdToPiarMap = null;
        HashSet<Long> productGroups = new HashSet<Long>(16);
        Tuple<Map<Long, Map<Long, Set<String>>>, Map<String, String>> collDataTuple = AcaMatAllocHelper.getCollData(allocIds, allocMap, productGroups, report);
        HashMap<Long, Set<String>> otherPgMap = new HashMap(16);
        if (!CadEmptyUtils.isEmpty(productGroups)) {
            otherPgMap = AcaMatAllocHelper.queryProductGroupDs(productGroups);
        }
        if (collDataTuple != null) {
            collDataMap = (Map)collDataTuple.item1;
            matIdToPiarMap = (Map)collDataTuple.item2;
        }
        return AcaMatAllocHelper.wrapParam(allocMap, collDataMap, matIdToPiarMap, otherPgMap, null);
    }

    private static Map<Long, Set<String>> queryProductGroupDs(Set<Long> productGroups) {
        HashMap<Long, Set<String>> otherPgMap = new HashMap<Long, Set<String>>(16);
        QFilter idQFilter = new QFilter("id", "in", productGroups);
        QFilter groupType = new QFilter("grouptype", "=", (Object)"3");
        DataSet otherPgDs = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper", (String)"cad_productintogroup", (String)"id productgroup,entryentity.material material,entryentity.auxpty auxpty", (QFilter[])new QFilter[]{idQFilter, groupType}, (String)"id desc");
        if (otherPgDs != null && !otherPgDs.isEmpty()) {
            for (Row row : otherPgDs) {
                Long productgroup = row.getLong("productgroup");
                Long material = row.getLong("material");
                Long auxpty = row.getLong("auxpty");
                String key = String.format("%s@%s", material, auxpty);
                otherPgMap.computeIfAbsent(productgroup, val -> new HashSet()).add(key);
            }
        }
        return otherPgMap;
    }

    private static AllocDataParameter wrapParam(DynamicObject alloc, AllocReport report) {
        HashMap<Long, Map<String, Object>> allocMap = new HashMap<Long, Map<String, Object>>();
        Map itemMap = allocMap.computeIfAbsent(alloc.getLong("id"), s -> new HashMap());
        DynamicObject org = alloc.getDynamicObject("org");
        Long ccId = alloc.getDynamicObject("costcenter").getLong("id");
        DynamicObject costdriver = alloc.getDynamicObject("costdriver");
        itemMap.put("id", alloc.getLong("id"));
        itemMap.put("org", org.getLong("id"));
        itemMap.put("costcenter", ccId);
        DynamicObject period = alloc.getDynamicObject("period");
        if (period != null) {
            itemMap.put("begindate", alloc.getDynamicObject("period").getDate("begindate"));
            itemMap.put("enddate", alloc.getDynamicObject("period").getDate("enddate"));
            itemMap.put("periodId", period.getLong("id"));
        }
        itemMap.put("stdnumber", costdriver.getString("number"));
        itemMap.put("costdriver", costdriver.getLong("id"));
        itemMap.put("allocdim", alloc.getString("allocdim"));
        Long materialId = alloc.getDynamicObject("material").getLong("id");
        itemMap.put("material", materialId);
        itemMap.put("costaccount", alloc.getDynamicObject("costaccount").getPkValue());
        if (report != null && CadEmptyUtils.isEmpty((Long)report.getOrgId())) {
            report.setOrgId(org.getLong("id"));
            report.setCostaccountId(alloc.getDynamicObject("costaccount").getLong("id"));
            report.setPeriodId(period == null ? 0L : period.getLong("id"));
            report.setCurrencyId(CurrencyHelper.getCurrency((Long)report.getCostaccountId()).longValue());
        }
        HashMap<Long, Set<String>> otherPgMap = new HashMap(16);
        DynamicObject productGroup = alloc.getDynamicObject("productgroup");
        if (!CadEmptyUtils.isEmpty((DynamicObject)productGroup)) {
            long productGroupId = productGroup.getLong("id");
            itemMap.put("productgroup", productGroupId);
            otherPgMap = AcaMatAllocHelper.queryProductGroupDs(Sets.newHashSet((Object[])new Long[]{productGroupId}));
        }
        HashMap<Long, Map<Long, Set<String>>> collDataMap = new HashMap<Long, Map<Long, Set<String>>>(16);
        Map driverMap = collDataMap.computeIfAbsent(alloc.getLong("id"), s -> new HashMap(16));
        driverMap.computeIfAbsent(costdriver.getLong("id"), s -> new HashSet(16));
        HashMap<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>> orgIdToMatInformationMap = new HashMap<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>>(16);
        orgIdToMatInformationMap.computeIfAbsent(org.getLong("id"), value -> new HashSet(16)).add(new Tuple((Object)new FourTuple((Object)materialId, (Object)AcaMatAllocHelper.getDynPkVal(alloc, "matversion"), (Object)AcaMatAllocHelper.getDynPkVal(alloc, "auxpty"), (Object)AcaMatAllocHelper.getDynPkVal(alloc, "manuorg")), (Object)new Date()));
        Map<String, String> matIdToPairMap = AcaMatAllocHelper.getAcaSubElementByOrg(orgIdToMatInformationMap);
        HashMap<String, Object> pageParamMap = new HashMap<String, Object>(16);
        pageParamMap.put("allocdim", alloc.getString("allocdim"));
        return AcaMatAllocHelper.wrapParam(allocMap, collDataMap, matIdToPairMap, otherPgMap, pageParamMap);
    }

    private static long getDynPkVal(DynamicObject dyn, String key) {
        DynamicObject sDyn = dyn.getDynamicObject(key);
        if (sDyn == null) {
            return 0L;
        }
        return sDyn.getLong("id");
    }

    private static Set<String> getAllocDims(Set<String> allocDimStrs) {
        HashSet allocDims = Sets.newHashSetWithExpectedSize((int)10);
        for (String allocDimStr : allocDimStrs) {
            String[] allocDimArr;
            for (String dim : allocDimArr = allocDimStr.split(",")) {
                if (StringUtils.isEmpty((CharSequence)dim)) continue;
                allocDims.add(dim);
            }
        }
        return allocDims;
    }

    private static AllocDataParameter wrapParam(Map<Long, Map<String, Object>> allocMap, Map<Long, Map<Long, Set<String>>> collDataMap, Map<String, String> matIdToPiarMap, Map<Long, Set<String>> otherPgMap, Map<String, Object> pageParamMap) {
        Long userId;
        AllocDataParameter param = new AllocDataParameter();
        param.setCollDataMap(collDataMap);
        param.setMatIdToPairMap(matIdToPiarMap);
        Set<Long> currentCalcCostobjectRange = null;
        HashMap<Long, Long> driverCostTypeMap = new HashMap<Long, Long>();
        HashSet<Long> costDriverIds = new HashSet<Long>(16);
        HashSet<String> allocDimStrs = new HashSet<String>(10);
        for (Map.Entry<Long, Map<String, Object>> allocEntry : allocMap.entrySet()) {
            Map<String, Object> itemMap = allocEntry.getValue();
            Long costDriverId = (Long)itemMap.get("costdriver");
            if (AcaAlgoxEmptyOrZeroUtils.isEmpty(costDriverId)) continue;
            costDriverIds.add(costDriverId);
            String allocDim = (String)itemMap.get("allocdim");
            if (StringUtils.isEmpty((CharSequence)allocDim)) continue;
            allocDimStrs.add(allocDim);
        }
        Set<String> allocDims = AcaMatAllocHelper.getAllocDims(allocDimStrs);
        if (!costDriverIds.isEmpty()) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("appnum", "=", (Object)"aca");
            qFilter.and("id", "in", costDriverIds);
            qFilter.and("costtype", "!=", (Object)0L);
            DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,costtype", (QFilter[])new QFilter[]{qFilter});
            if (costDrivers != null) {
                for (DynamicObject costDriver : costDrivers) {
                    long id = costDriver.getLong("id");
                    long costType = costDriver.getLong("costtype");
                    driverCostTypeMap.put(id, costType);
                }
            }
        }
        HashMap<String, Map<String, BigDecimal>> allocstdValueDataSets = new HashMap<String, Map<String, BigDecimal>>(16);
        for (Map.Entry<Long, Map<String, Object>> entry : allocMap.entrySet()) {
            Map subMaterialValueMap;
            Map<String, Object> itemMap = entry.getValue();
            Long costDriverId = (Long)itemMap.get("costdriver");
            Long costcenterId = (Long)itemMap.get("costcenter");
            String costDriverkey = String.format("%s@%s", costcenterId, costDriverId);
            String stdNumber = String.valueOf(itemMap.get("stdnumber"));
            if (StringUtils.isEmpty((CharSequence)stdNumber) || AcaAlgoxEmptyOrZeroUtils.isEmpty(costDriverId)) continue;
            Long costType = (Long)driverCostTypeMap.get(costDriverId);
            itemMap.put("costtype", costType);
            if (allocstdValueDataSets.containsKey(costDriverkey) && !AcaMatAllocHelper.isMatQuota(costDriverId)) continue;
            boolean isMaterialGroup = AcaMatAllocHelper.isMaterialGroupCostDriver(costDriverId);
            DataSet costCenterValues = AcaMatAllocHelper.getCostCenterValues(stdNumber, itemMap, isMaterialGroup, false);
            if (costCenterValues == null) {
                allocstdValueDataSets.put(costDriverkey, null);
                continue;
            }
            HashMap costObjectValueMaps = new HashMap(16);
            HashMap<Object, Long> materialGroupMap = new HashMap<Object, Long>(16);
            List<String> fieldNames = Arrays.asList(costCenterValues.getRowMeta().getFieldNames());
            for (Row row : costCenterValues) {
                Long costobjectId = row.getLong("costobject");
                BigDecimal value = row.getBigDecimal("value");
                if (value.compareTo(BigDecimal.ZERO) == 0) continue;
                Long subMaterialId = 0L;
                if (fieldNames.contains("submaterial")) {
                    subMaterialId = row.getLong("submaterial");
                }
                subMaterialValueMap = costObjectValueMaps.get(costobjectId) == null ? new HashMap(2) : (Map)costObjectValueMaps.get(costobjectId);
                subMaterialValueMap.put(subMaterialId, value);
                costObjectValueMaps.put(costobjectId, subMaterialValueMap);
                materialGroupMap.put(costobjectId, isMaterialGroup ? row.getLong("materialgroup") : 0L);
            }
            QFilter costObjFilter = new QFilter("id", "in", costObjectValueMaps.keySet());
            StringBuilder selectFields = new StringBuilder("id costobject,material,biztype,isrework,producenum,auxpty");
            for (String dim : allocDims) {
                if ("project".equals(dim)) {
                    selectFields.append(",projectnumber project");
                    continue;
                }
                selectFields.append(",").append(dim);
            }
            DataSet costObjectResult = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper-costobject", (String)"cad_costobject", (String)selectFields.toString(), (QFilter[])costObjFilter.toArray(), null);
            HashMap costCenterValueMaps = allocstdValueDataSets.get(costDriverkey) == null ? Maps.newHashMapWithExpectedSize((int)16) : (Map)allocstdValueDataSets.get(costDriverkey);
            for (Row row : costObjectResult) {
                Long costobjectId = row.getLong("costobject");
                if ("SO".equals(row.getString("biztype"))) {
                    if (currentCalcCostobjectRange == null) {
                        Long orgId = Long.valueOf(itemMap.get("org").toString());
                        Long costaccountId = Long.valueOf(itemMap.get("costaccount").toString());
                        Long periodId = Long.valueOf(itemMap.get("periodId").toString());
                        currentCalcCostobjectRange = AcaCalcRangeHelper.getCalcCurPeriodCostobjectRange(orgId, costaccountId, periodId, null);
                    }
                    if (!currentCalcCostobjectRange.contains(costobjectId)) continue;
                }
                if (CadEmptyUtils.isEmpty(subMaterialValueMap = (Map)costObjectValueMaps.get(costobjectId))) continue;
                String materialGroup = String.format("&&materialgroup=%s", materialGroupMap.get(costobjectId));
                for (Map.Entry materialValue : subMaterialValueMap.entrySet()) {
                    String subMaterial = String.format("&&submaterial=%s", materialValue.getKey());
                    String key = AcaMatAllocHelper.getRowStringKey(row, costObjectResult.getRowMeta(), materialGroup, subMaterial);
                    costCenterValueMaps.put(key, materialValue.getValue());
                }
            }
            allocstdValueDataSets.put(costDriverkey, costCenterValueMaps);
        }
        param.setReworkAllocSelf(AcaMatAllocHelper.getIsReworkAllocSelf());
        param.setProductGroupMatSet(otherPgMap);
        param.setAllocStdValueColls(allocstdValueDataSets);
        param.setProcessingAllocEntity("aca_matalloc");
        param.setAllocDims(allocDims);
        if (!CadEmptyUtils.isEmpty(pageParamMap)) {
            param.getPageParamMap().putAll(pageParamMap);
        }
        param.setAllocor((userId = Long.valueOf(RequestContext.get().getCurrUserId())) == null ? 1L : Long.parseLong(String.valueOf(userId)));
        return param;
    }

    private static String getRowStringKey(Row row, RowMeta rowmeta, String appd, String subMaterial) {
        StringBuilder sb = new StringBuilder();
        for (String fieldName : rowmeta.getFieldNames()) {
            if (sb.length() > 0) {
                sb.append("&&");
            }
            sb.append(String.format("%s=%s", fieldName, row.getString(fieldName)));
        }
        if (!StringUtils.isEmpty((CharSequence)appd)) {
            sb.append(appd);
        }
        if (!StringUtils.isEmpty((CharSequence)subMaterial)) {
            sb.append(subMaterial);
        }
        return sb.toString();
    }

    public static boolean getIsReworkAllocSelf() {
        String fkey = "aca_reworkacself";
        String strSql = "SELECT FVALUE FROM T_IM_INVDBPARAM WHERE FKEY = '" + fkey + "'";
        try (DataSet batSizeData = DB.queryDataSet((String)"getparam", (DBRoute)new DBRoute("scm"), (String)strSql);){
            if (batSizeData.hasNext()) {
                Row row = batSizeData.next();
                String value = row.get("FVALUE").toString();
                if ("0".equals(value)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        return "1".equals(CadBgParamUtils.getCadBgParamForString((String)fkey, (String)"1"));
    }

    private static boolean isMatQuota(Long costDriverId) {
        String formulaStr;
        String completeFormula;
        QFilter idFilter = new QFilter("id", "=", (Object)costDriverId);
        DynamicObject costDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"id,iscomplexcd,formula,number,name", (QFilter[])idFilter.toArray());
        if (costDriver.getBoolean("iscomplexcd") && StringUtils.isNotBlank((CharSequence)(completeFormula = FormulaUtil.getCompleteFormula(formulaStr = costDriver.getString("formula"), costDriver.getString("number"), costDriver.getString("name"), costDriverId)))) {
            List<Long> costDriverIds = FormulaUtil.getCostDriverIds(completeFormula);
            return costDriverIds.contains(MAT_QUOTA_Id);
        }
        return false;
    }

    private static boolean isMaterialGroupCostDriver(Long costDriverId) {
        String formulaStr;
        QFilter idFilter = new QFilter("id", "=", (Object)costDriverId);
        DynamicObject costDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"id,iscomplexcd,formula", (QFilter[])idFilter.toArray());
        if (costDriver.getBoolean("iscomplexcd") && StringUtils.isNotBlank((CharSequence)(formulaStr = costDriver.getString("formula")))) {
            List<Long> costDriverIds = FormulaUtil.getCostDriverIds(formulaStr);
            QFilter qFilter = new QFilter("id", "in", costDriverIds);
            qFilter.and("allocclass", "=", (Object)MATERIALGROUP);
            return QueryServiceHelper.exists((String)"cad_costdriver", (QFilter[])qFilter.toArray());
        }
        return false;
    }

    private static DataSet getCostCenterValues(String stdNumber, Map<String, Object> itemMap, boolean isMaterialGroup, boolean isComplex) {
        DataSet costCenterValues = null;
        switch (stdNumber) {
            case "CD_ACA000001_sys": {
                costCenterValues = AcaMatAllocHelper.getCompeteBillDataBy(itemMap, false);
                break;
            }
            case "CD_ACA000007_sys": {
                costCenterValues = AcaMatAllocHelper.getCompeteBillDataBy(itemMap, true);
                break;
            }
            case "CD_ACA000002_sys": {
                costCenterValues = AcaMatAllocHelper.getPlanBillDataBy(itemMap, "qty");
                break;
            }
            case "CD_ACA000003_sys": {
                costCenterValues = AcaMatAllocHelper.getPlanBillDataBy(itemMap, "wipqty");
                break;
            }
            case "CD_ACA000004_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_equipment");
                resTypeSet.add("mpdm_toolsresource");
                resTypeSet.add("mpdm_toolequip");
                resTypeSet.add("mpdm_mould");
                Set<Long> resourceIds = AcaMatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = AcaMatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "");
                break;
            }
            case "CD_ACA000005_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                Set<Long> resourceIds = AcaMatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = AcaMatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "0");
                break;
            }
            case "CD_ACA000008_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                Set<Long> resourceIds = AcaMatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = AcaMatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "1");
                break;
            }
            case "CD_ACA000010_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                resTypeSet.add("mpdm_equipment");
                resTypeSet.add("mpdm_toolsresource");
                resTypeSet.add("mpdm_toolequip");
                resTypeSet.add("mpdm_mould");
                Set<Long> resourceIds = AcaMatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = AcaMatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "0");
                break;
            }
            case "CD_ACA000011_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                resTypeSet.add("mpdm_equipment");
                resTypeSet.add("mpdm_toolsresource");
                resTypeSet.add("mpdm_toolequip");
                resTypeSet.add("mpdm_mould");
                Set<Long> resourceIds = AcaMatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = AcaMatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "1");
                break;
            }
            case "CD_ACA000012_sys": {
                costCenterValues = AcaMatAllocHelper.getIsreworkCompeteBillDataBy(itemMap);
                break;
            }
            case "CD_ACA000013_sys": {
                costCenterValues = AcaMatAllocHelper.getAssistFinishCompeteBillDataBy(itemMap);
                break;
            }
            case "CD_ACA000014_sys": {
                costCenterValues = AcaMatAllocHelper.getOutAssistFinishCompeteBillDataBy(itemMap);
                break;
            }
            case "CD_ACA000015_sys": {
                costCenterValues = AcaMatAllocHelper.getReWorkAssistFinishCompeteBillDataBy(itemMap);
                break;
            }
            case "CD_ACA000016_sys": {
                costCenterValues = AcaMatAllocHelper.getEndInProduceQtyOnCostObject(itemMap);
                break;
            }
            case "CD_ACA000017_sys": {
                costCenterValues = AcaMatAllocHelper.getEquivalentOnCostObject(itemMap);
                break;
            }
            case "CD_ACA000019_sys": {
                costCenterValues = AcaMatAllocHelper.getMftStockOnCostObject(itemMap, isComplex);
                break;
            }
            default: {
                costCenterValues = AcaMatAllocHelper.getAllocDataByDiyCostDrive(itemMap, isMaterialGroup);
            }
        }
        return costCenterValues;
    }

    private static boolean isContainMtfStockDriver(Long costDriverId) {
        if (costDriverId.equals(CostDriverIdConstant.MFT_STOCK_SCA) || costDriverId.equals(CostDriverIdConstant.MFT_STOCK_ACA)) {
            return true;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)costDriverId);
        qFilter.and("iscomplexcd", "=", (Object)Boolean.TRUE);
        DataSet costCenterComplexDriverDs = QueryServiceHelper.queryDataSet((String)"getcostdriver", (String)"cad_costdriver", (String)"id,formula,number,name,costtype", (QFilter[])qFilter.toArray(), null);
        for (Row row : costCenterComplexDriverDs) {
            String formula = row.getString("formula");
            String currentNumber = row.getString("number");
            String currentName = row.getString("name");
            long complexDriverId = row.getLong("id");
            try {
                formula = FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, complexDriverId);
            }
            catch (KDBizException e) {
                logger.error("getCompleteFormula error, formula is:{}", (Object)formula);
                throw e;
            }
            if (!formula.contains(String.valueOf(CostDriverIdConstant.MFT_STOCK_SCA)) && !formula.contains(String.valueOf(CostDriverIdConstant.MFT_STOCK_ACA))) continue;
            return true;
        }
        return false;
    }

    private static Tuple<Map<Long, Map<Long, Set<String>>>, Map<String, String>> getCollData(Set<Long> allocIds, Map<Long, Map<String, Object>> allocMap, Set<Long> productGroups, AllocReport report) {
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(allocIds)) {
            return null;
        }
        String algoKey = "kd.macc.aca.algox.alloc.AcaMatAllocHelper.getCollData";
        QFilter allocFilter = new QFilter("id", "in", allocIds);
        DataSet allocDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "1"), (String)"aca_matalloc", (String)"id,org,manuorg,material,matversion,auxpty,material.group materialgroup,period.id periodId,period.begindate begindate,period.enddate enddate,costcenter,costobject,costdriver,costdriver.number stdnumber,allocdim,productgroup,productnum,costaccount", (QFilter[])new QFilter[]{allocFilter}, null);
        DataSet allocCopyDataSet = allocDataSet.copy();
        Iterator it = allocCopyDataSet.iterator();
        HashMap<Long, Map> dataMap = new HashMap<Long, Map>();
        HashMap<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>> orgIdToMatInformationMap = new HashMap<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>>(16);
        Date date = new Date();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            if (report != null && CadEmptyUtils.isEmpty((Long)report.getOrgId())) {
                report.setOrgId(row.getLong("org").longValue());
                report.setCostaccountId(row.getLong("costaccount").longValue());
                report.setPeriodId(row.getLong("periodId").longValue());
                report.setCurrencyId(CurrencyHelper.getCurrency((Long)report.getCostaccountId()).longValue());
            }
            Long orgId = row.getLong("org");
            Long manuorg = row.getLong("manuorg");
            Long material = row.getLong("material");
            Long matversion = row.getLong("matversion");
            Long auxpty = row.getLong("auxpty");
            Long costdriverId = row.getLong("costdriver");
            Long id = row.getLong("id");
            Map itemMap = allocMap.computeIfAbsent(row.getLong("id"), s -> new HashMap());
            itemMap.put("id", id);
            itemMap.put("org", orgId);
            itemMap.put("manuorg", manuorg);
            itemMap.put("costcenter", row.getLong("costcenter"));
            itemMap.put("begindate", row.getDate("begindate"));
            itemMap.put("enddate", row.getDate("enddate"));
            itemMap.put("periodId", row.getLong("periodId"));
            itemMap.put("stdnumber", row.getString("stdnumber"));
            itemMap.put("costdriver", costdriverId);
            itemMap.put("allocdim", row.getString("allocdim"));
            itemMap.put("material", material);
            itemMap.put("matversion", matversion);
            itemMap.put("auxpty", auxpty);
            itemMap.put("materialgroup", row.getLong("materialgroup"));
            itemMap.put("productnum", row.getString("productnum"));
            Long productGroup = row.getLong("productgroup");
            itemMap.put("productgroup", productGroup);
            if (!CadEmptyUtils.isEmpty((Long)productGroup)) {
                productGroups.add(productGroup);
            }
            itemMap.put("costaccount", row.getLong("costaccount"));
            dataMap.computeIfAbsent(id, s -> new HashMap()).computeIfAbsent(costdriverId, s -> new HashSet());
            orgIdToMatInformationMap.computeIfAbsent(orgId, value -> new HashSet(16)).add(new Tuple((Object)new FourTuple((Object)material, (Object)matversion, (Object)auxpty, (Object)manuorg), (Object)date));
        }
        Map<String, String> matIdToPairMap = AcaMatAllocHelper.getAcaSubElementByOrg(orgIdToMatInformationMap);
        return new Tuple(dataMap, matIdToPairMap);
    }

    private static Map<String, String> getAcaSubElementByOrg(HashMap<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>> orgIdToMatInformationMap) {
        HashMap<String, String> returnMatIdToPairMap = new HashMap<String, String>(512);
        for (Map.Entry<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>> entry : orgIdToMatInformationMap.entrySet()) {
            AcaMatAllocHelper.getAcaSubElement(returnMatIdToPairMap, entry);
        }
        return returnMatIdToPairMap;
    }

    private static void getAcaSubElement(Map<String, String> returnMatIdToPairMap, Map.Entry<Long, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>>> entry) {
        Map matIdToPairMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getAcaSubElementByOrg", (Object[])new Object[]{entry.getKey(), entry.getValue(), "0"});
        returnMatIdToPairMap.putAll(matIdToPairMap);
    }

    private static DataSet getPlanBillDataBy(Map<String, Object> allocMap, String qtyFields) {
        String selectFields = "id,accountorg org,costcenter,costobject,costobject.material material," + qtyFields + " value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and accountorg = ? and costcenter = ? ", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter")});
        if ("qty".equals(qtyFields)) {
            filter.and(QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{allocMap.get("begindate"), allocMap.get("enddate")}));
        } else {
            filter.and(QFilter.of((String)"bizdate <= ?", (Object[])new Object[]{allocMap.get("enddate")}));
        }
        filter.and(new QFilter("costobject.bizstatus", "=", (Object)"A"));
        filter.and("costobject.producttype", "=", (Object)Character.valueOf('C'));
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        return AcaMatAllocHelper.queryStdValDataBy("cad_plannedoutputbill", selectFields, filter, allocMap);
    }

    private static DataSet getCompeteBillDataBy(Map<String, Object> allocMap, boolean isOutSource) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        filter.and("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C'));
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        filter.and("entryentity.costobject.isoutsource", "=", (Object)isOutSource);
        return AcaMatAllocHelper.queryStdValDataBy("cad_factnedoutputbill", selectFields, filter, allocMap);
    }

    private static DataSet getIsreworkCompeteBillDataBy(Map<String, Object> allocMap) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        filter.and(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        filter.and(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        return AcaMatAllocHelper.queryStdValDataBy("cad_factnedoutputbill", selectFields, filter, allocMap);
    }

    private static DataSet getAssistFinishCompeteBillDataBy(Map<String, Object> allocMap) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty,sourcebillentry";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        filter.and(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        filter.and("entryentity.costobject.isoutsource", "=", (Object)Boolean.FALSE);
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper.queryStdValDataBy", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)"ll", (String)"im_mdc_mftmanuinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet prodBillData = QueryServiceHelper.queryDataSet((String)"ll", (String)"im_productinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet srcBillData = finiBillData.union(prodBillData);
        DataSet joinData = finishInput.join(srcBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"org", "costcenter", "costobject", "material"}).sum("value").finish();
        return joinData;
    }

    private static DataSet getOutAssistFinishCompeteBillDataBy(Map<String, Object> allocMap) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty,sourcebillentry";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        filter.and(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        filter.and("entryentity.costobject.isoutsource", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper.queryStdValDataBy", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)"ll", (String)"im_mdc_omcmplinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet joinData = finishInput.join(finiBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"org", "costcenter", "costobject", "material"}).sum("value").finish();
        return joinData;
    }

    private static DataSet getReWorkAssistFinishCompeteBillDataBy(Map<String, Object> allocMap) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty,sourcebillentry";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        filter.and(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        filter.and(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper.queryStdValDataBy", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)"ll", (String)"im_mdc_mftmanuinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet prodBillData = QueryServiceHelper.queryDataSet((String)"ll", (String)"im_productinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet srcBillData = finiBillData.union(prodBillData);
        DataSet joinData = finishInput.join(srcBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"org", "costcenter", "costobject", "material"}).sum("value").finish();
        return joinData;
    }

    private static DataSet getEndInProduceQtyOnCostObject(Map<String, Object> allocMap) {
        DataSet endOnProduct = new WipCostCheckService().loadWipCostCheckDataSet((Long)allocMap.get("org"), 0L, (Long)allocMap.get("costaccount"), Sets.newHashSet((Object[])new Long[]{Long.parseLong(String.valueOf(allocMap.get("costcenter")))}), (Long)allocMap.get("periodId"));
        endOnProduct = endOnProduct.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "material"}).sum("endproducting").finish();
        return endOnProduct.select("844090490004888586L as costdriver,org,manuorg,costcenter,costobject,material,endproducting value");
    }

    private static DataSet getMftStockOnCostObject(Map<String, Object> allocMap, boolean isComplex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("org", "=", allocMap.get("org"));
        orgFilter.and("costcenter", "=", allocMap.get("costcenter"));
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)"aca");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)allocMap.get("periodId"), (String)"bd_period", (String)"begindate,enddate");
        if (period == null) {
            return null;
        }
        QFilter bookDateFilter = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        bookDateFilter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        DataSet mftStockBillInfo = QueryServiceHelper.queryDataSet((String)"getProBillInfo", (String)"cad_factnedoutputbill", (String)"org,costcenter,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.probill as probill,entryentity.costobject.isoutsource as isoutsource", (QFilter[])filters.toArray(new QFilter[0]), null).distinct();
        HashSet pomBillIds = new HashSet(1024);
        HashSet omBillIds = new HashSet(1024);
        mftStockBillInfo.copy().forEach(s -> {
            if (s.getBoolean("isoutsource").booleanValue()) {
                omBillIds.add(s.getLong("probill"));
            } else {
                pomBillIds.add(s.getLong("probill"));
            }
        });
        DataSet assemblyDataSet = null;
        if (!CadEmptyUtils.isEmpty(pomBillIds)) {
            QFilter orderEntryQf = new QFilter("orderentryid", "in", pomBillIds);
            assemblyDataSet = QueryServiceHelper.queryDataSet((String)"getmftStock", (String)"pom_mftstock", (String)"stockentry.materialid.masterid as material,stockentry.demandqty AS value,orderentryid", (QFilter[])new QFilter[]{orderEntryQf}, null);
        }
        if (!CadEmptyUtils.isEmpty(omBillIds)) {
            QFilter omOrderEntryQf = new QFilter("orderentryid", "in", omBillIds);
            DataSet omAssemblyDataSet = QueryServiceHelper.queryDataSet((String)"getommftStock", (String)"om_mftstock", (String)"stockentry.materialid.masterid as material,stockentry.demandqty AS value, orderentryid", (QFilter[])new QFilter[]{omOrderEntryQf}, null);
            assemblyDataSet = assemblyDataSet == null ? omAssemblyDataSet : DataSetUtils.union((DataSet)assemblyDataSet, (DataSet)omAssemblyDataSet);
        }
        if (assemblyDataSet == null) {
            return null;
        }
        mftStockBillInfo = isComplex ? mftStockBillInfo.join(assemblyDataSet, JoinType.INNER).on("probill", "orderentryid").select(new String[]{"org", "costcenter", "costobject"}, new String[]{"material", "value"}).finish() : mftStockBillInfo.join(assemblyDataSet, JoinType.INNER).on("probill", "orderentryid").select(new String[]{"org", "costcenter", "costobject", "material"}, new String[]{"value"}).finish();
        mftStockBillInfo = mftStockBillInfo.groupBy(new String[]{"org", "costcenter", "costobject", "material"}).sum("value").finish();
        return mftStockBillInfo;
    }

    private static DataSet getEquivalentOnCostObject(Map<String, Object> allocMap) {
        QFilter orgQF = new QFilter("org", "=", allocMap.get("org"));
        QFilter costaccountQF = new QFilter("costaccount", "=", allocMap.get("costaccount"));
        QFilter costCenterQf = new QFilter("entryentity.costcenter", "=", allocMap.get("costcenter"));
        costCenterQf.or("entryentity.costcenter", "=", (Object)0L);
        QFilter periodQF = new QFilter("period", "=", allocMap.get("periodId"));
        DataSet equivalentData = QueryServiceHelper.queryDataSet((String)"", (String)"aca_equivalent", (String)"org,manuorg,costaccount,entryentity.costcenter costcenter,entryentity.costobject costobject,entryentity.material material,entryentity.totalvalen value", (QFilter[])new QFilter[]{orgQF, costaccountQF, costCenterQf, periodQF}, null);
        DataSet orgEquivalentDataSet = equivalentData.copy().filter("costcenter == 0L");
        if (!orgEquivalentDataSet.isEmpty()) {
            final HashSet<Long> equivalentObjects = new HashSet<Long>(16);
            for (Row row : equivalentData.copy()) {
                Long costObjectId = row.getLong("costobject");
                if (CadEmptyUtils.isEmpty((Long)costObjectId)) continue;
                equivalentObjects.add(costObjectId);
            }
            Long orgId = Long.parseLong(String.valueOf(allocMap.get("org")));
            Long manuOrgId = Long.parseLong(String.valueOf(allocMap.get("manuorg") == null ? Long.valueOf(0L) : allocMap.get("manuorg")));
            Long costAccountId = Long.parseLong(String.valueOf(allocMap.get("costaccount")));
            Long costCenterId = Long.parseLong(String.valueOf(allocMap.get("costcenter")));
            Long periodId = Long.parseLong(String.valueOf(allocMap.get("periodId")));
            DataSet costObjectDs = new WipCostCheckService().loadWipCostCheckDataSet(orgId, manuOrgId, costAccountId, Sets.newHashSet((Object[])new Long[]{costCenterId}), periodId);
            BigDecimal totalValen = BigDecimal.ZERO;
            for (Row row : orgEquivalentDataSet) {
                totalValen = row.getBigDecimal("value");
            }
            DataSet otherCostObjDs = costObjectDs.filter(new FilterFunction(){

                public boolean test(Row row) {
                    return !equivalentObjects.contains(row.getLong("costobject"));
                }
            }).select("org,manuorg,costcenter,costobject,material,".concat(totalValen.toString()).concat(" as value,").concat(costAccountId.toString()).concat(" as costaccount"));
            equivalentData = DataSetHelper.union(equivalentData, otherCostObjDs);
        }
        equivalentData = equivalentData.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        return equivalentData.select("844090490004888587L as costdriver,org,manuorg,costcenter,costobject,material,value");
    }

    private static DataSet queryStdValDataBy(String entity, String selectFields, QFilter filter, Map<String, Object> allocMap) {
        DataSet allocstdValueDataSet = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper.queryStdValDataBy", (String)entity, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        GroupbyDataSet groupDataSet = allocstdValueDataSet.select("org,costcenter,costobject,material,value").groupBy(new String[]{"org", "costcenter", "costobject", "material"});
        groupDataSet.sum("value");
        return groupDataSet.finish();
    }

    private static Set<Long> getResourceFromType(Set<String> types) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("resourcesentryentity.itemclasstype", "in", types);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.alloc.AcaMatAllocHelper.getRourceDs", (String)"mpdm_resources", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> resourceIds = new HashSet<Long>(32);
        while (ds.hasNext()) {
            resourceIds.add(ds.next().getLong("id"));
        }
        return resourceIds;
    }

    private static DataSet getResourceBillQtyBy(Map<String, Object> allocMap, Set<Long> resourceIds, String valueField, String isOutSource) {
        DataSet allocstdValueDataSet;
        String algoKey = "kd.macc.sca.algox.alloc.MatAllocHelper.getResourceBillQtyBy2";
        String selectFields = "id,org,costcenter,resource,entryentity.costobject costobject,entryentity.material material,entryentity.workhour as workhour,entryentity." + valueField + " facthour";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        filter.and(new QFilter("appnum", "=", (Object)"aca"));
        if (!CollectionUtils.isEmpty(resourceIds)) {
            filter.and("resource", "in", resourceIds);
        }
        if (StringUtils.isNotBlank((CharSequence)isOutSource)) {
            boolean isOut = isOutSource.equals("1");
            filter.and("entryentity.costobject.isoutsource", "=", (Object)isOut);
        }
        if ((allocstdValueDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)selectFields, (QFilter[])new QFilter[]{filter}, null)).isEmpty()) {
            return null;
        }
        DataSet groupbyValueDataSet = allocstdValueDataSet.select("id,resource,org,costcenter,costobject,material,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end facthour").groupBy(new String[]{"org", "costcenter", "costobject", "material"}).sum("facthour", "value").finish();
        return groupbyValueDataSet;
    }

    public static void importAllocData(Map<Long, List<Long>> paramMap) {
        String selectFields = "id AS costaccount,number AS costaccountnum,calorg AS org,costtype AS costtype,calpolicy.currency.id AS currency";
        Set<Long> costaccountIdSet = paramMap.keySet();
        QFilter idQF = new QFilter("id", "in", costaccountIdSet);
        DynamicObjectCollection costaccountColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{idQF});
        ArrayList<Map<String, Object>> costaccountList = new ArrayList<Map<String, Object>>();
        for (DynamicObject data : costaccountColl) {
            Long costaccountId = data.getLong("costaccount");
            Long orgId = data.getLong("org");
            HashMap<String, Object> costaccountMap = new HashMap<String, Object>();
            costaccountMap.put("org", orgId);
            costaccountMap.put("appnum", "aca");
            costaccountMap.put("costaccountnum", data.getString("costaccountnum"));
            costaccountMap.put("costaccountId", costaccountId);
            costaccountMap.put("currencyId", data.getLong("currency"));
            costaccountMap.put("costtypeId", data.getLong("costtype") == 0L ? ACA_COST_TYPE_ID.longValue() : data.getLong("costtype"));
            costaccountMap.put("currentperiodId", AcaMatAllocHelper.getPeriod(orgId, costaccountId));
            costaccountMap.put("costObjectList", paramMap.get(costaccountId));
            costaccountList.add(costaccountMap);
        }
        AcaMatAllocHelper.toAlloc(costaccountList, null, null);
    }

    public static void importAllocData(List<Long> costaccountIdList) {
        HashMap<Long, List<Long>> paramMap = new HashMap<Long, List<Long>>(16);
        for (Long costaccountId : costaccountIdList) {
            paramMap.put(costaccountId, null);
        }
        AcaMatAllocHelper.importAllocData(paramMap);
    }

    private static Long getPeriod(Long orgId, Long costaccountId) {
        if (orgId == null || costaccountId == null) {
            return null;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (res == null || res.size() == 0) {
            return null;
        }
        return ((DynamicObject)res.get(0)).getLong("currentperiod");
    }

    public static AllocResult toAlloc(List<Map<String, Object>> costaccountList, String progressId, Map<String, Object> collectParamMap) {
        String matCostType;
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5f00\u59cb\uff1a{}", costaccountList);
        long billSize = 0L;
        AllocResult res = new AllocResult();
        res.setReasonMap(new HashMap<String, String>());
        HashMap cachaEleInfo = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)progressId)) {
            ProgressHelper.setProgress(progressId, ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"AcaMatAllocHelper_6", (String)"macc-aca-algox", (Object[])new Object[0]), 0, 100, "%");
        }
        boolean isDealPublic = true;
        if (!CadEmptyUtils.isEmpty(collectParamMap) && "D".equals(matCostType = (String)collectParamMap.get("matCostType"))) {
            isDealPublic = false;
        }
        int batchSize = CadBgParamUtils.getCadParamForInt((String)"acaMatAllocCollBatch", (int)20000);
        int unitMapProcess = 100 / costaccountList.size();
        Map<String, IDataEntityProperty> allMatAllocField = AcaMatAllocHelper.getExtFieldMap();
        for (Map<String, Object> costAccountMap : costaccountList) {
            List partArrIds;
            long time;
            StringBuilder extSelFields;
            Set calcKeys;
            AllocReport allocReport;
            String errorMsg;
            block35: {
                if (costAccountMap.get("costtypeId") == null) {
                    Map<String, String> reasonMap = res.getReasonMap();
                    reasonMap.put((String)costAccountMap.get("costaccountnum"), ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u4e0b\uff0c\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"AcaMatAllocHelper_1", (String)"macc-aca-algox", (Object[])new Object[0]));
                    res.setSuccess(false);
                    if (StringUtils.isEmpty((CharSequence)progressId)) continue;
                    ProgressHelper.setProgress(progressId, ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"AcaMatAllocHelper_6", (String)"macc-aca-algox", (Object[])new Object[0]), unitMapProcess, "%");
                    continue;
                }
                costAccountMap.put("cachaEleInfo", cachaEleInfo);
                errorMsg = null;
                allocReport = AllocReportHelper.initReport((long)((Long)costAccountMap.get("org")), (long)((Long)costAccountMap.get("costaccountId")), (long)((Long)costAccountMap.get("currentperiodId")), (long)((Long)costAccountMap.get("currencyId")), (String)"8", (String)((String)costAccountMap.get("appnum")));
                calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)((Long)costAccountMap.get("org")), (Long)((Long)costAccountMap.get("costaccountId")), (String)"aca");
                List extCalcKeys = CalcKeycolHelper.getExtendKeyCol((Set)calcKeys);
                extSelFields = new StringBuilder();
                extSelFields.append(fields);
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_matusecollect");
                if (!CadEmptyUtils.isEmpty((List)extCalcKeys)) {
                    for (String string : extCalcKeys) {
                        extSelFields.append(CalcKeycolHelper.getEntityUseFields((MainEntityType)entityType, (String)string));
                    }
                }
                if (!CadEmptyUtils.isEmpty(allMatAllocField)) {
                    for (Map.Entry entry : allMatAllocField.entrySet()) {
                        if (extCalcKeys.contains(entry.getKey())) continue;
                        extSelFields.append(CalcKeycolHelper.getEntityUseFields((MainEntityType)entityType, (String)((String)entry.getKey())));
                    }
                }
                AllocReportHelper.addCheckItem((AllocReport)allocReport, (String)"1", (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u5bf9\u5e94\u7684\u6e90\u4e1a\u52a1\u5355\u636e\u5b58\u5728\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"AcaMatAllocHelper_9", (String)"macc-aca-algox", (Object[])new Object[0]));
                time = System.currentTimeMillis();
                Set<Long> billEntryIds = AcaMatAllocHelper.getImportDataBillEntryId(costAccountMap, isDealPublic);
                partArrIds = Lists.partition(new ArrayList<Long>(billEntryIds), (int)batchSize);
                if (partArrIds != null && !partArrIds.isEmpty()) break block35;
                if (!StringUtils.isEmpty((CharSequence)progressId)) {
                    ProgressHelper.setProgress(progressId, ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"AcaMatAllocHelper_6", (String)"macc-aca-algox", (Object[])new Object[0]), unitMapProcess, "%");
                }
                if (allocReport == null) continue;
                if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                    AllocReportHelper.addCheckDatail((AllocReport)allocReport, null, (long)0L, (String)errorMsg);
                }
                AllocReportHelper.saveReport((AllocReport)allocReport);
                res.getReportIds().add(allocReport.getReportId());
                res.setReportContainError(!"1".equals(allocReport.getStatus()));
                continue;
            }
            try {
                int unitPartProcess = unitMapProcess / partArrIds.size();
                long batch = 0L;
                Long orgId = (Long)costAccountMap.get("org");
                Long costAccountId = (Long)costAccountMap.get("costaccountId");
                Map<String, String> matAllocStdMap = AcaMatAllocHelper.getMatAllocStdMap(orgId, "aca");
                for (List partIds : partArrIds) {
                    ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
                    time = System.currentTimeMillis();
                    QFilter entityIdFilter = new QFilter("entryentity.id", "in", (Object)partIds);
                    DynamicObjectCollection bills = QueryServiceHelper.query((String)"aca_matusecollect", (String)extSelFields.toString(), (QFilter[])entityIdFilter.toArray(), (String)"billno asc");
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u83b7\u53d6\u6e90\u5355\u6570\u91cf\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{++batch, bills == null ? 0 : bills.size(), System.currentTimeMillis() - time});
                    if (bills == null || bills.isEmpty()) continue;
                    time = System.currentTimeMillis();
                    List<Long> sourceBillIds = bills.stream().map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
                    List<Long> sourceAdjBillIds = bills.stream().filter(t -> "cal_costadjust_subentity".equals(t.getString("srcbilltype"))).map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
                    Map<Long, DynamicObject> costRecords = AcaMatAllocHelper.getCalCostRecord(costAccountId, sourceBillIds);
                    Map<Long, DynamicObject> costAdjusts = AcaMatAllocHelper.getCalCostAdjust(costAccountId, sourceAdjBillIds);
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165--\u6279\u6b21\uff1a{}\u83b7\u53d6\u6e90\u5355\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u636e\u6570\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{batch, costRecords == null ? 0 : costRecords.size(), System.currentTimeMillis() - time});
                    Date createTime = new Date();
                    Map<String, Pair<Long, Long>> matIdToPairMap = AcaMatAllocHelper.getStringPairMap(bills, createTime, orgId);
                    String costrecordMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"AcaMatAllocHelper_2", (String)"macc-aca-algox", (Object[])new Object[0]);
                    String costAdjustMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u6210\u672c\u8c03\u6574\u5355\u3002", (String)"AcaMatAllocHelper_12", (String)"macc-aca-algox", (Object[])new Object[0]);
                    logger.info("\u914d\u7f6e\u7684\u5171\u8017\u6750\u6599\u5206\u914d\u6807\u51c6\uff1a{}", (Object)SerializationUtils.toJsonString(matAllocStdMap));
                    for (DynamicObject bill2 : bills) {
                        String billno;
                        Map<String, String> reasonMap;
                        Long sourcebillentryid = bill2.getLong("sourcebillentryid");
                        String srcbilltype = bill2.getString("srcbilltype");
                        DynamicObject costrecordEntryDyn = costRecords.get(sourcebillentryid);
                        DynamicObject costadjustEntryDyn = costAdjusts.get(sourcebillentryid);
                        if (!"cal_costadjust_subentity".equals(srcbilltype) && costrecordEntryDyn == null) {
                            reasonMap = res.getReasonMap();
                            billno = bill2.getString("billno");
                            reasonMap.put(billno, costrecordMsg);
                            res.setSuccess(false);
                            AllocReportHelper.addCheckDatail((AllocReport)allocReport, (String)"1", (long)bill2.getLong("costcenter"), (String)(billno + costrecordMsg));
                            continue;
                        }
                        if ("cal_costadjust_subentity".equals(srcbilltype) && costadjustEntryDyn == null) {
                            reasonMap = res.getReasonMap();
                            billno = bill2.getString("billno");
                            reasonMap.put(billno, costAdjustMsg);
                            res.setSuccess(true);
                            AllocReportHelper.addCheckDatail((AllocReport)allocReport, (String)"1", (long)bill2.getLong("costcenter"), (String)(billno + costAdjustMsg));
                            continue;
                        }
                        Boolean qtyImportFlag = Boolean.TRUE;
                        if ("cal_costadjust_subentity".equals(srcbilltype)) {
                            qtyImportFlag = Boolean.FALSE;
                        }
                        if (qtyImportFlag.booleanValue() && BigDecimal.ZERO.compareTo(bill2.getBigDecimal("qty")) == 0) {
                            Map<String, String> reasonMap2 = res.getReasonMap();
                            String billno2 = bill2.getString("billno");
                            reasonMap2.put(billno2, ResManager.loadKDString((String)"\u9886\u6599\u6570\u91cf\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f15\u5165\u3002", (String)"AcaMatAllocHelper_8", (String)"macc-aca-algox", (Object[])new Object[0]));
                            res.setSuccess(false);
                            continue;
                        }
                        Long costobject = bill2.getLong("costobject");
                        if (!isDealPublic && CadEmptyUtils.isEmpty((Long)costobject)) continue;
                        DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"aca_matalloc");
                        AcaMatAllocHelper.setBillData(allocBill, bill2, costAccountMap, createTime, matAllocStdMap, allMatAllocField);
                        ArrayList<DynamicObject> calCostRecList = new ArrayList<DynamicObject>(16);
                        BigDecimal useamount = BigDecimal.ZERO;
                        String caldimension = "";
                        String noupdatecalfields = "";
                        if (costadjustEntryDyn != null) {
                            useamount = costadjustEntryDyn.getBigDecimal("actualcost");
                            caldimension = costadjustEntryDyn.getString("caldimension");
                            noupdatecalfields = costadjustEntryDyn.getString("noupdatecalfields");
                        } else if (costrecordEntryDyn != null) {
                            useamount = costrecordEntryDyn.getBigDecimal("actualcost");
                            caldimension = costrecordEntryDyn.getString("caldimension");
                            noupdatecalfields = costrecordEntryDyn.getString("noupdatecalfields");
                        }
                        allocBill.set("useamount", (Object)useamount);
                        if (costobject != null && costobject != 0L) {
                            AcaMatAllocHelper.setAllocDetail(allocBill, bill2, matIdToPairMap, costAccountMap, calCostRecList);
                        }
                        allocBill.set("srcauxpty", calCostRecList == null || calCostRecList.isEmpty() ? null : Long.valueOf(((DynamicObject)calCostRecList.get(0)).getLong("assist")));
                        CalcKeycolHelper.genMatAllocCalcKey((Set)calcKeys, (String)caldimension, (String)noupdatecalfields, (DynamicObject)allocBill, (DynamicObject)bill2, (String)"aca");
                        billList.add(allocBill);
                    }
                    if (!billList.isEmpty()) {
                        time = System.currentTimeMillis();
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"aca_matalloc");
                        Object[] saveAllocBill = billList.toArray(new DynamicObject[0]);
                        SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])saveAllocBill);
                        billSize += (long)saveAllocBill.length;
                        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u4fdd\u5b58\u5355\u636e\u6570\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{batch, billList.size(), System.currentTimeMillis() - time});
                        time = System.currentTimeMillis();
                        AcaMatAllocHelper.coAlloc(billList, allocReport);
                        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6279\u6b21\uff1a{}\u5f15\u5165\u65f6\u5bf9\u5171\u8017\u6750\u6599\u8fdb\u884c\u81ea\u52a8\u5206\u914d\u548c\u786e\u8ba4,\u8017\u65f6\uff1a{}ms", (Object)batch, (Object)(System.currentTimeMillis() - time));
                    }
                    if (!billList.isEmpty()) {
                        MultiPartCcHelper.checkIfMultiPartCc(billList);
                    }
                    if (StringUtils.isEmpty((CharSequence)progressId)) continue;
                    ProgressHelper.setProgress(progressId, ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"AcaMatAllocHelper_6", (String)"macc-aca-algox", (Object[])new Object[0]), unitPartProcess, "%");
                }
                if (allocReport == null) continue;
            }
            catch (Exception ex) {
                try {
                    errorMsg = ex.getMessage();
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (allocReport != null) {
                        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                            AllocReportHelper.addCheckDatail((AllocReport)allocReport, null, (long)0L, (String)errorMsg);
                        }
                        AllocReportHelper.saveReport((AllocReport)allocReport);
                        res.getReportIds().add(allocReport.getReportId());
                        res.setReportContainError(!"1".equals(allocReport.getStatus()));
                    }
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                AllocReportHelper.addCheckDatail((AllocReport)allocReport, null, (long)0L, (String)errorMsg);
            }
            AllocReportHelper.saveReport((AllocReport)allocReport);
            res.getReportIds().add(allocReport.getReportId());
            res.setReportContainError(!"1".equals(allocReport.getStatus()));
        }
        ArrayList errorList = Lists.newArrayList();
        Map<String, String> reasonMap = res.getReasonMap();
        if (res.isSuccess()) {
            if (billSize == 0L) {
                res.setSuccess(false);
                reasonMap.put("false", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5f15\u5165\u7684\u6570\u636e\u3002", (String)"AcaMatAllocHelper_3", (String)"macc-aca-algox", (Object[])new Object[0]));
            } else {
                reasonMap.put("success", ResManager.loadKDString((String)"\u5f15\u5165\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u6570\u636e\u6210\u529f\u3002", (String)"AcaMatAllocHelper_4", (String)"macc-aca-algox", (Object[])new Object[0]));
            }
        } else {
            String titleMsg = ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u6570\u636e", (String)"AcaMatAllocHelper_7", (String)"macc-aca-algox", (Object[])new Object[0]);
            for (Map.Entry<String, String> entry : reasonMap.entrySet()) {
                String key = entry.getKey();
                String msg = String.format(ResManager.loadKDString((String)("%s: " + entry.getValue()), (String)"AcaMatAllocHelper_5", (String)"macc-aca-algox", (Object[])new Object[0]), key);
                errorList.add(new String[]{titleMsg, "Error", msg});
            }
            reasonMap.clear();
            res.setErrorList(errorList);
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u7ed3\u675f");
        return res;
    }

    private static Map<String, IDataEntityProperty> getExtFieldMap() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_matusecollect");
        Map allMatCollectField = entityType.getAllFields();
        allMatCollectField.entrySet().removeIf(entry -> !CadEmptyUtils.equals((String)((IDataEntityProperty)entry.getValue()).getParent().toString(), (String)"aca_matusecollect"));
        MainEntityType matAllocEntityType = MetadataServiceHelper.getDataEntityType((String)"aca_matalloc");
        Map allMatAllocField = matAllocEntityType.getAllFields();
        allMatAllocField.entrySet().removeIf(entry -> {
            if (!(((String)entry.getKey()).contains("_") && allMatCollectField.containsKey(entry.getKey()) && CadEmptyUtils.equals((String)((IDataEntityProperty)entry.getValue()).getParent().toString(), (String)"aca_matalloc"))) {
                return true;
            }
            return allMatCollectField.containsKey(entry.getKey()) && ((IDataEntityProperty)allMatCollectField.get(entry.getKey())).getPropertyType() != ((IDataEntityProperty)entry.getValue()).getPropertyType();
        });
        return allMatAllocField;
    }

    private static Map<String, Pair<Long, Long>> getStringPairMap(DynamicObjectCollection bills, Date createTime, Long orgId) {
        Set materialToDateThreeTuple = bills.stream().map(e -> new Tuple((Object)new FourTuple((Object)e.getLong("material"), (Object)e.getLong("matversion"), (Object)e.getLong("auxpty"), (Object)e.getLong("manuorg")), (Object)createTime)).collect(Collectors.toSet());
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getAcaSubElementByOrg", (Object[])new Object[]{orgId, materialToDateThreeTuple});
    }

    public static void coAlloc(List<DynamicObject> dyns, AllocReport report) {
        AllocReportHelper.addCheckItem((AllocReport)report, (String)"2", (String)ResManager.loadKDString((String)"\u7269\u6599\u672a\u627e\u5230\u5206\u914d\u6807\u51c6\u3002", (String)"AcaMatAllocHelper_10", (String)"macc-aca-algox", (Object[])new Object[0]));
        HashSet<Long> toAllocBills = new HashSet<Long>();
        String costdriverMsg = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AcaMatAllocHelper_11", (String)"macc-aca-algox", (Object[])new Object[0]);
        dyns.forEach(t -> {
            if (!"2".equals(t.getString("allocstatus")) && t.getLong("costdriver") > 0L) {
                if (t.getLong("costdriver") == 0L) {
                    AllocReportHelper.addCheckDatail((AllocReport)report, (String)"2", (long)t.getLong("costcenter"), (String)(t.getString("billno") + costdriverMsg));
                } else {
                    toAllocBills.add(t.getLong("id"));
                }
            }
        });
        if (toAllocBills.size() > 0) {
            AcaMatAllocHelper.doAlloc(toAllocBills, "2", report);
        }
    }

    private static void setBillData(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, Date createTime, Map<String, String> matAllocStdMap, Map<String, IDataEntityProperty> matAllocExtFieldMap) {
        String costdriverKey;
        allocBill.set("manuorg", (Object)bill.getLong("manuorg"));
        allocBill.set("org", (Object)bill.getLong("org"));
        allocBill.set("costcenter", (Object)bill.getLong("costcenter"));
        allocBill.set("biztype", (Object)bill.getString("biztype"));
        allocBill.set("srcbiztype", (Object)bill.getString("srcbiztype"));
        allocBill.set("bizdate", (Object)bill.getDate("bizdate"));
        allocBill.set("srcbilltype", (Object)bill.getString("srcbilltype"));
        Long costobjectId = bill.getLong("costobject");
        if (!(costobjectId != null && costobjectId != 0L || StringUtils.isEmpty((CharSequence)(costdriverKey = AcaMatAllocHelper.getMatAllocStdCostDriver(bill.getLong("org"), bill.getLong("manuorg"), bill.getLong("costcenter"), bill.getLong("material"), bill.getLong("matversion"), bill.getLong("auxpty"), bill.getLong("materialgroup"), matAllocStdMap))))) {
            String[] costdriverArr = costdriverKey.split("@");
            allocBill.set("costdriver", (Object)Long.parseLong(costdriverArr[0]));
            if (costdriverArr.length > 1) {
                allocBill.set("allocdim", (Object)costdriverArr[1]);
            }
        }
        allocBill.set("material", (Object)bill.getLong("material"));
        allocBill.set("matversion", (Object)bill.getLong("matversion"));
        allocBill.set("auxpty", (Object)bill.getLong("auxpty"));
        allocBill.set("useqty", (Object)bill.getBigDecimal("qty"));
        allocBill.set("warehouse", (Object)bill.getLong("warehouse"));
        allocBill.set("location", (Object)bill.getLong("location"));
        allocBill.set("costobject", (Object)bill.getLong("costobject"));
        allocBill.set("lotcoderule", bill.get("lotcoderule"));
        allocBill.set("unit", (Object)bill.getLong("unit"));
        allocBill.set("baseunit", (Object)bill.getLong("baseunit"));
        allocBill.set("appnum", (Object)bill.getString("appnum"));
        allocBill.set("productgroup", (Object)bill.getLong("productgroup"));
        allocBill.set("costaccount", costaccountMap.get("costaccountId"));
        allocBill.set("period", costaccountMap.get("currentperiodId"));
        allocBill.set("currency", costaccountMap.get("currencyId"));
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("alloctype", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue());
        String rowIndex = bill.getString("seq");
        String billno = bill.getString("billno") + "_" + rowIndex + "_" + (String)costaccountMap.get("costaccountnum");
        allocBill.set("billno", (Object)billno);
        allocBill.set("matcollect", (Object)bill.getLong("entryid"));
        allocBill.set("matusesrcbillentryid", (Object)bill.getLong("sourcebillentryid"));
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
        allocBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("createtime", (Object)createTime);
        allocBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("modifytime", (Object)createTime);
        allocBill.set("isreturnitem", bill.get("isrework"));
        allocBill.set("productnum", bill.get("productnum"));
        allocBill.set("subproductnum", bill.get("subproductnum"));
        allocBill.set("product", bill.get("product"));
        allocBill.set("sourcebillid", bill.get("sourcebillid"));
        allocBill.set("project", bill.get("project"));
        allocBill.set("configuredcode", bill.get("configuredcode"));
        allocBill.set("tracknumber", bill.get("tracknumber"));
        if (!CadEmptyUtils.isEmpty(matAllocExtFieldMap)) {
            for (Map.Entry<String, IDataEntityProperty> entry : matAllocExtFieldMap.entrySet()) {
                allocBill.set(entry.getKey(), bill.get(entry.getKey()));
            }
        }
    }

    private static Set<Long> getImportDataBillEntryId(Map<String, Object> costaccountMap, boolean isDealPublic) {
        Long orgId = (Long)costaccountMap.get("org");
        QFilter orgIdQF = new QFilter("org", "=", (Object)orgId);
        Object currentperiodId = costaccountMap.get("currentperiodId");
        QFilter periodQF = new QFilter("id", "=", currentperiodId);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"begindate, enddate", (QFilter[])new QFilter[]{periodQF});
        if (periods.isEmpty()) {
            return null;
        }
        DynamicObject period = (DynamicObject)periods.get(0);
        QFilter begindateQF = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        QFilter enddateQF = new QFilter("bookdate", "<=", (Object)period.getDate("enddate"));
        QFilter costaccountQF = new QFilter("costaccount", "=", costaccountMap.get("costaccountId"));
        costaccountQF.and("period", "=", currentperiodId);
        QFilter appNumQf = new QFilter("appnum", "=", costaccountMap.get("appnum"));
        DataSet existAllocBills = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper.getImportDataId1", (String)"aca_matalloc", (String)"matcollect", (QFilter[])new QFilter[]{orgIdQF, costaccountQF, appNumQf}, null);
        ArrayList<Long> existAllocIds = new ArrayList<Long>();
        for (Row row : existAllocBills) {
            existAllocIds.add(row.getLong("matcollect"));
        }
        QFilter billstatusQF = new QFilter("billstatus", "=", (Object)"C");
        List costObjectList = (List)costaccountMap.get("costObjectList");
        QFilter costObjectQF = null;
        if (costObjectList != null && !costObjectList.isEmpty()) {
            costObjectQF = new QFilter("entryentity.costobject", "in", (Object)costObjectList);
        }
        if (!isDealPublic && costObjectQF == null) {
            costObjectQF = new QFilter("entryentity.costobject", "!=", (Object)0L);
        }
        QFilter[] qfilterArr = new QFilter[]{billstatusQF, orgIdQF, begindateQF, enddateQF, appNumQf, costObjectQF};
        StringBuilder filterSb = new StringBuilder();
        for (QFilter filter : qfilterArr) {
            if (filter == null) continue;
            filterSb.append(filter.toString()).append(" ");
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u83b7\u53d6\u9700\u8981\u5f15\u5165\u7684\u6570\u636e\u6761\u4ef6\uff1a{}", (Object)filterSb);
        HashSet totalIds = Sets.newHashSetWithExpectedSize((int)1024);
        DataSet importDataIdDataSet = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper.getImportDataId", (String)"aca_matusecollect", (String)"entryentity.id As entryid", (QFilter[])qfilterArr, null);
        for (Row row : importDataIdDataSet) {
            totalIds.add(row.getLong("entryid"));
        }
        totalIds.removeAll(existAllocIds);
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u9700\u8981\u5f15\u5165\u7684\u5355\u636eid\u6570\uff1a{}", (Object)totalIds.size());
        return totalIds;
    }

    public static void setMatAllocStdNull(Set<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        idFilter.and("allocstatus", "=", (Object)"0");
        idFilter.and("costdriver", "=", (Object)0);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"aca_matalloc", (String)"id,org,costcenter,costdriver,manuorg, material,matversion,auxpty,allocdim", (QFilter[])new QFilter[]{idFilter});
        if (dynObjs.length == 0) {
            return;
        }
        Long orgId = 0L;
        HashMap<Long, List> costcenterInIdMap = new HashMap<Long, List>(16);
        for (DynamicObject dynObj : dynObjs) {
            orgId = dynObj.getLong("org.id");
            Long costcenterId = dynObj.getLong("costcenter.id");
            costcenterInIdMap.computeIfAbsent(costcenterId, t -> new ArrayList()).add(dynObj);
        }
        Map<String, String> matAllocStdMap = AcaMatAllocHelper.getMatAllocStdMap(orgId, "aca");
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>();
        for (DynamicObject dynObj : dynObjs) {
            String costdriverKey = AcaMatAllocHelper.getMatAllocStdCostDriver(dynObj.getLong("org.id"), dynObj.getLong("manuorg.id"), dynObj.getLong("costcenter.id"), dynObj.getLong("material.id"), dynObj.getLong("matversion.id"), dynObj.getLong("auxpty.id"), dynObj.getLong("material.group.id"), matAllocStdMap);
            if (StringUtils.isEmpty((CharSequence)costdriverKey)) continue;
            String[] costdriverArr = costdriverKey.split("@");
            dynObj.set("costdriver", (Object)Long.parseLong(costdriverArr[0]));
            if (costdriverArr.length > 1) {
                dynObj.set("allocdim", (Object)costdriverArr[1]);
            }
            saveObjs.add(dynObj);
        }
        if (saveObjs.size() == 0) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
    }

    public static DataSet getAllocDataByDiyCostDrive(Map<String, Object> itemMap, boolean isMaterialGroup) {
        QFilter filter = new QFilter("id", "=", itemMap.get("costdriver"));
        DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,iscomplexcd,formula,number,name,isrelatedwork,workactivity,islinkresource,matchpattern,resource.fbasedataid resource,resourcetype,matchreport,costtype", (QFilter[])new QFilter[]{filter});
        if (costDrivers.isEmpty()) {
            return null;
        }
        if (((DynamicObject)costDrivers.get(0)).getBoolean("iscomplexcd")) {
            long costDriverId;
            DataSet complexCostDriverValue = AcaMatAllocHelper.getComplexCostDriverValue((DynamicObject)costDrivers.get(0), itemMap, isMaterialGroup);
            if (complexCostDriverValue == null) {
                return null;
            }
            long l = costDriverId = costDrivers.get(0) == null ? 0L : ((DynamicObject)costDrivers.get(0)).getLong("id");
            if (AcaMatAllocHelper.isContainMtfStockDriver(costDriverId)) {
                HashSet costObjectIds = new HashSet(256);
                complexCostDriverValue.copy().forEach(s -> costObjectIds.add(s.getLong("costobject")));
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    QFilter idQFilter = new QFilter("id", "in", costObjectIds);
                    DataSet costObjectMatDs = QueryServiceHelper.queryDataSet((String)"getcostobjectmat", (String)"cad_costobject", (String)"id,material", (QFilter[])idQFilter.toArray(), null);
                    complexCostDriverValue = complexCostDriverValue.removeFields(new String[]{"material"});
                    complexCostDriverValue = complexCostDriverValue.join(costObjectMatDs, JoinType.INNER).on("costobject", "id").select(complexCostDriverValue.getRowMeta().getFieldNames(), new String[]{"material"}).finish();
                }
            }
            complexCostDriverValue = complexCostDriverValue.groupBy(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "submaterial"}).sum("value").finish();
            return complexCostDriverValue;
        }
        if (((DynamicObject)costDrivers.get(0)).getBoolean("isrelatedwork")) {
            return AcaMatAllocHelper.getWorkActiveData(itemMap, ((DynamicObject)costDrivers.get(0)).get("workactivity"));
        }
        if (((DynamicObject)costDrivers.get(0)).getBoolean("islinkresource")) {
            String matchpattern;
            Set<Long> resourceIds = null;
            String valueField = "facthour";
            if ("much".equals(((DynamicObject)costDrivers.get(0)).getString("matchreport"))) {
                valueField = "factuse";
            }
            if ("resource".equals(matchpattern = ((DynamicObject)costDrivers.get(0)).getString("matchpattern"))) {
                resourceIds = new HashSet<Long>(32);
                for (DynamicObject costDriver : costDrivers) {
                    resourceIds.add(costDriver.getLong("resource"));
                }
            } else {
                HashSet<String> resTypeSet = new HashSet<String>(32);
                String resTypes = ((DynamicObject)costDrivers.get(0)).getString("resourcetype");
                if (!StringUtils.isEmpty((CharSequence)resTypes)) {
                    String[] resTypsArr;
                    for (String restype : resTypsArr = resTypes.split(",")) {
                        if ("A".equals(restype)) {
                            resTypeSet.add("mpdm_equipment");
                            continue;
                        }
                        if ("B".equals(restype)) {
                            resTypeSet.add("mpdm_toolsresource");
                            continue;
                        }
                        if ("C".equals(restype)) {
                            resTypeSet.add("mpdm_toolequip");
                            continue;
                        }
                        if ("D".equals(restype)) {
                            resTypeSet.add("mpdm_mould");
                            continue;
                        }
                        if (!"E".equals(restype)) continue;
                        resTypeSet.add("mpdm_manuperson");
                    }
                }
                resourceIds = AcaMatAllocHelper.getResourceFromType(resTypeSet);
            }
            if (resourceIds.isEmpty()) {
                return null;
            }
            return AcaMatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, valueField, "");
        }
        return AcaMatAllocHelper.getDiyData(itemMap);
    }

    private static DataSet getWorkActiveData(Map<String, Object> allocMap, Object workactId) {
        if (workactId == null) {
            return null;
        }
        String selectFields = "org,costcenter,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.entryqty value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? ", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter")});
        filter.and(new QFilter("costdriver", "=", allocMap.get("costdriver")));
        filter.and(new QFilter("workactivity", "=", workactId));
        filter.and(QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{allocMap.get("begindate"), allocMap.get("enddate")}));
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        filter.and("entryentity.costobject.producttype", "=", (Object)"C");
        return AcaMatAllocHelper.queryStdValDataBy("sca_workqtycollec", selectFields, filter, allocMap);
    }

    private static DataSet getDiyData(Map<String, Object> allocMap) {
        String selectFields = "org,costcenter,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.entryqty value";
        QFilter filter = QFilter.of((String)"org = ? and costcenter = ? ", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter")});
        filter.and(new QFilter("costdriver", "=", allocMap.get("costdriver")));
        filter.and("entryentity.costobject.producttype", "=", (Object)"C");
        if (allocMap.get("costaccount") != null) {
            filter.and(new QFilter("costaccount", "=", allocMap.get("costaccount")));
        }
        long periodId = allocMap.get("periodId") == null ? 0L : (Long)allocMap.get("periodId");
        filter.and(new QFilter("effectperiod", "!=", (Object)0L));
        filter.and(AcaMatAllocHelper.getEffectDateFilter(periodId));
        return AcaMatAllocHelper.queryStdValDataBy("sca_diycostdriver", selectFields, filter, allocMap);
    }

    public static QFilter getEffectDateFilter(Long periodId) {
        Date date = AcaMatAllocHelper.getEndDateByPeriod(periodId);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    private static Date getEndDateByPeriod(Long periodId) {
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,enddate", (QFilter[])qFilter.toArray());
        if (period == null) {
            return new Date();
        }
        return period.getDate("enddate");
    }

    private static Map<Long, DynamicObject> getCalCostRecord(Long costAccountId, List<Long> sourceBillIds) {
        DynamicObjectCollection costRecords = AcaMatAllocHelper.getCalCostRecordData(costAccountId, sourceBillIds);
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        costRecords.forEach(e -> {
            long bizbillentryid = e.getLong("bizbillentryid");
            resultMap.put(bizbillentryid, (DynamicObject)e);
        });
        return resultMap;
    }

    private static Map<Long, DynamicObject> getCalCostAdjust(Long costAccountId, List<Long> sourceBillIds) {
        DynamicObjectCollection costRecords = AcaMatAllocHelper.getCalCostAdjustData(costAccountId, sourceBillIds);
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        costRecords.forEach(e -> {
            long bizbillentryid = e.getLong("entryid");
            resultMap.put(bizbillentryid, (DynamicObject)e);
        });
        return resultMap;
    }

    public static Map<Long, Long> getMatSubEleRelate(List<Long> materials, Object costtypeId) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>();
        QFilter costtypeFilter = new QFilter("costtype", "=", costtypeId);
        DynamicObjectCollection matEles = QueryServiceHelper.query((String)"cad_subelement_material", (String)"material,subelement", (QFilter[])new QFilter[]{costtypeFilter});
        Map<Long, Long> allMap = matEles.stream().collect(Collectors.toMap(e -> e.getLong("material"), e -> e.getLong("subelement")));
        Long matDefSubEle = AcaAlgoxElementHelper.getMatDefSubEle();
        for (Long material : materials) {
            if (allMap.get(material) != null) {
                resultMap.put(material, allMap.get(material));
                continue;
            }
            resultMap.put(material, matDefSubEle);
        }
        return resultMap;
    }

    private static DynamicObjectCollection getCalCostRecordData(Long costAccountId, List<Long> sourceBillIds) {
        String fields = "bizbillid,entry.bizbillentryid bizbillentryid,entry.actualcost actualcost,entry.material material,entry.assist assist,entry.caldimension.caldimension caldimension,entry.noupdatecalfields noupdatecalfields";
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", sourceBillIds), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("billstatus", "=", (Object)"C")});
        return costRecords;
    }

    private static DynamicObjectCollection getCalCostAdjustData(Long costAccountId, List<Long> sourceBillIds) {
        String fields = "id,entryentity.id entryid,entryentity.adjustamt actualcost,entryentity.material material,entryentity.assist assist,entryentity.caldimension.caldimension caldimension,entryentity.noupdatecalfields noupdatecalfields";
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("billstatus", "=", (Object)"C")});
        return costRecords;
    }

    private static void setAllocDetail(DynamicObject allocBill, DynamicObject bill, Map<String, Pair<Long, Long>> matIdToPairMap, Map<String, Object> costaccountMap, List<DynamicObject> calCostRecList) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        Long materialId = allocBill.getLong("material");
        Long matVersionId = allocBill.getLong("matversion");
        Long auxptyId = allocBill.getLong("auxpty");
        Long manuorg = allocBill.getLong("manuorg");
        Date date = allocBill.getDate("createtime");
        String strKey = AcaMatAllocHelper.getStrKey(String.valueOf(materialId), matVersionId, auxptyId, manuorg, date);
        Pair<Long, Long> eleSubElePair = matIdToPairMap.get(strKey);
        DynamicObject entry = entryentity.addNew();
        BigDecimal price = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("qty")) != 0) {
            price = allocBill.getBigDecimal("useamount").divide(bill.getBigDecimal("qty"), 10, RoundingMode.HALF_UP);
        }
        long costObjectId = bill.getLong("costobject");
        entry.set("costobejctentry", (Object)costObjectId);
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        entry.set("amount", allocBill.get("useamount"));
        entry.set("price", (Object)price);
        if (eleSubElePair != null) {
            entry.set("subelemententry", eleSubElePair.getValue1());
            entry.set("elemententry", eleSubElePair.getValue0());
        }
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        allocBill.set("billstatus", (Object)"C");
        allocBill.set("alloctor", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("allocatedate", (Object)new Date());
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue());
    }

    public static Long getEleInfo(Object costtypeId, Long subEle) {
        DynamicObject costtype = BusinessDataServiceHelper.loadSingle((Object)costtypeId, (String)"cad_costtype");
        Long eletype = costtype.getLong("elementtype.masterid");
        Long element = AcaAlgoxElementHelper.getElementBySubele(Long.valueOf(subEle.toString()), eletype);
        return element;
    }

    private static DataSet getComplexCostDriverValue(DynamicObject complexCostDriver, Map<String, Object> itemMap, boolean isMaterialGroup) {
        String formula = complexCostDriver.getString("formula");
        String currentNumber = complexCostDriver.getString("number");
        String currentName = complexCostDriver.getString("name");
        long costDriverId = complexCostDriver.getLong("id");
        try {
            formula = FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, costDriverId);
        }
        catch (Exception e) {
            logger.error("\u590d\u5408\u6210\u672c\u52a8\u56e0\u516c\u5f0f\u51fa\u73b0\u5d4c\u5957\u5f02\u5e38", (Throwable)e);
            logger.error("getCompleteFormula error, formula is:{}", (Object)formula);
            return null;
        }
        List<String> suffixList = FormulaUtil.analyticFormula(formula);
        DataSet opResultDs = null;
        DataSet totalDriverDs = null;
        long periodId = (Long)itemMap.get("periodId");
        long orgId = (Long)itemMap.get("org");
        long costAccountId = (Long)itemMap.get("costaccount");
        ArrayList<String> materials = new ArrayList<String>();
        ArrayList<String> materialGroups = new ArrayList<String>();
        DataSet classifiedMaterialDataSet = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (suffixList != null && !suffixList.isEmpty()) {
            for (String number : suffixList) {
                QFilter qFilter;
                DynamicObject costDriver;
                if (OPERATOR.indexOf(number) >= 0 || !AcaMatAllocHelper.isInteger(number) || (costDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"id,number,allocclass,ismatgroupcal", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.parseLong(number))).toArray())) == null) continue;
                costDriverId = costDriver.getLong("id");
                itemMap.put("costdriver", costDriverId);
                itemMap.put("stdnumber", costDriver.getString("number"));
                String allocClass = costDriver.getString("allocclass");
                if (COSTCENTER.equals(allocClass)) {
                    DataSet diyCostDriverDs = FormulaUtil.getDiyDsOnCostCenter(costDriverId, orgId, costAccountId, periodId, "aca");
                    diyCostDriverDs = diyCostDriverDs.executeSql("select " + costDriverId + " as costdriver,org,costcenter,benefcostcenter,0 as costobject,0 as material,sum(value) value group by costdriver,org,costcenter,benefcostcenter");
                    totalDriverDs = AcaMatAllocHelper.union(totalDriverDs, diyCostDriverDs);
                    continue;
                }
                if (COSTOBJECT.equals(allocClass)) {
                    DataSet costDriverValue = AcaMatAllocHelper.getCostDriverValue(itemMap, isMaterialGroup);
                    if (costDriverValue != null) {
                        costDriverValue = costDriverValue.executeSql("select " + costDriverId + " as costdriver,org,costcenter,costobject,material,sum(value) value group by org,costcenter,costobject,material");
                        costDriverValue = costDriverValue.executeSql("select costdriver,org,costcenter,costcenter as benefcostcenter,costobject,material,value");
                    }
                    totalDriverDs = AcaMatAllocHelper.union(totalDriverDs, costDriverValue);
                    continue;
                }
                if (MATERIALGROUP.equals(allocClass)) {
                    DynamicObject[] diyCostDriverDys;
                    QFilter filters = new QFilter("org", "=", (Object)orgId);
                    filters.and(new QFilter("appnum", "=", (Object)"aca"));
                    filters.and(new QFilter("costdriver.id", "=", (Object)costDriverId));
                    filters.and(new QFilter("effectperiod", "!=", (Object)0L));
                    filters.and(new QFilter("costaccount", "=", (Object)costAccountId));
                    filters.and(AcaMatAllocHelper.getEffectDateFilter(periodId));
                    for (DynamicObject diyCostDriverDy : diyCostDriverDys = BusinessDataServiceHelper.load((String)"sca_diycostdriver", (String)"costdriver,org,materialgroupstd,entryentity,entryentity.materialgroup", (QFilter[])filters.toArray())) {
                        DynamicObject materialGroupStandard = diyCostDriverDy.getDynamicObject("materialgroupstd");
                        DynamicObjectCollection entryEntity = diyCostDriverDy.getDynamicObjectCollection("entryentity");
                        HashSet<DynamicObject> materialGroupSet = new HashSet<DynamicObject>(16);
                        entryEntity.forEach(s -> materialGroupSet.add(s.getDynamicObject("materialgroup")));
                        DataSet materialDataSet = AcaMatAllocHelper.getClassifiedMaterialDataSet(materialGroupSet, materialGroupStandard);
                        classifiedMaterialDataSet = classifiedMaterialDataSet == null ? materialDataSet : classifiedMaterialDataSet.union(materialDataSet).distinct();
                    }
                    materialGroups.add(String.valueOf(costDriverId));
                    paramMap.put(String.valueOf(costDriverId), costDriver.getBoolean("ismatgroupcal"));
                    continue;
                }
                materials.add(String.valueOf(costDriverId));
            }
            paramMap.put("exp", suffixList);
            paramMap.put("isMaterialGroup", isMaterialGroup);
            paramMap.put("materialGroup", materialGroups);
            paramMap.put("simulCostTypeId", complexCostDriver.getLong("costtype"));
            paramMap.put("material", materials);
            paramMap.put("costtype", itemMap.get("costtype"));
            paramMap.put("orgId", orgId);
            paramMap.put("costAccountId", costAccountId);
            paramMap.put("periodId", periodId);
            paramMap.put("appId", "aca");
            paramMap.put("subMat", itemMap.get("material"));
            paramMap.put("subAuxpty", itemMap.get("auxpty"));
            if (totalDriverDs != null && !totalDriverDs.isEmpty()) {
                boolean isConSiAux = false;
                if (!CadEmptyUtils.isEmpty(materials)) {
                    QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                    qFilter.and(new QFilter("costaccount", "=", (Object)costAccountId));
                    qFilter.and(new QFilter("appnum", "=", (Object)"aca"));
                    HashSet costDriverIds = new HashSet(16);
                    materials.forEach(s -> costDriverIds.add(Long.parseLong(s)));
                    qFilter.and(new QFilter("costdriver", "in", costDriverIds));
                    qFilter.and(new QFilter("entryentity.matauxpty", "!=", (Object)0L));
                    isConSiAux = QueryServiceHelper.exists((String)"sca_diycostdriver", (QFilter[])qFilter.toArray());
                }
                paramMap.put("isConSiAux", isConSiAux);
                opResultDs = FormulaUtil.startCostObjectCalculate(paramMap, totalDriverDs, classifiedMaterialDataSet, isConSiAux);
            }
        }
        if (opResultDs != null) {
            return opResultDs.select("org,costcenter,costobject,materialgroup,material,submaterial,value");
        }
        return null;
    }

    public static DataSet getClassifiedMaterialDataSet(Set<DynamicObject> materialGroupSet, DynamicObject materialGroupStandard) {
        Object pkValue = 730148448254487552L;
        if (materialGroupStandard != null) {
            pkValue = materialGroupStandard.getPkValue();
        }
        DataSet classifiedMaterialDataSet = null;
        if (materialGroupSet != null && materialGroupSet.size() > 0) {
            for (DynamicObject materialGroup : materialGroupSet) {
                long materialGroupId = materialGroup.getLong("id");
                QFilter filter = new QFilter("standard", "=", pkValue);
                filter.and(AcaMatAllocHelper.getGroupFilter(materialGroup, "group.longnumber"));
                DataSet materialGroupDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)(materialGroupId + " as materialgroup,material"), (QFilter[])filter.toArray(), (String)"group desc");
                if (classifiedMaterialDataSet == null) {
                    classifiedMaterialDataSet = materialGroupDataSet;
                    continue;
                }
                classifiedMaterialDataSet = classifiedMaterialDataSet.union(materialGroupDataSet).distinct();
            }
        }
        return classifiedMaterialDataSet;
    }

    public static QFilter getGroupFilter(DynamicObject materialGroup, String fieldName) {
        if (materialGroup != null) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            HashSet<String> groupNumSet = new HashSet<String>(16);
            String longnumber = materialGroup.getString("longnumber");
            groupFilter.or(new QFilter(fieldName, "like", (Object)(longnumber + longNumberDLM + "%")));
            groupNumSet.add(longnumber);
            if (!groupNumSet.isEmpty()) {
                groupFilter.or(new QFilter(fieldName, "in", groupNumSet));
            }
            return groupFilter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static DataSet getCostDriverValue(Map<String, Object> itemMap, boolean isMaterialGroup) {
        String stdNumber = String.valueOf(itemMap.get("stdnumber"));
        return AcaMatAllocHelper.getCostCenterValues(stdNumber, itemMap, isMaterialGroup, true);
    }

    private static DataSet union(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 == null && dataSet2 == null) {
            return null;
        }
        if (dataSet1 == null) {
            return dataSet2;
        }
        if (dataSet2 == null) {
            return dataSet1;
        }
        DataSet result = dataSet1.union(dataSet2).distinct();
        return result;
    }

    public static String getStrKey(String materialId, Long matVersionId, Long auxptyId, Long manuorg, Date createDate) {
        materialId = AcaAlgoxEmptyOrZeroUtils.isEmpty(matVersionId) ? materialId + "@0" : materialId + "@" + matVersionId;
        materialId = AcaAlgoxEmptyOrZeroUtils.isEmpty(auxptyId) ? materialId + "@0" : materialId + "@" + auxptyId;
        String string = materialId = AcaAlgoxEmptyOrZeroUtils.isEmpty(manuorg) ? materialId + "@0" : materialId + "@" + manuorg;
        if (createDate != null) {
            materialId = materialId + "@" + createDate.getTime();
        }
        return materialId;
    }

    public static Map<String, String> getMatAllocStdMap(Long orgId, String appnum) {
        HashSet<Long> orgIds = new HashSet<Long>();
        orgIds.add(orgId);
        return AcaMatAllocHelper.getMatAllocStdMap(orgIds, appnum);
    }

    public static Map<String, String> getMatAllocStdMap(Set<Long> orgIds, String appnum) {
        HashMap<String, String> map = new HashMap<String, String>(32);
        QFilter stdFilter = QFilter.of((String)"billstatus =?", (Object[])new Object[]{"C"});
        stdFilter = stdFilter.and(new QFilter("org", "in", orgIds));
        stdFilter = stdFilter.and("appnum", "=", (Object)appnum);
        stdFilter = stdFilter.and("expdate", ">=", (Object)new Date());
        DataSet stdDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocHelper.getMatAllocStdMap", (String)"sca_matallocstd", (String)"id,billno,org,manuorg,allocentry.costcenter costcenter,allocentry.bmaterial bmaterial,allocentry.matversion matversion,allocentry.auxpty auxpty,allocentry.materialgroup materialgroup,allocentry.materialgroup.longnumber materialgrouplongnumber,allocentry.materialgroup.standard standard,allocentry.costdriver costdriver,allocentry.allocdim allocdim", (QFilter[])new QFilter[]{stdFilter}, null);
        if (!stdDataSet.isEmpty()) {
            while (stdDataSet.hasNext()) {
                Row row = stdDataSet.next();
                Long costdriverId = row.getLong("costdriver");
                String allocdim = row.getString("allocdim");
                String costdriverKey = String.format("%s@%s", costdriverId, allocdim);
                Long materialgroup = AcaMatAllocHelper.getRowLongVal(row, "materialgroup");
                if (CadEmptyUtils.isEmpty((Long)materialgroup)) {
                    String uniqKey = String.format("%s@%s@%s@%s@%s@%s@%s", AcaMatAllocHelper.getRowLongVal(row, "org"), AcaMatAllocHelper.getRowLongVal(row, "manuorg"), AcaMatAllocHelper.getRowLongVal(row, "costcenter"), AcaMatAllocHelper.getRowLongVal(row, "bmaterial"), AcaMatAllocHelper.getRowLongVal(row, "matversion"), AcaMatAllocHelper.getRowLongVal(row, "auxpty"), materialgroup);
                    map.put(uniqKey, costdriverKey);
                    continue;
                }
                Set<Long> materialIds = AcaMatAllocHelper.getGroupMaterial(materialgroup, AcaMatAllocHelper.getRowLongVal(row, "standard"), row.getString("materialgrouplongnumber"));
                for (Long id : materialIds) {
                    String uniqKey = String.format("%s@%s@%s@%s@%s@%s@%s", AcaMatAllocHelper.getRowLongVal(row, "org"), AcaMatAllocHelper.getRowLongVal(row, "manuorg"), AcaMatAllocHelper.getRowLongVal(row, "costcenter"), AcaMatAllocHelper.getRowLongVal(row, "bmaterial"), AcaMatAllocHelper.getRowLongVal(row, "matversion"), AcaMatAllocHelper.getRowLongVal(row, "auxpty"), id);
                    map.put(uniqKey, costdriverKey);
                }
            }
        }
        return map;
    }

    public static Set<Long> getGroupMaterial(Long groupId, Long standardId, String groupLongNum) {
        HashSet groupIds = Sets.newHashSet();
        groupIds.add(groupId);
        if (StringUtils.isNotEmpty((CharSequence)groupLongNum)) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "!";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = new QFilter("standard", "=", (Object)standardId);
            groupFilter.and("longnumber", "like", (Object)(groupLongNum + longNumberDLM + "%"));
            DataSet groupDs = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroup", (String)"id,number,standard", (QFilter[])groupFilter.toArray(), null);
            for (Row row : groupDs) {
                groupIds.add(row.getLong("id"));
            }
        }
        QFilter filter = new QFilter("group", "in", (Object)groupIds);
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material", (QFilter[])filter.toArray(), null);
        HashSet materialIds = Sets.newHashSet();
        for (Row row : classifiedMaterialDataSet) {
            materialIds.add(row.getLong("material"));
        }
        return materialIds;
    }

    private static Long getRowLongVal(Row row, String key) {
        return AcaMatAllocHelper.getLongVal(row.getLong(key));
    }

    private static Long getLongVal(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }

    public static String getMatAllocStdCostDriver(Long orgId, Long manuOrg, Long costcenter, Long material, Long matversion, Long auxpty, Long materialgroup, Map<String, String> stdMap) {
        manuOrg = AcaMatAllocHelper.getLongVal(manuOrg);
        costcenter = AcaMatAllocHelper.getLongVal(costcenter);
        material = AcaMatAllocHelper.getLongVal(material);
        matversion = AcaMatAllocHelper.getLongVal(matversion);
        auxpty = AcaMatAllocHelper.getLongVal(auxpty);
        String keyFormat = "%s@%s@%s@%s@%s@%s@%s";
        logger.info("\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5b8c\u6574\u7684\u5339\u914d\u4e32:\u6838\u7b97\u7ec4\u7ec7\uff1a{}\u751f\u4ea7\u7ec4\u7ec7\uff1a{}\uff0c\u6210\u672c\u4e2d\u5fc3\uff1a{}\uff0c\u7269\u6599\uff1a{}\uff0c\u7269\u6599\u7248\u672c\uff1a{}\uff0c\u8f85\u52a9\u5c5e\u6027\uff1a{}", new Object[]{orgId, manuOrg, costcenter, material, matversion, auxpty});
        logger.info("\u5339\u914d\u4e32\uff1a{}", (Object)String.format(keyFormat, orgId, manuOrg, costcenter, material, matversion, auxpty, 0));
        if (manuOrg != 0L) {
            String key = String.format(keyFormat, orgId, manuOrg, costcenter, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, costcenter, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, costcenter, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, 0, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, 0, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, 0, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
        } else {
            String key = String.format(keyFormat, orgId, 0, costcenter, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
        }
        return "";
    }
}

