/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class WipCostCheckService {
    private static final Log logger = LogFactory.getLog(WipCostCheckService.class);
    private static final String[] valueArr = new String[]{"0", "0", "0", "0"};

    public DataSet loadWipCostCheckDataSet(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, Long periodId) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costaccountId)) {
            logger.info("WipCostCheckService \u4f20\u5165\u53c2\u6570\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a");
            return null;
        }
        Date[] periodStartAndEndTime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
        if (periodStartAndEndTime == null || periodStartAndEndTime[0] == null || periodStartAndEndTime[1] == null) {
            logger.info("WipCostCheckService \u5f53\u524d\u671f\u95f4\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u672a\u7ef4\u62a4");
            return null;
        }
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!orgEnableMultiFactory && !CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            manuorgfId = 0L;
            logger.info("\u6570\u636e\u9519\u8bef,{}\u672a\u5f00\u542f\u591a\u5de5\u5382\u8bf7\u52ff\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7", (Object)orgId);
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)periodId);
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            orgQf.and(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        DataSet wipCostCheckSave = QueryServiceHelper.queryDataSet((String)"getWipCostCheckSave", (String)"aca_wipcostchecksave", (String)"org,manuorg,costcenter,costobject as wipcostobject,costobject.material as material,checknum as endproducting", (QFilter[])new QFilter[]{orgQf, costAccountQf, periodQf}, null);
        DataSet qtyWipCostCheckSave = wipCostCheckSave.copy().groupBy(new String[]{"org", "manuorg", "costcenter", "wipcostobject", "material"}).sum("endproducting").finish();
        DataSet calcResult = this.getCalcResult(orgId, costaccountId, costcenterfId, periodId, orgEnableMultiFactory).addFields(valueArr, new String[]{"startchangenum", "endproductchange", "currentinput", "currentfinish"});
        DataSet wipAdjustBill = this.getWipAdjustBill(orgId, manuorgfId, costaccountId, costcenterfId, periodId, orgEnableMultiFactory);
        DataSet startDataSet = wipAdjustBill.filter("adjustType = 'START'").select("org,manuorg ,costcenter,costobject,producttype,adjustqty as startchangenum,material,auxpty").addFields(valueArr, new String[]{"startnum", "endproductchange", "currentinput", "currentfinish"});
        DataSet endDataSet = wipAdjustBill.filter("adjustType = 'END'").select("org,manuorg ,costcenter,costobject,producttype,adjustqty as endproductchange,material,auxpty").addFields(valueArr, new String[]{"startnum", "startchangenum", "currentinput", "currentfinish"});
        DataSet plannedOutPutBill = this.getPlannedOutPutBill(orgId, manuorgfId, costcenterfId, periodStartAndEndTime, orgEnableMultiFactory).addFields(valueArr, new String[]{"startnum", "startchangenum", "endproductchange", "currentfinish"});
        DataSet factnedoutputbill = this.getFactnedOutputBill(orgId, manuorgfId, costcenterfId, periodStartAndEndTime, orgEnableMultiFactory).addFields(valueArr, new String[]{"startnum", "startchangenum", "endproductchange", "currentinput"});
        String[] fieldNames = calcResult.getRowMeta().getFieldNames();
        String sql = "org,manuorg, costcenter, costobject,producttype,material,startnum,startchangenum,endproductchange,currentinput, currentfinish,startnum+startchangenum+currentinput-currentfinish as endproducting";
        DataSet resultDs = calcResult.union(startDataSet.select(fieldNames)).union(endDataSet.select(fieldNames)).union(plannedOutPutBill.filter("producttype = 'C'").select(fieldNames)).union(factnedoutputbill.filter("producttype = 'C'").select(fieldNames)).groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("startnum").sum("startchangenum").sum("endproductchange").sum("currentinput").sum("currentfinish").finish().select(sql);
        DataSet innerDs = qtyWipCostCheckSave.join(resultDs, JoinType.INNER).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("wipcostobject", "costobject").on("material", "material").select(qtyWipCostCheckSave.getRowMeta().getFieldNames(), new String[]{"costobject"}).finish();
        DataSet leftDs = resultDs.leftJoin(innerDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("costobject", "wipcostobject").on("material", "material").select(resultDs.getRowMeta().getFieldNames(), new String[]{"wipcostobject"}).finish();
        DataSet formulaDs = leftDs.filter("wipcostobject is null").select("org,manuorg,costcenter,costobject,material,endproducting");
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        DataSet costObjectDs = formulaDs.copy().select("costobject").distinct();
        for (Row row : costObjectDs) {
            costObjectIds.add(row.getLong("costobject"));
        }
        if (!CadEmptyUtils.isEmpty(costObjectIds)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("accountorg", "=", (Object)orgId));
            qFilters.add(new QFilter("closedatetime", "<=", (Object)DateUtils.getDayEndTime((Date)periodStartAndEndTime[1])));
            qFilters.add(new QFilter("closestatu", "=", (Object)Boolean.TRUE));
            qFilters.add(new QFilter("costobject", "in", costObjectIds));
            qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
            DataSet closeCostObjectDs = QueryServiceHelper.queryDataSet((String)"getClosePlannedOutPutBill", (String)"cad_plannedoutputbill", (String)"costobject as closeCostObject", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            DataSet innerFormulaDs = formulaDs.join(closeCostObjectDs, JoinType.INNER).on("costobject", "closeCostObject").select(new String[]{"org", "manuorg", "costcenter", "costobject", "material", "0 as endproducting"}).finish();
            DataSet leftFormulaDs = formulaDs.leftJoin(closeCostObjectDs).on("costobject", "closeCostObject").select(formulaDs.getRowMeta().getFieldNames(), new String[]{"closeCostObject"}).finish();
            DataSet noCloseCostObjectDs = leftFormulaDs.filter("closeCostObject is null").select("org,manuorg,costcenter,costobject,material,endproducting");
            formulaDs = innerFormulaDs.union(noCloseCostObjectDs);
        }
        wipCostCheckSave = wipCostCheckSave.select("org,manuorg,costcenter,wipcostobject as costobject,material,endproducting");
        DataSet finalDs = formulaDs.union(wipCostCheckSave).distinct();
        return finalDs;
    }

    public Map<String, BigDecimal> loadDataDataSetConvertMap(DataSet fullDataSet) {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        if (fullDataSet == null) {
            return returnMap;
        }
        for (Row row : fullDataSet) {
            BigDecimal startnum = this.getBigDecimalValue(row.getBigDecimal("startnum"));
            BigDecimal endproductchange = this.getBigDecimalValue(row.getBigDecimal("endproductchange"));
            BigDecimal currentinput = this.getBigDecimalValue(row.getBigDecimal("currentinput"));
            BigDecimal currentfinish = this.getBigDecimalValue(row.getBigDecimal("currentfinish"));
            BigDecimal endproducting = startnum.add(endproductchange).add(currentinput).subtract(currentfinish);
            BigDecimal checknum = endproducting.add(endproductchange);
            String key = row.getLong("manuorg") + "@" + row.getLong("costcenter") + "@" + row.getLong("costobject");
            returnMap.put(key, checknum);
        }
        return returnMap;
    }

    private BigDecimal getBigDecimalValue(BigDecimal startnum) {
        return CadEmptyUtils.isEmpty((BigDecimal)startnum) ? BigDecimal.ZERO : startnum;
    }

    private DataSet getCalcResult(Long orgId, Long costaccountId, Set<Long> costcenterfId, Long periodId, Boolean orgEnableMultiFactory) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)periodId);
        QFilter periodQf = new QFilter("period", "=", (Object)(prePeriod == null ? 0L : prePeriod.getLong("id")));
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        QFilter typeQf = new QFilter("entryentity.type", "=", (Object)"finalResult");
        String selectFile = orgEnableMultiFactory != false ? "org,costobject.manuorg as manuorg ,costcenter,costobject,costobject.producttype as producttype,entryentity.pdendqty + entryentity.endadjqty as startnum, costobject.material as material,costobject.auxpty as auxpty" : "org,0L as manuorg ,costcenter,costobject,costobject.producttype as producttype,entryentity.pdendqty + entryentity.endadjqty as startnum, costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getCalcResult", (String)"aca_calcresult", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, typeQf}, null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("startnum").finish();
        return qtyDataSet;
    }

    private DataSet getFactnedOutputBill(Long orgId, Long manuorgfId, Set<Long> costcenterfId, Date[] periodStartAndEndTime, Boolean orgEnableMultiFactory) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("bookdate", ">=", (Object)periodStartAndEndTime[0]));
        qFilters.add(new QFilter("bookdate", "<=", (Object)periodStartAndEndTime[1]));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            qFilters.add(new QFilter("costcenter", "in", costcenterfId));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        String selectFile = orgEnableMultiFactory != false ? "org,manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.producttype as producttype,entryentity.qty as currentfinish,entryentity.costobject.material as material,entryentity.costobject.auxpty as auxpty" : "org,0L manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.producttype as producttype,entryentity.qty as currentfinish,entryentity.costobject.material as material,entryentity.costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"", (String)"cad_factnedoutputbill", (String)selectFile, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("currentfinish").finish();
        return qtyDataSet;
    }

    private DataSet getWipAdjustBill(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, Long periodId, Boolean orgEnableMultiFactory) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)periodId);
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            orgQf.and(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        String selectFile = orgEnableMultiFactory != false ? "org,manuorg ,costcenter,costobject,costobject.producttype as producttype,adjustqty,adjustType,costobject.material as material,costobject.auxpty as auxpty" : "org,0L manuorg ,costcenter,costobject,costobject.producttype as producttype,adjustqty,adjustType,costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getWipAdjustBill", (String)"aca_wipadjustbill", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, statusQf}, null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "producttype", "adjustType", "material", "auxpty"}).sum("adjustqty").finish();
        return qtyDataSet;
    }

    private DataSet getPlannedOutPutBill(Long orgId, Long manuorgfId, Set<Long> costcenterfId, Date[] periodStartAndEndTime, Boolean orgEnableMultiFactory) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("accountorg", "=", (Object)orgId));
        qFilters.add(new QFilter("bizdate", ">=", (Object)periodStartAndEndTime[0]));
        qFilters.add(new QFilter("bizdate", "<=", (Object)periodStartAndEndTime[1]));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            qFilters.add(new QFilter("costcenter", "in", costcenterfId));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        String selectFile = orgEnableMultiFactory != false ? "accountorg org,manuorg,costcenter,costobject,costobject.producttype as producttype,qty as currentinput,costobject.material as material,costobject.auxpty as auxpty" : "accountorg org,0L manuorg,costcenter,costobject,costobject.producttype as producttype,qty as currentinput,costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getPlannedOutPutBill", (String)"cad_plannedoutputbill", (String)selectFile, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("currentinput").finish();
        logger.info("cad_plannedoutputbill\u53d6\u503c\u6761\u4ef6" + qFilters);
        return qtyDataSet;
    }
}

